/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes.sql_query;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import com.bmc.ctmconvert.zena.tasktypes.sql_query.SqlQuery;
import com.bmc.ctmconvert.zena.tasktypes.sql_query.SqlTaskConvertor;

public class SqlQueryConvertor {
    private final SqlTaskConvertor sqlTaskConvertor;
    private final ZenaJob job;
    private SqlQuery sqlQuery;

    public SqlQueryConvertor(SqlQuery sqlQuery, ZenaJob job, ZenaVariablesHandler zenaVariablesHandler) {
        this.sqlQuery = sqlQuery;
        this.job = job;
        this.sqlTaskConvertor = new SqlTaskConvertor(sqlQuery, job, zenaVariablesHandler);
    }

    private void setQuery() {
        if (this.hasQuery()) {
            String query = this.sqlTaskConvertor.zenaVariablesHandler.replaceZenaVariableWithItsValue(this.sqlQuery.QUERY, this::getValueOfTheVarInQuery);
            this.sqlTaskConvertor.wrapper.addSqlQuery(this.sqlTaskConvertor.zenaVariablesHandler.annotateVariables(query));
            this.job.addMessageWithJobNameAndOriginalJobName("WRN15045", new String[0]);
        }
    }

    private boolean hasQuery() {
        return GlobalFunctions.isNotEmpty((String)this.sqlQuery.QUERY);
    }

    public void convert() {
        this.sqlTaskConvertor.setDefaultValues("Open Query");
        this.sqlTaskConvertor.convert();
        this.setQuery();
    }

    public String getValueOfTheVarInQuery(String varName) {
        String ctmVariableName = this.sqlTaskConvertor.zenaVariablesHandler.replaceZenaVariableWithCtmVariable(varName);
        String varValue = this.job.getSmartFolder().getAutoedits().get(ctmVariableName);
        return varValue == null ? varName : varValue;
    }
}

