/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes.script;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import com.bmc.ctmconvert.zena.tasktypes.script.ScriptTask;
import com.bmc.ctmconvert.zena.tasktypes.script.ScriptVariable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScriptReplacer {
    private final ZenaVariablesHandler zenaVariablesHandler;
    private final Supplier<List<ScriptVariable>> getVariablesFromScript;
    private final RulesDataSet rules;

    public ScriptReplacer(ZenaVariablesHandler zenaVariablesHandler, Supplier<List<ScriptVariable>> getVariablesFromScript, RulesDataSet rules) {
        this.zenaVariablesHandler = zenaVariablesHandler;
        this.getVariablesFromScript = getVariablesFromScript;
        this.rules = rules;
    }

    public UnaryOperator<String> replaceItemAppendOutput(String echoFunction) {
        return this.replaceItemOutputFunctionWithEcho("appendoutput", echoFunction);
    }

    public UnaryOperator<String> replaceItemSetOutput(String echoFunction) {
        return this.replaceItemOutputFunctionWithEcho("setoutput", echoFunction);
    }

    private UnaryOperator<String> replaceItemOutputFunctionWithEcho(String zenaOutputFunction, String replacementEchoFunction) {
        Pattern pattern = this.compileCaseInsensitivePattern("item\\." + zenaOutputFunction);
        return inputScript -> pattern.matcher((CharSequence)inputScript).replaceAll(replacementEchoFunction);
    }

    private Pattern compileCaseInsensitivePattern(String regex) {
        return Pattern.compile(regex, 2);
    }

    private UnaryOperator<String> replacePatternAction(Pattern pattern, String replacement) {
        return this.replacePatternAction(pattern, replacement, "");
    }

    private UnaryOperator<String> replacePatternAction(Pattern pattern, String replacement, String type) {
        return inputScript -> {
            Matcher matcher = pattern.matcher((CharSequence)inputScript);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                String variableName = matcher.group("variableName");
                String validatedVariableName = "%%" + this.validateVariableName(variableName);
                ScriptVariable scriptVariable = new ScriptVariable(pattern, GlobalFunctions.removeVariablePrefix((String)validatedVariableName), type);
                this.addScriptVariable(scriptVariable);
                String replacementWithValidVariableName = this.replaceVariableNameInScript(scriptVariable, replacement, validatedVariableName);
                matcher.appendReplacement(buffer, replacementWithValidVariableName);
            }
            return matcher.appendTail(buffer).toString();
        };
    }

    private String validateVariableName(String variableName) {
        String validatedVariableName = this.zenaVariablesHandler.validateVariableName(variableName);
        if (!variableName.startsWith("_")) {
            return validatedVariableName.replaceAll("^(_)+", "");
        }
        return validatedVariableName;
    }

    private void addScriptVariable(ScriptVariable scriptVariable) {
        if (!scriptVariable.getType().isEmpty()) {
            this.getVariablesFromScript.get().add(scriptVariable);
        }
    }

    public UnaryOperator<String> replaceVariablesFor(String type, String replacement) {
        Pattern pattern = this.compileCaseInsensitivePattern("\\[" + type + "\\.VARIABLE\\.(?<variableName>.*?)]");
        return this.replacePatternAction(pattern, replacement, type);
    }

    public UnaryOperator<String> replaceGetVariableValueFor(String type, String replacement) {
        Pattern pattern = this.compileCaseInsensitivePattern(type + "\\.GetVariableValue\\s*\\(\"(?<variableName>.*?)\"\\)");
        return this.replacePatternAction(pattern, replacement);
    }

    public Function<String, String> replaceSetVariableValueForItem(String ctmVarCommand) {
        return this.replaceZenaFunctionWithCtmVarCommand("Item", "TASK", ctmVarCommand);
    }

    private Function<String, String> replaceZenaFunctionWithCtmVarCommand(String itemType, String variableType, String ctmVarCommand) {
        Pattern patternForFunctionWithParentheses = this.compileCaseInsensitivePattern(itemType + "\\.SetVariableValue\\s*\\(\"?(?<variableName>.*?)\"?\\)*\\s*,\\s*(?<variableValue>.*)\\)");
        Pattern patternForFunctionWithOutParentheses = this.compileCaseInsensitivePattern(itemType + "\\.SetVariableValue\\s*\"?(?<variableName>.*?)\"?\\s*,\\s*(?<variableValue>.*)");
        return this.replacePatternAction(patternForFunctionWithParentheses, ctmVarCommand, variableType).andThen(this.replacePatternAction(patternForFunctionWithOutParentheses, ctmVarCommand, variableType));
    }

    public Function<String, String> replaceSetVariableValueForProcess(String ctmVarCommand) {
        return this.replaceZenaFunctionWithCtmVarCommand("Process", "PROCESS", ctmVarCommand);
    }

    public UnaryOperator<String> addMessageForUnsupportedVariableUsages(Supplier<List<String>> getMMessageIds) {
        Pattern findQuotedVariableReference = this.compileCaseInsensitivePattern("[\"]+[^\\[]*(\\[(?<variableName>.*?)])[^\"]*[\"]+");
        return inputScript -> {
            Matcher matcher = findQuotedVariableReference.matcher((CharSequence)inputScript);
            if (matcher.find()) {
                ((List)getMMessageIds.get()).add("WRN15043");
            }
            return inputScript;
        };
    }

    private String replaceVariableNameInScript(ScriptVariable scriptVariable, String replacement, String validatedVariableName) {
        String variableReplacement = GlobalFunctions.removeVariablePrefix((String)validatedVariableName);
        String variableReplacementWithoutPrefix = this.adjustValidationToCountForItemUidPrefixIfNeeded(scriptVariable, variableReplacement);
        ZenaJob job = this.zenaVariablesHandler.getJob();
        if (scriptVariable.isVariableSet() && scriptVariable.isLocalVariable() && !ScriptTask.shouldAlwaysAddItemUid(this.rules) && ScriptTask.isMissingVariable(job, "%%" + job.getItemUid() + "_" + variableReplacementWithoutPrefix)) {
            replacement = replacement.replace("\" & ZenaUid & \"_", "").replace("\" + ZenaUid + \"_", "");
        }
        return replacement.replace("$1", variableReplacementWithoutPrefix);
    }

    private String adjustValidationToCountForItemUidPrefixIfNeeded(ScriptVariable scriptVariable, String variableReplacement) {
        boolean shouldAddItemUidPrefix = ScriptTask.shouldAlwaysAddItemUid(this.rules);
        if (scriptVariable.isVariableSet() && scriptVariable.isLocalVariable() && shouldAddItemUidPrefix) {
            int itemUidPrefixLength = 13;
            int maxVariableNameLength = 38;
            variableReplacement = variableReplacement.substring(0, Math.min(variableReplacement.length(), maxVariableNameLength - itemUidPrefixLength));
        }
        return variableReplacement;
    }
}

