/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes.dependency;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.file_watcher.FileWatcherWrapper;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import java.util.Optional;
import org.w3c.dom.Element;

public class FileDependencyTask
extends ZenaTask {
    public FileDependencyTask(Element entityDefinition, ZenaJob job) {
        super(entityDefinition, job);
    }

    @Override
    protected void convertTaskType() {
        FileWatcherWrapper fileWatcherWrapper = new FileWatcherWrapper((SchedEntity)this.job).convert().setType(FileWatcherWrapper.Type.CREATE);
        this.getValue().ifPresent(value -> fileWatcherWrapper.setMinimumDestinationSize(value.intValue(), FileWatcherWrapper.Unit.BYTES));
        this.getPath().ifPresent(arg_0 -> ((FileWatcherWrapper)fileWatcherWrapper).setPath(arg_0));
    }

    private Optional<Integer> getValue() {
        return this.getAttributeBy("VALUE").map(value -> GlobalFunctions.isNumber((String)value) ? Integer.parseInt(value) : 0);
    }

    private Optional<String> getAttributeBy(String name) {
        return XmlElement.ofNullable((Element)super.getEntityAttributes()).getAllDirectchildsElement().stream().filter(attribute -> attribute.getTagName().equals(name)).map(XmlElement::getText).findAny();
    }

    private Optional<String> getPath() {
        return this.getAttributeBy("SOURCE_PATH").map(this::convertPath);
    }

    private String convertPath(String path) {
        return this.zenaVariablesHandler.annotateVariables(path);
    }

    @Override
    public String getControlMTaskType() {
        return "Job";
    }
}

