/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes.data;

import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import com.bmc.ctmconvert.zena.tasktypes.data.ZenaDataHandler;
import com.bmc.ctmconvert.zena.tasktypes.data.ZenaDataVariableToPoolVariableHandler;
import com.bmc.ctmconvert.zena.tasktypes.data.ZenaDataVariableToSmartFolderVariableHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DataTask
extends ZenaTask {
    private Map<String, List<Element>> dataTypesMap;

    public DataTask(Element entityDefinition, ZenaJob job) {
        super(entityDefinition, job);
        this.initDataMapTypes();
    }

    @Override
    public String getControlMTaskType() {
        return "Dummy";
    }

    public String getZenaTaskType() {
        return this.getEntityDefinition().getTagName();
    }

    @Override
    public void convertTaskType() {
        for (String dataType : this.getDataTypesMap().keySet()) {
            ZenaDataHandler zenaHandler = this.createDataHandler(dataType);
            zenaHandler.handle(this.job);
        }
    }

    private ZenaDataHandler createDataHandler(String dataType) {
        return switch (dataType) {
            case "PROCESS_VARIABLES", "ITEM_VARIABLES" -> new ZenaDataVariableToSmartFolderVariableHandler(this.getDataRowsOfType(dataType));
            case "SYSTEM_VARIABLES" -> new ZenaDataVariableToPoolVariableHandler(this.getDataRowsOfType(dataType));
            default -> this.unsupportedTask(dataType);
        };
    }

    private ZenaDataHandler unsupportedTask(String dataType) {
        this.job.addMessage("WRN15013", this.getZenaTaskType() + "' with type '" + dataType + "\"");
        return ZenaDataHandler.NULL;
    }

    private List<Element> getDataRowsOfType(String dataType) {
        return this.getDataTypesMap().get(dataType);
    }

    @Override
    protected void setmemName(ZenaJob job) {
    }

    private void initDataMapTypes() {
        this.setDataTypesMap(new HashMap<String, List<Element>>());
        Element entityAttr = this.getEntityAttributes();
        if (entityAttr != null) {
            NodeList children = entityAttr.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String rowTagName = children.item(i).getNodeName();
                if (!rowTagName.contains("DATA")) continue;
                String rowType = this.getDataType((Element)children.item(i));
                if (this.getDataTypesMap().containsKey(rowType)) {
                    this.getDataTypesMap().get(rowType).add((Element)children.item(i));
                    continue;
                }
                ArrayList<Element> dataRowsList = new ArrayList<Element>();
                dataRowsList.add((Element)children.item(i));
                this.getDataTypesMap().put(rowType, dataRowsList);
            }
        }
    }

    private String getDataType(Element dataRow) {
        return dataRow.getAttribute("TYPE");
    }

    public Map<String, List<Element>> getDataTypesMap() {
        return this.dataTypesMap;
    }

    public void setDataTypesMap(Map<String, List<Element>> dataTypesMap) {
        this.dataTypesMap = dataTypesMap;
    }
}

