/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.zena.ZenaDefs;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;

public class TerminatorTask
extends ZenaTask {
    private static final String MODE = "MODE";
    private static final List<String> TERMINATOR_ERROR_TYPES = Arrays.asList("ERROR", "COMPLETED ABNORMAL");

    public TerminatorTask(Element entityDefinition, ZenaJob job) {
        super(entityDefinition, job);
    }

    @Override
    public String getControlMTaskType() {
        if (this.isTerminatorDummy()) {
            return "Dummy";
        }
        return "Command";
    }

    @Override
    protected boolean isEmptyTask() {
        return false;
    }

    @Override
    protected void setmemName(ZenaJob job) {
    }

    @Override
    protected void convertTaskType() {
        boolean endFolderSupported;
        boolean bl = endFolderSupported = Integer.parseInt(this.controlMVersion) > Integer.parseInt("9");
        if (endFolderSupported) {
            this.properties.put("END_FOLDER", "Y");
        }
        if (!this.isTerminatorDummy()) {
            String cmdLine;
            if (this.isErrorTerminator()) {
                cmdLine = "%%$$OUTERR";
                this.job.addOnDoStatement(OnStatement.createOnOkStatement().addDo(Do.createDoNotOk()));
            } else {
                cmdLine = "%%$$OUT";
            }
            this.setCmdLine(cmdLine);
        }
    }

    private boolean isErrorTerminator() {
        String terminatorType = Optional.ofNullable(this.getEntityAttributes()).map(XmlElement::ofNullable).map(attribute -> attribute.getFirstChildElementByName(MODE).getText()).orElse("");
        return TERMINATOR_ERROR_TYPES.contains(terminatorType);
    }

    private boolean isTerminatorDummy() {
        return !ZenaDefs.isOrderingJobRuleEnabled(this.job.getRules());
    }
}

