/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.MSSQL_ConnectionProfileActionHandler;
import com.bmc.ctmconvert.zena.run_as.LoginData;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import com.bmc.ctmconvert.zena.utils.ZenaXmlUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.w3c.dom.Element;

public class SsisTask
extends ZenaTask {
    private XmlElement taskDefinition = XmlElement.ofNullable((Element)this.getEntityDefinition());
    private String folderAttribute;
    private String packageAttribute;
    private String storageTypeAttribute;
    private EntitiesDefinitionsManager entitiesDefinitionsManager;
    private static String SQL_SERVER = "SQL_SERVER";
    private static String FILE = "FILE";

    public SsisTask(Element entityDefinition, ZenaJob job, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        super(entityDefinition, job);
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
    }

    @Override
    protected void convertTaskType() {
        this.parseTaskAttributes();
        this.setDefaultAutoeditValues();
        this.setDefualtAttribute();
        this.setConnectionProfile();
        this.setPackageVariable();
        this.handleMessage();
        this.addDatabaseAccountAction();
        this.convertParameters();
    }

    private void convertParameters() {
        Stream<XmlElement> parameters = ZenaXmlUtils.extractParametersOrdered(this.taskDefinition);
        GlobalFunctions.forEachIndexed(parameters, (parameter, index) -> this.convertVariableToParameter((XmlElement)parameter, index + 1));
    }

    private void convertVariableToParameter(XmlElement variable, int parameterCount) {
        String name = variable.getAttribute("NAME");
        String namespace = variable.getAttribute("NAMESPACE");
        String value = variable.getText();
        this.addSsisProperty(name, namespace, value, parameterCount);
    }

    private void addSsisProperty(String name, String namespace, String value, int parameterCount) {
        this.job.addAutoEdits(String.format("%%%%DB-SSIS_SETVALPARAMS-N%03d-NAME", parameterCount), String.format("\\Package.Variables[%s::%s]", namespace, name));
        this.job.addAutoEdits(String.format("%%%%DB-SSIS_SETVALPARAMS-N%03d-VALUE", parameterCount), this.zenaVariablesHandler.annotateVariables(value));
    }

    public void addDatabaseAccountAction() {
        HashMap<String, String> action = new HashMap<String, String>();
        if (this.parseLoginName().SERVERTYPE.map(s -> s.equals("1")).orElse(false).booleanValue()) {
            action = MSSQL_ConnectionProfileActionHandler.getMSSQL_ConncetionProfileAction(this.parseLoginName(), this.job.getJobName(), this.job.getAutoedits().get("%%DB-ACCOUNT"), this.job.getAttr("NODEID"), "defaultDB", Params.instance().getDatacenterName());
        } else {
            action.put("ACTENTTYPE", "DATABASEACC");
            action.put("JOBID", this.job.getJobName());
            action.put("ACTENTNAME", this.job.getAutoedits().get("%%DB-ACCOUNT"));
            action.put("ACTSTATUS", "0");
        }
        this.job.addAction(action);
    }

    private void setConnectionProfile() {
        String dataBaseName = this.parseLoginName().NAME.isEmpty() ? "DB_DEFAULT_CONNECTION" : this.parseLoginName().NAME;
        String validCP = FieldValidation.instance().validateAndReturnFixedValue("CONNECTION_PROFILE", dataBaseName);
        this.job.addAutoEdits("%%DB-ACCOUNT", validCP);
    }

    private void handleMessage() {
        List variableElement = Optional.ofNullable(this.taskDefinition.getFirstChildElementByName("VARIABLES")).map(attributesElement -> attributesElement.getAllDirectchildsElement()).orElse(Collections.emptyList());
        if (!variableElement.isEmpty()) {
            this.job.addMessage("WRN15040", this.job.getOriginalJobName(), this.job.getJobName());
        }
    }

    private void setDefualtAttribute() {
        this.job.addAttribute("APPL_TYPE", "DATABASE");
        this.job.addAttribute("APPL_FORM", "Databases");
        this.job.addAttribute("APPL_VER", "9.0.00");
    }

    private void setPackageVariable() {
        if (this.storageTypeAttribute.equals(SQL_SERVER)) {
            this.job.addAutoEdits("%%DB-SSIS_PACKAGE_SOURCE", "SQL Server");
        } else if (this.storageTypeAttribute.equals(FILE)) {
            StringBuilder path = new StringBuilder(this.folderAttribute);
            path.append("\\");
            path.append(this.packageAttribute);
            this.job.addAutoEdits("%%DB-SSIS_PACKAGE_SOURCE", path.toString());
        }
    }

    @Override
    public String getControlMTaskType() {
        return "Job";
    }

    private void parseTaskAttributes() {
        Optional.ofNullable(this.taskDefinition.getFirstChildElementByName("ATTRIBUTES")).map(attributesElement -> attributesElement.getAllDirectchildsElement()).orElse(Collections.emptyList()).forEach(this::processAttribute);
    }

    private void processAttribute(XmlElement attribute) {
        String tagName = attribute.getTagName();
        String innerText = attribute.getText();
        switch (tagName) {
            case "FOLDER": {
                this.folderAttribute = innerText;
                break;
            }
            case "PACKAGE": {
                this.packageAttribute = innerText;
                break;
            }
            case "STORAGE_TYPE": {
                this.storageTypeAttribute = innerText;
            }
        }
    }

    private void setDefaultAutoeditValues() {
        this.job.addAutoEdits("%%DB-STP_NAME", this.job.getJobName());
        this.job.addAutoEdits("%%DB-EXEC_TYPE", "SSIS Package");
        this.job.addAutoEdits("%%DB-APPEND_LOG", "Y");
        this.job.addAutoEdits("%%DB-APPEND_OUTPUT", "N");
        this.job.addAutoEdits("%%DB-STP_PACKAGE", "*");
        this.job.addAutoEdits("%%DB-OUTPUT_FORMAT", "Text");
        this.job.addAutoEdits("%%DB-AUTOCOMMIT", "N");
        this.job.addAutoEdits("%%DB-CSV_SEPERATOR", ",");
    }

    private LoginData parseLoginName() {
        Optional<Element> optionalLoginElement = Optional.ofNullable(this.taskDefinition.getFirstChildElementByName("LOGIN")).map(loginElement -> loginElement.getAttribute("UID")).map(loginUid -> this.entitiesDefinitionsManager.getElementByTypeAndID("LOGIN", (String)loginUid));
        return LoginData.parseLoginDefinition(optionalLoginElement);
    }
}

