/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.conditions.InConditionBuilder;
import com.bmc.ctmconvert.common.conditions.Op;
import com.bmc.ctmconvert.common.conditions.OutConditionBuilder;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.DoForceJob;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.zena.ConditionsGenerator;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.events.EventProcessRelation;
import com.bmc.ctmconvert.zena.events.ProcessDetails;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class SendEventTask
extends ZenaTask {
    private final Element processDefinition;
    private final EntitiesDefinitionsManager entitiesDefinitionsManager;

    public SendEventTask(Element entityDefinition, ZenaJob job, Element processDefinition, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        super(entityDefinition, job);
        this.processDefinition = processDefinition;
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
    }

    @Override
    protected void convertTaskType() {
        OnStatement.OnOkStatement onOkStatement = OnStatement.createOnOkStatement();
        this.getProcessNameToOrder(this.getEventUid()).forEach(name -> {
            DoForceJob doObj = new DoForceJob(name, Do.REMOTE.NO);
            this.putVariablesInDo(doObj);
            onOkStatement.addDo((Do)doObj);
        });
        this.convertUserEventConditions();
        this.job.addOnDoStatement((OnStatement)onOkStatement);
    }

    void convertUserEventConditions() {
        boolean isConditionNamingWithStatus = this.job.isConditionNamingWithStatus();
        if (this.isSendEventTask()) {
            this.createSendEventOutConditions(isConditionNamingWithStatus);
        } else if (this.isDependencyTask()) {
            this.wrapWithParentheses(this.createDependencyInConditions(isConditionNamingWithStatus));
        }
    }

    private boolean isDependencyTask() {
        return "DEPENDENCY".equals(this.processDefinition.getTagName());
    }

    private boolean isSendEventTask() {
        return "SEND_EVENT".equals(this.processDefinition.getTagName());
    }

    private void createSendEventOutConditions(boolean isConditionNamingWithStatus) {
        List<Element> dependencyTasks = this.entitiesDefinitionsManager.getSendEventToDependencyMapper().getDependencyTasksFor(this.getEventUid());
        dependencyTasks.forEach(dependencyTask -> {
            Integer conditionUniqueId = this.entitiesDefinitionsManager.getSendEventToDependencyMapper().getConditionIdFor(this.processDefinition, (Element)dependencyTask);
            String conditionName = this.generateConditionName(this.processDefinition, (Element)dependencyTask, isConditionNamingWithStatus, conditionUniqueId);
            this.job.addOutCondition(((OutConditionBuilder)new OutConditionBuilder().setConditionName(conditionName)).build().getProperties());
        });
    }

    private String generateConditionName(Element source, Element target, boolean isConditionNamingWithStatus, Integer conditionUniqueId) {
        if (isConditionNamingWithStatus) {
            return ConditionsGenerator.ConditionPropertiesCreator.generateConditionName(source, target, conditionUniqueId, true);
        }
        String from = ConditionsGenerator.ConditionPropertiesCreator.getDependencyConditionName(source);
        String to = ConditionsGenerator.ConditionPropertiesCreator.getDependencyConditionName(target);
        return ConditionsGenerator.ConditionPropertiesCreator.getConditionName(from, to, "%s-TO-%s");
    }

    private void wrapWithParentheses(List<InConditionBuilder> inConditionBuilderStream) {
        GlobalFunctions.forEachIndexed(inConditionBuilderStream, (inConditionBuilder, index) -> {
            if (inConditionBuilderStream.size() > 1) {
                if (index == 0) {
                    inConditionBuilder.setOp(Op.Open);
                }
                if (index == inConditionBuilderStream.size() - 1) {
                    inConditionBuilder.setOp(Op.Close);
                }
            }
            this.job.addInCondition(inConditionBuilder.build().getProperties());
        });
    }

    private List<InConditionBuilder> createDependencyInConditions(boolean isConditionNamingWithStatus) {
        return this.entitiesDefinitionsManager.getSendEventToDependencyMapper().getSendEventTasksFor(this.getEventUid()).stream().map(sendEventTask -> {
            Integer conditionUniqueId = this.entitiesDefinitionsManager.getSendEventToDependencyMapper().getConditionIdFor((Element)sendEventTask, this.processDefinition);
            String conditionName = this.generateConditionName((Element)sendEventTask, this.processDefinition, isConditionNamingWithStatus, conditionUniqueId);
            return ((InConditionBuilder)new InConditionBuilder().setConditionName(conditionName)).setOr();
        }).collect(Collectors.toList());
    }

    private void putVariablesInDo(DoForceJob doObj) {
        this.getVariablesFromOtherDefinition().forEach(variable -> doObj.putVariable(this.getVariableName((XmlElement)variable), this.zenaVariablesHandler.annotateVariables(variable.getValue())));
        this.getVariablesFromProcessDefinition().forEach(variable -> doObj.putVariable(this.getVariableName((XmlElement)variable), this.zenaVariablesHandler.annotateVariables(variable.getValue())));
    }

    private String getVariableName(XmlElement variable) {
        String tagName = variable.getTagName();
        String variableNameAttribute = variable.getAttribute("NAME");
        return "".equals(variableNameAttribute) ? tagName : variableNameAttribute;
    }

    private List<XmlElement> getVariablesFromProcessDefinition() {
        XmlElement attributes = XmlElement.ofNullable((Element)this.processDefinition).getFirstChildElementByName("ATTRIBUTES");
        return this.removeVariablesWithoutValue(attributes.getAllDirectchildsElement());
    }

    private List<XmlElement> removeVariablesWithoutValue(List<XmlElement> variables) {
        return variables.stream().filter(variable -> !"".equals(variable.getValue())).collect(Collectors.toList());
    }

    private List<XmlElement> getVariablesFromOtherDefinition() {
        return XmlElement.ofNullable((Element)this.getEntityDefinition()).getAllDecnedElementByName("ATTRIBUTE");
    }

    private String getEventUid() {
        return XmlElement.ofNullable((Element)this.processDefinition).getAttribute("UID");
    }

    private List<String> getProcessNameToOrder(String eventUid) {
        EventProcessRelation policyToProcess = this.entitiesDefinitionsManager.getEventProcessRelation();
        Collection<ProcessDetails> process = policyToProcess.getProcessDetailsByEventUid(eventUid);
        return process.stream().map(ProcessDetails::getName).collect(Collectors.toList());
    }

    @Override
    public String getControlMTaskType() {
        return "Dummy";
    }

    @Override
    protected boolean isEmptyTask() {
        return false;
    }
}

