/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class HttpTask
extends ZenaTask {
    public static final String NOT_PART_OF_PROTOCOL = "(?<![:/])";
    public static final String POSITION_BEFORE_SLASH = "(?=/)";
    public static final String FIRST_URL_SLASH = "(?<![:/])(?=/)";
    private final XmlElement attributes = new XmlElement(this.getEntityAttributes());

    public HttpTask(Element entityDefinition, ZenaJob job) {
        super(entityDefinition, job);
    }

    @Override
    public String getControlMTaskType() {
        return "Job";
    }

    @Override
    protected void convertTaskType() {
        this.convertWebServiceJobAttributes();
        this.convertWebServiceJobVariables();
        this.issueMessageForUnsupportedAttributes();
    }

    private void convertWebServiceJobAttributes() {
        this.job.addAttribute("APPL_TYPE", "WS");
        this.job.addAttribute("APPL_FORM", "WS");
        this.job.addAttribute("APPL_VER", "9.0.18.200");
        this.job.addAttribute("CM_VER", "N/A");
    }

    private void convertWebServiceJobVariables() {
        this.job.addAutoEdits("%%WS-ACCOUNT", "LOCAL_SERVER");
        this.job.addAutoEdits("%%WS-WSDL", this.extractBaseUrl());
        this.job.addAutoEdits("%%WS-TYPE", "REST");
        this.job.addAutoEdits("%%WS-SERVICE", this.extractServiceMethod());
        this.job.addAutoEdits("%%WS-OPERATION", this.extractUrl());
        this.job.addAutoEdits("%%WS-REQTYPE", "EDITSOAP");
        this.job.addAutoEdits("%%WS-NOSYSOUTBANNER", "N");
        this.job.addAutoEdits("%%WS-SYSOUTSKIP", "N");
    }

    private String extractBaseUrl() {
        return this.getResolvedUrl().map(url -> url.split(FIRST_URL_SLASH)[0]).orElse("");
    }

    private String extractUrl() {
        return this.getResolvedUrl().map(url -> url.split(FIRST_URL_SLASH, 2)).filter(splittedUrl -> ((String[])splittedUrl).length > 1).map(splittedUrl -> splittedUrl[1]).orElse("");
    }

    private Optional<String> getResolvedUrl() {
        return this.getFirstChildElementText("URL").map(this.job.getZenaVariablesHandler()::annotateVariables);
    }

    private Optional<String> getFirstChildElementText(String xmlAttributeUrl) {
        return Optional.ofNullable(this.attributes).map(attributes -> attributes.getFirstChildElementByName(xmlAttributeUrl)).map(urlElement -> urlElement.getText());
    }

    private String extractServiceMethod() {
        return this.getFirstChildElementText("OPERATION").orElse("");
    }

    private void issueMessageForUnsupportedAttributes() {
        this.job.addMessageWithJobNameAndOriginalJobName("WRN15048", this.getUnsupportedAttributes());
    }

    private String getUnsupportedAttributes() {
        List<String> supportedAttributes = Arrays.asList("URL", "OPERATION");
        return Optional.ofNullable(this.attributes).map(XmlElement::getAllDirectchildsElement).stream().flatMap(Collection::stream).map(XmlElement::getTagName).filter(Predicate.not(supportedAttributes::contains)).collect(Collectors.joining(", "));
    }
}

