/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import java.util.Optional;
import org.w3c.dom.Element;

public class FileTask
extends ZenaTask {
    public FileTask(Element entityDefinition, ZenaJob job) {
        super(entityDefinition, job);
    }

    @Override
    public String getControlMTaskType() {
        return "Command";
    }

    @Override
    protected void convertTaskType() {
        String operation;
        CommandLine cmdline = switch (operation = this.getAttributeBy("OPERATION").orElse("")) {
            case "DELETE" -> this.convertDeleteOperation();
            case "MOVE", "RENAME" -> this.convertMoveOrRenameOperation();
            case "COPY" -> this.convertCopyOperation();
            case "DELDIR" -> this.convertDelDirOperation();
            case "APPEND", "CREATE" -> this.convertAppendOperation();
            case "MKDIR" -> this.convertMkdirOperation();
            default -> this.convertUnsupportedOperation(this.job, operation);
        };
        super.setCmdLine(cmdline.convertFailOnNoWork(this.getFailOnNoWork()).toString());
    }

    private CommandLine convertMkdirOperation() {
        return new CommandLine("mkdir", this.getSourcePath());
    }

    private CommandLine convertAppendOperation() {
        String emptyContent = "\"\"";
        String source = this.getSourcePath();
        boolean overwrite = this.getOverwrite();
        String redirectOperation = overwrite ? ">" : ">>";
        String text = this.getAttributeBy("TEXT").filter(t -> !t.isEmpty()).map(String::trim).map(this::quoteIfNotQuoted).orElse("\"\"");
        return new CommandLine(String.format("echo %s %s", text, redirectOperation), source);
    }

    private boolean getFailOnNoWork() {
        return this.getAttributeBy("FAIL_ON_NO_WORK").map("Y"::equalsIgnoreCase).orElse(false);
    }

    private CommandLine convertDelDirOperation() {
        boolean deleteIfNotEmpty = this.getOverwrite();
        String source = this.getSourcePath();
        String command = this.isWindows() ? (deleteIfNotEmpty ? "rmdir /S /Q" : "rmdir") : (deleteIfNotEmpty ? "rm -rf" : "rmdir");
        return new CommandLine(command, source);
    }

    private CommandLine convertUnsupportedOperation(ZenaJob job, String operation) {
        Reporter.addMessage(job.getMessages(), (String)"WRN15012", (String)job.getTablePathForSons(), (String[])new String[]{operation});
        return CommandLine.empty;
    }

    private CommandLine convertMoveOrRenameOperation() {
        boolean overwrite = this.getOverwrite();
        String source = this.getSourcePath();
        String target = this.getTargetPath();
        MoveConverter commandConverter = new MoveConverter(source, target, this.isWindows(), overwrite);
        return new CommandLine(commandConverter.getCommand(), commandConverter.getArguments());
    }

    private CommandLine convertDeleteOperation() {
        String command = this.isWindows() ? "del" : "rm";
        this.getAttributeBy("HOURS_DEL_WAIT").filter(v -> !v.equalsIgnoreCase("0")).ifPresent(v -> this.job.addMessageWithJobNameAndOriginalJobName("WRN15047", (String)v));
        String arguments = this.getSourcePath();
        return new CommandLine(command, arguments);
    }

    private CommandLine convertCopyOperation() {
        boolean overwrite = this.getOverwrite();
        String source = this.getSourcePath();
        String target = this.getTargetPath();
        this.getAttributeBy("CREATE_TARGET").filter("Y"::equalsIgnoreCase).ifPresent(value -> this.job.addMessageWithJobNameAndOriginalJobName("WRN15046", new String[0]));
        CopyConverter copyConverter = new CopyConverter(source, target, this.isWindows(), overwrite);
        return new CommandLine(copyConverter.getCommand(), copyConverter.getArguments());
    }

    private Boolean getOverwrite() {
        return this.getAttributeBy("WRITEOVER").map("Y"::equalsIgnoreCase).orElse(true);
    }

    private String getTargetPath() {
        return this.getAttributeBy("TARGET_PATH").map(this::quoteIfNotQuoted).orElse("");
    }

    private String getSourcePath() {
        return this.getAttributeBy("SOURCE_PATH").map(this::quoteIfNotQuoted).orElse("");
    }

    private Optional<String> getAttributeBy(String name) {
        return XmlElement.ofNullable((Element)super.getEntityAttributes()).getAllDirectchildsElement().stream().filter(attribute -> attribute.getTagName().equals(name)).map(XmlElement::getText).findAny();
    }

    private static class CommandLine {
        public static final CommandLine empty = new CommandLine("", "");
        private final String command;
        private final String arguments;

        public CommandLine(String command, String arguments) {
            this.command = command;
            this.arguments = arguments;
        }

        public String toString() {
            return String.format("%s %s", this.command, this.arguments);
        }

        public CommandLine convertFailOnNoWork(boolean shouldFail) {
            if (!shouldFail && !this.isEmpty()) {
                return new CommandLine(this.command, this.arguments + " | echo");
            }
            return this;
        }

        public boolean isEmpty() {
            return this == empty;
        }
    }

    private static class MoveConverter
    extends CommandConverter {
        public MoveConverter(String source, String destination, boolean isWindows, boolean overwrite) {
            super(source, destination, isWindows, overwrite);
        }

        @Override
        String getCmdType() {
            return this.isWindows ? "move" : "mv";
        }
    }

    private static class CopyConverter
    extends CommandConverter {
        public CopyConverter(String source, String destination, boolean isWindows, boolean overwrite) {
            super(source, destination, isWindows, overwrite);
        }

        @Override
        String getCmdType() {
            return this.isWindows ? "copy" : "cp";
        }
    }

    private static abstract class CommandConverter {
        private final String source;
        private final String destination;
        protected final boolean isWindows;
        protected final boolean overwrite;

        public CommandConverter(String source, String destination, boolean isWindows, boolean overwrite) {
            this.source = source;
            this.destination = destination;
            this.isWindows = isWindows;
            this.overwrite = overwrite;
        }

        public String getCommand() {
            if (this.isWindows) {
                return this.convertWindowsCommand();
            }
            return this.convertUnixCommand();
        }

        public String getArguments() {
            return this.replaceSeparatorIfNeeded(this.source + " " + this.destination);
        }

        private String replaceSeparatorIfNeeded(String input) {
            return this.isWindows ? input.replace("/", "\\") : input;
        }

        private String convertWindowsCommand() {
            if (this.overwrite) {
                return this.getCmdType() + " /Y";
            }
            return String.format("echo N | %s /-Y", this.getCmdType());
        }

        private String convertUnixCommand() {
            String cmdType = this.getCmdType();
            if (this.overwrite) {
                return cmdType + " -f";
            }
            return cmdType + " -n";
        }

        abstract String getCmdType();
    }
}

