/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.run_as;

import com.bmc.ctmconvert.vc.IFieldValidation;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.run_as.ZenaRunAsData;
import java.util.Arrays;
import java.util.List;

public class RunAsConvertor {
    public static final String AGENT_SECURITY = "AGENT_SECURITY";
    private ZenaJob job;
    private ZenaRunAsData zenaRunAsData;
    private IFieldValidation fieldValidation;

    public RunAsConvertor(ZenaRunAsData zenaRunAsData, ZenaJob job, IFieldValidation fieldValidation) {
        this.zenaRunAsData = zenaRunAsData;
        this.job = job;
        this.fieldValidation = fieldValidation;
    }

    public void convert() {
        if (this.isTaskTypeSupported()) {
            this.zenaRunAsData.taskDefinitionsLogin.LOGIN.ifPresent(login -> this.job.addAttribute("OWNER", this.validate((String)login)));
            this.zenaRunAsData.overrideLogin.LOGIN.ifPresent(login -> this.job.addAttribute("OWNER", this.validate((String)login)));
            if (this.zenaRunAsData.usesAgentSecurity) {
                this.job.addAttribute("OWNER", AGENT_SECURITY);
            }
        }
    }

    private boolean isTaskTypeSupported() {
        List<String> supportedTaskTypes = Arrays.asList("TASK", "BROADCAST_TASK");
        return supportedTaskTypes.contains(this.zenaRunAsData.type);
    }

    private String validate(String login) {
        return this.fieldValidation.validateAndReturnFixedValue(this.job::addMessage, "OWNER", login, true, "LOGIN");
    }
}

