/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.handlers.actions;

import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.actions.DefaultZenaActionConvertor;
import com.bmc.ctmconvert.zena.handlers.actions.UnsupportedZenaActionConvertor;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionConvertor;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionsData;

public class ZenaActionsFactory {
    private ZenaActionsData action;
    private ZenaJob job;

    public ZenaActionsFactory(ZenaActionsData action, ZenaJob job) {
        this.action = action;
        this.job = job;
    }

    public ZenaActionConvertor createActionConvertor() {
        UnsupportedZenaActionConvertor convertor = new UnsupportedZenaActionConvertor(this.action, this.job::addMessageWithJobNameAndOriginalJobName);
        return switch (this.action.actionType) {
            case "RUNACTION", "RUNPROCESS" -> this.createConvertor(convertor);
            default -> convertor;
        };
    }

    private ZenaActionConvertor createConvertor(ZenaActionConvertor convertor) {
        return switch (this.action.eventType) {
            case "NORMAL" -> this.createConvertor((OnStatement)new OnStatement.OnOkStatement());
            case "COMPLETE" -> this.createConvertor((OnStatement)new OnStatement.OnJobEndedStatement());
            case "ERROR", "ABNORMAL" -> this.createConvertor((OnStatement)new OnStatement.OnNotOkStatement());
            default -> convertor;
        };
    }

    private DefaultZenaActionConvertor createConvertor(OnStatement onStatement) {
        return new DefaultZenaActionConvertor(onStatement, this.job, this.action);
    }
}

