/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.handlers.actions;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ZenaDefs;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionItem;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionsData;
import com.bmc.ctmconvert.zena.utils.ZenaXmlUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;

public class ZenaActionsDataCreator {
    private XmlElement entityDefinition;
    private XmlElement processDefinition;
    private EntitiesDefinitionsManager entitiesDefinitionsManager;

    public ZenaActionsDataCreator(Element entityDefinition, Element processDefinition, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        this(XmlElement.ofNullable((Element)entityDefinition), XmlElement.ofNullable((Element)processDefinition), entitiesDefinitionsManager);
    }

    public ZenaActionsDataCreator(XmlElement entityDefinition, XmlElement processDefinition, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        this.entityDefinition = entityDefinition;
        this.processDefinition = processDefinition;
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
    }

    private Set<XmlElement> getAllActionElements() {
        return this.removeDuplicates(Stream.concat(this.getAllActionsFrom(this.entityDefinition), this.getAllActionsFrom(this.processDefinition)));
    }

    private LinkedHashSet<XmlElement> removeDuplicates(Stream<XmlElement> allActions) {
        return allActions.collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Stream<XmlElement> getAllActionsFrom(XmlElement xmlDefinition) {
        if (this.isStandaloneAction(xmlDefinition)) {
            return Stream.of(xmlDefinition);
        }
        List actions = this.getActionsElement(xmlDefinition).map(action -> action.getAllDecnedElementByName("ACTION")).orElse(Collections.emptyList());
        return actions.stream();
    }

    private Optional<XmlElement> getActionsElement(XmlElement entityDefinition) {
        return Optional.ofNullable(entityDefinition.getFirstChildElementByName("ACTIONS"));
    }

    List<ZenaActionsData> parseActionsList() {
        Set<XmlElement> allActions = this.getAllActionElements();
        return allActions.stream().map(action -> this.parseAction((XmlElement)action)).collect(Collectors.toList());
    }

    private ZenaActionsData parseAction(XmlElement actionFromDefinition) {
        ZenaActionsData actionsData = new ZenaActionsData();
        this.setActionAndEventType(actionFromDefinition, actionsData);
        actionsData.uid = this.getUid(actionFromDefinition);
        Optional<XmlElement> actionByUID = this.getActionByUID(actionsData.uid);
        List<XmlElement> actionItems = this.getActionItemElements(actionByUID);
        actionsData.variables = this.getVariablesFrom(actionFromDefinition, actionByUID);
        this.createActionItems(actionsData, actionItems);
        Optional<Element> entityDef = this.getProcessDefinition(actionsData.uid);
        entityDef.ifPresent(process -> {
            actionsData.processName = Optional.ofNullable(ZenaDefs.getSmartTableName(process));
            this.replaceSimpleRunProcessActionWithSendMail(actionsData, actionsData.uid);
        });
        return actionsData;
    }

    private Optional<String> getUid(XmlElement actionFromDefinition) {
        return Optional.ofNullable(actionFromDefinition.getAttribute("UID")).filter(Predicate.not(String::isEmpty));
    }

    private void replaceSimpleRunProcessActionWithSendMail(ZenaActionsData actionsData, Optional<String> processUID) {
        if (this.isSimpleProcessWithEmailTask(actionsData, processUID)) {
            ZenaActionItem zenaActionItem = new ZenaActionItem();
            zenaActionItem.actionType = "SEND_EMAIL";
            this.getEmailTaskFrom(processUID).ifPresent(emailTask -> this.parseAttributes((XmlElement)emailTask, zenaActionItem));
            actionsData.actionItems.add(zenaActionItem);
            actionsData.actionType = "RUNACTION";
        }
    }

    private Optional<XmlElement> getEmailTaskFrom(Optional<String> processUID) {
        return processUID.map(uid -> ZenaXmlUtils.getProcessDefinition(this.entitiesDefinitionsManager, uid)).flatMap(process -> ZenaXmlUtils.getProcessItems(process).findFirst()).map(item -> ZenaXmlUtils.getDefinitionFromItem(this.entitiesDefinitionsManager, item));
    }

    private boolean isSimpleProcessWithEmailTask(ZenaActionsData actionsData, Optional<String> processUID) {
        if ("RUNPROCESS".equals(actionsData.actionType)) {
            return processUID.map(uid -> ZenaXmlUtils.getProcessDefinition(this.entitiesDefinitionsManager, uid)).map(process -> ZenaXmlUtils.getProcessItems(process).collect(Collectors.toList())).filter(processItems -> processItems.size() == 2).map(processItems -> {
                boolean firstTaskIsAnEmailTask;
                XmlElement firstItem = (XmlElement)processItems.get(0);
                if ("TASK".equals(firstItem.getTagName()) && (firstTaskIsAnEmailTask = Optional.ofNullable(ZenaXmlUtils.getTaskDefinitionFromItem(this.entitiesDefinitionsManager, firstItem)).filter(taskDefinition -> "TASK_EMAIL".equals(taskDefinition.getTagName())).isPresent())) {
                    XmlElement secondItem = (XmlElement)processItems.get(1);
                    return "TERMINATOR".equals(secondItem.getTagName());
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private Optional<Element> getProcessDefinition(Optional<String> actionDefinitionUID) {
        return actionDefinitionUID.map(uid -> this.entitiesDefinitionsManager.getElementByTypeAndID("PROCESS", (String)uid));
    }

    private void setActionAndEventType(XmlElement action, ZenaActionsData actionsData) {
        if (this.isStandaloneAction(action)) {
            actionsData.actionType = "RUNACTION";
            actionsData.eventType = "COMPLETE";
        } else {
            actionsData.actionType = action.getAttribute("ACTIONTYPE");
            actionsData.eventType = action.getAttribute("EVENTTYPE");
        }
    }

    private Map<String, String> getVariablesFrom(XmlElement actionFromDefinition, Optional<XmlElement> actionFromActionDefinition) {
        Map<String, String> variablesFromDefinition = this.getVariablesFrom(actionFromDefinition);
        Map<String, String> variablesFromActionDefinition = this.getVariablesFrom(actionFromActionDefinition.orElse(XmlElement.nullXmlElement));
        variablesFromActionDefinition.forEach((name, value) -> variablesFromDefinition.putIfAbsent((String)name, (String)value));
        return variablesFromDefinition;
    }

    private boolean isStandaloneAction(XmlElement action) {
        return "ACTION".equals(action.getTagName()) && action.hasAttribute("ALIAS");
    }

    private List<XmlElement> getActionItemElements(Optional<XmlElement> action) {
        return action.map(actionDefinition -> actionDefinition.getFirstChildElementByName("ACTION_ITEMS")).map(actionItemsElement -> actionItemsElement.getAllDecnedElementByName("ACTION_ITEM")).orElse(Collections.emptyList());
    }

    private Optional<XmlElement> getActionByUID(Optional<String> actionDefinitionUID) {
        return actionDefinitionUID.map(uid -> this.entitiesDefinitionsManager.getElementByTypeAndID("ACTION", (String)uid)).map(XmlElement::new);
    }

    private void createActionItems(ZenaActionsData actionsData, List<XmlElement> actionItems) {
        actionItems.forEach(actionItemElement -> {
            ZenaActionItem zenaActionItem = new ZenaActionItem();
            zenaActionItem.actionType = actionItemElement.getAttribute("ACTION_TYPE");
            this.parseAttributes((XmlElement)actionItemElement, zenaActionItem);
            actionsData.actionItems.add(zenaActionItem);
        });
    }

    private void parseAttributes(XmlElement actionItemElement, ZenaActionItem zenaActionItem) {
        List elementAttributes = actionItemElement.getFirstChildElementByName("ATTRIBUTES").getAllDirectchildsElement();
        elementAttributes.forEach(e -> zenaActionItem.attributes.put(e.getTagName(), e.getText()));
    }

    private Map<String, String> getVariablesFrom(XmlElement xmlElement) {
        XmlElement variables = Optional.ofNullable(xmlElement.getFirstChildElementByName("VARIABLES")).orElse(XmlElement.nullXmlElement);
        List variableList = variables.getAllDecnedElementByName("VARIABLE");
        return variableList.stream().collect(Collectors.toMap(v -> v.getAttribute("NAME"), v -> v.getValue()));
    }

    public ZenaActionsData parseTaskEmail(String sourceItemUid) {
        ZenaActionsData actionsData = new ZenaActionsData();
        actionsData.actionType = "RUNACTION";
        actionsData.eventType = this.convertTaskEmailEventType(sourceItemUid);
        actionsData.variables = this.getVariablesFrom(this.processDefinition, Optional.ofNullable(this.entityDefinition));
        actionsData.variables.put("ITEM_UID", this.processDefinition.getAttribute("ITEM_UID"));
        ZenaActionItem zenaActionItem = new ZenaActionItem();
        zenaActionItem.actionType = "SEND_EMAIL";
        this.parseAttributes(this.entityDefinition, zenaActionItem);
        actionsData.actionItems.add(zenaActionItem);
        return actionsData;
    }

    private String convertTaskEmailEventType(String sourceItemUid) {
        return ZenaXmlUtils.findLinkBetween(sourceItemUid, this.processDefinition).map(this::linkToOkOrNotOk).orElse("NORMAL");
    }

    private String linkToOkOrNotOk(XmlElement link) {
        String condition = link.getAttribute("CONDITION");
        if (condition.startsWith("NORMAL")) {
            return "NORMAL";
        }
        if (condition.startsWith("COMPLETE")) {
            return "COMPLETE";
        }
        return "ABNORMAL";
    }
}

