/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.handlers.actions;

import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.DoMail;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.actions.AbstractActionItemConvertor;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionItem;
import java.util.Map;

class SendMailActionItemConvertor
extends AbstractActionItemConvertor {
    private static final String ZENA_RECIPIENT_DELIMITER = ",";
    private ZenaActionItem actionItem;

    public SendMailActionItemConvertor(OnStatement onStatement, ZenaActionItem actionItem, Map<String, String> variables, ZenaJob job) {
        super(onStatement, variables, job);
        this.actionItem = actionItem;
    }

    @Override
    protected Do convertActionItem() {
        String message = this.actionItem.attributes.get("MESSAGE");
        return new DoMail(this.convertRecipients(this.actionItem.attributes.get("RECIPIENT"))).setMessage(this.replaceTheEmailVariablesTaskName(super.annotateVariables(message))).setSubject(this.replaceTheEmailVariablesTaskName(super.annotateVariables(this.actionItem.attributes.get("SUBJECT")))).setUrgancy(this.convertImportance(this.actionItem.attributes.get("IMPORTANCE"))).setAttachSysout(this.determineAttachSysout(message));
    }

    private DoMail.AttachSysout determineAttachSysout(String message) {
        DoMail.AttachSysout attachSysout = DoMail.AttachSysout.DEFAULT;
        if (message.contains("[TASK.OUTPUT]") || this.variableContainsTaskOutput()) {
            attachSysout = DoMail.AttachSysout.YES;
        }
        return attachSysout;
    }

    private boolean variableContainsTaskOutput() {
        return this.variables.values().stream().anyMatch(value -> value.contains("[TASK.OUTPUT]"));
    }

    private String[] convertRecipients(String recipients) {
        String annotatedRecipients = super.annotateVariables(recipients);
        annotatedRecipients = this.replaceTheEmailVariablesTaskName(annotatedRecipients);
        return annotatedRecipients.split(ZENA_RECIPIENT_DELIMITER);
    }

    String convertImportance(String importance) {
        switch (importance) {
            case "LOW": {
                return "R";
            }
            case "NORMAL": {
                return "U";
            }
            case "HIGH": {
                return "V";
            }
        }
        return "R";
    }

    private String replaceTheEmailVariablesTaskName(String annotatedRecipients) {
        if (this.variables.containsKey("ITEM_UID")) {
            String itemUID = (String)this.variables.get("ITEM_UID");
            for (String name : this.variables.keySet()) {
                String variableTaskName = "%%" + itemUID + name;
                if (!this.job.getAutoedits().containsKey(variableTaskName)) continue;
                annotatedRecipients = annotatedRecipients.replace("%%" + name, variableTaskName);
            }
        }
        return annotatedRecipients;
    }
}

