/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.handlers.actions;

import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.DoShout;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.actions.AbstractActionItemConvertor;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionItem;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SendAlertActionItemConvertor
extends AbstractActionItemConvertor {
    public static final String ZENA_ALERT_TYPE = "ALERT_TYPE";
    public static final String ZENA_ALERT_TITLE = "TITLE";
    public static final String ZENA_ALERT_MESSAGE = "MESSAGE";
    private final ZenaActionItem actionItem;
    public static final String ZENA_ALERT_PRIORITY_1 = "1";
    public static final String ZENA_ALERT_PRIORITY_2 = "2";

    public SendAlertActionItemConvertor(OnStatement onStatement, ZenaActionItem actionItem, Map<String, String> variables, ZenaJob job) {
        super(onStatement, variables, job);
        this.actionItem = actionItem;
    }

    @Override
    protected Do convertActionItem() {
        DoShout doShout = new DoShout("EM");
        doShout.setMessage(this.convertMessage());
        doShout.setUrgancy(this.convertImportance());
        return doShout;
    }

    private String convertImportance() {
        return switch (this.actionItem.attributes.get("PRIORITY")) {
            case ZENA_ALERT_PRIORITY_1 -> "V";
            case ZENA_ALERT_PRIORITY_2 -> "U";
            default -> "R";
        };
    }

    private String convertMessage() {
        String alertType = this.actionItem.attributes.get(ZENA_ALERT_TYPE);
        String alertTitle = this.actionItem.attributes.get(ZENA_ALERT_TITLE);
        String alertMessage = this.actionItem.attributes.get(ZENA_ALERT_MESSAGE);
        List<String> messageItems = Arrays.asList(alertType, alertTitle, alertMessage);
        String joinedMessage = messageItems.stream().filter(m -> !m.isEmpty()).collect(Collectors.joining(" - "));
        return super.annotateVariables(joinedMessage);
    }
}

