/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.handlers.actions;

import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.DoForceJob;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import com.bmc.ctmconvert.zena.handlers.actions.ActionItemConvertorFactory;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionConvertor;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionItem;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionsData;
import java.util.Map;

public class DefaultZenaActionConvertor
implements ZenaActionConvertor {
    private OnStatement onStatement;
    private ZenaJob job;
    private ZenaActionsData action;

    public DefaultZenaActionConvertor(OnStatement onStatement, ZenaJob job, ZenaActionsData action) {
        this.onStatement = onStatement;
        this.job = job;
        this.action = action;
    }

    @Override
    public void convertAction() {
        if ("RUNPROCESS".equals(this.action.actionType)) {
            new RunProcessActionConvertor().convert();
        } else {
            this.convertActionItemsToDo(this.action);
        }
        this.addOnStatement();
    }

    private void convertActionItemsToDo(ZenaActionsData action) {
        action.actionItems.forEach(actionItem -> this.convertActionItem((ZenaActionItem)actionItem, action.variables));
    }

    private void convertActionItem(ZenaActionItem actionItem, Map<String, String> variables) {
        new ActionItemConvertorFactory(this.job::addMessageWithJobNameAndOriginalJobName).createActionItemConvertor(this.onStatement, actionItem, variables, this.job).convert();
    }

    private void addOnStatement() {
        if (this.onStatement.hasDoStatements()) {
            this.job.addOnDoStatement(this.onStatement);
        }
    }

    private class RunProcessActionConvertor {
        private RunProcessActionConvertor() {
        }

        public void convert() {
            DefaultZenaActionConvertor.this.action.processName.ifPresent(processName -> {
                DoForceJob doForceJob = this.createDoForceJob(DefaultZenaActionConvertor.this.action, (String)processName);
                DefaultZenaActionConvertor.this.onStatement.addDo((Do)doForceJob);
            });
        }

        private DoForceJob createDoForceJob(ZenaActionsData runProcessAction, String processName) {
            DoForceJob doForceJob = new DoForceJob(processName, Do.REMOTE.NO);
            runProcessAction.variables.forEach((name, value) -> {
                ZenaVariablesHandler variableHandler = DefaultZenaActionConvertor.this.job.getZenaVariablesHandler();
                String variableName = variableHandler.convertToCtmVariableName((String)name);
                String variableValue = variableHandler.annotateVariables((String)value);
                doForceJob.putVariable(variableName, variableValue);
            });
            return doForceJob;
        }
    }
}

