/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.handlers;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.interfaces.AttributeSetter;
import com.bmc.ctmconvert.interfaces.BooleanFieldSetter;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ZenaAgentHandler {
    private EntitiesDefinitionsManager entitiesDefinitionsManager;
    private String parentUID;
    private Element agent;
    private String originalJobName;

    public ZenaAgentHandler(EntitiesDefinitionsManager entitiesDefinitionsManager, String parentUID, Element entityProcessData, Element entityDefinition) {
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
        this.parentUID = parentUID;
        this.originalJobName = entityProcessData.getAttribute("ALIAS");
        this.agent = this.getAgentElement(entityProcessData, entityDefinition);
    }

    public void handle(MessageHandler messageHandler, AttributeSetter attributeSetter, BooleanFieldSetter isWindows) {
        String nodedID = this.getNodeId(this.parentUID, this.agent, messageHandler, attributeSetter, isWindows);
        this.validateAgent(nodedID, messageHandler, attributeSetter);
    }

    private String getNodeId(String parentUID, Element agent, MessageHandler messageHandler, AttributeSetter attributeSetter, BooleanFieldSetter isWindows) {
        String nodeID = "";
        if (agent != null) {
            String agentType;
            String agentUID = agent.getAttribute("UID");
            switch (agentType = agent.getAttribute("AGENTTYPE")) {
                case "LIST": {
                    nodeID = this.getAgentName(agentUID, "AGENTLIST", "NAME");
                    break;
                }
                case "REMOTE": {
                    nodeID = this.getAgentName(agentUID, "AGENT", "COMPUTER");
                    this.setIsWindows(agentUID, isWindows);
                    break;
                }
                case "PROCESS": {
                    nodeID = this.handleProcessAgent(parentUID, messageHandler, attributeSetter, isWindows);
                    break;
                }
                default: {
                    messageHandler.handleMessage("WRN15030", new String[]{this.originalJobName, agentType});
                }
            }
        }
        return nodeID;
    }

    private String handleProcessAgent(String parentUID, MessageHandler messageHandler, AttributeSetter attributeSetter, BooleanFieldSetter isWindows) {
        Element parentElement = this.entitiesDefinitionsManager.getElementByTypeAndID("PROCESS", parentUID);
        XmlElement parent = XmlElement.ofNullable((Element)parentElement);
        List agents = parent.getDirectchildsElementbyName("AGENT");
        return agents.stream().findFirst().map(parentAgent -> this.getNodeId(null, parentAgent.getElement(), messageHandler, attributeSetter, isWindows)).orElse("");
    }

    private Element getAgentElement(Element entityProcessData, Element entityDefinition) {
        NodeList agentList = entityProcessData.getElementsByTagName("AGENT");
        Node tempAgent = agentList != null && agentList.getLength() > 0 ? agentList.item(0) : entityDefinition.getElementsByTagName("AGENT").item(0);
        return (Element)tempAgent;
    }

    private String getAgentName(String agentUID, String agentType, String attrForName) {
        Optional<Element> node = Optional.ofNullable(this.entitiesDefinitionsManager.getElementByTypeAndID(agentType, agentUID));
        return node.map(n -> n.getAttribute(attrForName)).orElse("");
    }

    private void setIsWindows(String agentUID, BooleanFieldSetter isWindows) {
        IAttrHolder agentTableRow;
        Element node = this.entitiesDefinitionsManager.getElementByTypeAndID("AGENT", agentUID);
        if (node != null && (agentTableRow = this.entitiesDefinitionsManager.getAgentTableRow(node.getAttribute("NAME"))) != null) {
            String osType = agentTableRow.getAttr("OSTYPE");
            if (osType == null) {
                osType = agentTableRow.getAttr("OSTYPE".toLowerCase());
            }
            isWindows.setField(osType.toLowerCase().contains("windows"));
        }
    }

    private void validateAgent(String orignal_nodeid, MessageHandler messageHandler, AttributeSetter attributeSetter) {
        String valid_name = FieldValidation.instance().validateAndReturnFixedValue("NODEID", orignal_nodeid);
        if (!orignal_nodeid.equals(valid_name)) {
            messageHandler.handleMessage("INF15007", new String[]{orignal_nodeid, valid_name});
        }
        attributeSetter.setAttribute("NODEID", valid_name);
    }
}

