/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.handlers;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.ZenaDefs;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.w3c.dom.Element;

public class ItemVariablesHandler {
    private final ZenaVariablesHandler zenaVariablesHandler;
    public static final String ITEMS_VARIABLE_PATTERN = "^ITEMS\\.(.*?)\\.VARIABLE\\.(.*)$";

    public ItemVariablesHandler(ZenaVariablesHandler zenaVariablesHandler) {
        this.zenaVariablesHandler = zenaVariablesHandler;
    }

    boolean isItemsVariable(String zenaVariableName) {
        return zenaVariableName.matches(ITEMS_VARIABLE_PATTERN);
    }

    String convertToItemsVariableReference(String zenaVariableName, Optional<String> variableUid, Optional<String> itemUid) {
        return "%%" + this.createItemsVariableName(zenaVariableName, variableUid, itemUid);
    }

    String convertToItemsVariableName(String zenaVariableName, Optional<String> variableUid, Optional<String> itemUid) {
        String variableName = this.createItemsVariableName(zenaVariableName, variableUid, itemUid);
        return this.zenaVariablesHandler.formatSmartVariable(variableName);
    }

    private String createItemsVariableName(String zenaVariableName, Optional<String> variableUid, Optional<String> itemUid) {
        String prefix = this.getItemVariablePrefix(zenaVariableName, variableUid, itemUid) + "_";
        String variableName = this.getVariableName(zenaVariableName, itemUid, variableUid);
        if (this.shouldNotAddItemUidPrefix(variableName, zenaVariableName)) {
            return this.zenaVariablesHandler.validateVariableName(variableName);
        }
        return this.zenaVariablesHandler.validateVariableName(prefix + variableName);
    }

    private String getItemVariablePrefix(String zenaVariableName, Optional<String> variableUid, Optional<String> itemUid) {
        return itemUid.orElse(this.findItemAlias(this.parseItemAliasOf(zenaVariableName), variableUid));
    }

    private boolean shouldNotAddItemUidPrefix(String variableName, String zenaVariableName) {
        Boolean ruleIsEnabled = Optional.ofNullable(this.zenaVariablesHandler.getJob()).map(ZenaJob::getRules).map(ZenaDefs::addZenaItemUidOnlyWhenNeeded).orElse(false);
        String jobName = this.parseItemAliasOf(zenaVariableName);
        return ruleIsEnabled != false && this.zenaVariablesHandler.getJob().getSmartFolder().getVariablesMapping().hasJobWithVariable(jobName, variableName);
    }

    private String getVariableName(String zenaVariableName, Optional<String> variableItemUid, Optional<String> variableUid) {
        return this.findDataVariableNameFromTaskDefinition(variableItemUid, variableUid).orElseGet(() -> this.parseVariableNameOf(zenaVariableName));
    }

    private String parseVariableNameOf(String zenaVariableName) {
        String VARIABLE_NAME_GROUP = "$2";
        return zenaVariableName.replaceAll(ITEMS_VARIABLE_PATTERN, VARIABLE_NAME_GROUP);
    }

    private Optional<String> findDataVariableNameFromTaskDefinition(Optional<String> variableItemUid, Optional<String> variableUid) {
        return variableItemUid.flatMap(varItemUid -> variableUid.flatMap(varUid -> this.findEntityUidByItemUid((String)varItemUid).flatMap(taskUid -> this.findVariableNameFromTaskDefinition((String)taskUid, (String)varUid))));
    }

    private Optional<String> findEntityUidByItemUid(String variableItemUid) {
        return this.findProcessItems().flatMap(allItems -> allItems.filter(item -> item.hasAttributeWithValue("ITEM_UID", variableItemUid)).map(item -> item.getAttribute("UID")).findFirst());
    }

    private Optional<String> findVariableNameFromTaskDefinition(String taskUid, String variableUid) {
        return this.getItemDefinition(taskUid).getAllDecnedElementByName("VARIABLE").stream().filter(variable -> variableUid.equals(variable.getAttribute("UID"))).map(variable -> variable.getAttribute("NAME")).findFirst();
    }

    private XmlElement getItemDefinition(String uid) {
        Element itemDefinition = this.zenaVariablesHandler.getEntitiesDefinitionsManager().getElementByID(uid);
        return XmlElement.ofNullable((Element)itemDefinition);
    }

    private String findItemAlias(String variableReferenceItemAlias, Optional<String> variableUid) {
        Optional itemUid = variableUid.flatMap(this::tryGettingItemUidUsingVariableUid);
        return itemUid.orElse(this.getItemUidFromProcessItems(variableReferenceItemAlias));
    }

    private String getItemUidFromProcessItems(String variableReferenceItemAlias) {
        return this.findProcessItems().flatMap(this.findItemWithAlias(variableReferenceItemAlias)).map(e -> e.getAttribute("ITEM_UID")).orElse(this.getJobNameInsteadOfItemUid(variableReferenceItemAlias));
    }

    private String getJobNameInsteadOfItemUid(String variableReferenceItemAlias) {
        return Optional.ofNullable(this.zenaVariablesHandler.getJob()).map(job -> job.issueMissingItemMessageAndReturnDefaultedName(variableReferenceItemAlias)).orElse(variableReferenceItemAlias);
    }

    private Function<Stream<XmlElement>, Optional<XmlElement>> findItemWithAlias(String variableReferenceItemAlias) {
        return items -> items.filter(e -> variableReferenceItemAlias.equals(e.getAttribute("ALIAS"))).findFirst();
    }

    private Optional<String> tryGettingItemUidUsingVariableUid(String variableUid) {
        if (this.isDataTask()) {
            return this.findProcessItems().flatMap(allItems -> allItems.filter(item -> {
                String uid = item.getAttribute("UID");
                return this.getItemDefinition(uid).getAllDecnedElementByName("VARIABLE").stream().anyMatch(variable -> variableUid.equals(variable.getAttribute("UID")));
            }).findFirst().map(e -> e.getAttribute("ITEM_UID")));
        }
        return Optional.empty();
    }

    private boolean isDataTask() {
        return "DATA".equals(this.zenaVariablesHandler.getEntityProcessData().getTagName());
    }

    private Optional<Stream<XmlElement>> findProcessItems() {
        return this.zenaVariablesHandler.getEntityProcessData().findParent(e -> e.getTagName().equals("ITEMS")).map(XmlElement::getAllDirectchildsElement).map(Collection::stream);
    }

    private String parseItemAliasOf(String zenaVariableName) {
        String ITEM_ALIAS_GROUP = "$1";
        return zenaVariableName.replaceAll(ITEMS_VARIABLE_PATTERN, ITEM_ALIAS_GROUP);
    }
}

