/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.handlers;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.dummy.DummyUtils;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.ZenaJob;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.w3c.dom.Element;

public class EnableFlagHandler {
    private static final String ENABLED_FLAG_ENABLED = "1";
    private final XmlElement entityDefinition;
    private final XmlElement processDefinition;

    public EnableFlagHandler(Element entityDefinition, Element processDefinition) {
        this.entityDefinition = XmlElement.ofNullable((Element)entityDefinition);
        this.processDefinition = XmlElement.ofNullable((Element)processDefinition);
    }

    public boolean isEnabled() {
        return this.processDoesntHaveSkip() && (this.hasNoUID() || this.hasDefinitionWithEnableFlagEnabled() != false);
    }

    private boolean processDoesntHaveSkip() {
        return !"YES".equals(this.processDefinition.getAttribute("SKIP"));
    }

    private boolean hasNoUID() {
        return !this.entityDefinition.hasAttribute("UID");
    }

    private Boolean hasDefinitionWithEnableFlagEnabled() {
        Optional parentDefinition = this.entityDefinition.findParent(e -> "DEFINITION".equals(e.getTagName()));
        return this.doesNotHaveEnableFlagAttribute(parentDefinition) || this.isEnabledAccordingToEnableFlag(parentDefinition);
    }

    private boolean isEnabledAccordingToEnableFlag(Optional<XmlElement> parentDefinition) {
        return parentDefinition.map(e -> e.getAttribute("ENABLE_FLAG")).filter(e -> e.equals(ENABLED_FLAG_ENABLED)).isPresent();
    }

    private boolean doesNotHaveEnableFlagAttribute(Optional<XmlElement> parentDefinition) {
        return parentDefinition.filter(e -> !e.hasAttribute("ENABLE_FLAG")).isPresent();
    }

    public void handleJob(ZenaJob job) {
        if (!this.isEnabled()) {
            DummyUtils.setRunAsDummyFor((SchedEntity)job);
            this.addDisableVariableToDisabledJob(job);
        }
    }

    private void addDisableVariableToDisabledJob(ZenaJob job) {
        job.addAutoEdits("ZENA_DISABLED_ENTITY", "ZENA_DISABLED_ENTITY");
    }

    public void disableSchedulingForDisabledTopLevelEntity(ZenaJob zenaJob, LocalDate today) {
        if (this.isEnabled()) {
            return;
        }
        if (zenaJob.isSmart()) {
            this.addDisableVariableToDisabledJob(zenaJob);
            List<Properties> rbcs = zenaJob.getTags();
            for (Properties rbc : rbcs) {
                rbc.setProperty("ACTIVE_TILL", today.format(DateTimeFormatter.BASIC_ISO_DATE));
            }
        }
    }
}

