/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.folders;

import com.bmc.ctmconvert.zena.folders.IFolderNode;

public class FolderNode
implements IFolderNode {
    private final String name;
    private final String uid;
    private final String parentUid;
    private String folderId;
    private static final IFolderNode empty = new EmptyFolderNode();

    public FolderNode(String name, String folderId, String uid, String parentId) {
        this.name = name;
        this.uid = uid;
        this.folderId = folderId;
        this.parentUid = parentId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getFolderId() {
        return this.folderId;
    }

    @Override
    public boolean hasParent() {
        return !this.parentUid.isEmpty();
    }

    @Override
    public String getParentUid() {
        return this.parentUid;
    }

    public static IFolderNode empty() {
        return empty;
    }

    private static class EmptyFolderNode
    implements IFolderNode {
        private static final String EMPTY_VALUE = "";

        private EmptyFolderNode() {
        }

        @Override
        public String getName() {
            return EMPTY_VALUE;
        }

        @Override
        public String getUid() {
            return EMPTY_VALUE;
        }

        @Override
        public String getFolderId() {
            return EMPTY_VALUE;
        }

        @Override
        public boolean hasParent() {
            return false;
        }

        @Override
        public String getParentUid() {
            return EMPTY_VALUE;
        }
    }
}

