/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.events.event_directory;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.DoForceJob;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.events.ProcessDetails;
import com.bmc.ctmconvert.zena.events.event_directory.EventDirectoryData;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import com.bmc.ctmconvert.zena.utils.ZenaUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class EventDirectoryConvertor {
    public static final String SOURCE_PATH_SEPARATOR = ",";
    private static final String FILENAME = "filename";
    private static final String FILENAME_VARIABLE = "%%filename";
    private static final String FILES_TO_PROCESS = "files_to_process";
    private static final String CTM_NODE_GROUP_VALUE = "%%NODEGRP";
    private final EventDirectoryData eventDirectory;
    private final ZenaJob job;
    private final ProcessDetails mainProcess;
    private final Collection<ProcessDetails> processes;
    private final ZenaVariablesHandler zenaVariablesHandler;

    public EventDirectoryConvertor(EventDirectoryData eventDirectory, ZenaJob job, ProcessDetails mainProcess, Collection<ProcessDetails> processes, ZenaVariablesHandler zenaVariablesHandler) {
        this.eventDirectory = eventDirectory;
        this.job = job;
        this.mainProcess = mainProcess;
        this.processes = processes;
        this.zenaVariablesHandler = zenaVariablesHandler;
    }

    public void convert() {
        this.setDefaultAftJobAttributes();
        this.setDefaultAftJobVariables();
        this.convertOperation();
        this.setConnectionProfile();
        this.convertSourcePathAndFileMask();
        this.convertTargetPath();
        this.setOSType();
        this.convertOnDoActions();
        this.convertJobRunningTime();
        this.addCyclic();
        this.job.handleEnableFlag();
    }

    private void addCyclic() {
        this.job.addAttribute("CYCLIC", "1");
        this.job.addAttribute("INTERVAL", String.format("%05dM", this.calculateCyclicInterval()));
    }

    private int calculateCyclicInterval() {
        try {
            double intervalInSeconds = Double.parseDouble(this.eventDirectory.getCyclicIntervalSeconds());
            double intervalInMinutes = intervalInSeconds < 60.0 ? 1.0 : intervalInSeconds / 60.0;
            return (int)Math.ceil(intervalInMinutes);
        }
        catch (Exception ex) {
            return 1;
        }
    }

    private String getOsTypeByPath(String path) {
        return this.isWindows(path) ? "Windows" : "UNIX";
    }

    private void setOSType() {
        this.job.addAutoEdits("%%FTP-LOSTYPE", this.getOsTypeByPath(this.eventDirectory.getSourcePath()));
        this.job.addAutoEdits("%%FTP-ROSTYPE", this.getOsTypeByPath(this.eventDirectory.getTargetPath()));
    }

    private void setConnectionProfile() {
        String user = this.job.getAttr("OWNER");
        String accountUser = user == null ? "" : user;
        accountUser = ZenaUtils.extractUserAccount(accountUser);
        String validAccountName = FieldValidation.instance().validateAndReturnFixedValue("AFT_ACCOUNT_NAME", "Local_CP" + (String)(accountUser.isEmpty() ? "" : "_" + accountUser));
        String accountCP = validAccountName + "+" + validAccountName;
        this.job.addAutoEdits("%%FTP-ACCOUNT", accountCP);
        this.job.addAutoEdits("%%FTP-LHOST", "Local_CP");
        this.job.addAutoEdits("%%FTP-RHOST", "Local_CP");
        this.job.addAutoEdits("%%FTP-CONNTYPE1", "Local_CP");
        this.job.addAutoEdits("%%FTP-CONNTYPE2", "Local_CP");
        this.addActionForConnectionProfile(accountCP, accountUser);
    }

    private void addActionForConnectionProfile(String account, String user) {
        HashMap<String, String> fileTransferAction = new HashMap<String, String>();
        fileTransferAction.put("ACTENTTYPE", "AFTACC");
        fileTransferAction.put("JOBID", this.job.getAttr("JOBNAME"));
        fileTransferAction.put("ACTENTNAME", account);
        fileTransferAction.put("ACTSTATUS", "0");
        String distributedJobType = this.job.isDSJob() ? "Unix" : "MVS";
        String osType = this.job.isWindows() ? "Windows" : distributedJobType;
        String params = String.format("%s=%s;%s=%s;%s=%s;%s=%s;%s=%s", "AFTLOSTYPE", osType, "AFTLTARGETAGENT", this.job.getAttr("NODEID"), "AFTLUSER", user, "SERVER", Params.instance().getDatacenterName(), "AFTCPTYPE", Globs.AFT_ACCOUNT_TYPES.LOCAL_TO_LOCAL.name());
        fileTransferAction.put("ACTPARAMETERS", params);
        this.job.addAction(fileTransferAction);
    }

    private void convertOnDoActions() {
        OnStatement onOkStatement = this.convertOnOkDoAction();
        this.job.addOnDoStatement(onOkStatement);
        OnStatement onCompletionStatus = this.convertOnOsCompletionStatusAction();
        this.job.addOnDoStatement(onCompletionStatus);
        OnStatement.OnNotOkStatement onNotOkStatement = this.convertOnNotOkAction();
        this.job.addOnDoStatement((OnStatement)onNotOkStatement);
    }

    private OnStatement.OnNotOkStatement convertOnNotOkAction() {
        OnStatement.OnNotOkStatement onNotOkStatement = OnStatement.createOnNotOkStatement();
        Do stopCyclic = Do.createStopCyclic();
        onNotOkStatement.addDo(stopCyclic);
        return onNotOkStatement;
    }

    private OnStatement convertOnOsCompletionStatusAction() {
        OnStatement.OnCompletionStatus onCompletionStatus = OnStatement.createOnCompletionStatus((int)7);
        Do doOk = Do.createDoOk();
        onCompletionStatus.addDo(doOk);
        return onCompletionStatus;
    }

    private OnStatement convertOnOkDoAction() {
        OnStatement.OnCompletionStatus onStatement = OnStatement.createOnCompletionStatus((int)0);
        this.processes.forEach(arg_0 -> this.lambda$convertOnOkDoAction$0((OnStatement)onStatement, arg_0));
        return onStatement;
    }

    private void convertDoForceJob(OnStatement onStatement, ProcessDetails process) {
        DoForceJob doForceJob = this.createDoForceJob(process);
        onStatement.addDo((Do)doForceJob);
    }

    private DoForceJob createDoForceJob(ProcessDetails process) {
        DoForceJob doForceJob = new DoForceJob(process.getName(), Do.REMOTE.YES, Params.instance().getDatacenterName());
        return this.setDoForceJobVariables(doForceJob, process);
    }

    private DoForceJob setDoForceJobVariables(DoForceJob doForceJob, ProcessDetails process) {
        UnaryOperator validateProcessVariable = variable -> this.zenaVariablesHandler.convertToCtmVariableName("PROCESS.VARIABLE." + variable);
        doForceJob.putVariable(CTM_NODE_GROUP_VALUE, "%%NODEID");
        process.getVariables().forEach(nameAndAttribute -> {
            String eventAttribute;
            String variableName = (String)validateProcessVariable.apply((String)nameAndAttribute.getKey());
            switch (eventAttribute = (String)nameAndAttribute.getValue()) {
                case "[EVENT.ATTRIBUTE.FILENAME]": {
                    doForceJob.putVariable(variableName, this.job.getZenaVariablesHandler().annotateVariables(FILENAME_VARIABLE));
                    break;
                }
                case "[EVENT.ATTRIBUTE.FILEPATH]": {
                    doForceJob.putVariable(variableName, this.job.getZenaVariablesHandler().annotateVariables(this.appendSeparatorIfNeeded(this.getTargetPathByOperation())));
                    break;
                }
                case "[EVENT.ATTRIBUTE.FULLFILENAME]": {
                    doForceJob.putVariable(variableName, this.job.getZenaVariablesHandler().annotateVariables(this.appendSeparatorIfNeeded(this.getTargetPathByOperation()) + FILENAME_VARIABLE));
                    break;
                }
                case "[EVENT.ATTRIBUTE.TARGET_PATH]": {
                    doForceJob.putVariable(variableName, this.job.getZenaVariablesHandler().annotateVariables(this.getTargetPathByOperation()));
                    break;
                }
                case "[EVENT.ATTRIBUTE.SOURCE_PATH]": {
                    doForceJob.putVariable(variableName, this.job.getZenaVariablesHandler().annotateVariables(this.appendSeparatorIfNeeded(this.eventDirectory.getSourcePath())));
                    break;
                }
                case "[EVENT.ATTRIBUTE.SOURCE_FILEMASK]": {
                    doForceJob.putVariable(variableName, this.job.getZenaVariablesHandler().annotateVariables(this.eventDirectory.getSourceFilemask()));
                    break;
                }
                case "[EVENT.ATTRIBUTE.OPERATION]": {
                    doForceJob.putVariable(variableName, this.job.getZenaVariablesHandler().annotateVariables(this.eventDirectory.getOperation()));
                    break;
                }
                case "[EVENT.ATTRIBUTE.JOBNAME]": {
                    doForceJob.putVariable(variableName, this.job.getAttr("JOBNAME"));
                    break;
                }
            }
        });
        return doForceJob;
    }

    private void convertOperation() {
        this.convertMoveOperation();
        List<String> unsupportedTypes = Arrays.asList("DELETE", "RENAME");
        if (unsupportedTypes.contains(this.eventDirectory.getOperation())) {
            this.generateUnsupportedOperationWarningMessage(this.eventDirectory.getOperation());
        }
    }

    private void generateUnsupportedOperationWarningMessage(String operation) {
        this.job.addMessage("WRN15034", this.job.getTablePathForSons(), this.eventDirectory.getEventJobName(), operation, this.mainProcess.getName());
    }

    private void convertMoveOperation() {
        this.job.addAutoEdits("%%FTP-UPLOAD1", "3");
        this.job.addAutoEdits("%%FTP-TRANSFER_ALL1", "1");
        this.job.addAutoEdits("%%FTP-SRCOPT1", "1");
        this.job.addAutoEdits("%%FTP-FW_TRANSFER_ALL_MATCH_CRITERIA1", "1");
        this.job.addAutoEdits("%%FTP-IF_EXIST1", this.overwriteOrSkip());
    }

    private String overwriteOrSkip() {
        return this.eventDirectory.getWriteover().equals("Y") ? "0" : "3";
    }

    private void convertTargetPath() {
        String rPath = this.appendSeparatorIfNeeded(this.getTargetPathByOperation());
        rPath = this.job.getZenaVariablesHandler().annotateVariables(rPath);
        this.job.addAutoEdits("%%FTP-RPATH1", rPath);
    }

    private String getTargetPathByOperation() {
        Object targetPath = this.eventDirectory.getTargetPath();
        if (this.eventDirectory.getOperation().equals("NOOP")) {
            targetPath = this.appendSeparatorIfNeeded(this.eventDirectory.getSourcePath()) + FILES_TO_PROCESS;
        }
        return targetPath;
    }

    private void convertSourcePathAndFileMask() {
        String lPath = this.concatSourcePathAndFileMask();
        lPath = this.job.getZenaVariablesHandler().annotateVariables(lPath);
        this.job.addAutoEdits("%%FTP-LPATH1", lPath);
    }

    private String concatSourcePathAndFileMask() {
        return this.appendSeparatorIfNeeded(this.splitFirstPath(this.eventDirectory.getSourcePath())) + this.eventDirectory.getSourceFilemask();
    }

    private String splitFirstPath(String sourcePath) {
        return sourcePath.split(SOURCE_PATH_SEPARATOR)[0];
    }

    private String appendSeparatorIfNeeded(String sourcePath) {
        if (this.shouldAppendSeparator(sourcePath, this::endsWithSeparatorOrVariableBracket)) {
            String separator = this.determineSeparator(sourcePath);
            return sourcePath + separator;
        }
        return sourcePath;
    }

    private String prependSeparatorIfNeeded(String sourcePath) {
        if (this.shouldAppendSeparator(sourcePath, this::startsWithSeparatorOrVariableBracket)) {
            String separator = this.determineSeparator(sourcePath);
            return separator + sourcePath;
        }
        return sourcePath;
    }

    private boolean shouldAppendSeparator(String sourcePath, Predicate<String> action) {
        return !sourcePath.isEmpty() && !action.test(sourcePath);
    }

    private String determineSeparator(String sourcePath) {
        if (this.isWindows(sourcePath)) {
            return "\\";
        }
        return "/";
    }

    private boolean isWindows(String path) {
        return path.contains("\\");
    }

    private boolean endsWithSeparatorOrVariableBracket(String sourcePath) {
        return sourcePath.endsWith("/") || sourcePath.endsWith("\\") || sourcePath.endsWith("]");
    }

    private boolean startsWithSeparatorOrVariableBracket(String sourcePath) {
        return sourcePath.startsWith("/") || sourcePath.startsWith("\\") || sourcePath.startsWith("[");
    }

    private void setDefaultAftJobAttributes() {
        this.job.addAttribute("TASKTYPE", "Job");
        this.job.addAttribute("APPL_TYPE", "FILE_TRANS");
        this.job.addAttribute("APPL_VER", "6.1.01");
        this.job.addAttribute("APPL_FORM", "AFT");
        this.job.addAttribute("CM_VER", "8.2.0");
        this.job.addAttribute("MULTY_AGENT", "Y");
    }

    private void setDefaultAftJobVariables() {
        this.job.addAutoEdits("%%FTP-LPASSIVE", "0");
        this.job.addAutoEdits("%%FTP-RPASSIVE", "0");
        this.job.addAutoEdits("%%FTP-TRANSFER_NUM", "1");
        this.job.addAutoEdits("%%FTP-CONT_EXE_NOTOK", "0");
        this.job.addAutoEdits("%%FTP-RPF", "0");
        this.job.addAutoEdits("%%FTP-USE_DEF_NUMRETRIES", "0");
        this.job.addAutoEdits("%%FTP-NUM_RETRIES", "5");
        this.job.addAutoEdits("%%FTP-AUTOREFRESH", "False");
        this.job.addAutoEdits("%%FTP-TYPE1", "I");
        this.job.addAutoEdits("%%FTP-TIMELIMIT_UNIT1", "1");
        this.job.addAutoEdits("%%FTP-TIMELIMIT1", "0");
        this.job.addAutoEdits("%%FTP-ABSTIME1", "0");
        this.job.addAutoEdits("%%FTP-WATCHNAME1", FILENAME);
        this.job.addAutoEdits("%%FTP-WATCH_VAR_TYPE1", "Local");
        this.job.addAutoEdits("%%FTP-OVERRIDE_WATCH_INTERVAL1", "0");
        this.job.addAutoEdits("%%FTP-WATCH_INTERVAL1", "30");
        this.job.addAutoEdits("%%FTP-DSTOPT1", "0");
        this.job.addAutoEdits("%%FTP-UNIQUE1", "0");
        this.job.addAutoEdits("%%FTP-RECURSIVE1", "0");
        this.job.addAutoEdits("%%FTP-TRIM1", "1");
        this.job.addAutoEdits("%%FTP-VERNUM1", "0");
        this.job.addAutoEdits("%%FTP-EXCLUDE_WILDCARD1", "0");
        this.job.addAutoEdits("%%FTP-CASEIFS1", "0");
        this.job.addAutoEdits("%%FTP-CONT_EXE_NOTOK", "0");
        this.job.addAutoEdits("%%FTP-RPF", "0");
        this.job.addAutoEdits("%%FTP-USE_DEF_NUMRETRIES", "0");
        this.job.addAutoEdits("%%FTP-NUM_RETRIES", "5");
        this.job.addAutoEdits("%%FTP-Is", "5");
        this.job.addAutoEdits("%%FTP-AUTOREFRESH", "False");
    }

    private void convertJobRunningTime() {
        this.job.addAttribute("TIMETO", "2355");
        this.job.addAutoEdits("%%FTP-TIMELIMIT1", "2358");
        this.job.addAutoEdits("%%FTP-TIMELIMIT_UNIT1", "23");
        this.job.addAutoEdits("%%FTP-ABSTIME1", "1");
    }

    private /* synthetic */ void lambda$convertOnOkDoAction$0(OnStatement onStatement, ProcessDetails process) {
        this.convertDoForceJob(onStatement, process);
    }
}

