/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.conditions;

import com.bmc.ctmconvert.zena.tasktypes.ExitCodeConverter;
import java.util.Collection;
import java.util.function.Supplier;
import org.w3c.dom.Element;

public class LinkItem {
    private static final ExitCodeConverter.ExitCodesExtractor exitCodesExtractor = new ExitCodeConverter.ExitCodesExtractor();
    private final Element source;
    private final Element target;
    private final Element link;

    public LinkItem(Element source, Element target, Element link) {
        this.source = source;
        this.target = target;
        this.link = link;
    }

    public Element getSource() {
        return this.source;
    }

    public Element getLink() {
        return this.link;
    }

    public Element getTarget() {
        return this.target;
    }

    protected String getAttribute(String xmlAttributeValue, Supplier<Element> from) {
        return from.get().getAttribute(xmlAttributeValue);
    }

    public boolean isFlow() {
        String sourceTagName = this.source.getTagName();
        return sourceTagName.contentEquals("FLOW");
    }

    public boolean isOptionalCondition() {
        return "YES".equals(this.getLink().getAttribute("OPTIONAL"));
    }

    public boolean isReturnValueLink() {
        boolean isTaskDefinition = this.source.getTagName().equals("TASK");
        Collection<Integer> exitCodes = this.getExitCodes();
        return !exitCodes.isEmpty() && isTaskDefinition;
    }

    public Collection<Integer> getExitCodes() {
        String value = this.link.getAttribute("VALUES");
        return exitCodesExtractor.extractExitCodes(value);
    }
}

