/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.ZenaJob;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ZenaPolicyProcessor {
    private static final String TIME = "TIME";
    private static final String PERPETUAL = "PERPETUAL";
    private static final String PERIOD = "PERIOD";
    private final SchedEntity.TYPE type;
    private final XmlElement entityDefinition;
    private final ZenaJob zenaJob;

    public ZenaPolicyProcessor(SchedEntity.TYPE type, Element entityDefinition, ZenaJob zenaJob) {
        this.type = type;
        this.entityDefinition = XmlElement.ofNullable((Element)entityDefinition);
        this.zenaJob = zenaJob;
    }

    public void processPolicy() {
        XmlElement policies;
        if (this.type != SchedEntity.TYPE.JOB && (policies = this.entityDefinition.getFirstChildElementByName("POLICIES")) != null) {
            List policyList = policies.getDirectchildsElementbyName("POLICY");
            List<XmlElement> policiesInDateRange = policyList.stream().filter(this::isPolicyDateRelevant).collect(Collectors.toList());
            this.processTimeBasedPolicies(policiesInDateRange);
        }
    }

    private void processTimeBasedPolicies(List<XmlElement> relevantPolicies) {
        List<XmlElement> supportedPolicies = relevantPolicies.stream().filter(policy -> this.isSupportedTimeBasedPolicyType(this.getPolicyType((XmlElement)policy))).toList();
        if (supportedPolicies.size() > 1) {
            this.zenaJob.addMessage("WRN15023", this.zenaJob.getOriginalJobName(), this.zenaJob.getJobName());
        }
        Optional firstPolicy = supportedPolicies.stream().findFirst();
        firstPolicy.ifPresent(policy -> {
            String policytype = this.getPolicyType((XmlElement)policy);
            if (policytype != null && policytype.equalsIgnoreCase(PERIOD)) {
                this.handlePeriodPolicy((XmlElement)policy);
            }
            if (policytype != null && policytype.equalsIgnoreCase(PERPETUAL)) {
                this.handlePerpetualPolicy((XmlElement)policy);
            }
            if (policytype != null && policytype.equalsIgnoreCase(TIME)) {
                this.handleTimePolicy((XmlElement)policy);
            }
        });
    }

    private String getPolicyType(XmlElement policy) {
        return policy.getAttribute("POLICYTYPE");
    }

    private boolean isSupportedTimeBasedPolicyType(String policytype) {
        List<String> supportedTimeTypes = Arrays.asList(PERPETUAL, PERIOD, TIME);
        return supportedTimeTypes.stream().anyMatch(t -> t.equalsIgnoreCase(policytype));
    }

    private void handleTimePolicy(XmlElement policy) {
        Optional<XmlElement> timeItem = Optional.ofNullable(policy.getFirstChildElementByName("TIMES"));
        List<String> timeList = timeItem.map(item -> item.getAllDecnedElementByName(TIME)).orElse(Collections.emptyList()).stream().map(XmlElement::getText).distinct().collect(Collectors.toList());
        switch (timeList.size()) {
            case 0: {
                this.issueWarningMessageForNoPolicyItems();
                break;
            }
            case 1: {
                this.convertSinglePolicyToTimeFrom(timeList);
                break;
            }
            default: {
                this.convertTimeListToCyclicJob(timeList);
            }
        }
    }

    private void issueWarningMessageForNoPolicyItems() {
        this.zenaJob.addMessage("WRN15026", this.zenaJob.getOriginalJobName(), this.zenaJob.getJobName());
    }

    private void convertTimeListToCyclicJob(List<String> timeList) {
        this.zenaJob.addAttribute("CYCLIC", "1");
        this.zenaJob.addAttribute("CYCLIC_TYPE", "SpecificTimes");
        timeList.forEach(timeToRun -> {
            Collection<String> cyclicTimesSequence = this.getCyclicTimeSequence();
            cyclicTimesSequence.add((String)timeToRun);
            this.zenaJob.addAttribute("CYCLIC_TIMES_SEQUENCE", String.join((CharSequence)",", cyclicTimesSequence));
        });
    }

    private void convertSinglePolicyToTimeFrom(List<String> timeList) {
        this.zenaJob.addAttribute("TIMEFROM", timeList.getFirst());
    }

    private Collection<String> getCyclicTimeSequence() {
        String cyclicTimesSequence = this.zenaJob.getAttr("CYCLIC_TIMES_SEQUENCE");
        return Optional.ofNullable(cyclicTimesSequence).map(s -> List.of(s.split(","))).map(LinkedHashSet::new).orElse(new LinkedHashSet());
    }

    private void handlePerpetualPolicy(XmlElement policy) {
        int delay;
        try {
            delay = Integer.parseInt(policy.getAttribute("DELAY")) / 60;
        }
        catch (NumberFormatException e) {
            delay = 0;
        }
        if (delay > 0) {
            this.zenaJob.addAttribute("CYCLIC", "1");
            this.zenaJob.addAttribute("INTERVAL", delay + "M");
            this.addTimeFromUntil(policy);
        }
    }

    private void handlePeriodPolicy(XmlElement policy) {
        int occurrence;
        try {
            occurrence = Integer.parseInt(policy.getAttribute("OCCURRENCES"));
        }
        catch (NumberFormatException e) {
            occurrence = 1;
        }
        String unit = policy.getAttribute("UNIT");
        if (occurrence > 1 && unit != null && (unit.equalsIgnoreCase("MINUTE") || unit.equalsIgnoreCase("HOUR"))) {
            int interval;
            this.zenaJob.addAttribute("CYCLIC", "1");
            try {
                interval = Integer.parseInt(policy.getAttribute("UNITCOUNT"));
            }
            catch (NumberFormatException e) {
                interval = 0;
            }
            this.zenaJob.addAttribute("INTERVAL", interval + unit.substring(0, 1));
            this.zenaJob.addAttribute("MAXRERUN", String.format("%d", occurrence));
            this.addTimeFromUntil(policy);
        }
    }

    private boolean isPolicyDateRelevant(XmlElement policy) {
        String today = new SimpleDateFormat("yyyy.MM.dd").format(Calendar.getInstance().getTime());
        return !this.isStartDateAfterToday(policy, today) && !this.isEndDateBeforeToday(policy, today);
    }

    private boolean isEndDateBeforeToday(XmlElement policy, String today) {
        String policyEndDate = policy.getAttribute("END_TIME");
        return policyEndDate != null && !policyEndDate.isEmpty() && today.compareTo(policyEndDate) > 0;
    }

    private boolean isStartDateAfterToday(XmlElement policy, String today) {
        String policyStartDate = policy.getAttribute("START_TIME");
        return policyStartDate != null && !policyStartDate.isEmpty() && today.compareTo(policyStartDate) < 0;
    }

    private void addTimeFromUntil(XmlElement policy) {
        Element timeItem;
        NodeList times = policy.getElement().getElementsByTagName("TIMES");
        if (times.getLength() > 1) {
            this.zenaJob.addMessage("WRN15024", this.zenaJob.getOriginalJobName(), this.zenaJob.getJobName());
        }
        if ((timeItem = (Element)times.item(0)) != null) {
            NodeList timeList = timeItem.getElementsByTagName(TIME);
            if (timeList.getLength() == 1) {
                Element time = (Element)timeList.item(0);
                String timeFrom = time.getAttribute("FROM");
                String timeUntil = time.getAttribute("UNTIL");
                this.zenaJob.addAttribute("TIMEFROM", timeFrom);
                this.zenaJob.addAttribute("TIMETO", timeUntil);
            }
            if (timeList.getLength() > 1) {
                this.zenaJob.addMessage("WRN15025", this.zenaJob.getOriginalJobName(), this.zenaJob.getJobName());
            }
        }
    }
}

