/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.Rbc.EveryDayRbc;
import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.conditions.OutConditionBuilder;
import com.bmc.ctmconvert.common.conditions.Sign;
import com.bmc.ctmconvert.common.ctmutilities.event.ConditionCommandBuilder;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.ondo.IdentityProperties;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.rules.FieldEditor;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.vc.IFieldValidation;
import com.bmc.ctmconvert.zena.ConcurrencyConvertor;
import com.bmc.ctmconvert.zena.ConditionsGenerator;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ProcessConditions;
import com.bmc.ctmconvert.zena.SchedulingConverter;
import com.bmc.ctmconvert.zena.VariablesMapping;
import com.bmc.ctmconvert.zena.ZenaCtmOrderJobConverter;
import com.bmc.ctmconvert.zena.ZenaDefs;
import com.bmc.ctmconvert.zena.ZenaPolicyProcessor;
import com.bmc.ctmconvert.zena.ZenaVariablesConvertor;
import com.bmc.ctmconvert.zena.events.EventProcessRelation;
import com.bmc.ctmconvert.zena.events.ProcessDetails;
import com.bmc.ctmconvert.zena.events.ZenaEvents;
import com.bmc.ctmconvert.zena.events.event_directory.EventDirectoryConvertor;
import com.bmc.ctmconvert.zena.events.event_directory.EventDirectoryData;
import com.bmc.ctmconvert.zena.folders.FolderPath;
import com.bmc.ctmconvert.zena.folders.ZenaFolderHierarchy;
import com.bmc.ctmconvert.zena.handlers.EnableFlagHandler;
import com.bmc.ctmconvert.zena.handlers.ZenaAgentHandler;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionHandler;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionsData;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionsDataCreator;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionsFactory;
import com.bmc.ctmconvert.zena.run_as.RunAsConvertor;
import com.bmc.ctmconvert.zena.run_as.ZenaRunAsData;
import com.bmc.ctmconvert.zena.run_as.ZenaRunAsDataCreator;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTaskFactory;
import com.bmc.ctmconvert.zena.utils.TaskEmailUtils;
import com.bmc.ctmconvert.zena.utils.ZenaXmlUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ZenaJob
implements SchedEntity {
    public static final String FOLDER_SUFFIX = "_folder";
    private final ArrayList<String> optionalProperties = new ArrayList();
    private final ArrayList<String> messages = new ArrayList();
    private SchedEntity.TYPE entityType;
    private boolean validEntity = true;
    private String entityUID;
    private EntitiesDefinitionsManager entitiesDefinitionsManager;
    private List<SchedEntity> children;
    private RulesDataSet rules;
    private ZenaJob entityParent;
    private LinkedHashMap<String, String> autoedits = new LinkedHashMap();
    private final List<Properties> rbcs = new ArrayList<Properties>();
    private ProcessConditions processConditions;
    private boolean issueConditionMessages = false;
    private boolean isWindows = true;
    private String uniqueTableOrParentName;
    private ZenaTaskFactory taskFactory;
    protected Properties properties = new Properties();
    Element entityDefinition;
    Element entityProcessData;
    ZenaVariablesHandler zenaVariablesHandler;
    LinkedHashMap<Properties, List<Properties>> onDoStatements = new LinkedHashMap();
    private Optional<String> folderId;
    private ZenaActionHandler zenaActionHandler;
    private final ZenaCtmOrderJobConverter zenaCtmOrderJobConverter = new ZenaCtmOrderJobConverter();
    public static Map<String, String[]> jobsStatistics = new HashMap<String, String[]>();
    private final VariablesMapping variablesMapping = new VariablesMapping();
    private List<Properties> controlResources = new ArrayList<Properties>();
    private Set<Properties> outConditionsToAdd = new HashSet<Properties>();
    private Set<Properties> inConditionsToAdd = new HashSet<Properties>();

    private ZenaJob() {
        this.zenaVariablesHandler = this.createVariablesHandler();
    }

    public static ZenaJob createZenaJobForTest() {
        return new ZenaJob();
    }

    public ZenaJob(String uid, String type) {
        this(uid, type, EntitiesDefinitionsManager.instance());
    }

    public ZenaJob(String uid, String type, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        this.entityUID = uid;
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
        this.zenaVariablesHandler = this.createVariablesHandler();
        if (this.entityUID == null || this.entityUID.isEmpty()) {
            this.validEntity = false;
        } else if (type.equals("EVENT")) {
            this.initializeEventFolder(uid);
        } else {
            this.entityType = SchedEntity.TYPE.SMART_TABLE;
            this.entityDefinition = entitiesDefinitionsManager.getElementByID(this.entityUID);
            this.initialize();
        }
    }

    private void initializeEventFolder(String uid) {
        this.rules = RuleManager.instance().getCurrentRules();
        this.entityType = SchedEntity.TYPE.SMART_TABLE;
        Element processXmlElement = this.entitiesDefinitionsManager.getElementByTypeAndID("PROCESS", uid);
        ProcessDetails processDetails = new ProcessDetails(XmlElement.ofNullable((Element)processXmlElement));
        this.addAttribute("JOBNAME", "Triggers_" + processDetails.getName());
        this.folderId = ZenaXmlUtils.getFolderIdFrom(processXmlElement);
        this.processConditions = new ProcessConditions();
        this.children = this.createEventDirectoryChildren(processDetails);
        this.rbcs.add(new EveryDayRbc().getProperties());
        this.handleFieldEditorValues();
    }

    public ZenaJob(Element entityData, Element processData, SchedEntity parent, String newName) {
        this(entityData, processData, parent, newName, EntitiesDefinitionsManager.instance());
    }

    public ZenaJob(Element entityData, Element processData, SchedEntity parent, String newName, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        this.entityDefinition = entityData;
        this.entityProcessData = processData;
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
        this.zenaVariablesHandler = this.createVariablesHandler();
        this.entityUID = this.getEntityUid();
        this.setEntityParent((ZenaJob)parent);
        this.setJobNameAttribute(newName);
        this.initialize();
    }

    private void setJobNameAttribute(String newName) {
        Optional.ofNullable(newName).ifPresent(newJobName -> this.addAttribute("JOBNAME", (String)newJobName));
    }

    private ZenaVariablesHandler createVariablesHandler() {
        return new ZenaVariablesHandler(this, this.entityProcessData, this.entitiesDefinitionsManager);
    }

    private String getEntityUid() {
        if (!this.isEventJob()) {
            return this.entityProcessData.getAttribute("UID");
        }
        return this.entityDefinition.getAttribute("UID");
    }

    private List<SchedEntity> createEventDirectoryChildren(ProcessDetails processDetails) {
        ZenaEvents events = this.entitiesDefinitionsManager.getEvents();
        EventProcessRelation eventProcessRelation = this.entitiesDefinitionsManager.getEventProcessRelation();
        Collection<String> eventIDs = eventProcessRelation.getEventUidsByProcessUid(processDetails.getUid());
        return eventIDs.stream().map(events::getEventDirectoryById).filter(event -> !EventDirectoryData.isEmptyEvent(event)).map(event -> {
            Collection<ProcessDetails> processes = eventProcessRelation.getProcessDetailsByEventUid(event.getUid());
            return this.createAFTJobFrom((EventDirectoryData)event, processes, processDetails);
        }).collect(Collectors.toList());
    }

    private ZenaJob createAFTJobFrom(EventDirectoryData eventDirectoryData, Collection<ProcessDetails> processes, ProcessDetails mainProcess) {
        Element entityData = eventDirectoryData.getEventXmlElement().getElement();
        Element processElement = mainProcess.getData().getElement();
        ZenaJob zenaJob = new ZenaJob(entityData, processElement, this, eventDirectoryData.getEventJobName());
        new EventDirectoryConvertor(eventDirectoryData, zenaJob, mainProcess, processes, this.zenaVariablesHandler).convert();
        return zenaJob;
    }

    private boolean hasSameNameAsParent(ZenaJob parentFolder) {
        return parentFolder.getJobName().equals(this.getJobName());
    }

    public void addFolderSuffix() {
        this.addAttribute("JOBNAME", this.getJobName() + FOLDER_SUFFIX);
    }

    private void initialize() {
        this.rules = RuleManager.instance().getCurrentRules();
        this.taskFactory = new ZenaTaskFactory(this.entitiesDefinitionsManager);
        this.folderId = this.initFolderId();
        if (this.entityType == null) {
            this.entityType = SchedEntity.TYPE.JOB;
            if (this.entityProcessData.getTagName().equals("PROCESS") && !ZenaDefs.isOrderingJobRuleEnabled(this.getRules()) && !this.isEventJob()) {
                this.entityType = SchedEntity.TYPE.SUB_TABLE;
            }
        }
        this.setAutoedits(new LinkedHashMap<String, String>());
        switch (this.entityType) {
            case SMART_TABLE: 
            case TABLE: {
                this.processConditions = ConditionsGenerator.instance().getProcessConditions(this.entityUID);
                this.createUniqueTableName();
                this.addFolderOrderIdVariable();
                break;
            }
            case SUB_TABLE: {
                this.setFolderName();
                this.properties.setProperty("PARENT_TABLE", this.getParentName());
                this.updateParentNameIfSameNameWhenConvertingToSaas();
                this.processConditions = ConditionsGenerator.instance().getProcessConditions(this.getUidPath() + "-" + this.entityProcessData.getAttribute("ITEM_UID"));
                break;
            }
            case JOB: {
                if (!this.isEventJob()) {
                    this.removeAttribute("JOBNAME");
                } else {
                    this.addAttribute("JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", this.getAttr("JOBNAME").replace(" ", "_")));
                }
                this.setJobName();
                this.updateParentNameIfSameNameWhenConvertingToSaas();
                this.properties.setProperty("PARENT_TABLE", this.getParentName());
                this.properties.setProperty("CYCLIC", "0");
                this.properties.setProperty("TAG_RELATIONSHIP", "OR");
                this.properties.setProperty("ACTIVE_FROM", "");
                this.properties.setProperty("ACTIVE_TILL", "");
                this.setNodeid();
                this.setOptionalAttribute("MAXWAIT", this.getRules().getStringRule("Zena rules", new String[]{"MAXWAIT"}));
                break;
            }
        }
        this.createCombinedOnDoStatements().forEach(this::addOnStmts);
        this.handleActions();
        this.handleFieldEditorValues();
        this.convertRunAsAttribute();
        if (!this.type().equals((Object)SchedEntity.TYPE.JOB)) {
            this.properties.setProperty("DESCRIPTION", this.getDescription());
        }
        this.setVariables();
        if (this.type() == SchedEntity.TYPE.JOB && !this.isEventJob()) {
            this.convertTask();
        }
        ZenaPolicyProcessor zenaPolicyProcessor = new ZenaPolicyProcessor(this.type(), this.entityDefinition, this);
        zenaPolicyProcessor.processPolicy();
        if (!this.isEventJob()) {
            this.createOrderingJob();
        }
        this.setSchedulingAttributes();
        this.convertTimesPolicy();
        this.handleEnableFlag();
        this.addActionIfNextTaskIsSkippedTaskEmail();
        this.issueWarningMessageForCalendarUidAttributeIfNeeded();
        this.handleJobStatistics();
        this.convertConcurrency();
    }

    private void updateParentNameIfSameNameWhenConvertingToSaas() {
        ZenaJob parentFolder;
        if (SettingsBooleanKeys.isSaas() && (parentFolder = this.getEntityParent()).isSmart() && this.hasSameNameAsParent(parentFolder)) {
            parentFolder.addFolderSuffix();
        }
    }

    private void setJobName() {
        this.setNameUsingField("Job name");
    }

    private void setFolderName() {
        this.setNameUsingField("Folder name");
    }

    private void setNameUsingField(String nameAttribute) {
        String jobName = ZenaDefs.extractJobName(this.entityProcessData, this.getAttr("JOBNAME"), this.messages, nameAttribute);
        this.properties.setProperty("JOBNAME", jobName);
    }

    private void convertConcurrency() {
        new ConcurrencyConvertor(this).convert();
    }

    private void handleJobStatistics() {
        String[] statistics;
        String id = this.entityUID;
        if (id.isEmpty()) {
            id = this.entityProcessData.getAttribute("ITEM_UID");
        }
        if ((statistics = jobsStatistics.get(id)) == null) {
            String zenaInstanceType = "";
            if (this.entityProcessData != null) {
                zenaInstanceType = this.entityProcessData.getTagName();
            }
            String zenaType = this.entityDefinition.getTagName();
            String chidren = String.valueOf(this.getChildren().size());
            String hasScheduling = "";
            if (this.type() != SchedEntity.TYPE.JOB) {
                if (this.rbcs.size() == 1 && this.rbcs.get(0).getProperty("NAME").equals("EMPTY_RBC")) {
                    hasScheduling = "NO";
                } else if (this.rbcs.size() > 1 || !this.rbcs.get(0).getProperty("NAME").equals("*")) {
                    hasScheduling = "YES";
                }
            }
            statistics = new String[]{id, this.getParentName(), this.getJobName(), this.type().toString(), zenaInstanceType, zenaType, chidren, hasScheduling, "1"};
        } else {
            statistics[8] = String.valueOf(Integer.parseInt(statistics[8]) + 1);
        }
        jobsStatistics.put(id, statistics);
    }

    private void issueWarningMessageForCalendarUidAttributeIfNeeded() {
        Boolean hasCalendarUid = Optional.ofNullable(this.entityProcessData).map(e -> !e.getAttribute("CALENDAR_UID").isEmpty()).orElse(false);
        if (hasCalendarUid.booleanValue()) {
            if (this.entityDefinition.getTagName().equals("PROCESS")) {
                this.addMessageWithJobName("WRN15050", this.entityDefinition.getTagName().toLowerCase());
            } else {
                this.addMessageWithJobName("WRN15049", this.entityDefinition.getTagName().toLowerCase());
            }
        }
    }

    public void handleEnableFlag() {
        new EnableFlagHandler(this.entityDefinition, this.entityProcessData).handleJob(this);
    }

    private void addFolderOrderIdVariable() {
        this.addAutoEdits("%%FOLDER_OID", "%%$SMART_ORDERID");
    }

    private void createUniqueTableName() {
        String tmpName = ZenaDefs.extractJobName(this.entityDefinition, this.getAttr("JOBNAME"), this.messages, "Folder name");
        String tableName = ZenaDefs.getUniqueTableName(this.entityUID, tmpName);
        this.properties.setProperty("JOBNAME", tableName);
        this.properties.setProperty("TABLE_NAME", tableName);
        if (!tmpName.equals(tableName)) {
            this.addMessage("INF0017", "JOBNAME", "NAME/ALIAS", tmpName, tableName, "since '" + tmpName + "' is already in use. Control-M does not allow duplicate folder names");
        }
    }

    private HashMap<String, String> handleFieldEditorValues() {
        HashMap<String, String> competitorValues = new HashMap<String, String>();
        this.setProcessApplicationAndSubApplication(competitorValues);
        this.setFolderApplicationAndSubApplication(competitorValues);
        List<String> propertyNames = Arrays.asList("APPLICATION", "GROUP", "OWNER", "AUTHOR", "DESCRIPTION");
        for (String propertyName : propertyNames) {
            this.setFieldEditorValues(competitorValues, propertyName);
        }
        return competitorValues;
    }

    private void handleActions() {
        this.zenaActionHandler = new ZenaActionHandler(this, new ZenaActionsDataCreator(this.entityDefinition, this.entityProcessData, this.entitiesDefinitionsManager));
        this.zenaActionHandler.handle();
    }

    private boolean isEventJob() {
        return XmlElement.ofNullable((Element)this.entityDefinition).getFirstChildElementByName("EVENT_DIRECTORY") != null;
    }

    private void setFieldEditorValues(HashMap<String, String> competitorValues, String propertyName) {
        FieldEditor fieldEditor = this.getRules().getFieldEditor();
        String ctmFieldValue = fieldEditor.generateCTMField(propertyName, competitorValues);
        String zenaValidationKey = propertyName;
        if (propertyName.equals("APPLICATION")) {
            zenaValidationKey = "APPLICATION_ZENA";
        }
        if (propertyName.equals("GROUP")) {
            zenaValidationKey = "GROUP_ZENA";
        }
        String value = FieldValidation.instance().validateAndReturnFixedValue(zenaValidationKey, ctmFieldValue);
        this.properties.setProperty(propertyName, value);
    }

    private void setFolderApplicationAndSubApplication(HashMap<String, String> competitorValues) {
        Optional<String> folderId = this.getFolderId().isPresent() ? this.getFolderId() : this.getParentFolderId();
        folderId.ifPresent(fldId -> {
            ZenaFolderHierarchy folderHierarchy = this.entitiesDefinitionsManager.getFolderHierarchy();
            FolderPath folderPath = folderHierarchy.getFolderPath((String)fldId);
            Optional<String> application = folderPath.getApplication();
            Optional<String> subApplication = folderPath.getSubApplication();
            application.ifPresent(topLevelFolder -> competitorValues.put("Folder name", (String)topLevelFolder));
            subApplication.ifPresent(subTopLevelFolder -> competitorValues.put("Sub folder name", (String)subTopLevelFolder));
        });
    }

    public boolean hasParent() {
        return this.getEntityParent() != null;
    }

    private void setProcessApplicationAndSubApplication(HashMap<String, String> competitorValues) {
        String fullPath = this.getParentName();
        String[] names = new String[]{fullPath, ""};
        if (fullPath.contains("/")) {
            names[0] = fullPath.substring(0, fullPath.indexOf("/"));
            names[1] = fullPath.substring(fullPath.lastIndexOf("/") + 1);
        }
        competitorValues.put("Process name", names[0]);
        competitorValues.put("Sub process name", names[1]);
    }

    private Optional<String> initFolderId() {
        XmlElement element = this.entityProcessData != null ? new XmlElement(this.entityProcessData) : new XmlElement(this.entityDefinition);
        return this.findFolderId(element);
    }

    private Optional<String> findFolderId(XmlElement elem) {
        return Optional.ofNullable(elem).flatMap(e -> e.findParent(p -> p.hasAttribute("FOLDER_ID"))).map(parent -> parent.getAttribute("FOLDER_ID")).filter(s -> !s.isEmpty());
    }

    private void convertRunAsAttribute() {
        ZenaRunAsData zenaRunAsData = new ZenaRunAsDataCreator(XmlElement.ofNullable((Element)this.entityProcessData), this.entitiesDefinitionsManager).create();
        new RunAsConvertor(zenaRunAsData, this, FieldValidation.instance()).convert();
    }

    private String getUidPath() {
        ArrayList<String> uids = new ArrayList<String>();
        ZenaJob topLevelParent = this;
        while (topLevelParent.hasParent()) {
            String itemUid = null;
            topLevelParent = topLevelParent.getEntityParent();
            if (topLevelParent.entityProcessData != null) {
                itemUid = topLevelParent.entityProcessData.getAttribute("ITEM_UID");
            }
            if (itemUid == null || itemUid.isEmpty()) {
                itemUid = topLevelParent.entityUID;
            }
            uids.add(0, itemUid);
        }
        Object topUid = (String)uids.get(0);
        for (int i = 1; i < uids.size(); ++i) {
            topUid = (String)topUid + "-" + (String)uids.get(i);
        }
        return topUid;
    }

    public List<String> getAllParentLevelsUID() {
        ArrayList<String> uids = new ArrayList<String>();
        ZenaJob topLevelParent = this;
        while (topLevelParent.hasParent()) {
            topLevelParent = topLevelParent.getEntityParent();
            String parentUID = topLevelParent.entityUID;
            uids.add(0, parentUID);
        }
        return uids;
    }

    private void createOrderingJob() {
        if (this.type() == SchedEntity.TYPE.JOB && this.entityProcessData != null && this.entityProcessData.getTagName().equals("PROCESS")) {
            String subProcessUid = this.getEntityUid();
            if (subProcessUid != null && !subProcessUid.isEmpty()) {
                Element entityDef = this.entitiesDefinitionsManager.getElementByID(subProcessUid);
                if (entityDef != null) {
                    String originalSubProcessName = ZenaDefs.extractJobName(entityDef, null, this.messages, "Folder name");
                    String folderToOrderName = ZenaDefs.getUniqueTableName(subProcessUid, originalSubProcessName);
                    String ctmOrderCommand = this.createCtmOrderCommand(folderToOrderName);
                    this.zenaCtmOrderJobConverter.setJobAttributes(ctmOrderCommand, this);
                } else {
                    this.getEntityParent().addMessage("WRN15028", this.getEntityParent().getOriginalJobName(), subProcessUid, this.getOriginalJobName());
                }
            } else {
                this.addMessage("WRN15022", this.entityProcessData.getAttribute("ALIAS"));
            }
        }
    }

    private String createCtmOrderCommand(String subFolderTableName) {
        String ctmorderCommand = "ctmorder -FOLDER " + subFolderTableName + " -NAME \"*\" -ODATE ODAT";
        String jobVariables = this.zenaCtmOrderJobConverter.appendJobVariables(this.filterVariablesForCtmOrder(), this);
        String conditionsToBeRaisedByTerminator = this.createConditionVariableWhenConvertingTerminatorJobs();
        return ctmorderCommand + jobVariables + conditionsToBeRaisedByTerminator;
    }

    private String createConditionVariableWhenConvertingTerminatorJobs() {
        Object conditionVariables = "";
        if (ZenaDefs.isOrderingJobRuleEnabled(this.getRules())) {
            this.addUniqueFlowVariableForTerminatorConditions();
            conditionVariables = (String)conditionVariables + this.addTerminatorVariableToCtmOrder(this.getOutConditionNamesForRemoval(), "%%$$OUT");
            conditionVariables = (String)conditionVariables + this.addTerminatorVariableToCtmOrder(this.getOnDoNotOkConditionNames(), "%%$$OUTERR");
            this.removeJobOutCond();
            this.removeJobOnNotOkDoConditions();
        }
        return conditionVariables;
    }

    private void addUniqueFlowVariableForTerminatorConditions() {
        this.addAutoEdits("%%BMC_SMART_ORDER_ID", "%%SMART_ORDERID");
    }

    private void removeJobOnNotOkDoConditions() {
        Predicate<Map.Entry> isOnNotOk = onDo -> ((Properties)onDo.getKey()).getProperty("CODE").equals("NOTOK");
        Predicate<Properties> isDoCondition = aDo -> aDo.getProperty("ACTION").equals("DOCOND");
        Iterator<Map.Entry<Properties, List<Properties>>> iterator = this.getOnDoStmt().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Properties, List<Properties>> onDo2 = iterator.next();
            if (!isOnNotOk.test(onDo2)) continue;
            List<Properties> doStatements = onDo2.getValue();
            doStatements.removeIf(isDoCondition);
            if (!doStatements.isEmpty()) continue;
            iterator.remove();
        }
    }

    private void removeJobOutCond() {
        Map<String, List<Properties>> outConditionsMap = this.getProcessConditions().getOutConditions();
        List<Properties> jobOutCondition = outConditionsMap.get(this.getConditionsKey());
        if (jobOutCondition != null) {
            jobOutCondition.removeIf(cond -> cond.getProperty("SIGN").equals("ADD"));
        }
    }

    private Stream<String> getOutConditionNamesForRemoval() {
        return this.getOutConds().stream().filter(cond -> cond.getProperty("SIGN").equals("ADD")).map(condition -> condition.getProperty("NAME"));
    }

    private String addTerminatorVariableToCtmOrder(Stream<String> conditionNames, String terminatorVariable) {
        String conditionCommands = conditionNames.map(conditionName -> new ConditionCommandBuilder().setAddAction().setConditionName(conditionName + "_%BMC_SMART_ORDER_ID%").build().toCommand()).collect(Collectors.joining(" && "));
        if (!conditionCommands.isEmpty()) {
            return this.zenaCtmOrderJobConverter.formatVariable(GlobalFunctions.removeVariablePrefix((String)terminatorVariable), GlobalFunctions.AddQuotes((String)conditionCommands));
        }
        return "";
    }

    private Stream<String> getOnDoNotOkConditionNames() {
        return this.getOnDoStmt().entrySet().stream().filter(on -> ((Properties)on.getKey()).getProperty("CODE").equals("NOTOK")).flatMap(on -> ((List)on.getValue()).stream().filter(aDo -> aDo.getProperty("ACTION").equals("DOCOND")).map(onDo -> onDo.getProperty("NAME")));
    }

    private Set<String> filterVariablesForCtmOrder() {
        List<String> filterValues = Arrays.asList("%%ZenaUID", "%%$BMCWAIORIGTYPE");
        return this.getAutoedits().keySet().stream().filter(varName -> !filterValues.contains(varName)).collect(Collectors.toSet());
    }

    private void convertTimesPolicy() {
        NodeList timeList = this.entityDefinition.getElementsByTagName("TIME");
        if (timeList != null && timeList.getLength() > 0) {
            boolean sameTimeDefinition = false;
            if (timeList.getLength() > 1) {
                sameTimeDefinition = true;
                Object toCompare = "";
                for (int index = 0; index < timeList.getLength(); ++index) {
                    Element timeElement = (Element)timeList.item(index);
                    String tmp = timeElement.getAttribute("FROM") + timeElement.getAttribute("UNTIL") + timeElement.getTextContent();
                    if (index > 0) {
                        sameTimeDefinition = sameTimeDefinition && ((String)toCompare).equals(tmp);
                        continue;
                    }
                    toCompare = tmp;
                }
            }
            if (sameTimeDefinition || timeList.getLength() == 1) {
                Element timeElement = (Element)timeList.item(0);
                String timePattern = "\\d{4}";
                if (timeElement.getTextContent().matches(timePattern)) {
                    this.properties.setProperty("TIMEFROM", timeElement.getTextContent());
                } else if (timeElement.hasAttribute("FROM") || timeElement.hasAttribute("UNTIL")) {
                    if (timeElement.hasAttribute("FROM") && timeElement.getAttribute("FROM").matches(timePattern)) {
                        this.properties.setProperty("TIMEFROM", timeElement.getAttribute("FROM"));
                    }
                    if (timeElement.hasAttribute("UNTIL") && timeElement.getAttribute("UNTIL").matches(timePattern)) {
                        this.properties.setProperty("TIMETO", timeElement.getAttribute("UNTIL"));
                    }
                } else {
                    this.addMessage("WRN15010", timeElement.getTextContent());
                }
            } else {
                this.addMessage("WRN15011", new String[0]);
            }
        }
    }

    private String getDescription() {
        Object toRet = this.properties.getProperty("DESCRIPTION", "");
        if (!((String)toRet).isEmpty()) {
            toRet = (String)toRet + "\n";
        }
        NodeList textList = this.entityDefinition.getElementsByTagName("TEXT");
        Node textElement = null;
        if (textList != null && textList.getLength() > 1) {
            textElement = (Element)textList.item(1);
        }
        if (textElement != null) {
            toRet = (String)toRet + textElement.getTextContent();
        }
        return FieldValidation.instance().validateAndReturnFixedValue("DESCRIPTION", (String)toRet);
    }

    private void setSchedulingAttributes() {
        this.setSchedulingForFolders();
        this.removeRedundantCalendarsAndReportUnsupportedExcludeCalendar();
        this.addDefaultRbcIfEmpty(this.rbcs);
        new EnableFlagHandler(this.entityDefinition, this.entityProcessData).disableSchedulingForDisabledTopLevelEntity(this, LocalDate.now());
    }

    private void addDefaultRbcIfEmpty(List<Properties> rbcs) {
        if (rbcs.isEmpty()) {
            this.rbcs.add(SchedulingConverter.getDefaultRbc(this.type()));
        }
    }

    private void removeRedundantCalendarsAndReportUnsupportedExcludeCalendar() {
        ArrayList<Properties> toRemove = new ArrayList<Properties>();
        for (Properties rbc : this.rbcs) {
            if (!this.isExcludeRBC(rbc)) {
                for (Properties rbc2 : this.rbcs) {
                    if (!this.isExcludeRBC(rbc2) || !rbc2.getProperty("NAME").substring(1).equals(rbc.getProperty("NAME"))) continue;
                    toRemove.add(rbc);
                    toRemove.add(rbc2);
                }
                continue;
            }
            if (!Params.instance().getGUIVersion().equals("7")) continue;
            this.addMessage("WRN15016", new String[0]);
        }
        this.rbcs.removeAll(toRemove);
    }

    private boolean isExcludeRBC(Properties rbc) {
        return rbc.getProperty("NAME").startsWith("!");
    }

    private void setSchedulingForFolders() {
        if (!this.type().equals((Object)SchedEntity.TYPE.JOB)) {
            ArrayList<String> calendarIDs = new ArrayList<String>();
            NodeList policyElements = this.entityDefinition.getElementsByTagName("POLICY");
            for (int i = 0; i < policyElements.getLength(); ++i) {
                Element policyElement = (Element)policyElements.item(i);
                NodeList calendars = this.getCalendars(policyElement);
                for (int j = 0; j < calendars.getLength(); ++j) {
                    Element calendar = (Element)calendars.item(j);
                    this.addCalendarsAndIssueMessages(calendarIDs, calendar);
                }
            }
            this.addChildRBCs();
        }
    }

    private void addChildRBCs() {
        for (SchedEntity child : this.getChildren()) {
            for (Properties rbc : child.getTags()) {
                if (rbc.getProperty("NAME").equals("*") || this.isExcludeRBC(rbc) || this.rbcs.contains(rbc)) continue;
                this.rbcs.add(rbc);
            }
        }
    }

    private void addCalendarsAndIssueMessages(List<String> calendarIDs, Element calendar) {
        if (!calendarIDs.contains(calendar.getAttribute("UID"))) {
            calendarIDs.add(calendar.getAttribute("UID"));
            SchedulingConverter.SchedulingAttributes schedulingAttributes = SchedulingConverter.instance().getSchedulingAttributes(calendar.getAttribute("UID"));
            this.rbcs.addAll(schedulingAttributes.getRbcs());
            this.addMessages(schedulingAttributes);
        }
    }

    private void addMessages(SchedulingConverter.SchedulingAttributes schedulingAttributes) {
        Map<String, List<String[]>> schedulingMessages = schedulingAttributes.getMessages();
        schedulingMessages.forEach((messageId, value) -> value.forEach(params -> this.addMessage((String)messageId, (String)params)));
    }

    private NodeList getCalendars(Element policyElement) {
        return policyElement.getElementsByTagName("CALENDAR");
    }

    private void setNodeid() {
        String parentUID = this.getEntityParent().entityUID;
        ZenaAgentHandler zenaAgentHandler = new ZenaAgentHandler(this.entitiesDefinitionsManager, parentUID, this.entityProcessData, this.entityDefinition);
        zenaAgentHandler.handle(this::addMessageWithJobName, this::addAttribute, this::setWindows);
    }

    private void setVariables() {
        new ZenaVariablesConvertor(this, this.entitiesDefinitionsManager).convertVariables();
    }

    String getItemUidOrUid() {
        return this.tryGettingItemUid().orElseGet(() -> Optional.ofNullable(this.entityUID).filter(Predicate.isEqual("").negate()).orElseGet(() -> this.issueMissingItemMessageAndReturnDefaultedName(this.getZenaOriginalJobName())));
    }

    public String getItemUid() {
        return this.tryGettingItemUid().orElseGet(() -> this.issueMissingItemMessageAndReturnDefaultedName(this.getZenaOriginalJobName()));
    }

    private Optional<String> tryGettingItemUid() {
        return Optional.ofNullable(this.entityProcessData).map(e -> e.getAttribute("ITEM_UID")).filter(Predicate.isEqual("").negate());
    }

    public String issueMissingItemMessageAndReturnDefaultedName(String variableItemAlias) {
        this.addMessageWithJobNameAndOriginalJobName("WRN15039", variableItemAlias);
        return variableItemAlias;
    }

    private void convertTask() {
        ZenaTask createTask = this.taskFactory.createTask(this.entityDefinition, this, this.entityProcessData);
        createTask.convertTask();
    }

    public void setMemLib(String memlib) {
        this.properties.setProperty("MEMLIB", this.zenaVariablesHandler.annotateVariables(memlib));
    }

    public void setCommandLine(String cmdLine) {
        String tempCmd = this.zenaVariablesHandler.annotateVariables(cmdLine);
        FieldValidation.instance().cmdLineValidateAndReportMessages(tempCmd, this.getJobName(), this.messages);
        this.properties.setProperty("CMDLINE", tempCmd);
    }

    public SchedEntity.TYPE type() {
        return this.entityType;
    }

    public String originalProductID() {
        return this.entityUID;
    }

    public List<SchedEntity> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<SchedEntity>();
            if (!this.entityType.equals((Object)SchedEntity.TYPE.JOB)) {
                Node items = this.entityDefinition.getElementsByTagName("ITEMS").item(0);
                if (items == null) {
                    ConversionLogger.getLogger().info(this.entityDefinition.getTagName() + ", ITEM_UID: " + this.entityDefinition.getAttribute("ITEM_UID") + ", UID: " + this.entityDefinition.getAttribute("UID"));
                    return this.children;
                }
                NodeList childs = items.getChildNodes();
                ArrayList<String> childrenNames = new ArrayList<String>();
                for (int childIndex = 0; childIndex < childs.getLength(); ++childIndex) {
                    String name;
                    if (childs.item(childIndex).getNodeType() != 1) continue;
                    Element child = (Element)childs.item(childIndex);
                    ArrayList<String> notAChild = new ArrayList<String>();
                    notAChild.add("TEXT");
                    notAChild.add("TASK_DEPENDENCY");
                    if (child.getTagName().equals("TERMINATOR") && !ZenaDefs.shouldConvertTerminators(this.getRules())) {
                        notAChild.add("TERMINATOR");
                        this.addMessage("INF15001", new String[0]);
                    }
                    HashMap<String, String> filterDetails = new HashMap<String, String>();
                    if (child.hasAttribute("NAME")) {
                        filterDetails.put("Name", child.getAttribute("NAME"));
                    }
                    if (child.hasAttribute("ALIAS")) {
                        filterDetails.put("Alias", child.getAttribute("ALIAS"));
                    }
                    if (!this.shouldConvertChild(child, notAChild) || !RuleManager.instance().getCurrentRules().getFilterHandler().isFilter(filterDetails)) continue;
                    String newName = name = ZenaDefs.extractJobName(child);
                    int cnt = 0;
                    while (childrenNames.contains(newName)) {
                        newName = String.format("%s_%02d", name, ++cnt);
                    }
                    childrenNames.add(newName);
                    if (newName.equals(name)) {
                        newName = null;
                    }
                    String childUID = child.getAttribute("UID");
                    List<String> allParentLevelsUID = this.getAllParentLevelsUID();
                    if (!allParentLevelsUID.contains(childUID)) {
                        Element data = this.entitiesDefinitionsManager.getElementByID(childUID);
                        ZenaJob childJob = null;
                        if (data != null && !child.getTagName().equals("PROCESS_DEPENDENCY")) {
                            if (!data.getTagName().equals("ZEKE")) {
                                childJob = new ZenaJob(data, child, this, newName);
                            }
                        } else {
                            childJob = new ZenaJob(child, child, this, newName);
                        }
                        if (childJob == null) continue;
                        this.children.add(childJob);
                        continue;
                    }
                    String childName = child.getAttribute("ALIAS");
                    String originalName = ZenaDefs.getOriginalName(this.entityProcessData, this.entityUID);
                    this.addMessage("WRN15027", this.getOriginalJobName(), originalName, childName);
                }
            }
        }
        return this.children;
    }

    private boolean shouldConvertChild(Element child, List<String> notAChild) {
        return this.isConvertableChild(child, notAChild) && !TaskEmailUtils.shouldSkipEmailTask(child, this.entitiesDefinitionsManager);
    }

    private boolean isConvertableChild(Element child, List<String> notAChild) {
        return !notAChild.contains(child.getTagName());
    }

    public List<AssistingJob> getAssistingJobs() {
        return null;
    }

    public String getAttr(String attrName) {
        return this.properties.getProperty(attrName);
    }

    public void setOptionalAttribute(String name, String value) {
        if (!this.optionalProperties.contains(name)) {
            this.optionalProperties.add(name);
        }
        this.properties.setProperty(name, value);
    }

    public List<Properties> getInConds() {
        Map<String, List<Properties>> inConditions = this.getProcessConditions().getInConditions();
        List<Properties> inCond = this.appendLinksConditions(inConditions);
        return this.updateInConditionLogic(this.addAdditionalInConditions(inCond));
    }

    private List<Properties> addAdditionalInConditions(List<Properties> inCond) {
        inCond.addAll(this.inConditionsToAdd);
        return inCond;
    }

    private List<Properties> updateInConditionLogic(List<Properties> inCond) {
        ArrayList<Properties> resultCond = new ArrayList<Properties>();
        Map<String, ArrayList<Properties>> sharedConds = this.getInConditionMap(inCond);
        sharedConds.forEach((key, value) -> {
            if (value.size() > 1) {
                ((Properties)value.get(0)).setProperty("OP", "(");
                ((Properties)value.get(0)).setProperty("AND_OR", "O");
                ((Properties)value.get(1)).setProperty("OP", ")");
            }
            resultCond.addAll((Collection<Properties>)value);
        });
        return resultCond;
    }

    private Map<String, ArrayList<Properties>> getInConditionMap(List<Properties> inCond) {
        Pattern pattern = Pattern.compile("(CID[0-9]+@)?(.+)", 8);
        HashMap<String, ArrayList<Properties>> sharedConds = new HashMap<String, ArrayList<Properties>>();
        inCond.forEach(cond -> {
            Matcher matcher = pattern.matcher((String)cond.get("NAME"));
            if (matcher.find()) {
                String conditionNameWithoutCID = matcher.group(2);
                if (sharedConds.containsKey(conditionNameWithoutCID)) {
                    ((ArrayList)sharedConds.get(conditionNameWithoutCID)).add(cond);
                } else {
                    ArrayList<Properties> condList = new ArrayList<Properties>();
                    condList.add((Properties)cond);
                    sharedConds.put(conditionNameWithoutCID, condList);
                }
            }
        });
        return sharedConds;
    }

    public List<Properties> getOutConds() {
        Map<String, List<Properties>> outConditions = this.getProcessConditions().getOutConditions();
        return this.addDeleteConditions(this.addAdditionalOutConditions(this.appendLinksConditions(outConditions)));
    }

    private List<Properties> addAdditionalOutConditions(List<Properties> appendLinksConditions) {
        appendLinksConditions.addAll(this.outConditionsToAdd);
        return appendLinksConditions;
    }

    private List<Properties> addDeleteConditions(List<Properties> outConditions) {
        List<Properties> deleteConditions = this.getDeleteConditions();
        outConditions.addAll(deleteConditions);
        return outConditions;
    }

    private List<Properties> getDeleteConditions() {
        if (this.shouldAddDeleteConditions()) {
            List<Properties> inConditions = this.getInConds();
            return inConditions.stream().map(inCond -> (OutConditionBuilder)((OutConditionBuilder)new OutConditionBuilder().setSign(Sign.Remove).setOdate(inCond.getProperty("ODATE"))).setConditionName(inCond.getProperty("NAME"))).map(builder -> builder.build().getProperties()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean shouldAddDeleteConditions() {
        if (!this.isConditionNamingWithStatus()) {
            return this.rules.getBooleanRule("Zena rules", new String[]{"CLEAN_UP_CONDITIONS"});
        }
        return false;
    }

    public List<Properties> getTags() {
        return this.rbcs;
    }

    public List<Properties> getQuantResources() {
        return Collections.emptyList();
    }

    public List<Properties> getCtrlResources() {
        return this.controlResources;
    }

    public List<Properties> getOnStmt() {
        return Collections.emptyList();
    }

    private List<Properties> createCombinedOnDoStatements() {
        Map<String, List<Properties>> onStatementsConditions = this.getProcessConditions().getOnStatementsConditions();
        return this.appendLinksConditions(onStatementsConditions);
    }

    private ProcessConditions getProcessConditions() {
        ProcessConditions conditions;
        ProcessConditions processConditions = conditions = this.hasParent() ? this.getEntityParent().processConditions : this.processConditions;
        if (!this.issueConditionMessages) {
            this.issueConditionMessages = true;
            List<Properties> conditionsMessages = this.appendLinksConditions(conditions.getConditionsMessages());
            for (Properties message : conditionsMessages) {
                this.addMessage(message.getProperty("MSGID"), (String[])message.get("RESVAR"));
            }
        }
        return conditions;
    }

    private String getConditionsKey() {
        String toRet = this.entityUID;
        if (!this.type().equals((Object)SchedEntity.TYPE.SMART_TABLE)) {
            toRet = this.entityProcessData.getAttribute("ITEM_UID");
        }
        return toRet;
    }

    private List<Properties> appendLinksConditions(Map<String, List<Properties>> linksMap) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        List<Properties> linksConds = linksMap.get(this.getConditionsKey());
        if (linksConds != null) {
            for (Properties prop : linksConds) {
                if (list.contains(prop)) continue;
                list.add(prop);
            }
        }
        return list;
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return this.onDoStatements;
    }

    private void addActionIfNextTaskIsSkippedTaskEmail() {
        TaskEmailUtils.getNextSkippedEmailTasks(this.entityProcessData, this.entitiesDefinitionsManager).forEach(skippedTaskEmailItem -> {
            XmlElement taskDefinition = ZenaXmlUtils.getTaskDefinitionFromItem(this.entitiesDefinitionsManager, skippedTaskEmailItem);
            ZenaActionsData emailActionData = new ZenaActionsDataCreator(taskDefinition, (XmlElement)skippedTaskEmailItem, this.entitiesDefinitionsManager).parseTaskEmail(this.getItemUid());
            new ZenaActionsFactory(emailActionData, this).createActionConvertor().convertAction();
            new ZenaActionHandler(this, new ZenaActionsDataCreator(taskDefinition, (XmlElement)skippedTaskEmailItem, this.entitiesDefinitionsManager)).handle();
        });
    }

    public List<Properties> getShouts() {
        return Collections.emptyList();
    }

    public String getJobName() {
        return this.properties.getProperty("JOBNAME");
    }

    public String getOriginalJobName() {
        return this.properties.getProperty("JOBNAME");
    }

    public String getParentName() {
        if (this.hasParent()) {
            if (this.entityType == SchedEntity.TYPE.JOB) {
                return this.getEntityParent().getParentName();
            }
            if (this.entityType == SchedEntity.TYPE.SUB_TABLE) {
                return this.getEntityParent().getParentName() + "/" + this.getJobName();
            }
        } else if (this.entityType == SchedEntity.TYPE.JOB) {
            if (this.uniqueTableOrParentName == null) {
                this.uniqueTableOrParentName = ZenaDefs.getUniqueTableName(this.entityUID, this.getJobName());
            }
        } else {
            this.uniqueTableOrParentName = this.getJobName();
        }
        return this.uniqueTableOrParentName;
    }

    public SchedEntity getParent() {
        return this.entityParent;
    }

    public String getTablePathForSons() {
        return this.getParentName() + (String)(this.hasParent() && this.entityType == SchedEntity.TYPE.JOB ? "/" + this.getJobName() : "");
    }

    public boolean isValid() {
        return this.validEntity;
    }

    public boolean hasWarnings() {
        if (this.messages.isEmpty()) {
            return false;
        }
        HashMap messageIds = MessageIdTable.instance().getMessageIds();
        for (String id : messageIds.keySet()) {
            if (!((MessageId)messageIds.get(id)).getMessageType(id).equals("W")) continue;
            for (String currMessage : this.messages) {
                if (!currMessage.startsWith(id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    public boolean isDSJob() {
        return true;
    }

    public String getTableName() {
        return this.getJobName();
    }

    public boolean isCyclic() {
        String cyclic = this.properties.getProperty("CYCLIC");
        if (cyclic == null) {
            return false;
        }
        return cyclic.equals("1");
    }

    public String applyFieldConversion(String field) {
        return null;
    }

    public String getApplication() {
        return this.properties.getProperty("APPLICATION");
    }

    public String getGroup() {
        return this.properties.getProperty("GROUP");
    }

    public LinkedHashMap<String, String> getAutoedits() {
        return this.autoedits;
    }

    public List<String> getOptionalAttributes() {
        return this.optionalProperties;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    public void addAutoEdits(String key, String value) {
        this.getAutoedits().put(key, value);
    }

    public void addAttribute(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void removeAttribute(String key) {
        this.properties.remove(key);
    }

    public void addMessage(String msgid, String ... stringsArr) {
        Reporter.addMessage(this.getMessages(), (String)msgid, (String)this.getTablePathForSons(), (String[])stringsArr);
    }

    public void addMessageWithJobName(String msgId, String ... stringsArr) {
        MessageHandler messageHandler = this::addMessage;
        messageHandler.addParameter(new String[]{this.getJobName()}).handleMessage(msgId, stringsArr);
    }

    public void addMessageWithJobNameAndOriginalJobName(String msgId, String ... stringsArr) {
        MessageHandler messageHandler = this::addMessageWithJobName;
        messageHandler.addParameter(new String[]{this.getZenaOriginalJobName()}).handleMessage(msgId, stringsArr);
    }

    String getZenaOriginalJobName() {
        if (this.entityProcessData != null && this.entityProcessData.hasAttribute("ALIAS")) {
            return this.entityProcessData.getAttribute("ALIAS");
        }
        return this.entityDefinition.getAttribute("NAME");
    }

    public void addOnStmts(Properties onStmts) {
        List<String> onStatementKeys = Arrays.asList("CODE", "STMT", "PGMS", "PROCS", "PATTERN", "FROM_COLUMN", "TO_COLUMN");
        IdentityProperties onStatement = new IdentityProperties();
        Properties doStatement = new Properties();
        onStmts.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> ZenaJob.lambda$addOnStmts$33(onStatementKeys, (Properties)onStatement, doStatement, arg_0, arg_1)));
        ArrayList<Properties> doStatements = new ArrayList<Properties>();
        doStatements.add(doStatement);
        this.onDoStatements.put((Properties)onStatement, doStatements);
    }

    public void addOnDoStatement(OnStatement onDoStatement) {
        onDoStatement.accept((onStatement, doStatements) -> this.onDoStatements.put((Properties)onStatement, (List<Properties>)doStatements));
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public void setWindows(boolean isWindows) {
        this.isWindows = isWindows;
    }

    public void setAutoedits(LinkedHashMap<String, String> autoedits) {
        this.autoedits = autoedits;
    }

    public RulesDataSet getRules() {
        return this.rules;
    }

    public boolean convertToDummyJobs() {
        return this.getRules().getTaskTypeHandler().isToDummy();
    }

    public IFieldValidation getFieldValidation() {
        return FieldValidation.instance();
    }

    public Optional<String> getFolderId() {
        return this.folderId.isPresent() ? this.folderId : this.getParentFolderId();
    }

    private Optional<String> getParentFolderId() {
        return Optional.ofNullable(this.getEntityParent()).flatMap(ZenaJob::getFolderId);
    }

    public void addAction(Map<String, String> action) {
        Reporter.addAction(action);
    }

    public boolean isSmart() {
        return this.type() == SchedEntity.TYPE.SMART_FOLDER || this.type() == SchedEntity.TYPE.SMART_TABLE;
    }

    public ZenaVariablesHandler getZenaVariablesHandler() {
        return this.zenaVariablesHandler;
    }

    public ZenaJob getSmartFolder() {
        if (this.hasParent()) {
            return this.getEntityParent().getSmartFolder();
        }
        return this;
    }

    protected ZenaJob getEntityParent() {
        return this.entityParent;
    }

    protected void setEntityParent(ZenaJob entityParent) {
        this.entityParent = entityParent;
    }

    public VariablesMapping getVariablesMapping() {
        return this.variablesMapping;
    }

    public String getAlias() {
        return Optional.ofNullable(this.entityProcessData).map(e -> e.getAttribute("ALIAS")).orElse(this.entityDefinition.getAttribute("NAME"));
    }

    public void addOutCondition(Properties condition) {
        this.outConditionsToAdd.add(condition);
    }

    public void addInCondition(Properties condition) {
        this.inConditionsToAdd.add(condition);
    }

    public boolean isConditionNamingWithStatus() {
        return "JOBA_OK".equals(this.getRules().getStringRule("Zena rules", new String[]{"CONDITION_NAME"}));
    }

    private static /* synthetic */ void lambda$addOnStmts$33(Collection onStatementKeys, Properties onStatement, Properties doStatement, Object key, Object value) {
        if (onStatementKeys.contains(key.toString())) {
            onStatement.put(key, value);
        } else {
            doStatement.put(key, value);
        }
    }
}

