/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ZenaAssessmentTreeNode;
import com.bmc.ctmconvert.zena.ZenaGlobals;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ZenaAssessmentReport
extends AbstractAssessmentReport {
    private final String zenaEntitiesTitle = "Entities Data";
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader;

    public ZenaAssessmentReport(String pathName, String descriptionXMLFileName, String optionalFile) {
        super(pathName, descriptionXMLFileName, optionalFile);
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) {
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        EntitiesDefinitionsManager.destroy();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        DefaultMutableTreeNode zenaEntities = new DefaultMutableTreeNode("Entities Data");
        for (String type : ZenaGlobals.XML_TARGET_TAG_TYPES_TO_FILE_NAME.keySet()) {
            Document dataDocument = EntitiesDefinitionsManager.instance().getDocumentByType(type);
            if (dataDocument == null) continue;
            NodeList typeDataList = dataDocument.getElementsByTagName("DEFINITION");
            HashMap<String, DefaultMutableTreeNode> entityTypeToTree = new HashMap<String, DefaultMutableTreeNode>();
            for (int index = 0; index < typeDataList.getLength(); ++index) {
                Element entity = (Element)((Element)typeDataList.item(index)).getFirstChild().getNextSibling();
                String tagName = entity.getTagName();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)entityTypeToTree.get(tagName);
                if (parent == null) {
                    parent = new DefaultMutableTreeNode(tagName);
                }
                entityTypeToTree.put(tagName, parent);
                parent.add(this.getChildNode(entity));
            }
            DefaultMutableTreeNode typeData = new DefaultMutableTreeNode(type);
            int typeDataChildCount = 0;
            for (String subType : entityTypeToTree.keySet()) {
                DefaultMutableTreeNode subTypeNode = (DefaultMutableTreeNode)entityTypeToTree.get(subType);
                int subTypeChildCount = subTypeNode.getChildCount();
                typeDataChildCount += subTypeChildCount;
                subTypeNode.setUserObject(subType + " (" + subTypeChildCount + ")");
                if (entityTypeToTree.size() == 1) {
                    typeData = subTypeNode;
                    continue;
                }
                typeData.add(subTypeNode);
            }
            if (entityTypeToTree.size() > 1) {
                typeData.setUserObject(type + " (" + typeDataChildCount + ")");
            }
            zenaEntities.add(typeData);
        }
        root.add(zenaEntities);
        return root;
    }

    private DefaultMutableTreeNode getChildNode(Element parent) {
        ZenaAssessmentTreeNode toRet = new ZenaAssessmentTreeNode(parent);
        if (parent.hasChildNodes()) {
            NodeList children = parent.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1 || !this.hasChildNodes((Element)children.item(i))) continue;
                toRet.add(this.getChildNode((Element)children.item(i)));
            }
        }
        return toRet;
    }

    private boolean hasChildNodes(Element node) {
        boolean toRet = false;
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                toRet = true;
            }
        }
        return toRet;
    }

    protected String getJobInfo(String messageID) {
        return null;
    }

    protected String getJobInfo(DefaultMutableTreeNode node) {
        if (node instanceof ZenaAssessmentTreeNode) {
            return this.getJobInfo(((ZenaAssessmentTreeNode)node).getDataElement(), "");
        }
        return null;
    }

    private String getJobInfo(Element entity, String tab) {
        IAttrHolder agentTableRow;
        StringBuilder jobInfo = new StringBuilder();
        NamedNodeMap attributs = entity.getAttributes();
        for (int index = 0; index < attributs.getLength(); ++index) {
            Node attribut = attributs.item(index);
            jobInfo.append(String.format("%s%-40s\t: %s%s", tab, attribut.getNodeName(), attribut.getNodeValue(), "\n"));
        }
        if (entity.getNodeName().equals("AGENT") && (agentTableRow = EntitiesDefinitionsManager.instance().getAgentTableRow(entity.getAttribute("NAME"))) != null) {
            jobInfo.append(String.format("%s%-40s\t: %s%s", tab, "OS TYPE", agentTableRow.getAttr("ostype"), "\n"));
        }
        NodeList children = entity.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            if (children.item(index).getNodeType() != 1 || this.hasChildNodes((Element)children.item(index))) continue;
            Element child = (Element)children.item(index);
            if (child.getChildNodes().getLength() == 1 && child.getChildNodes().item(0).getNodeType() == 3) {
                jobInfo.append(String.format("%s%-40s\t: %s%s", tab, child.getTagName(), child.getChildNodes().item(0).getTextContent(), "\n"));
                continue;
            }
            jobInfo.append(tab).append(child.getTagName()).append("\n").append(this.getJobInfo(child, tab + "    "));
        }
        return jobInfo.toString();
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        ArrayList<String> toRet = new ArrayList<String>();
        toRet.add("Entities Data");
        return toRet;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        ArrayList<String> toRet = new ArrayList<String>();
        return toRet;
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        return null;
    }

    protected HashMap<String, String> getDescriptionNodes() {
        LinkedHashMap descriptionMap_NodeName_NodeDesc = this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
        return descriptionMap_NodeName_NodeDesc;
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        return null;
    }
}

