/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class StatusCalculator {
    private final String complexStatus;
    private final String status;
    private final List<ConditionStatus> conditionStatuses;

    public StatusCalculator(String complexStatus, String status) {
        this.complexStatus = complexStatus;
        this.status = status;
        this.conditionStatuses = new ArrayList<ConditionStatus>();
    }

    public List<ConditionStatus> calculate() {
        String[] statusArr;
        for (String s : statusArr = this.status.split("\\s*,\\s*")) {
            String endOfJobStatus = this.getComplexStatus(s);
            if (endOfJobStatus.equalsIgnoreCase("NORMAL") || endOfJobStatus.equalsIgnoreCase("TRUE")) {
                this.conditionStatuses.add(new ConditionStatus("ENDED_OK", true, false));
                continue;
            }
            if (endOfJobStatus.equalsIgnoreCase("ABNORMAL") || endOfJobStatus.equalsIgnoreCase("FALSE") || endOfJobStatus.equalsIgnoreCase("ERROR")) {
                this.conditionStatuses.add(new ConditionStatus("ENDED_NOT_OK", false, true));
                continue;
            }
            if (!endOfJobStatus.equalsIgnoreCase("COMPLETE") && !endOfJobStatus.isBlank()) continue;
            this.conditionStatuses.add(new ConditionStatus("COMPLETED", true, true));
        }
        return this.getDistinctConditionStatuses();
    }

    private List<ConditionStatus> getDistinctConditionStatuses() {
        return this.conditionStatuses.stream().distinct().collect(Collectors.toList());
    }

    private String getComplexStatus(String status) {
        if (!this.complexStatus.isEmpty()) {
            if (status.equalsIgnoreCase("TRUE")) {
                status = this.complexStatus;
            } else if (status.equalsIgnoreCase("FALSE")) {
                status = this.complexStatus.equalsIgnoreCase("NORMAL") ? "ABNORMAL" : (this.complexStatus.equalsIgnoreCase("ABNORMAL") || this.complexStatus.equalsIgnoreCase("ERROR") ? "NORMAL" : "UNKNOWN");
            }
        }
        return status;
    }

    public static class ConditionStatus {
        private final String status;
        private final boolean isOk;
        private final boolean isNotOk;

        public ConditionStatus(String status, boolean isOk, boolean isNotOk) {
            this.status = status;
            this.isOk = isOk;
            this.isNotOk = isNotOk;
        }

        public String getStatus() {
            return this.status;
        }

        public boolean isOk() {
            return this.isOk;
        }

        public boolean isNotOk() {
            return this.isNotOk;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConditionStatus that = (ConditionStatus)o;
            if (this.isOk != that.isOk) {
                return false;
            }
            if (this.isNotOk != that.isNotOk) {
                return false;
            }
            return Objects.equals(this.status, that.status);
        }

        public int hashCode() {
            int result = this.status.hashCode();
            result = 31 * result + (this.isOk ? 1 : 0);
            result = 31 * result + (this.isNotOk ? 1 : 0);
            return result;
        }

        public String toString() {
            return "ConditionStatus{status='" + this.status + "', isOk=" + this.isOk + ", isNotOk=" + this.isNotOk + "}";
        }
    }
}

