/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.utils.ZenaXmlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SendEventToDependencyMapper {
    private Map<String, List<Element>> eventToSendEvent = new HashMap<String, List<Element>>();
    private Map<String, List<Element>> eventToDependency = new HashMap<String, List<Element>>();
    private Map<String, Integer> eventIdToConditionId = new HashMap<String, Integer>();
    private AtomicInteger conditionId = new AtomicInteger();

    public List<Element> getSendEventTasksFor(String eventUid) {
        return this.eventToSendEvent.getOrDefault(eventUid, Collections.emptyList());
    }

    public List<Element> getDependencyTasksFor(String eventUid) {
        return this.eventToDependency.getOrDefault(eventUid, Collections.emptyList());
    }

    public Integer getConditionIdFor(Element sendEventTask, Element dependencyTask) {
        String uniqueKey = this.generateUniqueKeyForCondition(sendEventTask, dependencyTask);
        return this.eventIdToConditionId.computeIfAbsent(uniqueKey, uid -> this.conditionId.incrementAndGet());
    }

    String generateUniqueKeyForCondition(Element sendEventTask, Element dependencyTask) {
        return ZenaXmlUtils.getItemUid(sendEventTask) + ZenaXmlUtils.getItemUid(dependencyTask) + ZenaXmlUtils.getUidOrItemUidFrom(sendEventTask);
    }

    void initializeUserEventDependencyMap(Document document) {
        this.mapEventUidToElementsOfTagName(document, "SEND_EVENT", this.eventToSendEvent);
        this.mapEventUidToElementsOfTagName(document, "DEPENDENCY", this.eventToDependency);
    }

    private void mapEventUidToElementsOfTagName(Document document, String tagName, Map<String, List<Element>> targetMap) {
        new XmlElement(document.getDocumentElement()).getAllDecnedElementByName(tagName).forEach(element -> {
            String eventUid = ZenaXmlUtils.getUidOrItemUidFrom(element.getElement());
            targetMap.computeIfAbsent(eventUid, uid -> new ArrayList()).add(element.getElement());
        });
    }
}

