/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.zena.SendEventToDependencyMapper;
import com.bmc.ctmconvert.zena.ZenaCSVDefinitions;
import com.bmc.ctmconvert.zena.ZenaDefs;
import com.bmc.ctmconvert.zena.ZenaGlobals;
import com.bmc.ctmconvert.zena.events.EventProcessRelation;
import com.bmc.ctmconvert.zena.events.ZenaEvents;
import com.bmc.ctmconvert.zena.folders.ZenaFolderHierarchy;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EntitiesDefinitionsManager {
    private static EntitiesDefinitionsManager instance;
    private final SendEventToDependencyMapper sendEventToDependencyMapper = new SendEventToDependencyMapper();
    private Map<String, Document> XMLdefinitions;
    private Map<String, List<String>> processUidToChildUids;
    private Map<String, Map<String, Element>> typeToidToElement = new HashMap<String, Map<String, Element>>();
    private Map<String, IAttrHolder> agentToTableRow;
    private static Path sourceDir;
    private ZenaFolderHierarchy folderHierarchy;
    private ZenaEvents events;
    private EventProcessRelation eventProcessRelation;

    public static void setSourceDirForTesting(Path sourceDir) {
        EntitiesDefinitionsManager.sourceDir = sourceDir;
    }

    public static EntitiesDefinitionsManager instance() {
        if (instance == null) {
            instance = new EntitiesDefinitionsManager();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
        sourceDir = EntitiesDefinitionsManager.getDefaultSourceDataPath();
    }

    private static Path getDefaultSourceDataPath() {
        return FileSystems.getDefault().getPath(Params.instance().getDatasourcePath(), new String[0]);
    }

    private EntitiesDefinitionsManager() {
        this.XMLdefinitions = new HashMap<String, Document>();
        this.eventProcessRelation = new EventProcessRelation();
        for (String type : ZenaGlobals.XML_TARGET_TAG_TYPES_TO_FILE_NAME.keySet()) {
            Path dataDir = sourceDir;
            try {
                InputStream typeFile = this.getFileContent(type, dataDir);
                try {
                    DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document document = documentBuilder.parse(typeFile);
                    document.getDocumentElement().normalize();
                    this.XMLdefinitions.put(type, document);
                    if (type.equals("PROCESS")) {
                        this.initializeProcessMap(document);
                        this.sendEventToDependencyMapper.initializeUserEventDependencyMap(document);
                    }
                    if (type.equals("FOLDER")) {
                        this.initializeFolderHierarchy(document);
                    }
                    if (!type.equals("EVENT")) continue;
                    this.initializeEventsStructure(document);
                }
                finally {
                    if (typeFile == null) continue;
                    typeFile.close();
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
    }

    public Document getVariablesDocument() {
        return this.XMLdefinitions.get("VARIABLE");
    }

    public void initializeGlobalVariables() {
        XmlElement variables = XmlElement.fromDocument((Document)this.getVariablesDocument());
        variables.getAllDirectchildsElement().stream().map(this::toVariableDefinition).forEach(this::createGlobalVariableAction);
    }

    private void createGlobalVariableAction(XmlElement variable) {
        ZenaVariablesHandler variablesHandler = new ZenaVariablesHandler(this);
        String variableName = variable.getAttribute("NAME");
        String poolName = variablesHandler.createPoolNameFromApplicationName(Optional.ofNullable(this.getFolderHierarchy()), variable);
        String validatedVariableName = GlobalFunctions.removeVariablePrefix((String)variablesHandler.annotateSystemVariableName(variableName, poolName));
        String variableValue = this.removeDescriptionElementFromVariableValue(variable);
        String resolvedValue = variablesHandler.annotateVariables(variableValue);
        Reporter.addGlobalAutoEditAction(null, (String)validatedVariableName, (String)resolvedValue, (String)"Global");
    }

    private String removeDescriptionElementFromVariableValue(XmlElement variable) {
        NodeList items = variable.getElement().getChildNodes();
        return IntStream.range(0, items.getLength()).mapToObj(items::item).filter(Objects::nonNull).filter(e -> e.getNodeName().equals("#text")).map(Node::getTextContent).filter(e -> !e.isBlank()).collect(Collectors.joining());
    }

    private XmlElement toVariableDefinition(XmlElement definition) {
        return definition.getFirstChildElementByName("VARIABLE");
    }

    private void initializeEventsStructure(Document document) {
        this.events = new ZenaEvents(document);
    }

    public ZenaEvents getEvents() {
        return this.events;
    }

    private InputStream getFileContent(String type, Path dataDir) throws IOException {
        try {
            Path filePath = dataDir.resolve(ZenaGlobals.XML_TARGET_TAG_TYPES_TO_FILE_NAME.get(type));
            return Files.newInputStream(filePath, new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            String emptyXml = "<DEFINITIONS/>";
            return new ByteArrayInputStream(emptyXml.getBytes());
        }
    }

    private void initializeFolderHierarchy(Document document) {
        this.folderHierarchy = new ZenaFolderHierarchy(document);
        this.folderHierarchy.createHierarchy();
    }

    public ZenaFolderHierarchy getFolderHierarchy() {
        return this.folderHierarchy;
    }

    private void initializeProcessMap(Document document) {
        this.processUidToChildUids = new HashMap<String, List<String>>();
        this.initProcessDefinitions(document);
        this.initByRule();
    }

    private void initProcessDefinitions(Document document) {
        NodeList definitions = document.getElementsByTagName("DEFINITION");
        for (int index = 0; index < definitions.getLength(); ++index) {
            Element processDefinition = (Element)definitions.item(index);
            this.initProcess(processDefinition);
            this.getEventProcessRelation().addProcess(processDefinition);
        }
    }

    private void initProcess(Element processDefinition) {
        Element processItems = (Element)processDefinition.getElementsByTagName("ITEMS").item(0);
        if (processItems != null) {
            NodeList subProcesses = processItems.getElementsByTagName("PROCESS");
            this.initSubProcesses(processDefinition, subProcesses);
        }
    }

    private void initSubProcesses(Element processDefinition, NodeList subProcesses) {
        if (subProcesses != null) {
            String processUID = processDefinition.getAttribute("UID");
            List childsIDs = this.processUidToChildUids.getOrDefault(processUID, new ArrayList());
            this.addSubProcessesUIDs(subProcesses, childsIDs);
            this.processUidToChildUids.put(processUID, childsIDs);
        }
    }

    private void addSubProcessesUIDs(NodeList subProcesses, List<String> childsIDs) {
        for (int subProcessIndex = 0; subProcessIndex < subProcesses.getLength(); ++subProcessIndex) {
            String subProcessID = ((Element)subProcesses.item(subProcessIndex)).getAttribute("UID");
            if (childsIDs.contains(subProcessID)) continue;
            childsIDs.add(subProcessID);
        }
    }

    private void initByRule() {
        boolean rulesSub2Ordering = ZenaDefs.isOrderingJobRuleEnabled(RuleManager.instance().getCurrentRules());
        if (!rulesSub2Ordering) {
            this.removeCircularDependencies();
        }
    }

    private void removeCircularDependencies() {
        HashMap<String, List<String>> tempProcessUidToChildUids = new HashMap<String, List<String>>(this.processUidToChildUids);
        Set<String> processUIDs = this.processUidToChildUids.keySet();
        Collection<List<String>> childProcessesUIDsList = this.processUidToChildUids.values();
        block0: for (String processUID : processUIDs) {
            for (List<String> childProcessesUIDs : childProcessesUIDsList) {
                if (!childProcessesUIDs.contains(processUID)) continue;
                tempProcessUidToChildUids.remove(processUID);
                childProcessesUIDsList = tempProcessUidToChildUids.values();
                continue block0;
            }
        }
        this.processUidToChildUids = tempProcessUidToChildUids;
    }

    public Map<String, List<String>> getProcessChildsMap() {
        return this.processUidToChildUids;
    }

    public Element getElementByID(String id) {
        String type;
        Element toRet = null;
        Iterator<String> iterator = ZenaGlobals.XML_TARGET_TAG_TYPES_TO_FILE_NAME.keySet().iterator();
        while (iterator.hasNext() && (toRet = this.getElementByTypeAndID(type = iterator.next(), id)) == null) {
        }
        return toRet;
    }

    public Element getElementByTypeAndID(String type, String id) {
        Map<String, Element> idToElement = this.typeToidToElement.get(type);
        if (idToElement == null) {
            idToElement = new HashMap<String, Element>();
            Document document = this.XMLdefinitions.get(type);
            NodeList definitions = document.getElementsByTagName("DEFINITION");
            for (int index = 0; index < definitions.getLength(); ++index) {
                Element element = (Element)((Element)definitions.item(index)).getFirstChild().getNextSibling();
                String UID = element.getAttribute("UID");
                idToElement.put(UID, element);
            }
            this.typeToidToElement.put(type, idToElement);
        }
        return idToElement.get(id);
    }

    public Document getDocumentByType(String type) {
        return this.XMLdefinitions.get(type);
    }

    public IAttrHolder getAgentTableRow(String key) {
        if (this.agentToTableRow == null) {
            this.agentToTableRow = new HashMap<String, IAttrHolder>();
            Path agentsDataPath = sourceDir.resolve("ZenaAgents.csv");
            if (Files.exists(agentsDataPath, new LinkOption[0])) {
                try (InputStream agentSource = Files.newInputStream(agentsDataPath, new OpenOption[0]);){
                    AttrHolderList agentsList = new ZenaCSVDefinitions(agentsDataPath).getDefinitions();
                    for (IAttrHolder agent : agentsList) {
                        this.agentToTableRow.put(agent.getAttr("NAME"), agent);
                    }
                }
                catch (IOException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
            }
        }
        return this.agentToTableRow.get(key);
    }

    public EventProcessRelation getEventProcessRelation() {
        return this.eventProcessRelation;
    }

    public static void setInstanceForTesting(EntitiesDefinitionsManager instance) {
        EntitiesDefinitionsManager.instance = instance;
    }

    public SendEventToDependencyMapper getSendEventToDependencyMapper() {
        return this.sendEventToDependencyMapper;
    }

    static {
        sourceDir = EntitiesDefinitionsManager.getDefaultSourceDataPath();
    }
}

