/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.conditions.AndOr;
import com.bmc.ctmconvert.common.conditions.InConditionBuilder;
import com.bmc.ctmconvert.common.conditions.OutConditionBuilder;
import com.bmc.ctmconvert.common.conditions.Sign;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.DoCondition;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.zena.ConditionData;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ProcessConditions;
import com.bmc.ctmconvert.zena.StatusCalculator;
import com.bmc.ctmconvert.zena.ZenaDefs;
import com.bmc.ctmconvert.zena.conditions.LinkItem;
import com.bmc.ctmconvert.zena.utils.TaskEmailUtils;
import com.bmc.ctmconvert.zena.utils.ZenaXmlUtils;
import com.csvreader.CsvWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConditionsGenerator {
    private static ConditionsGenerator instance;
    private AtomicInteger uniqueNumber;
    private boolean jobAOK;
    private ConditionData conditionData;
    private Map<String, ProcessConditions> allConditions;
    private static final List<String> SUPPORTED_TARGETS;

    private ConditionsGenerator() {
        this.initialize();
    }

    public static ConditionsGenerator instance() {
        if (instance == null) {
            instance = new ConditionsGenerator();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    public static boolean isZekeDefinition(String elementId, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        XmlElement sourceElement = XmlElement.ofNullable((Element)entitiesDefinitionsManager.getElementByID(elementId));
        return sourceElement.getTagName().equals("ZEKE");
    }

    public static void addMessage(String entityUID, String messageID, Map<String, List<Properties>> messages, String ... messageParams) {
        Properties message = new Properties();
        message.setProperty("MSGID", messageID);
        message.put("RESVAR", messageParams);
        ConditionsGenerator.addKeydObjectToCollection(messages, entityUID, message);
    }

    static Map<String, Element> getItemIDToElement(Element definition) {
        HashMap<String, Element> toRet = new HashMap<String, Element>();
        Node itmes = definition.getElementsByTagName("ITEMS").item(0);
        if (itmes != null) {
            NodeList childs = itmes.getChildNodes();
            for (int childIndex = 0; childIndex < childs.getLength(); ++childIndex) {
                if (childs.item(childIndex).getNodeType() != 1) continue;
                Element child = (Element)childs.item(childIndex);
                toRet.put(child.getAttribute("ITEM_UID"), child);
            }
        }
        return toRet;
    }

    private static <K, V> void addKeydObjectToCollection(Map<K, List<V>> collection, K key, V value) {
        List<V> list = collection.get(key);
        if (list == null) {
            list = new ArrayList<V>();
        }
        if (!list.contains(value)) {
            list.add(value);
        }
        collection.put(key, list);
    }

    static boolean shouldGenerateNonDependencyConditions(boolean generateDependencies, Element source) {
        return !generateDependencies && !ConditionsGenerator.isTaskDependency(source);
    }

    private static boolean isTaskDependency(Element source) {
        return source.getTagName().equals("TASK_DEPENDENCY");
    }

    static boolean shouldGenerateDependenciesConditions(boolean generateDependencies, Element source) {
        return generateDependencies && ConditionsGenerator.isTaskDependency(source);
    }

    static Map<String, List<LinkItem>> createStatusToLinkItems(Map<String, Element> itemIDToElement, Map<String, List<Element>> sourceItemIDToLinkElement, Element source, ConditionData conditionData) {
        HashMap<String, List<LinkItem>> toRet = new HashMap<String, List<LinkItem>>();
        try {
            for (Element sourceLink : sourceItemIDToLinkElement.get(source.getAttribute("ITEM_UID"))) {
                ConditionsGenerator.addConditionsToSource(itemIDToElement, sourceItemIDToLinkElement, source, toRet, sourceLink, conditionData);
            }
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return toRet;
    }

    private static void addConditionsToSource(Map<String, Element> itemIDToElement, Map<String, List<Element>> sourceItemIDToLinkElement, Element source, Map<String, List<LinkItem>> conditionMap, Element sourceLink, ConditionData conditionData) {
        String condition = sourceLink.getAttribute("CONDITION");
        String targetID = sourceLink.getAttribute("TARGET");
        Element target = itemIDToElement.get(targetID);
        String targetTagName = target.getTagName();
        LinkItem linkItem = new LinkItem(source, target, sourceLink);
        if (TaskEmailUtils.isTaskEmail(target, EntitiesDefinitionsManager.instance()) && SettingsBooleanKeys.ZENA_EMAIL_TASK_TO_ONDO.isEnabled()) {
            if (TaskEmailUtils.shouldSkipEmailTask(target, EntitiesDefinitionsManager.instance())) {
                ConditionsGenerator.addSubTargetsElements(itemIDToElement, sourceItemIDToLinkElement, target, condition, conditionMap, ConditionsGenerator::sourceConditionStrategy, conditionData);
                ConditionsGenerator.issueMessageForSkippedEmailTask(conditionData, source, target);
            } else {
                ConditionsGenerator.addKeydObjectToCollection(conditionMap, condition, linkItem);
            }
        } else if (ConditionsGenerator.isSupportedTargetTag(targetTagName)) {
            ConditionsGenerator.addKeydObjectToCollection(conditionMap, condition, linkItem);
            if (targetTagName.equals("PROCESS_DEPENDENCY")) {
                String status = ConditionsGenerator.getStatusFromProcessDependency(target);
                LinkItem processToDependency = new LinkItem(ConditionsGenerator.getDependentProcessFrom((Element)target).element, target, sourceLink);
                ConditionsGenerator.addKeydObjectToCollection(conditionMap, status, processToDependency);
            }
            if (targetTagName.equals("DEPENDENCY") && ConditionsGenerator.isZekeDefinition(targetID, EntitiesDefinitionsManager.instance())) {
                ConditionsGenerator.addSubTargetsElements(itemIDToElement, sourceItemIDToLinkElement, target, condition, conditionMap, ConditionsGenerator::targetConditionStrategy, conditionData);
            }
        } else if (targetTagName.equals("TASK_DEPENDENCY")) {
            ConditionsGenerator.addKeydObjectToCollection(conditionMap, condition, linkItem);
            ConditionsGenerator.addSubTargetsElements(itemIDToElement, sourceItemIDToLinkElement, target, condition, conditionMap, ConditionsGenerator::targetConditionStrategy, conditionData);
        } else if (targetTagName.equals("TERMINATOR")) {
            ConditionsGenerator.addKeydObjectToCollection(conditionMap, condition, linkItem);
        }
    }

    private static String getStatusFromProcessDependency(Element target) {
        return XmlElement.ofNullable((Element)target).getFirstChildElementByName("ATTRIBUTES").getAllDecnedElementByName("STATUS").stream().findFirst().map(XmlElement::getText).orElse("");
    }

    private static void issueMessageForSkippedEmailTask(ConditionData conditionData, Element source, Element target) {
        String sourceItemUid = source.getAttribute("ITEM_UID");
        String skippedTaskAlias = target.getAttribute("ALIAS");
        String skippedTaskItemUid = target.getAttribute("ITEM_UID");
        ConditionsGenerator.addMessage(sourceItemUid, "INF15008", conditionData.getMessages(), skippedTaskAlias, skippedTaskItemUid);
    }

    private static boolean isSupportedTargetTag(String targetTagName) {
        return SUPPORTED_TARGETS.contains(targetTagName);
    }

    private static void addSubTargetsElements(Map<String, Element> itemIDToElement, Map<String, List<Element>> sourceItemIDToLinkElement, Element target, String condition, Map<String, List<LinkItem>> toRet, BinaryOperator<String> conditionStrategy, ConditionData conditionData) {
        Map<String, List<LinkItem>> subTargets = ConditionsGenerator.createStatusToLinkItems(itemIDToElement, sourceItemIDToLinkElement, target, conditionData);
        subTargets.forEach((stat, subTargetLinks) -> {
            for (LinkItem item : subTargetLinks) {
                ConditionsGenerator.addKeydObjectToCollection(toRet, (String)conditionStrategy.apply(condition, stat), item);
            }
        });
    }

    private static String sourceConditionStrategy(String condition, String stat) {
        return condition;
    }

    private static String targetConditionStrategy(String condition, String stat) {
        return stat.isEmpty() ? condition : stat;
    }

    static Map<String, List<Element>> getSourceItemIDToLinkElement(Element definition) {
        HashMap<String, List<Element>> toRet = new HashMap<String, List<Element>>();
        NodeList links = definition.getElementsByTagName("LINK");
        for (int index = 0; index < links.getLength(); ++index) {
            Element link = (Element)links.item(index);
            String sourceID = link.getAttribute("SOURCE");
            ArrayList<Element> sourceLinks = (ArrayList<Element>)toRet.get(sourceID);
            if (sourceLinks == null) {
                sourceLinks = new ArrayList<Element>();
            }
            sourceLinks.add(link);
            toRet.put(sourceID, sourceLinks);
        }
        return toRet;
    }

    private static DependentProcess getDependentProcessFrom(Element target) {
        String uid = target.getAttribute("UID");
        Element process = EntitiesDefinitionsManager.instance().getElementByTypeAndID("PROCESS", uid);
        String processItemUid = XmlElement.ofNullable((Element)target).getAllDecnedElementByName("PROCESS_ITEM_UID").stream().findFirst().map(XmlElement::getText).orElse("");
        if (processItemUid.isEmpty()) {
            return new DependentProcess(process, uid, uid);
        }
        Element itemFromProcess = ZenaXmlUtils.getItemFromProcessByUid(process, processItemUid).orElse(null);
        return new DependentProcess(itemFromProcess, processItemUid, uid);
    }

    private void generateDependenciesConditions(String topLevelUID) {
        this.generateConditions(topLevelUID, topLevelUID, null, null, true);
    }

    private void generateNoneDependenciesConditions(String topLevelUID) {
        this.generateConditions(topLevelUID, topLevelUID, null, null, false);
    }

    public ProcessConditions getProcessConditions(String uid) {
        ProcessConditions toRet = new ProcessConditions();
        if (uid != null) {
            this.allConditions.putIfAbsent(uid, toRet);
            toRet = this.allConditions.get(uid);
        }
        return toRet;
    }

    private void initialize() {
        this.uniqueNumber = new AtomicInteger();
        RulesDataSet rules = RuleManager.instance().getCurrentRules();
        this.jobAOK = rules.getStringRule("Zena rules", new String[]{"CONDITION_NAME"}).equals("JOBA_OK");
        this.allConditions = new HashMap<String, ProcessConditions>();
        Map<String, List<String>> processChildsMap = EntitiesDefinitionsManager.instance().getProcessChildsMap();
        for (String UID : processChildsMap.keySet()) {
            this.generateDependenciesConditions(UID);
        }
        for (String UID : processChildsMap.keySet()) {
            this.generateNoneDependenciesConditions(UID);
        }
    }

    private void generateConditions(String topLevelUID, String uid, String itemUID, String cyclePath, boolean generateDependencies) {
        try {
            Element process;
            if (uid != null && (process = EntitiesDefinitionsManager.instance().getElementByID(uid)) != null) {
                Object key = topLevelUID;
                if (itemUID != null) {
                    key = topLevelUID + "-" + itemUID;
                }
                ConditionData conditionsData = this.generateConditionsMaps(process, generateDependencies);
                this.getProcessConditions((String)key).addInConditions(conditionsData.getInConditions());
                this.getProcessConditions((String)key).addOutConditions(conditionsData.getOutConditions());
                this.getProcessConditions((String)key).addOnStatementsConditions(conditionsData.getOnStatements());
                this.getProcessConditions((String)key).addConditionsMessages(conditionsData.getMessages());
                if (!ZenaDefs.isOrderingJobRuleEnabled(RuleManager.instance().getCurrentRules())) {
                    cyclePath = cyclePath == null ? uid : (String)cyclePath + "," + uid;
                    NodeList itemsList = process.getElementsByTagName("ITEMS");
                    Element items = (Element)itemsList.item(0);
                    NodeList subProcessList = items.getElementsByTagName("PROCESS");
                    for (int index = 0; index < subProcessList.getLength(); ++index) {
                        Element subProcessItem = (Element)subProcessList.item(index);
                        String subFolderUID = subProcessItem.getAttribute("UID");
                        if (((String)cyclePath).contains(subFolderUID)) continue;
                        this.generateConditions((String)key, subFolderUID, subProcessItem.getAttribute("ITEM_UID"), (String)cyclePath, generateDependencies);
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public void writeZekeConditionsToFile() {
        CsvWriter writer = new CsvWriter(Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "ZekeConditions.csv");
        try {
            writer.writeRecord(new String[]{"ID", "JOBNAME", "STATUS", "CONDITION_NAME"});
            for (String[] row : this.conditionData.getZekeConditions()) {
                writer.writeRecord(row);
            }
            writer.close();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private ConditionData generateConditionsMaps(Element parentDefinition, boolean generateDependencies) {
        this.conditionData = new ConditionData();
        Map<String, Element> itemIDToElement = ConditionsGenerator.getItemIDToElement(parentDefinition);
        Map<String, List<Element>> sourceItemIDToLinkElement = ConditionsGenerator.getSourceItemIDToLinkElement(parentDefinition);
        for (String sourceItemID : sourceItemIDToLinkElement.keySet()) {
            Element source = itemIDToElement.get(sourceItemID);
            Map<String, List<LinkItem>> statusToLinkItems = ConditionsGenerator.createStatusToLinkItems(itemIDToElement, sourceItemIDToLinkElement, source, this.conditionData);
            if (TaskEmailUtils.shouldSkipEmailTask(source, EntitiesDefinitionsManager.instance()) || !ConditionsGenerator.shouldGenerateDependenciesConditions(generateDependencies, source) && !ConditionsGenerator.shouldGenerateNonDependencyConditions(generateDependencies, source)) continue;
            this.generateConditionsProperties(source, statusToLinkItems);
        }
        return this.conditionData;
    }

    private void generateConditionsProperties(Element source, Map<String, List<LinkItem>> statusToLinkItems) {
        new ConditionPropertiesCreator(this.uniqueNumber, source, statusToLinkItems, this.conditionData, this.jobAOK, this::getProcessConditions, EntitiesDefinitionsManager.instance()).generate();
    }

    static {
        SUPPORTED_TARGETS = Arrays.asList("TASK", "DEPENDENCY", "PROCESS", "TIMER", "FLOW", "DATA", "TIME_RANGE", "SYNCHRONIZER", "VAR_DEPENDENCY", "ACTION", "ZEKE_NOTIFIER", "SEND_EVENT", "SCRIPT", "PROCESS_DEPENDENCY");
    }

    private static class DependentProcess {
        private final Element element;
        private final String itemUid;
        private final String processUid;

        public DependentProcess(Element element, String itemUid, String processUid) {
            this.element = element;
            this.itemUid = itemUid;
            this.processUid = processUid;
        }
    }

    public static class ConditionPropertiesCreator {
        public static final String JOB_A_ENDED_OK_FORMAT = "%s_%s";
        private final ConditionData conditionData;
        private final AtomicInteger uniqueNumber;
        private final Element source;
        private final Map<String, List<LinkItem>> statusToLinkItems;
        private final boolean jobAOK;
        private final Function<String, ProcessConditions> getProcessConditions;
        private final EntitiesDefinitionsManager entitiesDefinitionsManager;
        private final boolean isOrderingJob;
        private final boolean isDependency;

        public ConditionPropertiesCreator(AtomicInteger uniqueNumber, Element source, Map<String, List<LinkItem>> statusToLinkItems, ConditionData conditionData, boolean jobAOK, Function<String, ProcessConditions> getProcessConditions, EntitiesDefinitionsManager entitiesDefinitionsManager) {
            this.uniqueNumber = uniqueNumber;
            this.source = source;
            this.statusToLinkItems = statusToLinkItems;
            this.conditionData = conditionData;
            this.jobAOK = jobAOK;
            this.getProcessConditions = getProcessConditions;
            this.entitiesDefinitionsManager = entitiesDefinitionsManager;
            this.isOrderingJob = this.isOrderingJob();
            this.isDependency = this.isDependency();
        }

        private static void addPreviouslyCreatedPropertiesListToCollection(Map<String, List<Properties>> oldList, Map<String, List<Properties>> newList, String id, String key) {
            if (oldList != null && oldList.containsKey(id)) {
                for (Properties prop : oldList.get(id)) {
                    ConditionsGenerator.addKeydObjectToCollection(newList, key, prop);
                }
            }
        }

        private boolean isProcessDependency(Element source) {
            return source.getTagName().equals("PROCESS_DEPENDENCY");
        }

        public void generate() {
            try {
                String sourceID = Optional.of(this.source.getAttribute("ITEM_UID")).filter(s -> !s.isEmpty()).orElse(this.source.getAttribute("UID"));
                String complexStatus = this.getProcessOrTaskDependencyStatus();
                for (Map.Entry<String, List<LinkItem>> statusToLinks : this.statusToLinkItems.entrySet()) {
                    List<LinkItem> targetItems = statusToLinks.getValue();
                    List<StatusCalculator.ConditionStatus> conditionsStatuses = new StatusCalculator(complexStatus, statusToLinks.getKey()).calculate();
                    for (StatusCalculator.ConditionStatus conditionStatus : conditionsStatuses) {
                        String jobName = ZenaDefs.extractJobName(this.source);
                        String conditionPrefix = this.createConditionPrefix(jobName);
                        List<LinkItem> targetItemsWithoutFlows = this.addFlowConditions(targetItems, conditionPrefix);
                        this.createInConditions(targetItemsWithoutFlows, conditionStatus, conditionPrefix);
                        this.createOutConditions(targetItemsWithoutFlows, conditionStatus, conditionPrefix, sourceID);
                        this.createOnDoConditions(targetItemsWithoutFlows, sourceID, conditionStatus, jobName, conditionPrefix);
                        this.setConditions(this.isDependency, this.isOrderingJob, sourceID);
                    }
                }
            }
            catch (DOMException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }

        private List<LinkItem> addFlowConditions(List<LinkItem> targetItems, String conditionPrefix) {
            List<LinkItem> flowItems = targetItems.stream().filter(LinkItem::isFlow).toList();
            for (LinkItem linkItem : flowItems) {
                this.addFlowCondition(linkItem, conditionPrefix);
            }
            return targetItems.stream().filter(item -> !item.isFlow()).collect(Collectors.toList());
        }

        private void createOutConditions(List<LinkItem> targetItems, StatusCalculator.ConditionStatus conditionStatus, String conditionPrefix, String sourceID) {
            OutConditionBuilder outConditionAdd = this.getOutConditionBuilder(Sign.Add);
            String conditionName = ConditionPropertiesCreator.getConditionName(conditionPrefix, conditionStatus.getStatus(), JOB_A_ENDED_OK_FORMAT);
            String sourceKey = this.getSourceKey(this.isDependency, sourceID);
            if (this.jobAOK) {
                outConditionAdd.setConditionName(conditionName);
                this.addConditionsTo(this.conditionData.getOutConditions(), outConditionAdd.build().getProperties(), sourceKey, conditionStatus.isOk());
            }
            for (LinkItem targetItem : targetItems.stream().filter(item -> !item.isReturnValueLink()).toList()) {
                Element target = targetItem.getTarget();
                String targetJobName = ZenaDefs.extractJobName(target);
                if (!this.jobAOK) {
                    conditionName = ConditionPropertiesCreator.getConditionName(conditionPrefix, targetJobName, "%s-TO-%s");
                    outConditionAdd.setConditionName(conditionName);
                    this.addConditionsTo(this.conditionData.getOutConditions(), outConditionAdd.build().getProperties(), sourceKey, conditionStatus.isOk());
                }
                if (!this.isProcessDependency(this.source)) continue;
                this.createProcessDependencyOutCondition(conditionStatus, outConditionAdd, this.source);
            }
        }

        public static String getDependencyConditionName(Element element) {
            String name = ZenaDefs.extractJobName(element);
            Predicate<XmlElement> isProcess = e -> e.getTagName().equals("DEFINITION");
            XmlElement parent = XmlElement.ofNullable((Element)element).getParent();
            if (isProcess.test(parent)) {
                return name;
            }
            String parentName = ZenaDefs.extractJobName(parent.getParent().getElement());
            return String.format("%s-IN-%s", name, parentName);
        }

        private void createProcessDependencyOutCondition(StatusCalculator.ConditionStatus conditionStatus, OutConditionBuilder outConditionAdd, Element processDependencyItem) {
            DependentProcess dependentProcess = ConditionsGenerator.getDependentProcessFrom(processDependencyItem);
            String from = ConditionPropertiesCreator.getDependencyConditionName(dependentProcess.element);
            String to = ConditionPropertiesCreator.getDependencyConditionName(this.source);
            String conditionName = this.jobAOK ? ConditionPropertiesCreator.getConditionName(from, conditionStatus.getStatus(), JOB_A_ENDED_OK_FORMAT) : ConditionPropertiesCreator.getConditionName(from, to, "%s-TO-%s");
            outConditionAdd.setConditionName(conditionName);
            ProcessConditions conditions = this.getProcessConditions.apply(dependentProcess.processUid);
            List conditionFromProcessToProcessDependency = conditions.getOutConditions().getOrDefault(dependentProcess.itemUid, new ArrayList());
            conditionFromProcessToProcessDependency.add(outConditionAdd.build().getProperties());
            Map<String, List<Properties>> outConditions = conditions.getOutConditions();
            outConditions.put(dependentProcess.itemUid, conditionFromProcessToProcessDependency);
            conditions.addOutConditions(outConditions);
        }

        public void createOnDoConditions(List<LinkItem> targetItems, String sourceID, StatusCalculator.ConditionStatus conditionStatus, String jobName, String conditionPrefix) {
            boolean addToZEKEConditionMap = this.isAddToZEKEConditionMap(sourceID);
            String sourceKey = this.getSourceKey(this.isDependency, sourceID);
            Properties onStatement = this.createOnStatement();
            if (this.jobAOK) {
                String conditionName = ConditionPropertiesCreator.getConditionName(conditionPrefix, conditionStatus.getStatus(), JOB_A_ENDED_OK_FORMAT);
                onStatement.setProperty("NAME", conditionName);
                this.addConditionsTo(this.conditionData.getOnStatements(), onStatement, sourceKey, conditionStatus.isNotOk());
                if (addToZEKEConditionMap) {
                    this.addToZekeConditionMap(sourceID, jobName, conditionStatus.getStatus(), conditionName);
                }
            }
            for (LinkItem targetItem : targetItems) {
                Element target = targetItem.getTarget();
                if (this.jobAOK) continue;
                String targetJobName = ZenaDefs.extractJobName(target);
                String conditionName = ConditionPropertiesCreator.getConditionName(conditionPrefix, targetJobName, "%s-TO-%s");
                if (targetItem.isReturnValueLink()) {
                    this.convertReturnValueLinkToOnDoRaiseCondition(sourceKey, conditionName, targetItem, conditionStatus);
                }
                onStatement = (Properties)onStatement.clone();
                onStatement.setProperty("NAME", conditionName);
                this.addConditionsTo(this.conditionData.getOnStatements(), onStatement, sourceKey, conditionStatus.isNotOk());
                if (!addToZEKEConditionMap) continue;
                this.addToZekeConditionMap(sourceID, jobName, conditionStatus.getStatus(), conditionName);
            }
        }

        private void convertReturnValueLinkToOnDoRaiseCondition(String sourceKey, String conditionName, LinkItem targetItem, StatusCalculator.ConditionStatus conditionStatus) {
            Collection<Integer> exitCodes = targetItem.getExitCodes();
            exitCodes.forEach(exitCode -> {
                Properties onDo = ConditionPropertiesCreator.createOnCompletionStatusDoCondition(exitCode, conditionName);
                this.addConditionsTo(this.conditionData.getOnStatements(), onDo, sourceKey, conditionStatus.isOk());
            });
        }

        public static Properties createOnCompletionStatusDoCondition(int value, String conditionName) {
            Properties onDoStatement = new Properties();
            OnStatement.createOnCompletionStatus((int)value).addDo((Do)new DoCondition(conditionName, DoCondition.AddRemoveSign.ADD)).accept((on, doStatements) -> {
                onDoStatement.putAll((Map<?, ?>)on);
                onDoStatement.putAll((Map<?, ?>)((Map)doStatements.getFirst()));
            });
            return onDoStatement;
        }

        public void setConditions(boolean isDependency, boolean isOrderingJob, String sourceID) {
            String sourceKey = this.getSourceKey(isDependency, sourceID);
            if (isDependency || isOrderingJob) {
                this.getProcessConditions.apply(sourceID).addInConditions(this.conditionData.getInConditions());
                this.getProcessConditions.apply(sourceID).addOutConditions(this.getMapForID(this.conditionData.getOutConditions(), sourceID));
                this.getProcessConditions.apply(sourceID).addOnStatementsConditions(this.getMapForID(this.conditionData.getOnStatements(), sourceID));
                this.getProcessConditions.apply(sourceID).addConditionsMessages(this.conditionData.getMessages());
            } else {
                ProcessConditions processConditions = this.getProcessConditions.apply(sourceID);
                ConditionPropertiesCreator.addPreviouslyCreatedPropertiesListToCollection(processConditions.getOutConditions(), this.conditionData.getOutConditions(), sourceID, sourceKey);
                ConditionPropertiesCreator.addPreviouslyCreatedPropertiesListToCollection(processConditions.getOnStatementsConditions(), this.conditionData.getOnStatements(), sourceID, sourceKey);
            }
        }

        private void createInConditions(List<LinkItem> targetItems, StatusCalculator.ConditionStatus conditionStatus, String conditionPrefix) {
            InConditionBuilder inCondition = this.getInConditionBuilder();
            for (LinkItem targetItem : targetItems) {
                Element target = targetItem.getTarget();
                String targetKey = target.getAttribute("ITEM_UID");
                String restOfTheFlowConditionPrefix = this.getRestOfTheFlowConditionPrefix(this.isOrderingJob, conditionPrefix);
                String targetJobName = ZenaDefs.extractJobName(target);
                if (targetItem.isOptionalCondition()) {
                    inCondition.setAndOr(AndOr.OR);
                }
                String conditionName = ConditionPropertiesCreator.generateConditionName(conditionPrefix, targetJobName, conditionStatus.getStatus(), this.jobAOK);
                String orderingJobConditionName = ConditionPropertiesCreator.generateConditionName(restOfTheFlowConditionPrefix, targetJobName, conditionStatus.getStatus(), this.jobAOK);
                inCondition.setConditionName(conditionName);
                ConditionsGenerator.addKeydObjectToCollection(this.conditionData.getInConditions(), targetKey, inCondition.build().getProperties());
                if (this.isProcessDependency(this.source)) {
                    DependentProcess dependentProcess = ConditionsGenerator.getDependentProcessFrom(this.source);
                    String sourceKey = ZenaXmlUtils.getItemUid(this.source);
                    String from = ConditionPropertiesCreator.getDependencyConditionName(dependentProcess.element);
                    String to = ConditionPropertiesCreator.getDependencyConditionName(this.source);
                    String processDependencyConditionName = this.jobAOK ? ConditionPropertiesCreator.getConditionName(from, conditionStatus.getStatus(), JOB_A_ENDED_OK_FORMAT) : ConditionPropertiesCreator.getConditionName(from, to, "%s-TO-%s");
                    inCondition.setAnd();
                    inCondition.setConditionName(processDependencyConditionName);
                    ConditionsGenerator.addKeydObjectToCollection(this.conditionData.getInConditions(), sourceKey, inCondition.build().getProperties());
                }
                if (!this.isOrderingJob) continue;
                inCondition.setConditionName(orderingJobConditionName);
                ConditionsGenerator.addKeydObjectToCollection(this.conditionData.getInConditions(), targetKey, inCondition.build().getProperties());
            }
        }

        public static String generateConditionName(Element source, Element target, int id, boolean jobAOK) {
            return ConditionPropertiesCreator.generateConditionName(ConditionPropertiesCreator.createConditionPrefix(source, id), ZenaDefs.extractJobName(target), "ENDED_OK", jobAOK);
        }

        private static String generateConditionName(String conditionPrefix, String targetJobName, String conditionStatus, boolean jobAOK) {
            if (jobAOK) {
                return ConditionPropertiesCreator.getConditionName(conditionPrefix, conditionStatus, JOB_A_ENDED_OK_FORMAT);
            }
            return ConditionPropertiesCreator.getConditionName(conditionPrefix, targetJobName, "%s-TO-%s");
        }

        public static String getConditionName(String conditionPrefix, String conditionPostfix, String conditionNameFromToFormat) {
            String conditionName = String.format(conditionNameFromToFormat, conditionPrefix, conditionPostfix);
            return FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", conditionName);
        }

        public void addConditionsTo(Map<String, List<Properties>> target, Properties condition, String targetKey, boolean shouldAdd) {
            if (shouldAdd) {
                ConditionsGenerator.addKeydObjectToCollection(target, targetKey, condition);
            }
        }

        public static String createConditionPrefix(Element element, int id) {
            return ConditionPropertiesCreator.createConditionPrefix(id, ZenaDefs.extractJobName(element));
        }

        public String createConditionPrefix(String jobName) {
            return ConditionPropertiesCreator.createConditionPrefix(this.uniqueNumber.incrementAndGet(), jobName);
        }

        private static String createConditionPrefix(int id, String jobName) {
            return String.format("CID%04d@%s", id, jobName);
        }

        public String getRestOfTheFlowConditionPrefix(boolean isOrderingJob, String conditionPrefix) {
            return isOrderingJob ? conditionPrefix : "";
        }

        public String getSourceKey(boolean isDependency, String sourceKey) {
            if (this.source.hasAttribute("ITEM_UID") && !isDependency) {
                return this.source.getAttribute("ITEM_UID");
            }
            return sourceKey;
        }

        public String getProcessOrTaskDependencyStatus() {
            NodeList statusList;
            String dependencyStatus = "";
            if ((this.isProcessDependency(this.source) || ConditionsGenerator.isTaskDependency(this.source)) && (statusList = this.source.getElementsByTagName("STATUS")).getLength() == 1) {
                dependencyStatus = statusList.item(0).getTextContent();
            }
            return dependencyStatus;
        }

        private boolean isDependency() {
            return ConditionsGenerator.isTaskDependency(this.source);
        }

        public boolean isAddToZEKEConditionMap(String sourceID) {
            if (sourceID != null && !sourceID.isEmpty()) {
                return ConditionsGenerator.isZekeDefinition(sourceID, this.entitiesDefinitionsManager);
            }
            return false;
        }

        public boolean isOrderingJob() {
            return this.source.getTagName().equals("PROCESS") && ZenaDefs.isOrderingJobRuleEnabled(RuleManager.instance().getCurrentRules());
        }

        public Properties createOnStatement() {
            Properties onStatement = new Properties();
            onStatement.setProperty("CODE", "NOTOK");
            onStatement.setProperty("STMT", "*");
            onStatement.setProperty("ACTION", "DOCOND");
            onStatement.setProperty("ODATE", "ODAT");
            onStatement.setProperty("SIGN", "ADD");
            return onStatement;
        }

        public OutConditionBuilder getOutConditionBuilder(Sign add) {
            OutConditionBuilder outConditionAdd = new OutConditionBuilder();
            outConditionAdd.setSign(add);
            outConditionAdd.setOdate("ODAT");
            return outConditionAdd;
        }

        public InConditionBuilder getInConditionBuilder() {
            InConditionBuilder inCondition = new InConditionBuilder();
            inCondition.setAndOr(AndOr.AND);
            inCondition.setOdate("ODAT");
            return inCondition;
        }

        private void addToZekeConditionMap(String id, String jobname, String status, String conditionName) {
            this.conditionData.getZekeConditions().add(new String[]{id, jobname, status, conditionName});
        }

        private void addFlowCondition(LinkItem item, String conditionPrefix) {
            Element linkItem = item.getLink();
            Element targetItem = item.getTarget();
            Element sourceItem = item.getSource();
            String targetJobName = ZenaDefs.extractJobName(targetItem);
            String conditionName = ConditionPropertiesCreator.getConditionName(conditionPrefix, targetJobName, "%s-TO-%s");
            String triggerValue = linkItem.getAttribute("VALUES");
            String operator = linkItem.getAttribute("OPERATOR");
            Properties onStatement = this.createOnStatement(conditionName, triggerValue);
            Properties inCondition = this.createInCondition(conditionName, item.isOptionalCondition());
            String sourceKey = sourceItem.getAttribute("ITEM_UID");
            String targetKey = targetItem.getAttribute("ITEM_UID");
            ConditionsGenerator.addKeydObjectToCollection(this.conditionData.getOnStatements(), sourceKey, onStatement);
            ConditionsGenerator.addKeydObjectToCollection(this.conditionData.getInConditions(), targetKey, inCondition);
            this.addUnsupportedOperatorMessageIfNeeded(sourceItem, conditionName, operator);
        }

        private void addUnsupportedOperatorMessageIfNeeded(Element source, String conditionName, String operator) {
            String flowUid = source.getAttribute("ITEM_UID");
            String value = source.getAttribute("VALUE");
            if (this.isUnsupportedOperators(operator)) {
                ConditionsGenerator.addMessage(flowUid, "WRN15029", this.conditionData.getMessages(), flowUid, conditionName, operator, value);
            }
        }

        private boolean isUnsupportedOperators(String operator) {
            boolean isContains = operator.equals("CONTAINS");
            boolean isEquals = operator.equals("=");
            return !isContains && !isEquals;
        }

        private Properties createInCondition(String conditionName, boolean isOptional) {
            InConditionBuilder inCondition = new InConditionBuilder();
            inCondition.setConditionName(conditionName);
            inCondition.setOdate("ODAT");
            AndOr andOrValue = isOptional ? AndOr.OR : AndOr.AND;
            inCondition.setAndOr(andOrValue);
            return inCondition.build().getProperties();
        }

        private Properties createOnStatement(String conditionName, String value) {
            Properties onStatement = new Properties();
            Object searchString = value.isEmpty() ? "*" : "*" + value + "*";
            onStatement.setProperty("STMT", "*");
            onStatement.setProperty("CODE", (String)searchString);
            onStatement.setProperty("ACTION", "DOCOND");
            onStatement.put("NAME", conditionName);
            onStatement.setProperty("ODATE", "ODAT");
            onStatement.put("SIGN", "ADD");
            return onStatement;
        }

        private Map<String, List<Properties>> getMapForID(Map<String, List<Properties>> map, String id) {
            HashMap<String, List<Properties>> toRet = new HashMap<String, List<Properties>>();
            if (map.containsKey(id)) {
                toRet.put(id, map.get(id));
            }
            return toRet;
        }
    }
}

