/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.workspace.entities.ControlResource;
import com.bmc.ctmconvert.zena.ZenaDefs;
import com.bmc.ctmconvert.zena.ZenaJob;
import java.util.Properties;
import org.w3c.dom.Element;

public class ConcurrencyConvertor {
    private ZenaJob job;

    public ConcurrencyConvertor(ZenaJob job) {
        this.job = job;
    }

    public void convert() {
        if (this.shouldConvertConcurrency()) {
            String concurrency = XmlElement.ofNullable((Element)this.job.entityDefinition).getAttribute("CONCURRENCY");
            if ("DEFER".equals(concurrency)) {
                Properties resource = new ControlResource(this.createResourceName(), "E").asProperties();
                this.job.getCtrlResources().add(resource);
            } else if (!"RUN".equals(concurrency)) {
                this.job.addMessageWithJobNameAndOriginalJobName("WRN15051", this.describeConcurrency(concurrency));
            }
        }
    }

    private String describeConcurrency(String concurrency) {
        return switch (concurrency) {
            case "SKIP" -> "SKIP if process is already running";
            case "RUN_ONCE" -> "SKIP if process has already run today";
            default -> concurrency;
        };
    }

    private String createResourceName() {
        return ZenaDefs.getSmartTableName(this.job.entityDefinition);
    }

    private boolean shouldConvertConcurrency() {
        return this.job.isSmart() || this.job.type() == SchedEntity.TYPE.SUB_TABLE;
    }
}

