/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.common.NonQuotedStringReplacer;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandLineParser {
    public static final String SPECIAL_MARKER = "bmcSpecialMarker";

    public static String parse(String cmdLine, String parameters, ZenaJob job) {
        String OPEN_BRACKET = "\\[";
        String NO_CLOSING_BRACKET = "[^\\]]";
        String CLOSE_BRACKET = "\\]";
        String bracketsParametrsRegex = "(" + OPEN_BRACKET + NO_CLOSING_BRACKET + "*?" + CLOSE_BRACKET + ")";
        String commandLineTempDlimeter = "BMCQUOTE";
        parameters = CommandLineParser.surrondBracketsParmetrsWithQuotes(parameters, bracketsParametrsRegex);
        parameters = new NonQuotedStringReplacer().replaceAllButQuoted(parameters, "\\s+", commandLineTempDlimeter);
        parameters = CommandLineParser.deleteSurrondingQuotesFromBracketsParmetrs(parameters, "\"bmcSpecialMarker" + bracketsParametrsRegex + "bmcSpecialMarker\"");
        cmdLine = CommandLineParser.buildCommandline(cmdLine, parameters, job, commandLineTempDlimeter);
        return cmdLine;
    }

    private static String buildCommandline(String cmdLine, String parameters, ZenaJob job, String commandLineTempDlimeter) {
        if (parameters != null && parameters.length() > 0) {
            ZenaVariablesHandler zenaVariablesHandler = job.getZenaVariablesHandler();
            String[] parametersArr = parameters.split(commandLineTempDlimeter);
            for (int index = 0; index < parametersArr.length; ++index) {
                job.getAutoedits().put(String.format("%%%%PARM%d", index + 1), zenaVariablesHandler.annotateVariables(parametersArr[index]));
                cmdLine = cmdLine.concat(" " + String.format("%%%%PARM%d", index + 1));
            }
        }
        return cmdLine;
    }

    private static String surrondBracketsParmetrsWithQuotes(String parameters, String bracketsParametrsRegex) {
        StringBuffer result = new StringBuffer();
        Pattern bracketsParametrsPattern = Pattern.compile(bracketsParametrsRegex);
        Matcher bracketsParmetrsMatcher = bracketsParametrsPattern.matcher(parameters);
        while (bracketsParmetrsMatcher.find()) {
            String pramGroup = bracketsParmetrsMatcher.group();
            String quoteReplacement = Matcher.quoteReplacement(pramGroup);
            String replacement = "\"bmcSpecialMarker" + quoteReplacement + "bmcSpecialMarker\"";
            bracketsParmetrsMatcher.appendReplacement(result, replacement);
        }
        bracketsParmetrsMatcher.appendTail(result);
        return result.toString();
    }

    private static String deleteSurrondingQuotesFromBracketsParmetrs(String parameters, String qoutedBracketsParametrsRegex) {
        StringBuffer result = new StringBuffer();
        Pattern bracketsParametrsPattern = Pattern.compile(qoutedBracketsParametrsRegex);
        Matcher bracketsParmetrsMatcher = bracketsParametrsPattern.matcher(parameters);
        while (bracketsParmetrsMatcher.find()) {
            String group = bracketsParmetrsMatcher.group();
            String replaceAll = Matcher.quoteReplacement(group).replaceAll("\"bmcSpecialMarker|bmcSpecialMarker\"", "");
            bracketsParmetrsMatcher.appendReplacement(result, replaceAll);
        }
        bracketsParmetrsMatcher.appendTail(result);
        return result.toString();
    }
}

