/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CtmPriority;
import com.bmc.ctmconvert.common.DateUtils;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.rules.FieldEditor;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tng.DependenciesConvertor;
import com.bmc.ctmconvert.tng.JobParmTable;
import com.bmc.ctmconvert.tng.JobResTable;
import com.bmc.ctmconvert.tng.JobSetTable;
import com.bmc.ctmconvert.tng.JobTable;
import com.bmc.ctmconvert.tng.StationGroupTable;
import com.bmc.ctmconvert.tng.TNGSAPConverterHandler;
import com.bmc.ctmconvert.tng.TandemHandler;
import com.bmc.ctmconvert.tng.TngCalendars;
import com.bmc.ctmconvert.tng.TngDefs;
import com.bmc.ctmconvert.tng.TngGlobals;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class TngJob
implements SchedEntity {
    private ArrayList<String> m_messages = null;
    private boolean m_isValid = true;
    private final SchedEntity.TYPE m_type;
    private static ArrayList<String> m_ext_messages = null;
    private TngDefs m_sourceDefs = null;
    private RulesDataSet m_rules = null;
    private final IAttrHolder m_sourceAttr;
    private String m_origEntityName;
    private String m_origTableName;
    private String m_origEntityNumber;
    private boolean m_JobRunsEveryDay = false;
    private List<Properties> m_tags = null;
    private final HashMap<String, String> m_jobAttr = new HashMap();
    private final HashMap<String, String> m_tagAttr = new HashMap();
    private TngJob m_parent;
    private static TngGlobals.DATE_FORMAT m_dateFormat = null;
    private final LinkedHashMap<String, String> m_autoedits = new LinkedHashMap();
    private final List<Properties> m_shouts = new ArrayList<Properties>();
    private final List<String> m_optionalAttributesUsed = new ArrayList<String>();
    private static TngGlobals.RESOURCE_MODE m_resourceMode = null;
    private static String[] m_weekDaysArray = null;
    private static String m_maxWait = null;
    private static final String DEFAULT_MAX_WAIT = "03";
    private static Boolean toJob = null;
    private static Boolean toDummy = null;
    private final List<String> m_paramsList = new ArrayList<String>();
    protected HashMap<String, String> autoEditAttrNameAutoEditAttrValue = new HashMap();

    TngJob(String tableName, IAttrHolder attributes, SourceDefinitions sourceDef) {
        this.m_sourceDefs = (TngDefs)sourceDef;
        this.m_sourceAttr = attributes;
        this.m_isValid = true;
        this.m_type = SchedEntity.TYPE.SMART_TABLE;
        this.init();
    }

    public TngJob(TngJob parent, IAttrHolder attributes, TngDefs sourceDef) {
        this.m_sourceDefs = sourceDef;
        this.m_parent = parent;
        this.m_sourceAttr = attributes;
        this.m_type = SchedEntity.TYPE.JOB;
        this.init();
    }

    private void resolveOwnerForSmartFolder() {
        String jobOwner = this.applyFieldConversionForSchedEndity("OWNER", this.smartFolderFieldGetter());
        if (jobOwner.startsWith("\"") && jobOwner.endsWith("\"")) {
            jobOwner = jobOwner.substring(1, jobOwner.length() - 1);
        }
        this.m_jobAttr.put("OWNER", FieldValidation.instance().validateAndReturnFixedValue("OWNER", jobOwner, true, null, null, this.m_messages));
    }

    void init() {
        this.m_rules = RuleManager.instance().getCurrentRules();
        String entity_id = "JOB_ID";
        if (this.m_type != SchedEntity.TYPE.JOB) {
            entity_id = "JOBSET_ID";
        }
        this.m_origEntityName = this.getAttrWithDefault(entity_id, null, null, null, null, TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.LEAVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        if (this.m_type == SchedEntity.TYPE.JOB) {
            this.m_origEntityNumber = this.getAttrWithDefault("JNO_ID", null, null, null, null, TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.LEAVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        }
        ConvertorException.setCurrentEntity((String)("(" + String.valueOf(this.m_type) + ") " + this.getOriginalJobId()));
        ConvertorException.setCurrentEntityState((String)"Evaluation Started", (boolean)false);
        if (m_weekDaysArray == null) {
            String firstDay = this.m_rules.getStringRule("TNG rules", new String[]{"FIRST_DAY_OF_WEEK"});
            String firstDayCTMFormat = GlobalFunctions.FullDayNameToCtmName((String)firstDay);
            if (firstDayCTMFormat == null) {
                throw new NullPointerException("first name of week is not recognize ");
            }
            m_weekDaysArray = GlobalFunctions.getWeekDaysArray((String)firstDayCTMFormat);
        }
        this.retrieveResourceMode();
        if (this.m_messages == null) {
            this.m_messages = new ArrayList();
            if (m_ext_messages != null) {
                this.m_messages.addAll(m_ext_messages);
                m_ext_messages = null;
            }
        }
        this.determineTaskType();
        this.m_origTableName = this.m_sourceAttr.getAttr("JOBSET_ID");
        this.m_jobAttr.put("TABLE_NAME", FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", this.m_origTableName));
        this.m_jobAttr.put("JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", this.m_origEntityName) + (String)(this.m_type == SchedEntity.TYPE.JOB ? "_" + this.m_origEntityNumber : ""));
        if (this.m_type == SchedEntity.TYPE.SMART_TABLE) {
            this.resolveGroupandApplicationForTable();
            this.resolveOwnerForSmartFolder();
            if (!this.m_tagAttr.isEmpty()) {
                this.m_tagAttr.clear();
            }
        }
        if (this.m_type == SchedEntity.TYPE.JOB) {
            this.resolveNodeIDForJob();
            this.resolveCmdLineForJob();
            this.resolveOwnerForJob();
            this.resolveGroupForJob();
            this.resolveApplicationForJob();
            this.resolveCyclic();
        }
        if (this.m_type != SchedEntity.TYPE.TABLE) {
            this.resolveAuthor();
            this.resolveActiveFrom();
            this.resolveActiveTill();
            this.resolvePriority();
            this.resolveSchedulingCriteria();
            this.resolveTimeFrom();
            this.resolveTimeTo();
            this.resolveDescription();
            this.resolveConfirm();
            this.resolveMaxwait();
            this.resolveFailCond();
            this.resolveShoutLateSub();
            this.resolveShoutExecTime();
        }
        if (this.m_type != SchedEntity.TYPE.JOB) {
            this.resolveUserDaily();
        }
        if (this.m_rules.getBooleanRule("TNG rules", new String[]{"SAP_AVAILABLE"}).booleanValue()) {
            String command = this.m_jobAttr.get("CMDLINE");
            TNGSAPConverterHandler tngSAPConverterHandler = new TNGSAPConverterHandler();
            if (command != null && tngSAPConverterHandler.isSAPJob(command)) {
                tngSAPConverterHandler.buildAutoEditAttrNameAutoEditAttrValueMapFromCommand(this.m_jobAttr.get("JOBNAME"), this.autoEditAttrNameAutoEditAttrValue, this.m_messages, this.m_rules, this.m_paramsList, command);
                tngSAPConverterHandler.convert(this.m_jobAttr, this.m_autoedits, this.m_optionalAttributesUsed, this.m_rules, this.autoEditAttrNameAutoEditAttrValue);
                HashMap<String, String> action = new HashMap<String, String>();
                action.put("ACTENTTYPE", "SAPACC");
                action.put("JOBID", this.m_jobAttr.get("JOBNAME"));
                action.put("ACTENTNAME", this.m_autoedits.get("%%SAPR3-ACCOUNT"));
                action.put("ACTSTATUS", "0");
                Reporter.addAction(action);
                this.m_messages.removeIf(m -> m.contains("WRN1005"));
            }
        }
        if (this.m_type == SchedEntity.TYPE.JOB) {
            this.setDummy();
        }
        if (this.isTandemJob()) {
            String jobName = this.m_sourceAttr.getAttr("JOB_ID");
            String jobSet = this.m_sourceAttr.getAttr("JOBSET_ID");
            String jno = this.m_sourceAttr.getAttr("JNO_ID");
            IAttrHolder jobParmAttr = JobParmTable.instance().getParams(jobSet, jobName, jno);
            TandemHandler tandemHandler = new TandemHandler(this, jobParmAttr, this.m_sourceDefs);
            tandemHandler.execute();
        }
        ConvertorException.setCurrentEntityState((String)"Evaluation Completed", (boolean)true);
    }

    private boolean isTandemJob() {
        String jobName = this.m_sourceAttr.getAttr("JOB_ID");
        String jobSet = this.m_sourceAttr.getAttr("JOBSET_ID");
        String jno = this.m_sourceAttr.getAttr("JNO_ID");
        IAttrHolder jobParmAttr = JobParmTable.instance().getParams(jobSet, jobName, jno);
        String jobParmProgname = null;
        if (jobParmAttr != null) {
            jobParmProgname = jobParmAttr.getAttr("PROGNAME");
        }
        boolean isTandemJob = jobParmProgname != null && !jobParmProgname.isEmpty() && !jobParmProgname.equals("NULL");
        return isTandemJob;
    }

    private void resolveGroupandApplicationForTable() {
        String jobset;
        String sep = this.m_rules.getStringRule("TNG rules", new String[]{"APPLICATION_SEP"});
        String app = "";
        String grp = "";
        boolean hasSeperator = false;
        if (sep != null && (jobset = this.m_sourceAttr.getAttr("JOBSET_ID")).contains(sep)) {
            String[] appGroup = jobset.split(sep, 2);
            app = appGroup[0];
            grp = appGroup[1];
            hasSeperator = true;
        }
        if (hasSeperator) {
            this.resolveGroupForTable(grp);
            this.resolveApplicationForTable(app);
        } else {
            this.resolveGroupForTable();
            this.resolveApplicationForTable();
        }
    }

    private void resolveApplicationForTable(String application) {
        if (application.isEmpty()) {
            application = "EMPTY_APPLICATION";
        }
        this.m_jobAttr.put("APPLICATION", FieldValidation.instance().validateAndReturnFixedValue("APPLICATION", application));
    }

    private void resolveGroupForTable(String groupName) {
        if (groupName.isEmpty()) {
            groupName = "EMPTY_GROUP";
        }
        this.m_jobAttr.put("GROUP", FieldValidation.instance().validateAndReturnFixedValue("GROUP", groupName));
    }

    public static String buildJobIdKey(String jobSet, String jobId, String jobNo) {
        String key = jobSet.toString();
        if (jobId != null) {
            key = key.concat(" - ").concat(jobId.toString());
        }
        if (jobNo != null) {
            key = key.concat(" - ").concat(jobNo.toString());
        }
        return key;
    }

    private String getOriginalJobId() {
        if (this.m_type == SchedEntity.TYPE.JOB) {
            String jobSetID = this.m_sourceAttr.getAttr("JOBSET_ID");
            String jno = this.m_sourceAttr.getAttr("JNO_ID");
            return TngJob.buildJobIdKey(jobSetID, this.getOriginalJobName(), jno);
        }
        return TngJob.buildJobIdKey(this.getOriginalJobName(), null, null);
    }

    private void retrieveResourceMode() {
        if (m_resourceMode != null) {
            return;
        }
        String mode = this.m_rules.getStringRule("TNG rules", new String[]{"RESOURCE_MODE"});
        m_resourceMode = TngGlobals.RESOURCE_MODE.AUTO;
        if (mode.equalsIgnoreCase("Auto")) {
            m_resourceMode = TngGlobals.RESOURCE_MODE.AUTO;
        } else if (mode.equalsIgnoreCase("Quantitative Resource")) {
            m_resourceMode = TngGlobals.RESOURCE_MODE.QUANTITATIVE;
        } else if (mode.equalsIgnoreCase("Control Resource")) {
            m_resourceMode = TngGlobals.RESOURCE_MODE.CTRL;
        }
    }

    private String getDayNum(String CritKey, Integer PrefixLen) {
        String dayNum = CritKey.substring(PrefixLen + 1);
        if (dayNum.length() > 1 && dayNum.startsWith("0")) {
            dayNum = dayNum.substring(1);
        }
        return dayNum;
    }

    private String getDayNumCode(String CritKey, Integer PrefixLen) {
        String DayNumCode = CritKey.substring(PrefixLen, PrefixLen + 1);
        return DayNumCode;
    }

    private Integer appendSchedulingElement(StringBuilder SchedulingStr, String NewElement, Integer MaxLength, String SchedulingEntityName) {
        if (NewElement.length() == 0) {
            return SchedulingStr.length();
        }
        if (SchedulingStr.length() > 0) {
            if (SchedulingStr.length() + 1 + NewElement.length() > MaxLength) {
                return -1;
            }
            SchedulingStr.append(",");
        }
        if (SchedulingStr.length() + NewElement.length() > MaxLength) {
            Reporter.addMessage(this.m_messages, (String)"WRN0007", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), SchedulingEntityName.toString(), SchedulingStr.toString(), NewElement.toString(), MaxLength.toString(), ""});
            return -1;
        }
        SchedulingStr.append(NewElement.toString());
        return SchedulingStr.length();
    }

    private void putOptionalAttribute(String AttributeName, String AttributeValue, Boolean appendToTag) {
        if (AttributeValue.length() < 1) {
            return;
        }
        if (this.m_type == SchedEntity.TYPE.JOB || !appendToTag.booleanValue()) {
            this.m_jobAttr.put(AttributeName, FieldValidation.instance().validateAndReturnFixedValue(AttributeName, AttributeValue.toString(), true, null, null, this.m_messages));
            this.m_optionalAttributesUsed.add(AttributeName);
        }
        if (this.m_type == SchedEntity.TYPE.SMART_TABLE && appendToTag.booleanValue()) {
            this.m_tagAttr.put(AttributeName, FieldValidation.instance().validateAndReturnFixedValue(AttributeName, AttributeValue.toString(), true, null, null, this.m_messages));
        }
    }

    private void issueCalendarMessage(String CalendarName, String CalendarType) {
        if (CalendarName.length() < 1) {
            return;
        }
        Reporter.addMessage(this.m_messages, (String)"INF0006", (String)this.getOriginalJobId(), (String[])new String[]{CalendarName.toString(), CalendarType.toString()});
        HashMap<String, String> calendarAction = new HashMap<String, String>();
        calendarAction.put("ACTENTTYPE", "CAL");
        calendarAction.put("JOBID", this.getOriginalJobId());
        calendarAction.put("ACTENTNAME", CalendarName);
        calendarAction.put("ACTENTQTY", "0");
        calendarAction.put("ACTSTATUS", "0");
        Reporter.addAction(calendarAction);
    }

    private String getAttrWithDefault(String Attribute, String parentAttrCtm, String parentAttrOrig, String DefaultValue, String MessageId, TngGlobals.CASE_HANDLING caseHandle, QUOTES_HANDLING removeQuotes, PARENTHESES_HANDLING removeParentheses) {
        String attrValue = this.m_sourceAttr.getAttr(Attribute);
        String parentValue = "";
        if (attrValue == null) {
            attrValue = "";
        }
        if (attrValue.isEmpty() || attrValue.equals("NULL")) {
            if (parentAttrCtm != null && this.m_parent != null && (parentValue = this.m_parent.getAttr(parentAttrCtm)) == null) {
                parentValue = "";
            }
            if ((parentValue.isEmpty() || parentValue.equals("NULL")) && parentAttrOrig != null && this.m_parent != null) {
                parentValue = this.m_parent.m_sourceAttr.getAttr(parentAttrOrig);
            }
            if (parentValue == null) {
                parentValue = "";
            }
            if (((attrValue = parentValue).isEmpty() || attrValue.equals("NULL")) && DefaultValue != null) {
                attrValue = DefaultValue;
                if (MessageId != null) {
                    Reporter.addMessage(this.m_messages, (String)MessageId, (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), Attribute, "", DefaultValue});
                }
            }
        }
        if (removeQuotes == QUOTES_HANDLING.REMOVE_DELIMITER && attrValue.startsWith("\"") && attrValue.endsWith("\"")) {
            attrValue = attrValue.substring(1, attrValue.length() - 1);
        }
        if (removeParentheses == PARENTHESES_HANDLING.REMOVE_DELIMITER && attrValue.startsWith("(") && attrValue.endsWith(")")) {
            attrValue = attrValue.substring(1, attrValue.length() - 1);
        }
        if (caseHandle == TngGlobals.CASE_HANDLING.TOUPPER) {
            attrValue = attrValue.toUpperCase();
        } else if (caseHandle == TngGlobals.CASE_HANDLING.TOLOWER) {
            attrValue = attrValue.toLowerCase();
        }
        return attrValue;
    }

    private void resolveNodeIDForJob() {
        String stations;
        String nodeID = this.getAttrWithDefault("STATION", "NODEID", "STATION", "DEFAULT_NODEID", "INF0005", TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        this.m_jobAttr.put("NODEID", FieldValidation.instance().validateAndReturnFixedValue("NODEID", nodeID, true, null, null, this.m_messages));
        IAttrHolder stationGroupAttr = StationGroupTable.instance().getStationGroupAttr(nodeID);
        if (stationGroupAttr != null && (stations = stationGroupAttr.getAttr("STATIONS")) != null) {
            TreeSet<String> nodes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            nodes.addAll(Arrays.asList(this.parseStations(stations)));
            Reporter.addNodeGroupAction((String)nodeID, nodes, (String)this.getOriginalJobId(), (String)stations);
        }
    }

    private String[] parseStations(String stations) {
        String PARENTHESES = "\\(|\\)";
        String stationsWithoutParentheses = stations.replaceAll(PARENTHESES, "");
        return stationsWithoutParentheses.split("\\s*,\\s*");
    }

    public void resolveSchedulingCriteria() {
        TngCalendars.NamedCalendar tempCal;
        Integer n;
        StringBuilder weekStr = new StringBuilder("");
        StringBuilder daysStr = new StringBuilder("");
        String weeksCal = "";
        String daysCal = "";
        String confCal = "";
        String confCalShift = "";
        String confCalShiftNum = "";
        String daysAndOr = "OR";
        String tag_relationship = "OR";
        ArrayList<Object> Specific_Dates = new ArrayList<Object>();
        Object dayNum = "";
        String dayNumCode = "";
        Integer dayIndex = 0;
        Integer weekIndex = 0;
        Integer monthIndex = 0;
        Integer WeekNumber = 0;
        String allDaysCal = this.m_rules.getStringRule("TNG rules", new String[]{"ALLDAYS"});
        String holidaysCal = this.m_rules.getStringRule("TNG rules", new String[]{"HOLIDAY"});
        String[] monthsArray = GlobalFunctions.getMonthsArray();
        Boolean monthAll = true;
        String[] monthStr = new String[monthsArray.length];
        monthIndex = 0;
        while (monthIndex < monthsArray.length) {
            monthStr[monthIndex.intValue()] = "0";
            Integer n2 = monthIndex;
            monthIndex = monthIndex + 1;
        }
        String critKeys = this.getAttrWithDefault("CRITKEYS", null, null, "", null, TngGlobals.CASE_HANDLING.TOUPPER, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        String critCal = this.getAttrWithDefault("CRITCAL", null, null, "", null, TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        String critHact = this.getAttrWithDefault("CRITHACT", null, null, "", null, TngGlobals.CASE_HANDLING.TOUPPER, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        String calendar = this.getAttrWithDefault("CALENDAR", null, null, "", null, TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        String[] critKeysArray = critKeys.split(" |,");
        Integer i = 0;
        while (i < critKeysArray.length) {
            Constable valueNotImplemented;
            if (critKeysArray[i].length() >= 1) {
                valueNotImplemented = Boolean.valueOf(false);
                if (GlobalFunctions.getDayOfTheWeekIndex((String[])m_weekDaysArray, (String)critKeysArray[i].toString()) >= 0) {
                    dayIndex = GlobalFunctions.getDayOfTheWeekCtmIndex((String[])m_weekDaysArray, (String)critKeysArray[i].toString());
                    this.appendSchedulingElement(weekStr, dayIndex.toString(), Globs.WEEKSTR_MAX_LEN, "WEEKDAYS");
                } else if (critKeysArray[i].length() >= 3 && GlobalFunctions.getDayOfTheWeekIndex((String[])m_weekDaysArray, (String)critKeysArray[i].substring(0, 3)) >= 0) {
                    dayIndex = GlobalFunctions.getDayOfTheWeekCtmIndex((String[])m_weekDaysArray, (String)critKeysArray[i].substring(0, 3));
                    dayNum = this.getDayNum(critKeysArray[i], 3);
                    dayNumCode = this.getDayNumCode(critKeysArray[i], 3);
                    if (((String)dayNum).equalsIgnoreCase("L")) {
                        if (critKeysArray.length > 1) {
                            dayNum = "";
                            Reporter.addMessage(this.m_messages, (String)"WRN1001", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), "CRITKEYS", critKeysArray[i].toString(), critKeys.toString(), ""});
                        } else {
                            daysAndOr = "AND";
                            this.appendSchedulingElement(daysStr, "L1,L2,L3,L4,L5,L6,L7", Globs.DAYSSTR_MAX_LEN, "DAYS");
                            dayNum = dayIndex.toString();
                        }
                    } else {
                        if (dayNumCode.equals("#")) {
                            dayNum = "D" + dayIndex.toString() + "W" + (String)dayNum;
                        }
                        daysAndOr = "AND";
                    }
                    this.appendSchedulingElement(weekStr, (String)dayNum, Globs.WEEKSTR_MAX_LEN, "WEEKDAYS");
                    daysCal = calendar.toString();
                } else if (critKeysArray[i].length() >= 4 && critKeysArray[i].substring(0, 1).equalsIgnoreCase("X") && GlobalFunctions.getDayOfTheWeekIndex((String[])m_weekDaysArray, (String)critKeysArray[i].substring(1, 4)) >= 0) {
                    dayIndex = GlobalFunctions.getDayOfTheWeekCtmIndex((String[])m_weekDaysArray, (String)critKeysArray[i].substring(1, 4));
                    dayNum = this.getDayNum(critKeysArray[i], 4);
                    dayNumCode = this.getDayNumCode(critKeysArray[i], 4);
                    if (dayNumCode.equals("#")) {
                        if (((String)dayNum).equalsIgnoreCase("L")) {
                            if (critKeysArray.length > 1) {
                                dayNum = "";
                                Reporter.addMessage(this.m_messages, (String)"WRN1001", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), "CRITKEYS", critKeysArray[i].toString(), critKeys.toString(), ""});
                            } else {
                                daysAndOr = "AND";
                                this.appendSchedulingElement(daysStr, "-L1,-L2,-L3,-L4,-L5,-L6,-L7", Globs.DAYSSTR_MAX_LEN, "DAYS");
                                dayNum = dayIndex.toString();
                                this.appendSchedulingElement(weekStr, (String)dayNum, Globs.WEEKSTR_MAX_LEN, "WEEKDAYS");
                            }
                        } else {
                            WeekNumber = Integer.parseInt((String)dayNum);
                            weekIndex = 1;
                            while (weekIndex <= 6) {
                                if (weekIndex != WeekNumber) {
                                    dayNum = "D" + dayIndex.toString() + "W" + weekIndex.toString();
                                    this.appendSchedulingElement(weekStr, (String)dayNum, Globs.WEEKSTR_MAX_LEN, "WEEKDAYS");
                                }
                                n = weekIndex;
                                weekIndex = weekIndex + 1;
                            }
                        }
                        weeksCal = calendar.toString();
                    } else {
                        this.addMessage("WRN0005", this.getOriginalJobId(), this.getJobName(), "CRITKEYS=" + critKeysArray[i].toString());
                    }
                } else if (critKeysArray[i].toString().equals("DAILY")) {
                    daysStr.replace(0, daysStr.length(), "ALL");
                    daysCal = calendar.toString();
                } else if (critKeysArray[i].toString().equals("HOLIDAYS")) {
                    daysStr.replace(0, daysStr.length(), "ALL");
                    daysCal = holidaysCal.toString();
                } else if (critKeysArray[i].toString().equals("WORKDAYS")) {
                    daysStr.replace(0, daysStr.length(), "ALL");
                    daysCal = calendar.toString();
                } else if (critKeysArray[i].startsWith("WORKD")) {
                    dayNum = this.getDayNum(critKeysArray[i], 5);
                    dayNumCode = this.getDayNumCode(critKeysArray[i], 5);
                    if (dayNumCode.equals("#")) {
                        dayNum = ((String)dayNum).equals("L") ? "L1" : "D" + (String)dayNum;
                    } else if (dayNumCode.equals("M")) {
                        dayNum = "L" + (String)dayNum;
                    } else if (dayNumCode.equals("X")) {
                        dayNum = ((String)dayNum).equalsIgnoreCase("L") ? "-L1" : "-" + (String)dayNum;
                    }
                    if (daysStr.toString().equalsIgnoreCase("ALL")) {
                        daysStr.delete(0, daysStr.length());
                    }
                    this.appendSchedulingElement(daysStr, (String)dayNum, Globs.DAYSSTR_MAX_LEN, "DAYS");
                    daysCal = calendar.toString();
                    if (daysCal.isEmpty()) {
                        daysCal = allDaysCal.toString();
                    }
                } else if (critKeysArray[i].toString().equals("WEEKDAYS")) {
                    this.appendSchedulingElement(weekStr, GlobalFunctions.getDayOfTheWeekCtmIndex((String[])m_weekDaysArray, (String)"MON").toString(), Globs.WEEKSTR_MAX_LEN, "WEEKDAYS");
                    this.appendSchedulingElement(weekStr, GlobalFunctions.getDayOfTheWeekCtmIndex((String[])m_weekDaysArray, (String)"TUE").toString(), Globs.WEEKSTR_MAX_LEN, "WEEKDAYS");
                    this.appendSchedulingElement(weekStr, GlobalFunctions.getDayOfTheWeekCtmIndex((String[])m_weekDaysArray, (String)"WED").toString(), Globs.WEEKSTR_MAX_LEN, "WEEKDAYS");
                    this.appendSchedulingElement(weekStr, GlobalFunctions.getDayOfTheWeekCtmIndex((String[])m_weekDaysArray, (String)"THU").toString(), Globs.WEEKSTR_MAX_LEN, "WEEKDAYS");
                    this.appendSchedulingElement(weekStr, GlobalFunctions.getDayOfTheWeekCtmIndex((String[])m_weekDaysArray, (String)"FRI").toString(), Globs.WEEKSTR_MAX_LEN, "WEEKDAYS");
                    confCal = holidaysCal.toString();
                    confCalShift = "IGNOREJOB";
                } else if (critKeysArray[i].startsWith("WEEKD")) {
                    dayNum = this.getDayNum(critKeysArray[i], 5);
                    dayNumCode = this.getDayNumCode(critKeysArray[i], 5);
                    if (dayNumCode.equals("#") && ((String)dayNum).equals("L")) {
                        dayNum = "5";
                    }
                    this.appendSchedulingElement(weekStr, (String)dayNum, Globs.WEEKSTR_MAX_LEN, "WEEKDAYS");
                    weeksCal = calendar.toString();
                } else if (critKeysArray[i].startsWith("MNTHD")) {
                    dayNum = this.getDayNum(critKeysArray[i], 5);
                    dayNumCode = this.getDayNumCode(critKeysArray[i], 5);
                    if (dayNumCode.equals("#")) {
                        dayNum = ((String)dayNum).equals("L") ? "L1" : "D" + (String)dayNum;
                    } else if (dayNumCode.equals("M")) {
                        dayNum = "L" + (String)dayNum;
                    } else if (dayNumCode.equals("X")) {
                        dayNum = "-" + (String)dayNum;
                    }
                    this.appendSchedulingElement(daysStr, (String)dayNum, Globs.DAYSSTR_MAX_LEN, "DAYS");
                    daysCal = allDaysCal.toString();
                } else if (critKeysArray[i].toString().equals("FOM")) {
                    this.appendSchedulingElement(daysStr, "D1", Globs.DAYSSTR_MAX_LEN, "DAYS");
                    daysCal = allDaysCal.toString();
                } else if (critKeysArray[i].toString().equals("XFOM")) {
                    this.appendSchedulingElement(daysStr, "-D1", Globs.DAYSSTR_MAX_LEN, "DAYS");
                    daysCal = allDaysCal.toString();
                } else if (critKeysArray[i].toString().equals("FOMWORK")) {
                    this.appendSchedulingElement(daysStr, "D1", Globs.DAYSSTR_MAX_LEN, "DAYS");
                    daysCal = calendar.toString();
                    this.checkCalIsEmpty(daysCal, "DAYSCAL", critKeysArray[i].toString(), "Workdays");
                } else if (critKeysArray[i].toString().equals("XFOMWORK")) {
                    this.appendSchedulingElement(daysStr, "-D1", Globs.DAYSSTR_MAX_LEN, "DAYS");
                    daysCal = calendar.toString();
                    this.checkCalIsEmpty(daysCal, "DAYSCAL", critKeysArray[i].toString(), "Workdays");
                } else if (critKeysArray[i].toString().equals("FOMWEEK")) {
                    valueNotImplemented = Boolean.valueOf(true);
                } else if (critKeysArray[i].toString().equals("XFOMWEEK")) {
                    valueNotImplemented = Boolean.valueOf(true);
                } else if (critKeysArray[i].toString().equals("EOM")) {
                    this.appendSchedulingElement(daysStr, "L1", Globs.DAYSSTR_MAX_LEN, "DAYS");
                    daysCal = allDaysCal.toString();
                } else if (critKeysArray[i].toString().equals("XEOM")) {
                    this.appendSchedulingElement(daysStr, "-L1", Globs.DAYSSTR_MAX_LEN, "DAYS");
                    daysCal = allDaysCal.toString();
                } else if (critKeysArray[i].toString().equals("EOMWORK")) {
                    this.appendSchedulingElement(daysStr, "L1", Globs.DAYSSTR_MAX_LEN, "DAYS");
                    daysCal = calendar.toString();
                } else if (critKeysArray[i].toString().equals("XEOMWORK")) {
                    this.appendSchedulingElement(daysStr, "-L1", Globs.DAYSSTR_MAX_LEN, "DAYS");
                    daysCal = calendar.toString();
                } else if (critKeysArray[i].toString().equals("EOMWEEK")) {
                    valueNotImplemented = Boolean.valueOf(true);
                } else if (critKeysArray[i].toString().equals("XEOMWEEK")) {
                    valueNotImplemented = Boolean.valueOf(true);
                } else if (critKeysArray[i].length() >= 3 && GlobalFunctions.getMonthIndex((String[])monthsArray, (String)critKeysArray[i].substring(0, 3)) >= 0) {
                    monthIndex = GlobalFunctions.getMonthIndex((String[])monthsArray, (String)critKeysArray[i].substring(0, 3));
                    if (critKeysArray[i].length() > 3) {
                        dayNum = this.getDayNum(critKeysArray[i], 3);
                        dayNumCode = this.getDayNumCode(critKeysArray[i], 3);
                        if (dayNumCode.equals("#")) {
                            if (critKeysArray.length > 1) {
                                if (GlobalFunctions.isNumber((String)dayNum)) {
                                    Specific_Dates.add(String.format("%02d%02d", monthIndex, Integer.parseInt((String)dayNum)));
                                } else if (((String)dayNum).equals("L")) {
                                    Integer currYear = Calendar.getInstance().get(1);
                                    Calendar tempCal2 = Calendar.getInstance();
                                    tempCal2.set(currYear, monthIndex - 1, 1);
                                    int lastDay = tempCal2.getActualMaximum(5);
                                    Specific_Dates.add(String.format("%02d%02d", monthIndex, lastDay));
                                } else {
                                    Reporter.addMessage(this.m_messages, (String)"WRN0006", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), "CRITKEYS", critKeysArray[i].toString(), "day number"});
                                }
                            } else {
                                this.appendSchedulingElement(daysStr, (String)dayNum, Globs.DAYSSTR_MAX_LEN, "DAYS");
                            }
                        } else if (dayNumCode.equals("M")) {
                            dayNum = "L" + (String)dayNum;
                            this.appendSchedulingElement(daysStr, (String)dayNum, Globs.DAYSSTR_MAX_LEN, "DAYS");
                        }
                    } else {
                        daysStr.replace(0, daysStr.length(), "ALL");
                    }
                    if (Specific_Dates.size() == 0) {
                        monthStr[monthIndex.intValue() - 1] = "1";
                        monthAll = false;
                    }
                } else if (critKeysArray[i].length() >= 4 && critKeysArray[i].substring(0, 1).equalsIgnoreCase("X") && GlobalFunctions.getMonthIndex((String[])monthsArray, (String)critKeysArray[i].substring(1, 4)) >= 0) {
                    monthIndex = GlobalFunctions.getMonthIndex((String[])monthsArray, (String)critKeysArray[i].substring(1, 4));
                    if (critKeysArray[i].length() > 4) {
                        dayNum = this.getDayNum(critKeysArray[i], 4);
                        dayNumCode = this.getDayNumCode(critKeysArray[i], 4);
                        if (((String)dayNum).equals("L")) {
                            dayNum = "L1";
                        }
                        if (dayNumCode.equals("M")) {
                            dayNum = "L" + (String)dayNum;
                        }
                        dayNum = "-" + (String)dayNum;
                        this.appendSchedulingElement(daysStr, (String)dayNum, Globs.DAYSSTR_MAX_LEN, "DAYS");
                    }
                    daysCal = allDaysCal.toString();
                    monthAll = false;
                    monthStr[monthIndex.intValue() - 1] = "1";
                } else if (critKeysArray[i].length() >= 5 && (critKeysArray[i].substring(2, 3).equalsIgnoreCase("/") || critKeysArray[i].substring(4, 5).equalsIgnoreCase("/"))) {
                    String[] yy_mm_dd = critKeysArray[i].split("\\.+|/+");
                    if (yy_mm_dd[2].length() == 4) {
                        this.addMessage("WRN0005", this.getOriginalJobId(), this.getJobName(), "CRITKEYS=" + critKeysArray[i].toString());
                    } else {
                        if (yy_mm_dd[0] == "**" || yy_mm_dd[0] != "****") {
                            // empty if block
                        }
                        if (yy_mm_dd[1].equals("**") && yy_mm_dd[2].equals("**")) {
                            monthAll = true;
                            daysStr.replace(0, daysStr.length(), "ALL");
                        } else {
                            yy_mm_dd[1] = yy_mm_dd[1].replace("*", "\\d");
                            yy_mm_dd[2] = yy_mm_dd[2].replace("*", "\\d");
                            monthIndex = 1;
                            while (monthIndex <= 12) {
                                Object mm = String.format("%02d", monthIndex);
                                if (((String)mm).matches(yy_mm_dd[1].toString())) {
                                    dayIndex = 1;
                                    while (dayIndex <= 31) {
                                        String dd = String.format("%02d", dayIndex);
                                        if (dd.matches(yy_mm_dd[2].toString())) {
                                            Specific_Dates.add(((String)mm).toString() + dd.toString());
                                        }
                                        Integer n3 = dayIndex;
                                        dayIndex = dayIndex + 1;
                                    }
                                }
                                mm = monthIndex;
                                monthIndex = monthIndex + 1;
                            }
                        }
                    }
                } else if (critKeysArray[i].toString().equals("AND")) {
                    daysAndOr = "AND";
                } else if (!critKeysArray[i].toString().equals("OR")) {
                    valueNotImplemented = Boolean.valueOf(true);
                }
                if (((Boolean)valueNotImplemented).booleanValue()) {
                    this.addMessage("WRN0005", this.getOriginalJobId(), this.getJobName(), "CRITKEYS=" + critKeysArray[i].toString());
                }
            }
            valueNotImplemented = i;
            i = i + 1;
        }
        if (calendar != null && calendar.length() > 0 && Specific_Dates.size() == 0) {
            if (!weekStr.toString().isEmpty()) {
                if (weeksCal.isEmpty() && daysCal.isEmpty()) {
                    weeksCal = calendar.toString();
                }
            } else if (daysCal.isEmpty()) {
                daysCal = calendar.toString();
            }
        }
        if (critCal != null && critCal.length() > 0) {
            confCal = critCal.toString();
        }
        if (Specific_Dates.size() > 0 && daysStr.toString().equalsIgnoreCase("ALL")) {
            daysStr.replace(0, daysStr.length(), "");
        }
        if (critHact.equalsIgnoreCase("W")) {
            confCalShift = "NEXTDAY";
        } else if (critHact.equalsIgnoreCase("P")) {
            confCalShift = "PREVDAY";
        } else if (critHact.equalsIgnoreCase("S")) {
            confCalShift = "NOCONFCAL";
            confCal = "";
        } else if (critHact.equalsIgnoreCase("N")) {
            confCalShift = "NOCONFCAL";
            confCalShiftNum = "+01";
        } else if (critHact.equalsIgnoreCase("O")) {
            confCalShift = "IGNOREJOB";
            daysStr.replace(0, daysStr.length(), "ALL");
            daysCal = confCal.toString();
            confCal = "";
            weekStr.replace(0, weekStr.length(), "");
        } else {
            confCalShift = "IGNOREJOB";
        }
        if (daysStr.toString().equalsIgnoreCase("ALL")) {
            this.m_JobRunsEveryDay = true;
        }
        Object confCalForDraft = confCal;
        if (!weeksCal.toString().isEmpty() && (tempCal = this.m_sourceDefs.getNamedCalendar(weeksCal.toString())) != null) {
            this.addCalendarMessages(tempCal, confCal);
            if (tempCal.getDependsOn() != null && (confCal == null || confCal.isEmpty())) {
                confCal = tempCal.getDependsOn().getName();
                confCalForDraft = "not-" + confCal;
            }
        }
        if (!daysCal.toString().isEmpty() && (tempCal = this.m_sourceDefs.getNamedCalendar(daysCal.toString())) != null) {
            this.addCalendarMessages(tempCal, confCal);
            if (tempCal.getDependsOn() != null && (confCal == null || confCal.isEmpty())) {
                confCal = tempCal.getDependsOn().getName();
                confCalForDraft = "not-" + confCal;
            }
        }
        this.putOptionalAttribute("WEEKDAYS", weekStr.toString(), true);
        this.putOptionalAttribute("DAYS", daysStr.toString(), true);
        this.putOptionalAttribute("WEEKSCAL", weeksCal.toString(), true);
        this.putOptionalAttribute("DAYSCAL", daysCal.toString(), true);
        this.putOptionalAttribute("CONFCAL", ((String)confCalForDraft).toString(), true);
        this.putOptionalAttribute("SHIFT", confCalShift.toString(), true);
        this.putOptionalAttribute("SHIFTNUM", confCalShiftNum.toString(), true);
        if (this.m_type != SchedEntity.TYPE.TABLE) {
            this.putOptionalAttribute("DAYS_AND_OR", daysAndOr.toString(), true);
        }
        if (Specific_Dates.size() > 0) {
            Object DateStr = "";
            Integer dateIndex = 0;
            while (dateIndex < Specific_Dates.size()) {
                DateStr = (String)DateStr + ((String)Specific_Dates.get(dateIndex)).substring(0, 2) + ((String)Specific_Dates.get(dateIndex)).substring(2, 4);
                Integer n4 = dateIndex;
                dateIndex = dateIndex + 1;
            }
            this.putOptionalAttribute("DATE", ((String)DateStr).toString(), true);
            if (Specific_Dates.size() > Globs.SPECIFIC_DATES_MAX_LEN) {
                Reporter.addMessage(this.m_messages, (String)"WRN0011", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), Integer.toString(Globs.SPECIFIC_DATES_MAX_LEN), Integer.toString(Specific_Dates.size()), ((String)DateStr).toString(), critKeys.toString()});
            }
            if (!(daysStr.toString().isEmpty() && weekStr.toString().isEmpty() && daysCal.toString().isEmpty() && weeksCal.toString().isEmpty() && confCal.toString().isEmpty())) {
                Reporter.addMessage(this.m_messages, (String)"WRN0013", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), "CRITKEYS", critKeys.toString()});
            }
            monthAll = false;
        }
        if (monthAll.booleanValue()) {
            monthIndex = 0;
            while (monthIndex < monthsArray.length) {
                monthStr[monthIndex.intValue()] = "1";
                n = monthIndex;
                monthIndex = monthIndex + 1;
            }
        }
        monthIndex = 0;
        while (monthIndex < monthsArray.length) {
            this.putOptionalAttribute(monthsArray[monthIndex].toString(), monthStr[monthIndex].toString(), true);
            n = monthIndex;
            monthIndex = monthIndex + 1;
        }
        if (this.m_type == SchedEntity.TYPE.JOB) {
            if (weekStr.toString().length() > 0 || daysStr.toString().length() > 0 || weeksCal.toString().length() > 0 || daysCal.toString().length() > 0 || confCal.toString().length() > 0 || Specific_Dates.size() > 0) {
                tag_relationship = "AND";
            }
            this.m_jobAttr.put("TAG_RELATIONSHIP", tag_relationship);
        }
        if (!this.m_sourceDefs.isCalendarConverted(daysCal.toString())) {
            this.issueCalendarMessage(daysCal.toString(), "DAYSCAL");
        }
        if (!this.m_sourceDefs.isCalendarConverted(weeksCal.toString())) {
            this.issueCalendarMessage(weeksCal.toString(), "WEEKSCAL");
        }
        if (!this.m_sourceDefs.isCalendarConverted(confCal.toString())) {
            this.issueCalendarMessage(confCal.toString(), "CONFCAL");
        }
    }

    private void checkCalIsEmpty(String cal, String calType, String critKeys, String calText) {
        if (cal.isEmpty()) {
            Reporter.addMessage(this.m_messages, (String)"WRN0018", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), calType, "CRITKEYS", critKeys.toString(), calText});
        }
    }

    private void resolvePriority() {
        String priority = this.getAttrWithDefault("PRIORITY", "PRIORITY", "PRIORITY", null, null, TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        if (priority.equals("1")) {
            priority = "";
        }
        if (priority.length() > 0) {
            CtmPriority p = priority.length() == 1 ? new CtmPriority(0, 9) : new CtmPriority(0, 99);
            Integer priorityNumber = 0;
            try {
                priorityNumber = Integer.parseInt(priority);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.m_jobAttr.put("PRIORITY", p.calculatePriority(priorityNumber.intValue()).toString());
        }
    }

    private void resolveCyclic() {
        String cyclic = this.getAttrWithDefault("CYCLIC", null, null, "NO", null, TngGlobals.CASE_HANDLING.TOUPPER, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        String interval = this.getAttrWithDefault("CYCFREQ", null, null, "60", null, TngGlobals.CASE_HANDLING.TOUPPER, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        String maxrerun = this.getAttrWithDefault("CYCCOUNT", null, null, "0", null, TngGlobals.CASE_HANDLING.TOUPPER, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        if (cyclic.equalsIgnoreCase("YES")) {
            this.m_jobAttr.put("CYCLIC", "1");
            this.m_jobAttr.put("CYCLIC_TYPE", "Interval");
            this.m_jobAttr.put("IND_CYCLIC", "START");
            if (!GlobalFunctions.isNumber((String)interval)) {
                Reporter.addMessage(this.m_messages, (String)"WRN0010", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), "CYCFREQ", interval.toString(), "INTERVAL", "60"});
                interval = "60";
            }
            this.m_jobAttr.put("INTERVAL", interval);
            if (!GlobalFunctions.isNumber((String)maxrerun)) {
                Reporter.addMessage(this.m_messages, (String)"WRN0010", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), "CYCCOUNT", interval.toString(), "MAXRERUN", String.format("%d", 99)});
                maxrerun = String.format("%d", 99);
            }
            if (Integer.parseInt(maxrerun) > 99) {
                Reporter.addMessage(this.m_messages, (String)"WRN0001", (String)this.getOriginalJobId(), (String[])new String[]{maxrerun, String.format("%d", 99)});
                maxrerun = String.format("%d", 99);
            }
            this.m_jobAttr.put("MAXRERUN", maxrerun);
        } else {
            this.m_jobAttr.put("CYCLIC", "0");
        }
    }

    private void resolveFailCond() {
        Properties tmpStatement = new Properties();
        Integer failCondLow = 2;
        Integer failCondHigh = 9999;
        Integer sign = 1;
        String condName = "";
        String abendAction = this.getAttrWithDefault("ABENDACTION", null, "ABENDACTION", "", null, TngGlobals.CASE_HANDLING.TOUPPER, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        if (abendAction.equalsIgnoreCase("CONTINUE")) {
            if (!DependenciesConvertor.isDirectJob()) {
                tmpStatement.setProperty("CODE", String.format("NOTOK", new Object[0]));
                tmpStatement.setProperty("STMT", "*");
                tmpStatement.setProperty("ACTION", "DOCOND");
                condName = this.m_type == SchedEntity.TYPE.JOB ? DependenciesConvertor.instance().buildDefaultCondName(this.getOriginalJobSet(), this.getOriginalJobName(), this.getOriginalJobNumber()) : DependenciesConvertor.instance().buildDefaultCondName(this.getOriginalJobSet(), null, null);
                tmpStatement.put("NAME", condName);
                tmpStatement.setProperty("ODATE", "ODAT");
                tmpStatement.put("SIGN", "ADD");
                this.getOnStmt(true).add(tmpStatement);
            } else {
                ArrayList<Properties> propList = DependenciesConvertor.instance().getOutConds(this);
                if (propList != null) {
                    for (Properties prop : propList) {
                        if (((String)prop.get("SIGN")).equals("DEL")) continue;
                        tmpStatement = new Properties();
                        tmpStatement.setProperty("CODE", String.format("NOTOK", new Object[0]));
                        tmpStatement.setProperty("STMT", "*");
                        tmpStatement.setProperty("ACTION", "DOCOND");
                        condName = prop.getProperty("NAME");
                        tmpStatement.put("NAME", condName);
                        tmpStatement.setProperty("ODATE", "ODAT");
                        tmpStatement.put("SIGN", "ADD");
                        this.getOnStmt(true).add(tmpStatement);
                    }
                }
            }
            return;
        }
        if (this.m_type == SchedEntity.TYPE.SMART_TABLE) {
            return;
        }
        String failCond = this.getAttrWithDefault("FAILCOND", null, "FAILCOND", "", null, TngGlobals.CASE_HANDLING.TOUPPER, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        if (failCond.length() > 0) {
            String[] failCondRange = failCond.split(",");
            if (failCondRange[0].startsWith("+")) {
                sign = 1;
                failCondRange[0] = failCondRange[0].substring(1);
            }
            if (failCondRange[0].startsWith("-")) {
                sign = -1;
                failCondRange[0] = failCondRange[0].substring(1);
            }
            if (GlobalFunctions.isNumber((String)failCondRange[0])) {
                failCondLow = Integer.parseInt(failCondRange[0]);
            }
            failCondLow = failCondLow * sign;
            if (failCondRange[1].startsWith("+")) {
                sign = 1;
                failCondRange[1] = failCondRange[1].substring(1);
            }
            if (failCondRange[1].startsWith("-")) {
                sign = -1;
                failCondRange[1] = failCondRange[1].substring(1);
            }
            if (GlobalFunctions.isNumber((String)failCondRange[1])) {
                failCondHigh = Integer.parseInt(failCondRange[1]);
            }
            if (failCondLow == (failCondHigh = Integer.valueOf(failCondHigh * sign))) {
                return;
            }
            if (failCondLow != 1) {
                tmpStatement.setProperty("CODE", String.format("COMPSTAT LT %d", failCondLow));
                tmpStatement.setProperty("STMT", "*");
                tmpStatement.setProperty("ACTION", "OK");
                this.getOnStmt(true).add(tmpStatement);
                tmpStatement = new Properties();
            }
            if (failCondHigh != 9999) {
                tmpStatement.setProperty("CODE", String.format("COMPSTAT GT %d", failCondHigh));
                tmpStatement.setProperty("STMT", "*");
                tmpStatement.setProperty("ACTION", "OK");
                this.getOnStmt(true).add(tmpStatement);
                tmpStatement = new Properties();
            }
            if (failCondLow <= 0 && failCondHigh >= 0) {
                tmpStatement.setProperty("CODE", String.format("COMPSTAT = 0", new Object[0]));
                tmpStatement.setProperty("STMT", "*");
                tmpStatement.setProperty("ACTION", "NOTOK");
                this.getOnStmt(true).add(tmpStatement);
                tmpStatement = new Properties();
            }
        }
    }

    private void resolveCmdLineForJob() {
        if (this.isTandemJob()) {
            return;
        }
        Object cmdCommand = "";
        String jobName = this.m_sourceAttr.getAttr("JOB_ID");
        String jobSet = this.m_sourceAttr.getAttr("JOBSET_ID");
        String jno = this.m_sourceAttr.getAttr("JNO_ID");
        String jobParmCommand = "";
        IAttrHolder jobParmAttr = JobParmTable.instance().getParams(jobSet, jobName, jno);
        if (jobParmAttr != null) {
            jobParmCommand = jobParmAttr.getAttr("SUBFILE");
        }
        if (jobParmCommand.isEmpty() || jobParmCommand.equalsIgnoreCase("NULL")) {
            Reporter.addMessage(this.m_messages, (String)"WRN0012", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), "SUBFILE"});
            this.setTaskType("Dummy");
            return;
        }
        jobParmCommand = this.removeSlashIntFromCmdLine(jobParmCommand);
        Object params = "";
        boolean breakOnFirstNULL = false;
        int maxParams = JobParmTable.instance().getMaxParam(jobSet, jobName, jno);
        if (maxParams == -1) {
            maxParams = JobParmTable.instance().getMaxParam();
            breakOnFirstNULL = true;
        }
        this.m_paramsList.clear();
        this.m_paramsList.add(jobParmCommand);
        String[] parmArray = new String[maxParams];
        for (int i = 1; i <= maxParams; ++i) {
            String space = " ";
            String paramNumber = String.format("%d", i);
            String parmString = "PARM" + paramNumber;
            String param = JobParmTable.instance().getParams(jobSet, jobName, jno).getAttr(parmString);
            if (param.equals("NULL") && breakOnFirstNULL) {
                if (!((String)params).endsWith(space)) break;
                int spacePlace = ((String)params).lastIndexOf(32);
                params = ((String)params).substring(0, spacePlace);
                break;
            }
            if (!(param = this.resolveConfiguredParams(param)).equals("NULL")) {
                this.m_paramsList.add(param);
            }
            parmArray[i - 1] = param;
            if (!param.startsWith("\"") || !param.endsWith("\"")) {
                param = GlobalFunctions.AddQuotes((String)param);
            }
            if (i == maxParams) {
                space = "";
            }
            params = (String)params + param + space;
        }
        String spaceBetweenCmdAndParameters = " ";
        if (((String)params).isEmpty()) {
            spaceBetweenCmdAndParameters = "";
        }
        if (!this.isTasktypeHandled(jobParmCommand, parmArray)) {
            this.setTaskType("Command");
            cmdCommand = jobParmCommand + spaceBetweenCmdAndParameters + (String)params;
            FieldValidation.instance().cmdLineValidateAndReportMessages((String)cmdCommand, jobName, this.m_messages);
            this.m_jobAttr.put("CMDLINE", (String)cmdCommand);
        }
    }

    private String removeSlashIntFromCmdLine(String cmd) {
        String l_cmd = cmd.toString().toUpperCase();
        if (l_cmd.startsWith("/INT")) {
            Integer index = cmd.indexOf(32) + 1;
            if (index == 0 || index > cmd.length() || index > 6) {
                l_cmd = cmd.toString();
            } else {
                l_cmd = cmd.substring(index);
                String removed = cmd.substring(0, index - 1);
                Reporter.addMessage(this.m_messages, (String)"INF0009", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), cmd, removed});
            }
            return l_cmd;
        }
        return cmd;
    }

    private boolean isTasktypeHandled(String cmd, String[] parmArray) {
        if (!this.isToJob().booleanValue()) {
            return false;
        }
        boolean isCMDShouldbeJOB = false;
        for (String taskTypeFilter : this.m_rules.getTaskTypeHandler().getTaskTypeFilters()) {
            if (taskTypeFilter == null || !cmd.contains(taskTypeFilter)) continue;
            isCMDShouldbeJOB = true;
            break;
        }
        if (isCMDShouldbeJOB) {
            String[] memLibandName = this.getMemLibAndName(cmd);
            if (memLibandName[0].equals("")) {
                Reporter.addMessage(this.m_messages, (String)"INF0008", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), "MEMLIB", cmd.toString()});
                return false;
            }
            if (memLibandName[1].equals("")) {
                Reporter.addMessage(this.m_messages, (String)"INF0008", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), "MEMNAME", cmd.toString()});
                return false;
            }
            this.setTaskType("Job");
            this.m_jobAttr.put("MEMLIB", memLibandName[0]);
            this.m_jobAttr.put("MEMNAME", memLibandName[1]);
            for (int i = 0; i < parmArray.length; ++i) {
                String value = parmArray[i];
                if (value == null || value.length() <= 0) continue;
                this.m_autoedits.put(String.format("%%%%PARM%d", i + 1), value);
            }
        }
        return isCMDShouldbeJOB;
    }

    private String[] getMemLibAndName(String cmd) {
        int lastIndexOfDirSep;
        String memLib = "";
        String memName = "";
        int dirSep = 47;
        if (!cmd.matches("^[\"']?(/|\\$).*$")) {
            dirSep = 92;
        }
        if ((lastIndexOfDirSep = cmd.lastIndexOf(dirSep)) < 0) {
            memName = cmd;
        } else {
            memLib = cmd.substring(0, lastIndexOfDirSep);
            memName = cmd.substring(lastIndexOfDirSep + 1, cmd.length());
        }
        String[] tmpArr = new String[]{memLib, memName};
        return tmpArr;
    }

    private String resolveConfiguredParams(String param) {
        if (!this.m_rules.getBooleanRule("TNG rules", new String[]{"PARAMS_AVAILABLE"}).booleanValue()) {
            return param;
        }
        String tmpParam = param;
        ArrayList parmConf = this.m_rules.getPairsListRule("TNG rules", new String[]{"PARAMS"});
        for (Map.Entry entry : parmConf) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.equals(param)) continue;
            tmpParam = param.replace(key, value);
            break;
        }
        return tmpParam;
    }

    private void resolveActiveFrom() {
        String dateFormat = this.m_rules.getStringRule("TNG rules", new String[]{"DATE_FORMAT"});
        this.setDateFormat(dateFormat);
        String activeFrom = "";
        String effectiveDate = this.getAttrWithDefault("EFFECTIVEDATE", null, null, "", null, TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        if (effectiveDate.isEmpty() || effectiveDate.equals("NULL")) {
            effectiveDate = "";
        } else {
            activeFrom = this.handleDate(effectiveDate, "EFFECTIVEDATE");
        }
        if (this.m_type == SchedEntity.TYPE.JOB) {
            this.m_jobAttr.put("ACTIVE_FROM", activeFrom);
        }
        if (this.m_type == SchedEntity.TYPE.SMART_TABLE) {
            this.m_tagAttr.put("ACTIVE_FROM", FieldValidation.instance().validateAndReturnFixedValue("ACTIVE_FROM", activeFrom.toString(), true, null, null, this.m_messages));
        }
    }

    private String dataAdjustment(String inputDate) {
        String[] dateArr = inputDate.split("\\W");
        for (int i = 0; i < dateArr.length; ++i) {
            dateArr[i] = TngJob.getNumericMonth(dateArr[i]);
        }
        List<String> retList = Arrays.asList(dateArr);
        return retList.toString().substring(1, retList.toString().length() - 1).replaceAll(", ", "-");
    }

    public static String getNumericMonth(String month) {
        String retVal = null;
        if (month.length() == 3) {
            String startWith;
            switch (startWith = month.substring(0, 3).toUpperCase()) {
                case "JAN": {
                    retVal = String.valueOf(1);
                    break;
                }
                case "FEB": {
                    retVal = String.valueOf(2);
                    break;
                }
                case "MAR": {
                    retVal = String.valueOf(3);
                    break;
                }
                case "APR": {
                    retVal = String.valueOf(4);
                    break;
                }
                case "MAY": {
                    retVal = String.valueOf(5);
                    break;
                }
                case "JUN": {
                    retVal = String.valueOf(6);
                    break;
                }
                case "JUL": {
                    retVal = String.valueOf(7);
                    break;
                }
                case "AUG": {
                    retVal = String.valueOf(8);
                    break;
                }
                case "SEP": {
                    retVal = String.valueOf(9);
                    break;
                }
                case "OCT": {
                    retVal = String.valueOf(10);
                    break;
                }
                case "NOV": {
                    retVal = String.valueOf(11);
                    break;
                }
                case "DEC": {
                    retVal = String.valueOf(12);
                }
            }
        }
        return retVal == null ? month : (retVal.length() == 1 ? "0" + retVal : retVal);
    }

    private String handleDate(String inputDate, String wlmDateFiled) {
        String retVal = "";
        String formatData = "";
        if (m_dateFormat == TngGlobals.DATE_FORMAT.EUROPEAN) {
            formatData = "d-M-yyyy";
        }
        if (m_dateFormat == TngGlobals.DATE_FORMAT.AMERICAN) {
            formatData = "M-d-yyyy";
        }
        inputDate = inputDate.replaceAll("\\W", "-");
        retVal = DateUtils.transformDateFormat((String)(inputDate = this.dataAdjustment(inputDate)), (String)formatData, (String)DateUtils.DEFAULT_CONTROL_M_FORMAT);
        if (retVal == "") {
            Reporter.addMessage(this.m_messages, (String)"WRN0006", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), wlmDateFiled, inputDate.toString(), "date"});
        }
        return retVal;
    }

    private void resolveActiveTill() {
        String defaultAutoSel;
        String autoSel;
        String dateFormat = this.m_rules.getStringRule("TNG rules", new String[]{"DATE_FORMAT"});
        this.setDateFormat(dateFormat);
        String activeTill = "";
        String expireDate = this.getAttrWithDefault("EXPIRESDATE", null, null, "", null, TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        activeTill = expireDate.isEmpty() || expireDate.equals("NULL") ? "" : this.handleDate(expireDate, "EXPIRESDATE");
        if (this.m_type == SchedEntity.TYPE.JOB && (autoSel = this.getAttrWithDefault("AUTOSEL", null, null, defaultAutoSel = "YES", null, TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER)).equalsIgnoreCase("NO")) {
            Integer currYear = Calendar.getInstance().get(1);
            activeTill = String.format("%4d1231", currYear - 1);
        }
        if (this.m_type == SchedEntity.TYPE.JOB) {
            this.m_jobAttr.put("ACTIVE_TILL", activeTill);
        }
        if (this.m_type == SchedEntity.TYPE.SMART_TABLE) {
            this.m_tagAttr.put("ACTIVE_TILL", FieldValidation.instance().validateAndReturnFixedValue("ACTIVE_TILL", activeTill.toString(), true, null, null, this.m_messages));
        }
    }

    private void resolveTimeFrom() {
        Object timeFrom = this.getAttrWithDefault("EARLYTIME", null, "EARLYTIME", "", null, TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        if (((String)timeFrom).isEmpty() || ((String)timeFrom).equals("NULL")) {
            timeFrom = "";
        } else {
            String[] sepTime = ((String)timeFrom).split(":");
            if (sepTime.length > 2) {
                timeFrom = sepTime[0].trim() + sepTime[1].trim();
            } else if (sepTime.length == 2) {
                timeFrom = "00" + sepTime[0].trim();
            } else {
                Reporter.addMessage(this.m_messages, (String)"WRN0006", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), "EARLYTIME", ((String)timeFrom).toString(), "time"});
                timeFrom = "";
            }
        }
        if (((String)timeFrom).length() > 0 && !((String)timeFrom).equals("0000")) {
            this.m_jobAttr.put("TIMEFROM", (String)timeFrom);
        }
    }

    private void resolveTimeTo() {
        Object timeTo = this.getAttrWithDefault("MUSTCOMPTIME", null, "MUSTCOMPTIME", "", null, TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        if (((String)timeTo).isEmpty() || ((String)timeTo).equals("NULL")) {
            timeTo = "";
        } else {
            String[] sepTime = ((String)timeTo).split(":");
            if (sepTime.length > 2) {
                timeTo = sepTime[0].trim() + sepTime[1].trim();
            } else if (sepTime.length == 2) {
                timeTo = "00" + sepTime[0].trim();
            } else {
                Reporter.addMessage(this.m_messages, (String)"WRN0006", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), "MUSTCOMPTIME", ((String)timeTo).toString(), "time"});
                timeTo = "";
            }
        }
        if (((String)timeTo).length() > 0 && !((String)timeTo).equals("0000")) {
            this.m_jobAttr.put("TIMETO", (String)timeTo);
            Properties tmpProps = new Properties();
            tmpProps.setProperty("DEST", "EM");
            tmpProps.setProperty("WHEN", "LATETIME");
            tmpProps.setProperty("TIME", (String)timeTo);
            tmpProps.setProperty("URGENCY", "R");
            tmpProps.setProperty("MESSAGE", "Job name %%JOBNAME did not complete on time");
            this.m_shouts.add(tmpProps);
        }
    }

    private void resolveShoutLateSub() {
        Object mustStartTime = this.getAttrWithDefault("MUSTSTARTTIME", null, null, "", null, TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        if (((String)mustStartTime).isEmpty() || ((String)mustStartTime).equalsIgnoreCase("NULL")) {
            mustStartTime = "";
        } else {
            String[] sepTime = ((String)mustStartTime).split(":");
            if (sepTime.length > 2) {
                mustStartTime = sepTime[0].trim() + sepTime[1].trim();
            } else if (sepTime.length == 2) {
                mustStartTime = "00" + sepTime[0].trim();
            } else {
                Reporter.addMessage(this.m_messages, (String)"WRN0006", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), "MUSTSTARTTIME", ((String)mustStartTime).toString(), "time"});
                mustStartTime = "";
            }
        }
        if (((String)mustStartTime).length() > 0 && !((String)mustStartTime).equals("0000")) {
            Properties tmpProps = new Properties();
            tmpProps.setProperty("DEST", "EM");
            tmpProps.setProperty("WHEN", "LATESUB");
            tmpProps.setProperty("TIME", (String)mustStartTime);
            tmpProps.setProperty("URGENCY", "R");
            tmpProps.setProperty("MESSAGE", "Job name %%JOBNAME did not start yet");
            this.m_shouts.add(tmpProps);
        }
    }

    private void resolveShoutExecTime() {
        Integer execTime = 0;
        boolean valueValid = true;
        String maxTime = this.getAttrWithDefault("MAXTIME", null, null, "", null, TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        if (maxTime.isEmpty() || maxTime.equalsIgnoreCase("NULL")) {
            maxTime = "";
        } else {
            String[] sepTime = maxTime.split(":");
            if (sepTime.length > 2) {
                if (GlobalFunctions.isNumber((String)sepTime[0].trim())) {
                    execTime = Integer.parseInt(sepTime[0].trim()) * 60;
                } else {
                    valueValid = false;
                }
                if (GlobalFunctions.isNumber((String)sepTime[1].trim())) {
                    execTime = execTime + Integer.parseInt(sepTime[1].trim());
                } else {
                    valueValid = false;
                }
            } else if (sepTime.length == 2) {
                if (GlobalFunctions.isNumber((String)sepTime[0].trim())) {
                    execTime = Integer.parseInt(sepTime[0].trim());
                } else {
                    valueValid = false;
                }
            } else {
                valueValid = false;
            }
            if (!valueValid) {
                Reporter.addMessage(this.m_messages, (String)"WRN0006", (String)this.getOriginalJobId(), (String[])new String[]{Params.instance().getVendorName(), "MAXTIME", maxTime.toString(), "time"});
                execTime = 0;
            }
        }
        if (execTime > 0) {
            if (execTime > Globs.MAXEXECTIME_int) {
                String maxTimeValue = String.format("%s (%s minutes)", maxTime.toString(), execTime);
                Reporter.addMessage(this.m_messages, (String)"WRN1009", (String)this.getOriginalJobId(), (String[])new String[]{this.getJobName(), this.getJobName(), maxTimeValue});
                execTime = Globs.MAXEXECTIME_int;
            }
            Properties tmpProps = new Properties();
            tmpProps.setProperty("DEST", "EM");
            tmpProps.setProperty("WHEN", "EXECTIME");
            tmpProps.setProperty("TIME", ">" + execTime.toString());
            tmpProps.setProperty("URGENCY", "R");
            tmpProps.setProperty("MESSAGE", "Job name %%JOBNAME run time exceeded maximum");
            this.m_shouts.add(tmpProps);
        }
    }

    private void resolveUserDaily() {
        String defaultAutoSel = "NO";
        String autoSel = this.getAttrWithDefault("AUTOSEL", null, null, defaultAutoSel, null, TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        if (autoSel.equalsIgnoreCase("YES")) {
            this.m_jobAttr.put("TABLE_USERDAILY", "SYSTEM");
        } else {
            this.m_jobAttr.put("TABLE_USERDAILY", "");
        }
    }

    private void resolveDescription() {
        String description = this.getAttrWithDefault("DESCRIPTION", null, null, null, "INF0005", TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        this.m_jobAttr.put("DESCRIPTION", FieldValidation.instance().validateAndReturnFixedValue("DESCRIPTION", description));
    }

    private void resolveConfirm() {
        String hold = this.getAttrWithDefault("HOLD", null, null, "NO", null, TngGlobals.CASE_HANDLING.TOUPPER, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        if (hold.equalsIgnoreCase("YES")) {
            this.m_jobAttr.put("CONFIRM", FieldValidation.instance().validateAndReturnFixedValue("CONFIRM", "1"));
        }
    }

    private void resolveMaxwait() {
        String maxwait = DEFAULT_MAX_WAIT;
        String backlog = this.getAttrWithDefault("BACKLOG", null, "BACKLOG", "YES", null, TngGlobals.CASE_HANDLING.TOUPPER, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        if (backlog.equalsIgnoreCase("DEF") && (backlog = this.m_parent.m_sourceAttr.getAttr("BACKLOG")) == null) {
            backlog = "YES";
        }
        if (backlog.equalsIgnoreCase("YES") || backlog.equalsIgnoreCase("RUN")) {
            this.getMaxWaitFromConfiguration();
            maxwait = m_maxWait;
        } else {
            maxwait = "0";
        }
        this.putOptionalAttribute("MAXWAIT", maxwait.toString(), true);
    }

    private void getMaxWaitFromConfiguration() {
        if (m_maxWait == null && ((m_maxWait = this.m_rules.getStringRule("TNG rules", new String[]{"MAXWAIT"})) == null || m_maxWait.equalsIgnoreCase(""))) {
            m_maxWait = DEFAULT_MAX_WAIT;
        }
    }

    private void resolveApplicationForJob() {
        if (this.m_parent != null) {
            String application = this.m_parent.getApplication();
            this.m_jobAttr.put("APPLICATION", application);
        }
    }

    private void resolveApplicationForTable() {
        String application = this.getAttrWithDefault("JOBSET_ID", null, null, "DEFAULT_APPLICATION", "INF0005", TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.LEAVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        this.m_jobAttr.put("APPLICATION", FieldValidation.instance().validateAndReturnFixedValue("APPLICATION", application));
    }

    private void resolveGroupForJob() {
        if (this.m_parent != null) {
            String groupName = this.m_parent.getGroup();
            this.m_jobAttr.put("GROUP", groupName);
        }
    }

    private void resolveGroupForTable() {
        String groupName = this.getAttrWithDefault("JOBSET_ID", null, null, "DEFAULT_GROUP", "INF0005", TngGlobals.CASE_HANDLING.LEAVE_CASE, QUOTES_HANDLING.LEAVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        this.m_jobAttr.put("GROUP", FieldValidation.instance().validateAndReturnFixedValue("GROUP", groupName));
    }

    private void resolveAuthor() {
        String author = this.applyFieldConversion("AUTHOR");
        this.m_jobAttr.put("AUTHOR", author);
    }

    private void resolveOwnerForJob() {
        String jobOwner = this.applyFieldConversion("OWNER");
        if (jobOwner.startsWith("\"") && jobOwner.endsWith("\"")) {
            jobOwner = jobOwner.substring(1, jobOwner.length() - 1);
        }
        this.m_jobAttr.put("OWNER", FieldValidation.instance().validateAndReturnFixedValue("OWNER", jobOwner, true, null, null, this.m_messages));
    }

    private void determineTaskType() {
        if (this.m_type == SchedEntity.TYPE.JOB) {
            this.getToJobParam();
            if (this.isToJob().booleanValue()) {
                this.setTaskType("Job");
            } else {
                this.setTaskType("Command");
            }
        }
    }

    private void getToJobParam() {
        if (toJob == null) {
            toJob = this.m_rules.getTaskTypeHandler().isToJobType() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
    }

    private void setDummy() {
        String sTaskType = this.m_jobAttr.get("TASKTYPE");
        if (null != sTaskType && sTaskType.equals("Dummy")) {
            return;
        }
        if (toDummy == null) {
            toDummy = this.m_rules.getTaskTypeHandler().isToDummy() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if (toDummy.booleanValue()) {
            if (!Params.instance().getGUIVersion().equals("7")) {
                this.m_autoedits.put("%%$BMCWAIORIGTYPE", this.m_jobAttr.get("TASKTYPE"));
            }
            this.setTaskType("Dummy");
        }
    }

    private Boolean isToJob() {
        this.getToJobParam();
        return toJob;
    }

    private void setTaskType(String tasktype) {
        this.m_jobAttr.put("TASKTYPE", tasktype);
    }

    public String applyFieldConversion(String field) {
        return this.applyFieldConversionForSchedEndity(field, this.jobFieldGetter());
    }

    private String applyFieldConversionForSchedEndity(String field, FieldEditor.SourceFieldGetter fieldGetter) {
        if (field.equalsIgnoreCase("OWNER")) {
            String convertedString = this.m_rules.getFieldEditor().replaceFormats(field, fieldGetter);
            convertedString = this.m_rules.getFieldEditor().replaceStrings(convertedString, field);
            if (convertedString.isEmpty() && field.equalsIgnoreCase("OWNER")) {
                Reporter.addMessage(this.m_messages, (String)"INF0002", (String)this.getOriginalJobId(), (String[])new String[]{convertedString});
                convertedString = this.m_rules.getFieldEditor().getDefaultValue(field);
            }
            return convertedString;
        }
        return this.m_rules.getFieldEditor().generateCTMField(field, new FieldEditor.SourceFieldGetter(this){

            public String getField(String fieldName) {
                return "";
            }
        });
    }

    private FieldEditor.SourceFieldGetter jobFieldGetter() {
        return fieldName -> {
            String valToCheck = "";
            String jobName = this.m_sourceAttr.getAttr("JOB_ID");
            String jobSet = this.m_sourceAttr.getAttr("JOBSET_ID");
            String jno = this.m_sourceAttr.getAttr("JNO_ID");
            IAttrHolder jobParm = JobParmTable.instance().getParams(jobSet, jobName, jno);
            if (jobParm != null && jobParm.getAttr("SUBUSER") != null && !jobParm.getAttr("SUBUSER").equals("NULL")) {
                valToCheck = jobParm.getAttr("SUBUSER");
                if (this.m_parent != null && valToCheck.equalsIgnoreCase("Def")) {
                    valToCheck = this.m_parent.m_sourceAttr.getAttr("SUBUSER");
                }
            }
            if (valToCheck.equalsIgnoreCase("Def")) {
                valToCheck = "";
            }
            return valToCheck;
        };
    }

    private FieldEditor.SourceFieldGetter smartFolderFieldGetter() {
        return fieldName -> {
            String valToCheck = "";
            String jobSet = this.m_sourceAttr.getAttr("JOBSET_ID");
            IAttrHolder jobsetAttr = JobSetTable.instance().getJobsetAttributesById(jobSet);
            if (jobsetAttr != null && jobsetAttr.getAttr("SUBUSER") != null && !jobsetAttr.getAttr("SUBUSER").equals("NULL")) {
                valToCheck = jobsetAttr.getAttr("SUBUSER");
            }
            if (valToCheck.equalsIgnoreCase("Def")) {
                valToCheck = "";
            }
            return valToCheck;
        };
    }

    private void setDateFormat(String dateFormat) {
        if (m_dateFormat != null) {
            return;
        }
        m_dateFormat = this.m_rules.getStringRule("TNG rules", new String[]{"DATE_FORMAT"}).equals("American") ? TngGlobals.DATE_FORMAT.AMERICAN : TngGlobals.DATE_FORMAT.EUROPEAN;
    }

    public String getApplication() {
        return this.m_jobAttr.get("APPLICATION");
    }

    public List<AssistingJob> getAssistingJobs() {
        return this.m_sourceDefs.getAssistingJobs(TngJob.buildJobIdKey(this.getTableName(), this.getJobName(), this.getOriginalJobNumber()));
    }

    public String getAttr(String attrName) {
        return this.m_jobAttr.get(attrName);
    }

    public LinkedHashMap<String, String> getAutoedits() {
        return this.m_autoedits;
    }

    public List<SchedEntity> getChildren() {
        if (this.m_type == SchedEntity.TYPE.JOB) {
            return null;
        }
        AttrHolderList jobsList = JobTable.instance().getJobs().get(this.m_sourceAttr.getAttr("JOBSET_ID"));
        if (jobsList == null) {
            return null;
        }
        ArrayList<SchedEntity> list = new ArrayList<SchedEntity>();
        for (IAttrHolder currJob : jobsList) {
            if (!this.isFilterNeeded(currJob)) continue;
            list.add(new TngJob(this, currJob, this.m_sourceDefs));
        }
        return list;
    }

    private boolean isFilterNeeded(IAttrHolder currJob) {
        return this.m_sourceDefs.isFiltered(currJob, true);
    }

    public List<Properties> getCtrlResources() {
        return this.getResources(TngGlobals.RESOURCE_MODE.CTRL);
    }

    private List<Properties> getResources(TngGlobals.RESOURCE_MODE resMode) {
        if (this.m_type != SchedEntity.TYPE.JOB || m_resourceMode != TngGlobals.RESOURCE_MODE.AUTO && m_resourceMode != resMode) {
            return null;
        }
        ArrayList<Properties> retList = new ArrayList<Properties>();
        AttrHolderList list = JobResTable.instance().getJobResTableAttributesByKey(this.getOriginalJobSet(), this.getOriginalJobName(), this.getOriginalJobNumber());
        if (list == null) {
            return null;
        }
        for (IAttrHolder rec : list) {
            String name = rec.getAttr("RES_ID");
            String quantity = rec.getAttr("AMOUNT");
            String ctrlType = this.getCtrlType(rec.getAttr("USAGE"));
            if (!GlobalFunctions.isNumber((String)quantity)) {
                quantity = "0";
            }
            int quan = Integer.parseInt(quantity);
            Properties props = new Properties();
            if (resMode == TngGlobals.RESOURCE_MODE.QUANTITATIVE) {
                if (quan == 0 && m_resourceMode == TngGlobals.RESOURCE_MODE.AUTO) {
                    return null;
                }
                String newVal = FieldValidation.instance().validateAndReturnFixedValue("QUANTITATIVE_RESOURCE_NAME", name, true, null, null, this.m_messages);
                props.setProperty("NAME", newVal);
                props.setProperty("QUANT", quantity);
                this.addQRAction(props);
            } else {
                if (quan != 0 && m_resourceMode == TngGlobals.RESOURCE_MODE.AUTO) {
                    return null;
                }
                String newValue = FieldValidation.instance().validateAndReturnFixedValue("CONTROL_RESOURCE_NAME", name, true, null, null, this.m_messages);
                props.put("NAME", newValue);
                props.put("TYPE", ctrlType);
            }
            retList.add(props);
        }
        return retList;
    }

    private String getCtrlType(String attr) {
        String type = "S";
        if (attr.equals(TngGlobals.PRIVATE)) {
            type = "E";
        }
        return type;
    }

    public String getGroup() {
        return this.m_jobAttr.get("GROUP");
    }

    public List<Properties> getInConds() {
        return DependenciesConvertor.instance().getInconds(this);
    }

    public String getJobName() {
        return this.m_jobAttr.get("JOBNAME");
    }

    public ArrayList<String> getMessages() {
        return this.m_messages;
    }

    public List<Properties> getOnStmt() {
        return this.m_sourceDefs.getJobOnstmts(this);
    }

    public List<Properties> getOnStmt(boolean create) {
        return this.m_sourceDefs.getJobOnstmts(this, create);
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return null;
    }

    public List<String> getOptionalAttributes() {
        return this.m_optionalAttributesUsed;
    }

    public String getOriginalJobName() {
        return this.m_origEntityName;
    }

    public String getOriginalJobNumber() {
        return this.m_origEntityNumber;
    }

    public String getOriginalJobSet() {
        return this.m_origTableName;
    }

    public boolean getJobRunsEveryDay() {
        return this.m_JobRunsEveryDay;
    }

    public List<Properties> getOutConds() {
        return DependenciesConvertor.instance().getOutConds(this);
    }

    public String getParentName() {
        return this.m_jobAttr.get("TABLE_NAME");
    }

    public SchedEntity getParent() {
        return this.m_parent;
    }

    public List<Properties> getQuantResources() {
        return this.getResources(TngGlobals.RESOURCE_MODE.QUANTITATIVE);
    }

    private void addQRAction(Properties qr) {
        String name = qr.getProperty("NAME");
        String quantity = qr.get("QUANT").toString();
        if (GlobalFunctions.isNumber((String)((String)qr.get("QUANT")))) {
            Integer qty = Integer.parseInt((String)qr.get("QUANT"));
            quantity = qty.toString();
        }
        HashMap<String, String> quantAction = new HashMap<String, String>();
        quantAction.put("ACTENTTYPE", "QR");
        quantAction.put("JOBID", this.getOriginalJobId());
        quantAction.put("ACTENTNAME", name);
        quantAction.put("ACTENTQTY", quantity);
        quantAction.put("ACTSTATUS", "0");
        Reporter.addAction(quantAction);
    }

    public List<Properties> getShouts() {
        return this.m_shouts;
    }

    public String getTableName() {
        return this.m_jobAttr.get("TABLE_NAME");
    }

    public String getTablePathForSons() {
        Object tablePathForSons;
        if (this.m_parent == null) {
            tablePathForSons = this.getJobName();
        } else {
            String fixedTableName = FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", this.getJobName(), true, null, null, this.m_messages);
            tablePathForSons = this.m_parent.getTablePathForSons() + "/" + fixedTableName;
        }
        return tablePathForSons;
    }

    public List<Properties> getTags() {
        if (this.m_tags != null) {
            return this.m_tags;
        }
        this.m_tags = new ArrayList<Properties>();
        Set<Object> set = new HashSet();
        set = this.m_type == SchedEntity.TYPE.JOB ? this.m_sourceDefs.getTags(this.m_origTableName) : (this.m_type == SchedEntity.TYPE.SMART_TABLE ? this.m_sourceDefs.getTags(this.m_origEntityName) : null);
        if (set == null) {
            return null;
        }
        for (Properties tag : set) {
            String tagName = (String)tag.get("NAME");
            String newTagName = FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", tagName);
            if (newTagName.compareTo(tagName) != 0) {
                tag.remove("NAME");
                tag.put("NAME", newTagName);
            }
            this.m_tags.add(tag);
            if (this.m_tagAttr == null || this.m_tagAttr.size() <= 0) continue;
            tag.putAll((Map<?, ?>)this.m_tagAttr);
            newTagName = this.getCalendarName(this.m_tagAttr.get("DAYSCAL"));
            if (newTagName != null) {
                tag.put("NAME", newTagName);
                continue;
            }
            newTagName = this.getCalendarName(this.m_tagAttr.get("WEEKSCAL"));
            if (newTagName != null) {
                tag.put("NAME", newTagName);
                continue;
            }
            newTagName = this.getCalendarName(this.m_tagAttr.get("CONFCAL"));
            if (newTagName == null) continue;
            tag.put("NAME", newTagName);
        }
        return this.m_tags;
    }

    private String getCalendarName(String calendar) {
        String calName = null;
        if (calendar != null && !calendar.isEmpty()) {
            calName = FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", calendar);
        }
        return calName;
    }

    public boolean hasMessages() {
        return !this.m_messages.isEmpty();
    }

    public boolean hasWarnings() {
        if (this.m_messages.isEmpty()) {
            return false;
        }
        HashMap messageIds = MessageIdTable.instance().getMessageIds();
        for (String id : messageIds.keySet()) {
            if (!((MessageId)messageIds.get(id)).getMessageType(id).equals("W")) continue;
            for (String currMessage : this.m_messages) {
                if (!currMessage.startsWith(id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCyclic() {
        boolean isCyclic = false;
        String cyclic = this.m_jobAttr.get("CYCLIC");
        if (cyclic != null) {
            isCyclic = cyclic.equalsIgnoreCase("1");
        }
        if (isCyclic) {
            this.m_jobAttr.put("IND_CYCLIC", "TARGET");
        }
        return isCyclic;
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    public String originalProductID() {
        return null;
    }

    public SchedEntity.TYPE type() {
        return this.m_type;
    }

    public static void addReporterMessage(String msgId, String jobSet, String jobId, String jobNo, String ... stringsArr) {
        if (m_ext_messages == null) {
            m_ext_messages = new ArrayList();
        }
        Reporter.addMessage(m_ext_messages, (String)msgId, (String)TngJob.buildJobIdKey(jobSet, jobId, jobNo), (String[])stringsArr);
    }

    private void addCalendarMessages(TngCalendars.NamedCalendar calendar, String confCal) {
        boolean confCalInUse;
        boolean bl = confCalInUse = confCal != null && !confCal.isEmpty();
        if (confCalInUse && calendar.getDependsOn() != null && !calendar.getDependsOn().getName().isEmpty() && !calendar.getDependsOn().getName().equals(confCal)) {
            Reporter.addMessage(this.m_messages, (String)"WRN0014", (String)this.getOriginalJobId(), (String[])new String[]{"CA_WLM", "CONFCAL", confCal, calendar.getDependsOn().getName(), String.format("Holidays calendar or CRITICAL were already converted to Control-M CONFCAL. %s's depencdency on %s could not be implemented as CONFCAL", calendar.getName(), calendar.getDependsOn().getName())});
        }
        for (String currId : calendar.getMessages().keySet()) {
            for (String[] msgElements : calendar.getMessages().get(currId)) {
                Reporter.addMessage(this.m_messages, (String)currId, (String)this.getOriginalJobId(), (String[])msgElements);
            }
        }
        if (calendar.getDependsOn() != null) {
            this.addCalendarMessages(calendar.getDependsOn(), null);
        }
    }

    public static void destroy() {
        m_ext_messages = null;
        m_dateFormat = null;
        m_resourceMode = null;
        m_weekDaysArray = null;
        m_maxWait = null;
        toJob = null;
        toDummy = null;
    }

    public boolean isDSJob() {
        return true;
    }

    public void addAttribute(String attr, String value) {
        this.m_jobAttr.put(attr, value);
    }

    public void addAutoEdits(String name, String value) {
        this.m_autoedits.put(name, value);
    }

    public void addMessage(String msgid, String ... stringsArr) {
        Reporter.addMessage(this.m_messages, (String)msgid, (String)this.getOriginalJobId(), (String[])stringsArr);
    }

    private static enum QUOTES_HANDLING {
        REMOVE_DELIMITER,
        LEAVE_DELIMITER;

    }

    private static enum PARENTHESES_HANDLING {
        REMOVE_DELIMITER,
        LEAVE_DELIMITER;

    }
}

