/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tng.DependenciesConvertor;
import com.bmc.ctmconvert.tng.JobParmTable;
import com.bmc.ctmconvert.tng.JobPredTable;
import com.bmc.ctmconvert.tng.JobResTable;
import com.bmc.ctmconvert.tng.JobSetPredTable;
import com.bmc.ctmconvert.tng.JobSetResTable;
import com.bmc.ctmconvert.tng.JobSetTable;
import com.bmc.ctmconvert.tng.JobTable;
import com.bmc.ctmconvert.tng.ResourceTable;
import com.bmc.ctmconvert.tng.StationGroupTable;
import com.bmc.ctmconvert.tng.StationTable;
import com.bmc.ctmconvert.tng.TngCalendars;
import com.bmc.ctmconvert.tng.TngGlobals;
import com.bmc.ctmconvert.tng.TngJob;
import com.bmc.ctmconvert.tng.TngSuccessorJob;
import com.bmc.ctmconvert.tng.TngTrigger;
import com.bmc.ctmconvert.tng.TriggerTable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class TngDefs
implements SourceDefinitions {
    private static TngDefs m_instance = null;
    private final HashMap<String, Set<Properties>> m_entityTags = new HashMap();
    private final HashMap<String, List<Properties>> m_onStatements = new HashMap();
    private final HashMap<String, FileWriter> m_fwFilesList = new HashMap();
    private final HashMap<String, ArrayList<AssistingJob>> m_assistingJobs = null;
    private final HashMap<String, String> m_triggersList = new HashMap();
    private RulesDataSet m_rules = RuleManager.instance().getCurrentRules();
    private JobSetTable m_jobSetTable = null;
    private JobTable m_jobTable = null;
    private AttrHolderList m_topLevelParents = null;
    private TngCalendars m_calendars = null;
    private JobPredTable m_jobPredTable = null;
    private JobSetPredTable m_jobSetPredTable = null;
    private Boolean m_isIncludeType = null;
    private Boolean m_isOrCond = null;

    public static TngDefs instance() {
        if (m_instance == null) {
            m_instance = new TngDefs();
        }
        return m_instance;
    }

    public void applyFilter(String root) {
        AttrHolderList filteredList = new AttrHolderList();
        if (this.m_topLevelParents == null) {
            return;
        }
        for (int i = 0; i < this.m_topLevelParents.size(); ++i) {
            IAttrHolder parent = (IAttrHolder)this.m_topLevelParents.get(i);
            if (!this.isFiltered(parent, false)) continue;
            filteredList.add((Object)parent);
        }
        this.m_topLevelParents = null;
        this.m_topLevelParents = filteredList;
    }

    public boolean isFiltered(IAttrHolder record, boolean isJob) {
        boolean rc = true;
        boolean funcRC = false;
        boolean isInclude = this.getIncludeType();
        boolean isOrCondition = this.getOrCondition();
        ArrayList filterConds = this.m_rules.getFilterHandler().getConditions();
        if (filterConds.isEmpty() || filterConds == null) {
            return true;
        }
        for (Map.Entry entry : filterConds) {
            String field = (String)entry.getKey();
            String regVal = (String)entry.getValue();
            field = this.getTNGFieldID(field);
            IAttrHolder checkRecord = record;
            if (field.equalsIgnoreCase("SUBUSER")) {
                if (isJob) {
                    String jobSet = checkRecord.getAttr("JOBSET_ID");
                    String jobName = checkRecord.getAttr("JOB_ID");
                    String jno = checkRecord.getAttr("JNO_ID");
                    checkRecord = JobParmTable.instance().getParams(jobSet, jobName, jno);
                } else {
                    if (isInclude) continue;
                    rc = false;
                    continue;
                }
            }
            if (!isInclude) {
                rc = false;
            }
            if (!checkRecord.isFieldExist(field)) continue;
            String recordVal = checkRecord.getAttr(field);
            if (!isJob && !field.equalsIgnoreCase("JOBSET_ID")) continue;
            funcRC = this.matchWildcard(recordVal, regVal);
            if (funcRC) {
                if (isOrCondition) {
                    rc = true;
                    break;
                }
                rc = true;
                continue;
            }
            if (isOrCondition) {
                rc = false;
                continue;
            }
            rc = false;
            break;
        }
        if (isInclude) {
            return rc;
        }
        return !rc;
    }

    private String getTNGFieldID(String field) {
        if (field.equalsIgnoreCase("JOBSET")) {
            return "JOBSET_ID";
        }
        if (field.equalsIgnoreCase("JOB")) {
            return "JOB_ID";
        }
        if (field.equalsIgnoreCase("STATION")) {
            return "STATION";
        }
        if (field.equalsIgnoreCase("SUBUSER")) {
            return "SUBUSER";
        }
        return "";
    }

    private boolean matchWildcard(String value, String expr) {
        String regExp = expr.replaceAll("\\*", ".*");
        regExp = regExp.replaceAll("\\?", ".");
        return value.matches(regExp);
    }

    private boolean getOrCondition() {
        if (this.m_isOrCond == null) {
            this.m_isOrCond = this.m_rules.getFilterHandler().isOr();
        }
        return this.m_isOrCond;
    }

    private boolean getIncludeType() {
        if (this.m_isIncludeType == null) {
            this.m_isIncludeType = this.m_rules.getFilterHandler().isInclude();
        }
        return this.m_isIncludeType;
    }

    public void createDependencies(String root) {
    }

    public Set<Properties> createTags(String root) {
        return null;
    }

    public void finalize_() {
        JobSetTable.destroy();
        JobTable.destroy();
        JobPredTable.destroy();
        JobParmTable.destroy();
        JobResTable.destroy();
        JobSetResTable.destroy();
        JobSetPredTable.destroy();
        ResourceTable.destroy();
        StationGroupTable.destroy();
        StationTable.destroy();
        TriggerTable.destroy();
        TngJob.destroy();
        DependenciesConvertor.destroy();
    }

    public AttrHolderList getChildren(String parentEntityId) {
        return null;
    }

    public String getEntNameFieldName() {
        return "JOBSET_ID";
    }

    public String getIdFieldName() {
        return "JOBSET_ID";
    }

    public TngCalendars.NamedCalendar getNamedCalendar(String name) {
        if (this.m_calendars == null) {
            return null;
        }
        TngCalendars tngCalendars = this.m_calendars;
        Objects.requireNonNull(tngCalendars);
        return new TngCalendars.NamedCalendar(tngCalendars, name, this.m_calendars);
    }

    public List<Properties> getJobControlRes(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        return null;
    }

    private boolean hassJobId(IAttrHolder attrs) {
        return attrs.isFieldExist("JOB_ID");
    }

    private Integer getPredHeaderSize(boolean isJob) {
        if (isJob) {
            return this.m_jobPredTable.getJobPredHeaderSize();
        }
        return this.m_jobSetPredTable.getJobSetPredHeaderSize();
    }

    private Integer getPredAttrIndex(boolean isJob, String attr) {
        if (isJob) {
            return this.m_jobPredTable.getJobPredAttrIndex(attr);
        }
        return this.m_jobSetPredTable.getJobSetPredAttrIndex(attr);
    }

    private void setPredValue(boolean isJob, String[] predAttributes, String attr, String value) {
        if (this.getPredAttrIndex(isJob, attr) != null) {
            predAttributes[this.getPredAttrIndex((boolean)isJob, (String)attr).intValue()] = value;
        }
    }

    private void appendPredAttributes(boolean isJob, String[] predAttributes) {
        if (isJob) {
            this.m_jobPredTable.addJobs(predAttributes);
        } else {
            this.m_jobSetPredTable.addJobs(predAttributes);
        }
    }

    public List<Properties> getJobOnstmts(SchedEntity job) {
        String key = "";
        if (job.type() == SchedEntity.TYPE.SMART_TABLE) {
            key = TngJob.buildJobIdKey(job.getJobName(), null, null);
        } else if (job.type() == SchedEntity.TYPE.JOB) {
            key = TngJob.buildJobIdKey(job.getTableName(), job.getJobName(), ((TngJob)job).getOriginalJobNumber());
        }
        return this.m_onStatements.get(key);
    }

    public void addJobOnstmt(SchedEntity job, Properties onDo) {
        String key = "";
        if (job.type() == SchedEntity.TYPE.SMART_TABLE) {
            key = TngJob.buildJobIdKey(job.getJobName(), null, null);
        } else if (job.type() == SchedEntity.TYPE.JOB) {
            key = TngJob.buildJobIdKey(job.getTableName(), job.getJobName(), ((TngJob)job).getOriginalJobNumber());
        }
        List<Properties> fullList = this.m_onStatements.get(key);
        if (fullList == null) {
            fullList = new ArrayList<Properties>();
        }
        fullList.add(onDo);
        this.m_onStatements.put(key, fullList);
    }

    public List<Properties> getJobOnstmts(SchedEntity job, boolean create) {
        String key = "";
        if (job.type() == SchedEntity.TYPE.SMART_TABLE) {
            key = TngJob.buildJobIdKey(job.getJobName(), null, null);
        } else if (job.type() == SchedEntity.TYPE.JOB) {
            key = TngJob.buildJobIdKey(job.getTableName(), job.getJobName(), ((TngJob)job).getOriginalJobNumber());
        }
        List<Properties> toRet = this.m_onStatements.get(key);
        if (toRet == null && create) {
            toRet = new ArrayList<Properties>();
            this.m_onStatements.put(key, toRet);
        }
        return toRet;
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        return null;
    }

    public ArrayList<AssistingJob> getAssistingJobs(String key) {
        if (this.m_assistingJobs != null && this.m_assistingJobs.containsKey(key)) {
            return this.m_assistingJobs.get(key);
        }
        return null;
    }

    public String getDefaultFieldValue(String field) {
        return this.m_rules.getFieldEditor().getDefaultValue(field);
    }

    public String getParentEntFieldName() {
        return "JOBSET_ID";
    }

    public AttrHolderList getTopLevelEntities() {
        return this.m_topLevelParents;
    }

    public boolean hasChildren(String entId) {
        AttrHolderList children = this.m_jobTable.getJobs().get(entId);
        return children != null && !children.isEmpty();
    }

    public void init() {
        this.m_jobSetTable = JobSetTable.instance();
        this.m_jobTable = JobTable.instance();
        this.m_jobPredTable = JobPredTable.instance();
        this.m_jobSetPredTable = JobSetPredTable.instance();
        this.createCalendars();
        try {
            this.generateTriggers();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        this.generateTags();
        this.m_topLevelParents = (AttrHolderList)this.m_jobSetTable.getChilds().clone();
        this.applyFilter(this.getParentEntFieldName());
    }

    private void generateTriggers() throws IOException {
        if (!this.m_rules.getBooleanRule("TNG rules", new String[]{"FW_AVAILABLE"}).booleanValue()) {
            return;
        }
        boolean jobPerTriggersEnabled = this.m_rules.getBooleanRule("TNG rules", new String[]{"FW_JOB_PER_TRIGGER"});
        this.createTableForTriggerJobs();
        TriggerTable.instance();
        Set<String> triggerJobsList = this.m_jobPredTable.getJobPredTriggerJobsList();
        for (String key : triggerJobsList) {
            AttrHolderList triggersForJobList = this.m_jobPredTable.getJobPredTriggersForJob(key);
            Integer count = 0;
            for (IAttrHolder triggerAttr : triggersForJobList) {
                Integer n = count;
                count = count + 1;
                IAttrHolder TriggerEventAttr = TriggerTable.instance().getTrigger(triggerAttr.getAttr("TRID"), triggerAttr.getAttr("TREV"));
                if (TriggerEventAttr == null) {
                    TngJob.addReporterMessage("WRN1002", triggerAttr.getAttr("JOBSET_ID"), triggerAttr.getAttr("JOB_ID"), triggerAttr.getAttr("JNO_ID"), triggerAttr.getAttr("TRID"), triggerAttr.getAttr("TREV"));
                    continue;
                }
                if (jobPerTriggersEnabled) {
                    this.createFwJobForTrigger(triggerAttr, TriggerEventAttr);
                    continue;
                }
                if (triggersForJobList.size() > 1 && count == 1) {
                    this.createTriggerOrderJob(triggerAttr, TriggerEventAttr);
                }
                this.handleTriggerForJob(triggerAttr, TriggerEventAttr, triggersForJobList.size());
            }
        }
        Set<String> triggerJobSetsList = this.m_jobSetPredTable.getJobSetPredTriggerJobsList();
        for (String key : triggerJobSetsList) {
            AttrHolderList triggersForJobList = this.m_jobSetPredTable.getJobSetPredTriggersForJob(key);
            Integer count = 0;
            for (IAttrHolder triggerAttr : triggersForJobList) {
                Integer n = count;
                count = count + 1;
                IAttrHolder TriggerEventAttr = TriggerTable.instance().getTrigger(triggerAttr.getAttr("TRID"), triggerAttr.getAttr("TREV"));
                if (TriggerEventAttr == null) {
                    TngJob.addReporterMessage("WRN1002", triggerAttr.getAttr("JOBSET_ID"), "", "", triggerAttr.getAttr("TRID"), triggerAttr.getAttr("TREV"));
                    continue;
                }
                if (jobPerTriggersEnabled) {
                    this.createFwJobForTrigger(triggerAttr, TriggerEventAttr);
                    continue;
                }
                if (triggersForJobList.size() > 1 && count == 1) {
                    this.createTriggerOrderJob(triggerAttr, TriggerEventAttr);
                }
                this.handleTriggerForJob(triggerAttr, TriggerEventAttr, triggersForJobList.size());
            }
        }
        this.closeFwFiles();
    }

    private void createTableForTriggerJobs() {
        String[] tableValue = new String[this.m_jobSetTable.getJobSetHeaderSize().intValue()];
        Integer i = 0;
        while (i < tableValue.length) {
            tableValue[i.intValue()] = "NULL";
            Integer n = i;
            i = i + 1;
        }
        tableValue[this.m_jobSetTable.getJobSetAttrIndex((String)"ID").intValue()] = TngGlobals.TRIGGERS_TABLE;
        tableValue[this.m_jobSetTable.getJobSetAttrIndex((String)"JOBSET_ID").intValue()] = TngGlobals.TRIGGERS_TABLE;
        tableValue[this.m_jobSetTable.getJobSetAttrIndex((String)"DESCRIPTION").intValue()] = "Scheduling table for Triggers";
        tableValue[this.m_jobSetTable.getJobSetAttrIndex((String)"FAILCOND").intValue()] = "(9999,9999)";
        tableValue[this.m_jobSetTable.getJobSetAttrIndex((String)"PRIORITY").intValue()] = "1";
        tableValue[this.m_jobSetTable.getJobSetAttrIndex((String)"BACKLOG").intValue()] = "YES";
        tableValue[this.m_jobSetTable.getJobSetAttrIndex((String)"AUTOSEL").intValue()] = "YES";
        tableValue[this.m_jobSetTable.getJobSetAttrIndex((String)"HOLD").intValue()] = "NO";
        tableValue[this.m_jobSetTable.getJobSetAttrIndex((String)"CRITHACT").intValue()] = "O";
        this.m_jobSetTable.appendJobSetAttributes(tableValue);
    }

    private void createTriggerOrderJob(IAttrHolder triggerAttr, IAttrHolder TriggerEventAttr) {
        String[] jobValue = new String[this.m_jobTable.getJobHeaderSize().intValue()];
        String job_id = "";
        if (triggerAttr.isFieldExist("JOB_ID")) {
            job_id = triggerAttr.getAttr("JOB_ID");
        }
        String jno_id = "1";
        if (triggerAttr.isFieldExist("JNO_ID")) {
            jno_id = triggerAttr.getAttr("JNO_ID");
        }
        Integer i = 0;
        while (i < jobValue.length) {
            jobValue[i.intValue()] = "NULL";
            Integer n = i;
            i = i + 1;
        }
        String jobName = String.format(TngGlobals.CTMFW_ORDER_ID_FORMAT, triggerAttr.getAttr("JOBSET_ID"), job_id, jno_id);
        jobValue[this.m_jobTable.getJobAttrIndex((String)"ID").intValue()] = String.format(TngGlobals.CTMFW_JOB_ID_FORMAT, TngGlobals.TRIGGERS_TABLE, jobName, jno_id);
        jobValue[this.m_jobTable.getJobAttrIndex((String)"JOBSET_ID").intValue()] = TngGlobals.TRIGGERS_TABLE;
        jobValue[this.m_jobTable.getJobAttrIndex((String)"JOB_ID").intValue()] = jobName;
        jobValue[this.m_jobTable.getJobAttrIndex((String)"JNO_ID").intValue()] = jno_id;
        jobValue[this.m_jobTable.getJobAttrIndex((String)"DESCRIPTION").intValue()] = String.format(TngGlobals.CTMFW_ORDER_DESCRIPT_FORMAT, jobName);
        jobValue[this.m_jobTable.getJobAttrIndex((String)"FAILCOND").intValue()] = "(1,9999)";
        jobValue[this.m_jobTable.getJobAttrIndex((String)"PRIORITY").intValue()] = "1";
        jobValue[this.m_jobTable.getJobAttrIndex((String)"JOBTYPE").intValue()] = "CPU";
        jobValue[this.m_jobTable.getJobAttrIndex((String)"CYCLIC").intValue()] = "YES";
        jobValue[this.m_jobTable.getJobAttrIndex((String)"CYCFREQ").intValue()] = "1";
        jobValue[this.m_jobTable.getJobAttrIndex((String)"CALENDAR").intValue()] = TriggerEventAttr.getAttr("CALENDAR");
        this.m_jobTable.appendJobAttributes(jobValue);
        JobParmTable jobParmTable = JobParmTable.instance();
        String[] jobParmValue = new String[jobParmTable.getJobParmHeaderSize().intValue()];
        Integer i2 = 0;
        while (i2 < jobParmValue.length) {
            jobParmValue[i2.intValue()] = "NULL";
            Integer n = i2;
            i2 = i2 + 1;
        }
        jobParmValue[jobParmTable.getJobParmAttrIndex((String)"ID").intValue()] = String.format(TngGlobals.CTMFW_JOB_ID_FORMAT, TngGlobals.TRIGGERS_TABLE, jobName, jno_id);
        jobParmValue[jobParmTable.getJobParmAttrIndex((String)"JOBSET_ID").intValue()] = TngGlobals.TRIGGERS_TABLE;
        jobParmValue[jobParmTable.getJobParmAttrIndex((String)"JOB_ID").intValue()] = jobName;
        jobParmValue[jobParmTable.getJobParmAttrIndex((String)"JNO_ID").intValue()] = jno_id;
        if (!triggerAttr.isFieldExist("JOB_ID")) {
            job_id = "*";
        }
        jobParmValue[jobParmTable.getJobParmAttrIndex((String)"SUBFILE").intValue()] = String.format(TngGlobals.CTMFW_ORDER_COMMAND_FORMAT, triggerAttr.getAttr("JOBSET_ID"), job_id);
        jobParmValue[jobParmTable.getJobParmAttrIndex((String)"SUBUSER").intValue()] = this.getFwJobOwner("");
        jobParmTable.appendJobParmAttributes(jobParmValue);
    }

    private void createFwJobForTrigger(IAttrHolder triggerAttr, IAttrHolder TriggerEventAttr) {
        Object fwStopTime;
        Integer i;
        String jobName = String.format(TngGlobals.CTMFW_ID_FORMAT, TriggerEventAttr.getAttr("TRIGGER_ID"));
        if (this.m_triggersList.get(TriggerEventAttr.getAttr("TRIGGER_ID")) == null) {
            this.m_triggersList.put(TriggerEventAttr.getAttr("TRIGGER_ID"), TriggerEventAttr.getAttr("TRIGGER_ID"));
            String[] jobValue = new String[this.m_jobTable.getJobHeaderSize().intValue()];
            Integer i2 = 0;
            while (i2 < jobValue.length) {
                jobValue[i2.intValue()] = "NULL";
                Integer n = i2;
                i2 = i2 + 1;
            }
            String failCond = TriggerEventAttr.getAttr("FAILCOND");
            if (failCond == null || failCond.isEmpty() || failCond.equals("NULL")) {
                failCond = "(1,9999)";
            }
            jobValue[this.m_jobTable.getJobAttrIndex((String)"ID").intValue()] = String.format(TngGlobals.CTMFW_JOB_ID_FORMAT, TngGlobals.TRIGGERS_TABLE, jobName, "0001");
            jobValue[this.m_jobTable.getJobAttrIndex((String)"JOBSET_ID").intValue()] = TngGlobals.TRIGGERS_TABLE;
            jobValue[this.m_jobTable.getJobAttrIndex((String)"JOB_ID").intValue()] = jobName;
            jobValue[this.m_jobTable.getJobAttrIndex((String)"JNO_ID").intValue()] = "0001";
            jobValue[this.m_jobTable.getJobAttrIndex((String)"DESCRIPTION").intValue()] = TriggerEventAttr.getAttr("DESCRIPTION");
            jobValue[this.m_jobTable.getJobAttrIndex((String)"FAILCOND").intValue()] = failCond;
            jobValue[this.m_jobTable.getJobAttrIndex((String)"PRIORITY").intValue()] = "1";
            jobValue[this.m_jobTable.getJobAttrIndex((String)"STATION").intValue()] = TriggerEventAttr.getAttr("STATION");
            jobValue[this.m_jobTable.getJobAttrIndex((String)"JOBTYPE").intValue()] = "CPU";
            jobValue[this.m_jobTable.getJobAttrIndex((String)"SKIP").intValue()] = TriggerEventAttr.getAttr("SKIP");
            jobValue[this.m_jobTable.getJobAttrIndex((String)"EXPIRESDATE").intValue()] = TriggerEventAttr.getAttr("EXPIRESDATE");
            jobValue[this.m_jobTable.getJobAttrIndex((String)"EFFECTIVEDATE").intValue()] = TriggerEventAttr.getAttr("EFFECTIVEDATE");
            jobValue[this.m_jobTable.getJobAttrIndex((String)"BACKLOG").intValue()] = TriggerEventAttr.getAttr("BACKLOG");
            jobValue[this.m_jobTable.getJobAttrIndex((String)"AUTOSEL").intValue()] = TriggerEventAttr.getAttr("AUTOSEL");
            jobValue[this.m_jobTable.getJobAttrIndex((String)"CALENDAR").intValue()] = TriggerEventAttr.getAttr("CALENDAR");
            jobValue[this.m_jobTable.getJobAttrIndex((String)"CRITCAL").intValue()] = TriggerEventAttr.getAttr("CRITCAL");
            jobValue[this.m_jobTable.getJobAttrIndex((String)"CRITHACT").intValue()] = TriggerEventAttr.getAttr("CRITHACT");
            jobValue[this.m_jobTable.getJobAttrIndex((String)"CRITKEYS").intValue()] = TriggerEventAttr.getAttr("CRITKEYS");
            jobValue[this.m_jobTable.getJobAttrIndex((String)"CRITCADJ").intValue()] = TriggerEventAttr.getAttr("CRITCADJ");
            this.m_jobTable.appendJobAttributes(jobValue);
            JobParmTable jobParmTable = JobParmTable.instance();
            String[] jobParmValue = new String[jobParmTable.getJobParmHeaderSize().intValue()];
            i = 0;
            while (i < jobParmValue.length) {
                jobParmValue[i.intValue()] = "NULL";
                Integer n = i;
                i = i + 1;
            }
            jobParmValue[jobParmTable.getJobParmAttrIndex((String)"ID").intValue()] = String.format(TngGlobals.CTMFW_JOB_ID_FORMAT, TngGlobals.TRIGGERS_TABLE, jobName, "0001");
            jobParmValue[jobParmTable.getJobParmAttrIndex((String)"JOBSET_ID").intValue()] = TngGlobals.TRIGGERS_TABLE;
            jobParmValue[jobParmTable.getJobParmAttrIndex((String)"JOB_ID").intValue()] = jobName;
            jobParmValue[jobParmTable.getJobParmAttrIndex((String)"JNO_ID").intValue()] = "0001";
            String fwInterval = this.m_rules.getStringRule("TNG rules", new String[]{"FW_INTERVAL"});
            fwStopTime = this.m_rules.getStringRule("TNG rules", new String[]{"FW_INTERVAL"});
            jobParmValue[jobParmTable.getJobParmAttrIndex((String)"SUBFILE").intValue()] = String.format(TngGlobals.CTMFW_TRIGGER_JOB_COMMAND_FORMAT, TriggerEventAttr.getAttr("FILENAME"), fwInterval, fwStopTime);
            jobParmValue[jobParmTable.getJobParmAttrIndex((String)"SUBUSER").intValue()] = this.getFwJobOwner(TriggerEventAttr.getAttr("STATION"));
            jobParmTable.appendJobParmAttributes(jobParmValue);
        }
        String job_id = "NULL";
        if (triggerAttr.isFieldExist("JOB_ID")) {
            job_id = triggerAttr.getAttr("JOB_ID");
        }
        String jno_id = "NULL";
        if (triggerAttr.isFieldExist("JNO_ID")) {
            jno_id = triggerAttr.getAttr("JNO_ID");
        }
        String[] jobPredValue = new String[this.getPredHeaderSize(this.hassJobId(triggerAttr)).intValue()];
        if (job_id == null) {
            job_id = "NULL";
        }
        if (jno_id == null) {
            jno_id = "NULL";
        }
        String id = String.format(TngGlobals.CTMFW_JOB_ID_FORMAT, triggerAttr.getAttr("JOBSET_ID"), job_id, jno_id);
        i = 0;
        while (i < jobPredValue.length) {
            jobPredValue[i.intValue()] = "NULL";
            fwStopTime = i;
            i = i + 1;
        }
        this.setPredValue(this.hassJobId(triggerAttr), jobPredValue, "ID", id);
        this.setPredValue(this.hassJobId(triggerAttr), jobPredValue, "JOBSET_ID", triggerAttr.getAttr("JOBSET_ID"));
        this.setPredValue(this.hassJobId(triggerAttr), jobPredValue, "JOB_ID", job_id);
        this.setPredValue(this.hassJobId(triggerAttr), jobPredValue, "JNO_ID", jno_id);
        this.setPredValue(this.hassJobId(triggerAttr), jobPredValue, "TREV", TngGlobals.EVENT_IN_COND);
        this.setPredValue(this.hassJobId(triggerAttr), jobPredValue, "WORKDAY", triggerAttr.getAttr("WORKDAY"));
        this.setPredValue(this.hassJobId(triggerAttr), jobPredValue, "PJNO", "AND");
        this.appendPredAttributes(this.hassJobId(triggerAttr), jobPredValue);
        String condName = "";
        ArrayList<Properties> dependenciesConditionsByTriggerName = DependenciesConvertor.instance().getTriggerListPerJobTrigger(jobName);
        if (dependenciesConditionsByTriggerName != null && !dependenciesConditionsByTriggerName.isEmpty()) {
            for (Properties prop : dependenciesConditionsByTriggerName) {
                String localJobName = prop.getProperty(TngGlobals.JOB_NAME);
                String localFormat = prop.getProperty(TngGlobals.FORMAT_NAME);
                if (!localJobName.equalsIgnoreCase(job_id = job_id == null || job_id.equalsIgnoreCase("NULL") ? triggerAttr.getAttr("JOBSET_ID") : job_id)) continue;
                condName = localFormat;
                String key = TngJob.buildJobIdKey(TngGlobals.TRIGGERS_TABLE, jobName, jno_id);
                this.addPropToOnStmt(key, condName);
            }
        } else {
            String triggeredJobName = DependenciesConvertor.instance().buildDefaultCondName(triggerAttr.getAttr("JOBSET_ID"), job_id, jno_id);
            condName = DependenciesConvertor.instance().buildDefaultCondName(TngGlobals.TRIGGERS_TABLE, jobName, triggeredJobName);
            String key = TngJob.buildJobIdKey(TngGlobals.TRIGGERS_TABLE, jobName, "0001");
            this.addPropToOnStmt(key, condName);
        }
    }

    private void addPropToOnStmt(String key, String condName) {
        Properties tmpStatement = new Properties();
        tmpStatement.setProperty("CODE", "COMPSTAT EQ 0");
        tmpStatement.setProperty("STMT", "*");
        tmpStatement.setProperty("ACTION", "DOCOND");
        tmpStatement.put("NAME", condName);
        tmpStatement.setProperty("ODATE", "ODAT");
        tmpStatement.put("SIGN", "ADD");
        List<Properties> list = this.m_onStatements.get(key);
        if (list == null) {
            list = new ArrayList<Properties>();
            this.m_onStatements.put(key, list);
        }
        list.add(tmpStatement);
    }

    private void createFwJobForStation(String station) {
        String[] jobValue = new String[this.m_jobTable.getJobHeaderSize().intValue()];
        Integer i = 0;
        while (i < jobValue.length) {
            jobValue[i.intValue()] = "NULL";
            Integer n = i;
            i = i + 1;
        }
        String jobName = String.format(TngGlobals.CTMFW_ID_FORMAT, station);
        jobValue[this.m_jobTable.getJobAttrIndex((String)"ID").intValue()] = String.format(TngGlobals.CTMFW_JOB_ID_FORMAT, TngGlobals.TRIGGERS_TABLE, jobName, "0001");
        jobValue[this.m_jobTable.getJobAttrIndex((String)"JOBSET_ID").intValue()] = TngGlobals.TRIGGERS_TABLE;
        jobValue[this.m_jobTable.getJobAttrIndex((String)"JOB_ID").intValue()] = jobName;
        jobValue[this.m_jobTable.getJobAttrIndex((String)"JNO_ID").intValue()] = "0001";
        jobValue[this.m_jobTable.getJobAttrIndex((String)"DESCRIPTION").intValue()] = String.format(TngGlobals.CTMFW_JOB_DESCRIPT_FORMAT, station);
        jobValue[this.m_jobTable.getJobAttrIndex((String)"FAILCOND").intValue()] = "(1,9999)";
        jobValue[this.m_jobTable.getJobAttrIndex((String)"PRIORITY").intValue()] = "1";
        jobValue[this.m_jobTable.getJobAttrIndex((String)"STATION").intValue()] = station;
        jobValue[this.m_jobTable.getJobAttrIndex((String)"JOBTYPE").intValue()] = "CPU";
        jobValue[this.m_jobTable.getJobAttrIndex((String)"CRITHACT").intValue()] = "O";
        this.m_jobTable.appendJobAttributes(jobValue);
        JobParmTable jobParmTable = JobParmTable.instance();
        String[] jobParmValue = new String[jobParmTable.getJobParmHeaderSize().intValue()];
        Integer i2 = 0;
        while (i2 < jobParmValue.length) {
            jobParmValue[i2.intValue()] = "NULL";
            Integer n = i2;
            i2 = i2 + 1;
        }
        jobParmValue[jobParmTable.getJobParmAttrIndex((String)"ID").intValue()] = String.format(TngGlobals.CTMFW_JOB_ID_FORMAT, TngGlobals.TRIGGERS_TABLE, jobName, "0001");
        jobParmValue[jobParmTable.getJobParmAttrIndex((String)"JOBSET_ID").intValue()] = TngGlobals.TRIGGERS_TABLE;
        jobParmValue[jobParmTable.getJobParmAttrIndex((String)"JOB_ID").intValue()] = jobName;
        jobParmValue[jobParmTable.getJobParmAttrIndex((String)"JNO_ID").intValue()] = "0001";
        jobParmValue[jobParmTable.getJobParmAttrIndex((String)"SUBFILE").intValue()] = String.format(TngGlobals.CTMFW_STATION_JOB_COMMAND_FORMAT, this.buildFwFileName(station));
        jobParmValue[jobParmTable.getJobParmAttrIndex((String)"SUBUSER").intValue()] = this.getFwJobOwner(station);
        jobParmTable.appendJobParmAttributes(jobParmValue);
        TngJob.addReporterMessage("INF1001", TngGlobals.TRIGGERS_TABLE, jobName, "0001", this.buildFwFileName(station), station);
    }

    private String getFwJobOwner(String station) {
        String owner = "DEFAULT_OWNER";
        Integer selectedStationLen = 0;
        Integer cfgStationLen = 0;
        ArrayList fwStationToOwner = this.m_rules.getPairsListRule("TNG rules", new String[]{"FW_STATION_TO_OWNER_TABLE"});
        for (Map.Entry entry : fwStationToOwner) {
            String cfgStation = ((String)entry.getKey()).toUpperCase();
            String cfgOwner = (String)entry.getValue();
            if (station.isEmpty()) {
                if (!cfgStation.isEmpty() && !cfgStation.equals("*")) continue;
                owner = cfgOwner;
                break;
            }
            try {
                cfgStationLen = cfgStation.length();
                cfgStation = cfgStation.replace("*", ".*");
                if (cfgStationLen <= selectedStationLen || !Pattern.matches(cfgStation, station.toUpperCase())) continue;
                owner = cfgOwner;
                selectedStationLen = cfgStationLen;
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
        return owner;
    }

    private void handleTriggerForJob(IAttrHolder triggerAttr, IAttrHolder TriggerEventAttr, int numTriggersForJob) throws IOException {
        FileWriter fwFile;
        boolean jobIND;
        boolean bl = jobIND = triggerAttr.getAttr("JOB_ID") != null && !triggerAttr.getAttr("JOB_ID").equalsIgnoreCase("NULL");
        if (this.m_triggersList.get(TriggerEventAttr.getAttr("TRIGGER_ID")) != null) {
            TngTrigger tngTrigger = new TngTrigger(triggerAttr.getAttr("TRID"), triggerAttr.getAttr("TREV"), triggerAttr.getAttr("WORKDAY"));
            TngSuccessorJob job = new TngSuccessorJob(triggerAttr.getAttr("JOBSET_ID"), triggerAttr.getAttr("JOB_ID"), triggerAttr.getAttr("JNO_ID"));
            job.setTrev(triggerAttr.getAttr("TREV"));
            job.setTrid(triggerAttr.getAttr("TRID"));
            DependenciesConvertor.instance().appendTriggerJobs(tngTrigger, job, jobIND);
            return;
        }
        this.m_triggersList.put(TriggerEventAttr.getAttr("TRIGGER_ID"), TriggerEventAttr.getAttr("TRIGGER_ID"));
        String line = "";
        String job_id = null;
        if (triggerAttr.isFieldExist("JOB_ID")) {
            job_id = triggerAttr.getAttr("JOB_ID");
        }
        String jno_id = null;
        if (triggerAttr.isFieldExist("JNO_ID")) {
            jno_id = triggerAttr.getAttr("JNO_ID");
        }
        if ((fwFile = this.m_fwFilesList.get(TriggerEventAttr.getAttr("STATION"))) == null) {
            String fileName = this.buildFwFileName(TriggerEventAttr.getAttr("STATION"));
            fwFile = new FileWriter(fileName);
            this.m_fwFilesList.put(TriggerEventAttr.getAttr("STATION"), fwFile);
            this.writeFwGlobalParams(fwFile);
        }
        line = String.format(TngGlobals.CTMFW_FILE_HEADER_FORMAT, TngJob.buildJobIdKey(triggerAttr.getAttr("JOBSET_ID"), job_id, jno_id), TriggerEventAttr.getAttr("TRIGGER_ID"), TriggerEventAttr.getAttr("DESCRIPTION"));
        fwFile.write(line);
        line = String.format(TngGlobals.CTMFW_ON_FILEWATCH_FORMAT, TriggerEventAttr.getAttr("FILENAME"));
        fwFile.write(line);
        line = String.format(TngGlobals.CTMFW_ON_THEN_FORMAT, new Object[0]);
        fwFile.write(line);
        if (numTriggersForJob > 1) {
            this.writeTriggerEntryDoCond(fwFile, triggerAttr, TriggerEventAttr);
            TngTrigger tngTrigger = new TngTrigger(triggerAttr.getAttr("TRID"), triggerAttr.getAttr("TREV"), triggerAttr.getAttr("WORKDAY"));
            TngSuccessorJob job = new TngSuccessorJob(triggerAttr.getAttr("JOBSET_ID"), triggerAttr.getAttr("JOB_ID"), triggerAttr.getAttr("JNO_ID"));
            job.setTrev(triggerAttr.getAttr("TREV"));
            job.setTrid(triggerAttr.getAttr("TRID"));
            DependenciesConvertor.instance().appendTriggerJobs(tngTrigger, job, jobIND);
        } else {
            this.writeTriggerEntryDoCmd(fwFile, triggerAttr, TriggerEventAttr);
        }
        line = String.format(TngGlobals.CTMFW_ON_END_FORMAT, new Object[0]);
        fwFile.write(line);
    }

    private void writeFwGlobalParams(FileWriter fwFile) throws IOException {
        String fwInterval = this.m_rules.getStringRule("TNG rules", new String[]{"FW_INTERVAL"});
        String fwStopTime = this.m_rules.getStringRule("TNG rules", new String[]{"STOP_TIME"});
        String line = "";
        line = String.format("# Global parameters\n", new Object[0]);
        fwFile.write(line);
        line = String.format("INTERVAL        %s\n", fwInterval);
        fwFile.write(line);
        line = String.format("WAIT_TIME       0\n", new Object[0]);
        fwFile.write(line);
        line = String.format("CYCLIC_INTERVAL 1\n", new Object[0]);
        fwFile.write(line);
        line = String.format("STOP_TIME       %s\n", fwStopTime);
        fwFile.write(line);
        line = String.format("CHECK_OPEN      Y\n", new Object[0]);
        fwFile.write(line);
        line = String.format("\n", new Object[0]);
        fwFile.write(line);
    }

    private void writeTriggerEntryDoCmd(FileWriter fwFile, IAttrHolder triggerAttr, IAttrHolder TriggerEventAttr) throws IOException {
        String job_id = "*";
        if (triggerAttr.isFieldExist("JOB_ID")) {
            job_id = triggerAttr.getAttr("JOB_ID");
        }
        String line = String.format(TngGlobals.CTMFW_DO_CMD_FORMAT, triggerAttr.getAttr("JOBSET_ID"), job_id);
        fwFile.write(line);
    }

    private void writeTriggerEntryDoCond(FileWriter fwFile, IAttrHolder triggerAttr, IAttrHolder TriggerEventAttr) throws IOException {
        String condName = "";
        if (DependenciesConvertor.isDirectJob()) {
            String job_id = "";
            if (triggerAttr.isFieldExist("JOB_ID")) {
                job_id = triggerAttr.getAttr("JOB_ID");
            }
            String jno_id = "1";
            if (triggerAttr.isFieldExist("JNO_ID")) {
                jno_id = triggerAttr.getAttr("JNO_ID");
            }
            String jobName = String.format(TngGlobals.CTMFW_ORDER_ID_FORMAT, triggerAttr.getAttr("JOBSET_ID"), job_id, jno_id);
            TngSuccessorJob job = new TngSuccessorJob(TngGlobals.TRIGGERS_TABLE, jobName, jno_id);
            condName = DependenciesConvertor.instance().getInCondName(job, TriggerEventAttr.getAttr("TRIGGER_ID"));
        }
        if (condName.equals("")) {
            condName = String.format(TngGlobals.CTMFW_DO_CONDNAME_FORMAT, TriggerEventAttr.getAttr("TRIGGER_ID"));
        }
        String line = String.format(TngGlobals.CTMFW_DO_COND_FORMAT, condName);
        fwFile.write(line);
    }

    private void closeFwFiles() throws IOException {
        for (String station : this.m_fwFilesList.keySet()) {
            FileWriter fwFile = this.m_fwFilesList.get(station);
            fwFile.close();
            this.createFwJobForStation(station);
            DependenciesConvertor.instance().appendStationsToOutConds(station);
        }
    }

    private String buildFwFileName(String station) {
        return Globs.TEMP_DIR + Globs.DIRSEP + String.format(TngGlobals.CTMFW_INPUT_FILE_FORMAT, station);
    }

    private void createCalendars() {
        String calendarSource = Params.instance().getDatasourcePath() + "TngCalendars.CAL";
        int numYears = this.m_rules.getIntegerRule("TNG rules", new String[]{"NUMBER_OF_YEARS"});
        if (GlobalFunctions.isFileExist((String)calendarSource) && numYears > 0) {
            try {
                int startYear = Calendar.getInstance().get(1);
                int endYear = startYear + numYears - 1;
                this.m_calendars = new TngCalendars(calendarSource, Params.instance().getDatacenterName());
                this.m_calendars.convert(startYear -= 2, endYear);
                this.m_calendars.writeResults();
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        } else {
            this.deleteCalendarsIfExists();
        }
    }

    private void deleteCalendarsIfExists() {
        GlobalFunctions.getTempCalendarFilePath().stream().filter(calendarFile -> Files.exists(Paths.get(calendarFile, new String[0]), new LinkOption[0])).forEach(calendar -> new File((String)calendar).delete());
    }

    private void generateTags() {
        for (IAttrHolder row : this.m_jobSetTable.getChilds()) {
            String tableName = row.getAttr("JOBSET_ID");
            HashSet<Properties> set = new HashSet<Properties>();
            Properties prop = new Properties();
            set.add(prop);
            prop.put("NAME", tableName);
            this.m_entityTags.put(tableName, set);
        }
    }

    public boolean isContainerEntity(IAttrHolder entAttr) {
        return true;
    }

    public boolean isStandAloneGrouped() {
        return false;
    }

    public SchedEntity spawnJob(String table, IAttrHolder attributes) {
        return new TngJob(table, attributes, (SourceDefinitions)this);
    }

    public SchedEntity spawnJob(SchedEntity parent, IAttrHolder attributes) {
        return null;
    }

    public Set<Properties> getTags(String jobName) {
        return this.m_entityTags.get(jobName);
    }

    public boolean isCalendarConverted(String calName) {
        return this.m_calendars != null && this.m_calendars.wasConverted(calName);
    }

    public ArrayList<String> getGeneralMessages() {
        return null;
    }
}

