/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tandem.TandemJobType;
import com.bmc.ctmconvert.tandem.TandemWrapper;
import com.bmc.ctmconvert.tng.TngDefs;
import com.bmc.ctmconvert.tng.TngGlobals;
import com.bmc.ctmconvert.tng.TngJob;
import java.util.Properties;

public class TandemHandler {
    private final RulesDataSet m_rules;
    private TngJob tngJob;
    private IAttrHolder jobParmAttr;
    private TngDefs m_sourceDefs;
    private String memLib = "";

    public TandemHandler(TngJob tngJob, IAttrHolder jobParmAttr, TngDefs m_sourceDefs) {
        this.tngJob = tngJob;
        this.jobParmAttr = jobParmAttr;
        this.m_sourceDefs = m_sourceDefs;
        this.m_rules = RuleManager.instance().getCurrentRules();
    }

    public void execute() {
        String parameter;
        TandemWrapper tandemWrapper = new TandemWrapper((SchedEntity)this.tngJob);
        tandemWrapper.convertToTandemJob();
        String value = "";
        String program = this.jobParmAttr.getAttr("PROGNAME");
        if (program.contains("TACL") && this.enableTACLRuleChecked()) {
            tandemWrapper.setJobType(TandemJobType.TACL);
            emptyArray = new String[]{"", "", ""};
            value = this.jobParmAttr.getAttr("IN");
            String[] inValues = value != null && !value.isEmpty() ? value.split("\\.") : emptyArray;
            String memName = inValues[0];
            if (inValues.length > 2) {
                memName = inValues[2];
            }
            tandemWrapper.setMemName(memName);
            this.tngJob.addAttribute("MEMNAME", memName);
            if (inValues != null && inValues.length > 1) {
                this.memLib = inValues[0] + "." + inValues[1];
            }
            tandemWrapper.setMemLib(this.memLib);
            this.tngJob.addAttribute("MEMLIB", this.memLib);
        } else {
            tandemWrapper.setJobType(TandemJobType.PGM);
            emptyArray = new String[]{"", "", ""};
            tandemWrapper.setMemName(program);
            String[] programValues = program != null && !program.isEmpty() ? program.split("\\.") : emptyArray;
            String memName = programValues[0];
            if (programValues.length > 2) {
                memName = programValues[2];
            }
            tandemWrapper.setMemName(memName);
            this.tngJob.addAttribute("MEMNAME", memName);
            if (programValues != null && programValues.length > 1) {
                this.memLib = programValues[0] + "." + programValues[1];
            }
            tandemWrapper.setMemLib(this.memLib);
            this.tngJob.addAttribute("MEMLIB", this.memLib);
            value = this.jobParmAttr.getAttr("IN");
            if (value != null && !value.isEmpty()) {
                tandemWrapper.setInputFile(value);
            }
        }
        value = this.jobParmAttr.getAttr("SUBUSER");
        tandemWrapper.setJobOwner(value);
        value = this.jobParmAttr.getAttr("CPU");
        tandemWrapper.setCpu(value);
        value = this.jobParmAttr.getAttr("NAME");
        tandemWrapper.setName(value);
        value = this.jobParmAttr.getAttr("OUT");
        if (value != null && !value.isEmpty()) {
            if (value.contains("#")) {
                this.tngJob.addAttribute("OPTION", "Copy");
                this.tngJob.addAttribute("PAR", value);
                Properties onDoStmt = new Properties();
                onDoStmt.setProperty("CODE", "NOTOK");
                onDoStmt.setProperty("STMT", "*");
                onDoStmt.setProperty("ACTION", "DOSYSOUT");
                onDoStmt.setProperty("OPTION", "Copy");
                onDoStmt.setProperty("PAR", value);
                this.m_sourceDefs.addJobOnstmt(this.tngJob, onDoStmt);
            } else {
                tandemWrapper.setOut(value);
            }
        }
        value = this.jobParmAttr.getAttr("PRI");
        tandemWrapper.setPri(value);
        tandemWrapper.setHomeTerm(TngGlobals.TANDEM_TERM);
        String defaultValue = this.jobParmAttr.getAttr("DEFAULT");
        if (!this.memLib.equalsIgnoreCase(defaultValue)) {
            this.tngJob.addAutoEdits("%%TANDEM_DEFAULT", defaultValue);
            this.tngJob.addMessage("WRN20004", this.tngJob.getJobName(), defaultValue);
        }
        if (!(parameter = this.jobParmAttr.getAttr("PARAMETERS")).equalsIgnoreCase("NULL") && parameter.contains("ABENDONABEND")) {
            this.tngJob.addAutoEdits("%%TANDEM-TACL_RUN_OPTION", "STOPONABEND");
        }
    }

    private boolean enableTACLRuleChecked() {
        return this.m_rules.getBooleanRule("TNG rules", new String[]{"RUN_TACL_SCRIPTS_AS_JOB_TYPE_TACL"});
    }
}

