/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tng.SAPConverterHandler;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class TNGSAPConverterHandler
implements SAPConverterHandler {
    private static final String MEMLIB = "Not in use for Sap jobs";
    private String sapApplForm;

    @Override
    public void buildAutoEditAttrNameAutoEditAttrValueMapFromCommand(String jobName, HashMap<String, String> autoEditAttrNameAutoEditAttrValue, ArrayList<String> messages, RulesDataSet m_rules, List<String> paramsList, String command) {
        if (command.matches("^(.*[\\s\\\\/])?sapjob(s{0,1}?)(\\.[A-Za-z]{3})?(\\s+.*)?")) {
            this.sapApplForm = "SAP R3";
            this.getSapJobAutoEditValuesFromCommand(jobName, autoEditAttrNameAutoEditAttrValue, messages, m_rules, paramsList, "sapjob");
        } else if (command.matches("^(.*[\\s\\\\/])?capchain(\\.[A-Za-z]{3})?(\\s+.*)?")) {
            this.sapApplForm = "SAP Business Warehouse";
            this.getCapcahinAutoEditValuesFromCommand(jobName, autoEditAttrNameAutoEditAttrValue, messages, m_rules, paramsList, "capchain");
        }
    }

    private String getSapJobType() {
        return this.sapApplForm;
    }

    private void getCapcahinAutoEditValuesFromCommand(String jobName, HashMap<String, String> autoEditAttrNameAutoEditAttrValue, ArrayList<String> messages, RulesDataSet m_rules, List<String> paramsList, String sapCommandType) {
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-RUNCOUNT", "%%RUNCOUNT");
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-JOB_MODE", "PC_RUN_ORG");
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-PROCESS_TYPE", "ProcessChain");
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-PROCESSCHAIN_RERUN_INSTANCE", "PC_RUN_CURR_INSTANCE");
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-PC_periodic", "X");
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-PC_DONT_POLL", "N");
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-JOBLOG", "*SYSOUT");
        this.extractNonDefaultValues(jobName, autoEditAttrNameAutoEditAttrValue, messages, paramsList, sapCommandType);
    }

    private boolean isKnownParam(String param, String sapCommandType) {
        boolean knownParam = false;
        String[] retKnownParam = null;
        if (sapCommandType.equals("sapjob")) {
            retKnownParam = knownParamExpr = new String[]{"-r\\d*", "-v\\d*", "-n", "-a", "-4", "-j", "-s", "-d", "-u", "-m", "-w", "-o", "-y", "-f", "-g", "-x", "-b", "-c", "-e", "-h", "-I", "-k", "-l", "-p", "-q", "-sn", "-t", "-z", "-0", "-1", "-2", "-3", "-5", "-6", "-7", "-8", "\\+C"};
        } else if (sapCommandType.equals("capchain")) {
            retKnownParam = knownParamExpr = new String[]{"-n", "\\+C", "-d", "-y", "-u"};
        }
        for (int i = 0; i < retKnownParam.length; ++i) {
            if (!param.matches((String)retKnownParam[i])) continue;
            knownParam = true;
            break;
        }
        return knownParam;
    }

    @Override
    public void convert(HashMap<String, String> jobAttr, HashMap<String, String> autoedits, List<String> optionalAttributesUsed, RulesDataSet m_rules, HashMap<String, String> autoEditAttrNameAutoEditAttrValue) {
        this.setJobAttributes(jobAttr, optionalAttributesUsed, m_rules);
        this.setJobAutoEdits(autoedits, autoEditAttrNameAutoEditAttrValue);
    }

    @Override
    public boolean isSAPJob(String command) {
        boolean retVal = false;
        int indexOfFirstSpace = command.indexOf(" ");
        if (indexOfFirstSpace >= 0) {
            String firstCommand = command.substring(0, indexOfFirstSpace);
            retVal = firstCommand.toLowerCase().contains("sapjob");
            if (command.toLowerCase().matches("\\s*capchain.*")) {
                retVal = true;
            }
        }
        return retVal;
    }

    private void setJobAttributes(HashMap<String, String> jobAttr, List<String> optionalAttributesUsed, RulesDataSet m_rules) {
        jobAttr.put("TASKTYPE", m_rules.getTaskTypeHandler().getTaskType());
        jobAttr.put("MEMLIB", MEMLIB);
        jobAttr.put("MEMNAME", jobAttr.get("JOBNAME"));
        jobAttr.put("APPL_FORM", this.getSapJobType());
        optionalAttributesUsed.add("APPL_FORM");
        jobAttr.putAll(Globs.SAP_TYPE_VERSION);
        optionalAttributesUsed.addAll(Globs.SAP_TYPE_VERSION.keySet());
    }

    private void setJobAutoEdits(HashMap<String, String> autoedits, HashMap<String, String> autoEditAttrNameAutoEditAttrValue) {
        for (String autoEditName : autoEditAttrNameAutoEditAttrValue.keySet()) {
            autoedits.put(autoEditName, autoEditAttrNameAutoEditAttrValue.get(autoEditName));
        }
    }

    private void getSapJobAutoEditValuesFromCommand(String jobName, HashMap<String, String> autoEditAttrNameAutoEditAttrValue, ArrayList<String> messages, RulesDataSet m_rules, List<String> paramsList, String sapCommandType) {
        String SAP_AUTO_DETECT_CHILD_TABLE_DEF_VAL = "%%SCHEDTAB";
        String SAP_AUTO_DETECT_OPTION_DEF_VAL = "1";
        String SAP_AUTO_FILE_JOBCOUNT_DEF_VAL = "LAST_SCHEDULED";
        String SAP_AUTO_GROUP_ORDID_DEF_VAL = "%%GROUP_ORDID";
        String SAP_AUTO_JOB_COUNT_DEF_VAL = "LAST_SCHEDULED";
        String SAP_AUTO_JOB_MODE_DEF_VAL = "CREATE";
        String SAP_AUTO_JOBCLASS_DEF_VAL = "C";
        String SAP_AUTO_JOBLOG_DEF_VAL = "*SYSOUT";
        String SAP_AUTO_KEEP_JOBLOG_OPTION_DEF_VAL = "S";
        String SAP_AUTO_OVERRIDE_JOBLOG_DEFAULT_DEF_VAL = "X";
        String SAP_AUTO_SERVER_OR_GROUP_TYPE_DEF_VAL = "S";
        String SAP_AUTO_SUBMIT_ASAP_DEF_VAL = "X";
        String SAP_AUTO_XBP_VERSION_DEF_VAL = "XBP20";
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-DETECT_CHILD_TABLE", SAP_AUTO_DETECT_CHILD_TABLE_DEF_VAL);
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-DETECT_OPTION", SAP_AUTO_DETECT_OPTION_DEF_VAL);
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-JOBCOUNT", SAP_AUTO_FILE_JOBCOUNT_DEF_VAL);
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-GROUP_ORDID", SAP_AUTO_GROUP_ORDID_DEF_VAL);
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-JOB_COUNT", SAP_AUTO_JOB_COUNT_DEF_VAL);
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-JOB_MODE", SAP_AUTO_JOB_MODE_DEF_VAL);
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-JOBCLASS", SAP_AUTO_JOBCLASS_DEF_VAL);
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-JOBLOG", SAP_AUTO_JOBLOG_DEF_VAL);
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-KEEP_JOBLOG_OPTION", SAP_AUTO_KEEP_JOBLOG_OPTION_DEF_VAL);
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", SAP_AUTO_OVERRIDE_JOBLOG_DEFAULT_DEF_VAL);
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-SERVER_OR_GROUP_TYPE", SAP_AUTO_SERVER_OR_GROUP_TYPE_DEF_VAL);
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-SUBMIT_ASAP", SAP_AUTO_SUBMIT_ASAP_DEF_VAL);
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-XBP_VERSION", SAP_AUTO_XBP_VERSION_DEF_VAL);
        this.extractNonDefaultValues(jobName, autoEditAttrNameAutoEditAttrValue, messages, paramsList, sapCommandType);
    }

    private String returnFixedValue(String val) {
        val = this.removeFirstBackslash(val);
        return val;
    }

    private String removeFirstBackslash(String val) {
        int firstSpaceIndex = val.indexOf(" ");
        if (firstSpaceIndex != -1) {
            String beforeFirstSpace = val.substring(0, firstSpaceIndex);
            val = val.substring(firstSpaceIndex);
            beforeFirstSpace = beforeFirstSpace.replace("\\", "");
            val = beforeFirstSpace.concat(val);
        }
        return val;
    }

    private void extractNonDefaultValues(String jobName, HashMap<String, String> autoEditAttrNameAutoEditAttrValue, ArrayList<String> messages, List<String> paramsList, String sapJobCommandType) {
        paramsList.remove(0);
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < paramsList.size(); ++i) {
            String fixedParam = "";
            if (i < paramsList.size() - 1) {
                fixedParam = this.returnFixedValue(paramsList.get(i));
                boolean isParamKnown = false;
                String[] tmpArr = fixedParam.split(" ", 2);
                if (tmpArr.length == 2) {
                    isParamKnown = this.isKnownParam(tmpArr[0], sapJobCommandType);
                    if (isParamKnown) {
                        paramsMap.put(tmpArr[0], tmpArr[1]);
                        continue;
                    }
                    paramsMap.put(tmpArr[0], "");
                    continue;
                }
                isParamKnown = this.isKnownParam(fixedParam, sapJobCommandType);
                if (isParamKnown) {
                    if (paramsList.get(i + 1).contains("=") || paramsList.get(i + 1).startsWith("-") || paramsList.get(i + 1).startsWith("+")) {
                        paramsMap.put(fixedParam, "");
                        continue;
                    }
                    paramsMap.put(fixedParam, paramsList.get(i + 1));
                    ++i;
                    continue;
                }
                if (fixedParam.contains("=")) {
                    tmpArr = paramsList.get(i).split("=", 2);
                    paramsMap.put(tmpArr[0], tmpArr[1]);
                    continue;
                }
                paramsMap.put(fixedParam, "");
                continue;
            }
            fixedParam = this.returnFixedValue(paramsList.get(i));
            if (fixedParam.contains("=")) {
                String[] tmpArr = fixedParam.split("=", 2);
                paramsMap.put(tmpArr[0], tmpArr[1]);
                continue;
            }
            if (fixedParam.equals("")) continue;
            paramsMap.put(fixedParam, "");
        }
        if (sapJobCommandType.equals("sapjob")) {
            this.handleSapJobCommand(autoEditAttrNameAutoEditAttrValue, paramsMap, jobName, messages);
        } else if (sapJobCommandType.equals("capchain")) {
            this.handleCapchainCommand(autoEditAttrNameAutoEditAttrValue, paramsMap, jobName, messages);
        }
        autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("SAPJOBNAME", jobName));
    }

    private void handleCapchainCommand(HashMap<String, String> autoEditAttrNameAutoEditAttrValue, LinkedHashMap<String, String> paramsMap, String sapJobName, ArrayList<String> messages) {
        String sysnr = "";
        String userId = "";
        String destinatation = "";
        String config = "";
        for (String arg : paramsMap.keySet()) {
            String testVal = paramsMap.get(arg);
            if (testVal.equals("")) {
                Reporter.addMessage(messages, (String)"SAPW001", (String)sapJobName, (String[])new String[]{arg});
                continue;
            }
            String formattedArg = String.format("%s %s", arg, paramsMap.get(arg));
            Object resultArg = this.changeCapchainArgConvention(formattedArg);
            if (((String)resultArg).equals(formattedArg)) {
                resultArg = arg + "=" + paramsMap.get(arg);
            }
            String[] tmpArr = ((String)resultArg).split("=", 2);
            String name = tmpArr[0];
            name = name.toUpperCase();
            String value = tmpArr[1];
            if (name.equals("SYSNR")) {
                sysnr = value;
                continue;
            }
            if (name.equals("USER")) {
                userId = value;
                continue;
            }
            if (name.equals("DESTINATION")) {
                destinatation = value;
                continue;
            }
            if (name.equals("CONFIG")) {
                config = value;
                continue;
            }
            if (name.equals("CHAINID")) {
                autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-ProcessChain_ID", value);
                continue;
            }
            Reporter.addMessage(messages, (String)"SAPW001", (String)sapJobName, (String[])new String[]{arg});
        }
        ArrayList<String> accountParams = new ArrayList<String>();
        accountParams.add(sysnr);
        accountParams.add(userId);
        accountParams.add(destinatation);
        accountParams.add(config);
        StringBuilder sb = new StringBuilder();
        for (String prm : accountParams) {
            sb.append(String.format("%s", prm));
            if (prm.isEmpty()) continue;
            sb.append("_");
        }
        if (!sb.toString().isEmpty()) {
            int index = sb.lastIndexOf("_");
            sb.deleteCharAt(index);
        }
        if (!sb.toString().isEmpty()) {
            autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-ACCOUNT", sb.toString());
        } else {
            autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-ACCOUNT", "SAP_ACCOUNT");
            Reporter.addMessage(messages, (String)"SAPI002", (String)sapJobName, (String[])new String[]{autoEditAttrNameAutoEditAttrValue.get("%%SAPR3-ACCOUNT")});
        }
    }

    private String changeCapchainArgConvention(String arg) {
        arg = arg.replaceAll("\\s*\\+C\\s*\\s+(.*?)\\s*", "CONFIG=$1").trim();
        arg = arg.replaceAll("\\s*-n\\s*\\s+(.*?)\\s*", "CHAINID=$1").trim();
        arg = arg.replaceAll("\\s*-d\\s*\\s+(.*?)\\s*", "DESTINATION=$1").trim();
        arg = arg.replaceAll("\\s*-y\\s*\\s+(.*?)\\s*", "SYSNR=$1").trim();
        arg = arg.replaceAll("\\s*-u\\s*\\s+(.*?)\\s*", "USER=$1").trim();
        return arg;
    }

    private void handleSapJobCommand(HashMap<String, String> autoEditAttrNameAutoEditAttrValue, LinkedHashMap<String, String> paramsMap, String sapJobName, ArrayList<String> messages) {
        String jobUser = "";
        String sysnr = "";
        int currentStep = 0;
        for (String arg : paramsMap.keySet()) {
            String testVal = paramsMap.get(arg);
            if (testVal.equals("")) {
                Reporter.addMessage(messages, (String)"SAPW001", (String)sapJobName, (String[])new String[]{arg});
                continue;
            }
            String formattedArg = String.format("%s %s", arg, paramsMap.get(arg));
            Object resultArg = this.changeSapjobArgConvention(formattedArg);
            if (((String)resultArg).equals(formattedArg)) {
                resultArg = arg + "=" + paramsMap.get(arg);
            }
            String[] tmpArr = ((String)resultArg).split("=", 2);
            String name = tmpArr[0];
            name = name.toUpperCase();
            String value = tmpArr[1];
            if (name.equals("AUTHORITY")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_AUTH", currentStep), value);
                continue;
            }
            if (name.equals("COPIES")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_COPIES", currentStep), value);
                continue;
            }
            if (name.equals("COVER")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_BANNER", currentStep), value);
                continue;
            }
            if (name.equals("DEPARTMENT")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-DEPT", currentStep), value);
                continue;
            }
            if (name.equals("EXPIRATION")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_EXPIRATION", currentStep), value);
                continue;
            }
            if (name.matches("REPORT[0-9]*")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-PROGRAM", ++currentStep), value);
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-STEP_TYPE", currentStep), "A");
                continue;
            }
            if (name.equals("EXTPGM_NAME")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-PROGRAM", ++currentStep), value);
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-STEP_TYPE", currentStep), "C");
                continue;
            }
            if (name.equals("EXTPGM_SYSTEM")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-TARGET_HOST", currentStep), value);
                continue;
            }
            if (name.equals("EXTPGM_PARAM")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-VAR-NAME", currentStep), value);
                continue;
            }
            if (name.equals("IMMEDIATELY")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_IMMED", currentStep), value);
                continue;
            }
            if (name.equals("LINE_COUNT")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_NUMLINES", currentStep), value);
                continue;
            }
            if (name.equals("LINE_SIZE")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S01-PRINT_NUMCOLUMNS", currentStep), value);
                continue;
            }
            if (name.equals("PDEST")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_DEST", currentStep), value);
                continue;
            }
            if (name.equals("RECEIVER")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_RECIPIENT", currentStep), value);
                continue;
            }
            if (name.equals("RELEASE")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_RELEASE", currentStep), value);
                continue;
            }
            if (name.equals("SPOOLNAME")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-LIST_NAME", currentStep), value);
                continue;
            }
            if (name.equals("TITLE")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-LIST_TEXT", currentStep), value);
                continue;
            }
            if (name.matches("VARIANT[0-9]*")) {
                autoEditAttrNameAutoEditAttrValue.put(String.format("%%%%SAPR3-STEP-S%02d-VAR-NAME", currentStep), value);
                continue;
            }
            if (name.equals("DESTINATION") || name.equals("HOSTNAME")) {
                autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-TARGET_SERVER", value);
                continue;
            }
            if (name.equals("JOBCLASS")) {
                autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-JOBCLASS", value);
                continue;
            }
            if (name.equals("JOBNAME")) {
                value = FieldValidation.instance().validateAndReturnFixedValue("SAPJOBNAME", value);
                autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-JOBNAME", value);
                continue;
            }
            if (name.equals("START")) {
                autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-SUBMIT_ASAP", value);
                continue;
            }
            if (name.equals("JOBUSER")) {
                jobUser = value;
                continue;
            }
            if (name.equals("SYSNR")) {
                sysnr = value;
                continue;
            }
            if (name.equals("CLIENT") || name.equals("DESTINATION") || name.equals("GATEWAYHOST") || name.equals("GATEWAYSERVICE") || name.equals("LANGUAGE")) continue;
            Reporter.addMessage(messages, (String)"SAPW001", (String)sapJobName, (String[])new String[]{resultArg});
        }
        if (!sysnr.isEmpty() && !jobUser.isEmpty()) {
            autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-ACCOUNT", String.format("%s_%s", jobUser, sysnr));
        } else {
            autoEditAttrNameAutoEditAttrValue.put("%%SAPR3-ACCOUNT", "SAP_ACCOUNT");
            Reporter.addMessage(messages, (String)"SAPI002", (String)sapJobName, (String[])new String[]{autoEditAttrNameAutoEditAttrValue.get("%%SAPR3-ACCOUNT"), jobUser.isEmpty() ? "JOBUSER" : "SYSNR"});
        }
    }

    private String changeSapjobArgConvention(String arg) {
        arg = arg.replaceAll("\\s*-r\\d*\\s*\\s+(.*?)\\s*", "REPORT=$1").trim();
        arg = arg.replaceAll("\\s*-v\\d*\\s*\\s+(.*?)\\s*", "VARIANT=$1").trim();
        arg = arg.replaceAll("\\s*-n\\s*\\s+(.*?)\\s*", "EXTPGM_NAME=$1").trim();
        arg = arg.replaceAll("\\s*-a\\s*\\s+(.*?)\\s*", "EXTPGM_PARAM=$1").trim();
        arg = arg.replaceAll("\\s*-4\\s*\\s+(.*?)\\s*", "JOBCLASS=$1").trim();
        arg = arg.replaceAll("\\s*-j\\s*\\s+(.*?)\\s*", "JOBUSER=$1").trim();
        arg = arg.replaceAll("\\s*-s\\s*\\s+(.*?)\\s*", "EXTPGM_SYSTEM=$1").trim();
        arg = arg.replaceAll("\\s*-d\\s*\\s+(.*?)\\s*", "DESTINATION=$1").trim();
        arg = arg.replaceAll("\\s*-u\\s*\\s+(.*?)\\s*", "USER=$1").trim();
        arg = arg.replaceAll("\\s*-m\\s*\\s+(.*?)\\s*", "CLIENT=$1").trim();
        arg = arg.replaceAll("\\s*-w\\s*\\s+(.*?)\\s*", "PASSWORD=$1").trim();
        arg = arg.replaceAll("\\s*-o\\s*\\s+(.*?)\\s*", "HOSTNAME=$1").trim();
        arg = arg.replaceAll("\\s*-y\\s*\\s+(.*?)\\s*", "SYSNR=$1").trim();
        arg = arg.replaceAll("\\s*-f\\s*\\s+(.*?)\\s*", "LANGUAGE=$1").trim();
        arg = arg.replaceAll("\\s*-g\\s*\\s+(.*?)\\s*", "GATEWAYSERVICE=$1").trim();
        arg = arg.replaceAll("\\s*-x\\s*\\s+(.*?)\\s*", "GATEWAYHOST=$1").trim();
        arg = arg.replaceAll("\\s*-b\\s*\\s+(.*?)\\s*", "TITLE=$1").trim();
        arg = arg.replaceAll("\\s*-c\\s*\\s+(.*?)\\s*", "COPIES=$1").trim();
        arg = arg.replaceAll("\\s*-e\\s*\\s+(.*?)\\s*", "EXPIRATION=$1").trim();
        arg = arg.replaceAll("\\s*-h\\s*\\s+(.*?)\\s*", "RELEASE=$1").trim();
        arg = arg.replaceAll("\\s*-I\\s*\\s+(.*?)\\s*", "IMMEDIATELY=$1").trim();
        arg = arg.replaceAll("\\s*-k\\s*\\s+(.*?)\\s*", "ARCMODE=$1").trim();
        arg = arg.replaceAll("\\s*-l\\s*\\s+(.*?)\\s*", "LAYOUT=$1").trim();
        arg = arg.replaceAll("\\s*-p\\s*\\s+(.*?)\\s*", "PDEST=$1").trim();
        arg = arg.replaceAll("\\s*-q\\s*\\s+(.*?)\\s*", "RECEIVER=$1").trim();
        arg = arg.replaceAll("\\s*-sn\\s*\\s+(.*?)\\s*", "SPOOLNAME=$1").trim();
        arg = arg.replaceAll("\\s*-t\\s*\\s+(.*?)\\s*", "LINE_COUNT=$1").trim();
        arg = arg.replaceAll("\\s*-z\\s*\\s+(.*?)\\s*", "LINE_SIZE=$1").trim();
        arg = arg.replaceAll("\\s*-0\\s*\\s+(.*?)\\s*", "PRIPARMS=$1").trim();
        arg = arg.replaceAll("\\s*-1\\s*\\s+(.*?)\\s*", "ARCINFO=$1").trim();
        arg = arg.replaceAll("\\s*-2\\s*\\s+(.*?)\\s*", "OBJECT=$1").trim();
        arg = arg.replaceAll("\\s*-3\\s*\\s+(.*?)\\s*", "SAPOBJECT=$1").trim();
        arg = arg.replaceAll("\\s*-5\\s*\\s+(.*?)\\s*", "AUTHORITY=$1").trim();
        arg = arg.replaceAll("\\s*-6\\s*\\s+(.*?)\\s*", "DEPARTMENT=$1").trim();
        arg = arg.replaceAll("\\s*-7\\s*\\s+(.*?)\\s*", "NEWSPOOL=$1").trim();
        arg = arg.replaceAll("\\s*-8\\s*\\s+(.*?)\\s*", "COVER=$1").trim();
        return arg;
    }
}

