/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.tng.TNGAssessmentCSVReader;
import com.bmc.ctmconvert.tng.TNGAssessmentCalendarTXTReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.tree.DefaultMutableTreeNode;

public class TNGAssessmentReport
extends AbstractAssessmentReport {
    private TNGAssessmentCSVReader m_SDReport;
    private TNGAssessmentCalendarTXTReader m_CalendarTXTReader;
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader;
    private static final String m_sJobs = "Jobs";
    private static final String m_sCalendarsInUse = "Calendars - In Use";
    private static final String m_sCalendarsDefined = "Calendars - Defined";
    private static final String m_sUsers = "Users";
    private static final String m_sStationsInUse = "Stations - In Use";
    private static final String m_sStationGroupsDefined = "Station Groups - Defined";
    private static final String m_sTriggerJobs = "Trigger Jobs";
    private static final String m_sUnsupportedAttributes = "Unsupported Attributes";
    private static final String m_sDates = "Dates";
    private static final String m_sRecommendedDateFormat = "Recommended Date Format";
    private static final String m_sSAPJobs = "SAP Jobs";
    private static final String m_sTandemJobs = "Tandem Jobs";
    private static final String m_sNA = "N\\A";
    private static final String m_sBoldPrefix = "<html><b>";
    private static final String m_sBoldSuffix = "</b></html>";
    private static final String m_sDarkBlue = "<FONT COLOR=\"#0000A0\" BGCOLOR=\"#ffffff\">";
    private static final String m_sDelimiter = " - ";
    private static final int m_LowMachinesThreshold = 25;
    private int m_iLowMachinesUse;
    private ArrayList<String> m_listNamesOflowMachinesUse;
    private String[] m_jobColumnHeaders;
    private String[] m_stationColumnHeaders;
    private HashMap<String, String> m_NodeName_EntityCount;
    private HashMap<String, String> m_NodeName_InfluenceCount;

    public TNGAssessmentReport(String pathName, String descriptionXMLFileName, String textCalendarFileName) {
        super(pathName, descriptionXMLFileName, textCalendarFileName);
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String textCalendarFileName) {
        this.m_NodeName_EntityCount = new HashMap();
        this.m_NodeName_InfluenceCount = new HashMap();
        this.m_iLowMachinesUse = 0;
        this.m_listNamesOflowMachinesUse = new ArrayList();
        String path = pathName.substring(0, pathName.lastIndexOf(Globs.DIRSEP) + Globs.DIRSEP.length());
        this.m_SDReport = new TNGAssessmentCSVReader(path);
        if (!textCalendarFileName.isEmpty()) {
            this.m_CalendarTXTReader = new TNGAssessmentCalendarTXTReader(textCalendarFileName);
        }
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
        this.m_jobColumnHeaders = this.m_SDReport.getJobColumnsHeaders();
        this.m_stationColumnHeaders = this.m_SDReport.getStationColumnsHeaders();
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        ArrayList<String> jobsListInStation;
        DefaultMutableTreeNode mainTreeNodes = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        DefaultMutableTreeNode mainJobsNode = new DefaultMutableTreeNode("Jobs(" + this.m_SDReport.getCRowsNumber() + ")");
        DefaultMutableTreeNode jobSetNode = null;
        DefaultMutableTreeNode jobInJobSetNode = null;
        DefaultMutableTreeNode mainCalendarsInUseNode = null;
        DefaultMutableTreeNode mainCalendarsDefinedNode = null;
        DefaultMutableTreeNode mainUsersNode = null;
        DefaultMutableTreeNode mainStationsNode = null;
        DefaultMutableTreeNode mainStationGroupsDefinedNode = null;
        DefaultMutableTreeNode stationGroupNode = null;
        DefaultMutableTreeNode mainTriggersNode = null;
        DefaultMutableTreeNode stationTriggerNode = null;
        DefaultMutableTreeNode mainSAPJobsNode = null;
        DefaultMutableTreeNode mainTandemJobsNode = null;
        DefaultMutableTreeNode mainUnsupportedAttributesNode = null;
        DefaultMutableTreeNode mainDatesNode = null;
        ArrayList<String> tempList = null;
        StringBuilder nodeName = new StringBuilder();
        tempList = this.m_SDReport.getAllJobSetsList();
        if (null != tempList) {
            Collections.sort(tempList);
            if (tempList.size() > 0) {
                ArrayList<String> jobsListInJobSet = null;
                Object jobName = "";
                for (String jobSet : tempList) {
                    jobsListInJobSet = this.m_SDReport.getJobsListOfJobSet(jobSet);
                    if (null != jobsListInJobSet) {
                        Collections.sort(jobsListInJobSet);
                        jobSetNode = new DefaultMutableTreeNode(jobSet + "(" + jobsListInJobSet.size() + ")");
                        for (String string : this.m_SDReport.getJobsListOfJobSet(jobSet)) {
                            jobName = string.substring(string.indexOf(m_sDelimiter) + m_sDelimiter.length(), string.length());
                            jobInJobSetNode = new DefaultMutableTreeNode(jobName);
                            jobSetNode.add(jobInJobSetNode);
                        }
                    } else {
                        jobSetNode = new DefaultMutableTreeNode(jobSet + "(0)");
                        jobSetNode.add(new DefaultMutableTreeNode(m_sNA));
                    }
                    mainJobsNode.add(jobSetNode);
                }
            }
        }
        this.m_NodeName_EntityCount.put(m_sJobs, Integer.toString(this.m_SDReport.getCRowsNumber()));
        this.m_NodeName_InfluenceCount.put(m_sJobs, Integer.toString(this.m_SDReport.getCRowsNumber()));
        ArrayList<String> allCalendars = null;
        if (null != this.m_CalendarTXTReader && null != (allCalendars = this.m_CalendarTXTReader.getAllCalendarsNames())) {
            Collections.sort(allCalendars);
            if (allCalendars.size() > 0) {
                mainCalendarsDefinedNode = new DefaultMutableTreeNode("Calendars - Defined(" + allCalendars.size() + ")");
                this.m_NodeName_EntityCount.put(m_sCalendarsDefined, Integer.toString(allCalendars.size()));
                for (String calName : allCalendars) {
                    mainCalendarsDefinedNode.add(new DefaultMutableTreeNode(calName));
                }
            }
        }
        if (null != (tempList = this.m_SDReport.getAllCalendarsList())) {
            Collections.sort(tempList);
            int iJobsInCals = 0;
            if (tempList.size() > 0) {
                ArrayList<String> jobsListInCalendar = null;
                mainCalendarsInUseNode = new DefaultMutableTreeNode("Calendars - In Use(" + tempList.size() + ")");
                this.m_NodeName_EntityCount.put(m_sCalendarsInUse, Integer.toString(tempList.size()));
                boolean bDefinedCal = false;
                for (String string : tempList) {
                    nodeName.delete(0, nodeName.length());
                    bDefinedCal = false;
                    if (null != allCalendars) {
                        bDefinedCal = allCalendars.contains(string);
                    }
                    if (bDefinedCal) {
                        nodeName.append(m_sBoldPrefix);
                    }
                    nodeName.append(string);
                    nodeName.append("(");
                    jobsListInCalendar = this.m_SDReport.getJobsListOfCalendar(string);
                    if (null != jobsListInCalendar) {
                        Collections.sort(jobsListInCalendar);
                        nodeName.append(this.m_SDReport.getJobsListOfCalendar(string).size());
                        iJobsInCals += this.m_SDReport.getJobsListOfCalendar(string).size();
                    } else {
                        nodeName.append("0");
                    }
                    nodeName.append(")");
                    if (bDefinedCal) {
                        nodeName.append(m_sBoldSuffix);
                    }
                    mainCalendarsInUseNode.add(new DefaultMutableTreeNode(nodeName.toString()));
                }
            }
            this.m_NodeName_InfluenceCount.put(m_sCalendarsInUse, Integer.toString(iJobsInCals));
        }
        if (null != (tempList = this.m_SDReport.getAllUsersList())) {
            int iJobsInUsers = 0;
            Collections.sort(tempList);
            if (tempList.size() > 0) {
                ArrayList<String> jobsListInUser = null;
                mainUsersNode = new DefaultMutableTreeNode("Users(" + tempList.size() + ")");
                this.m_NodeName_EntityCount.put(m_sUsers, Integer.toString(tempList.size()));
                for (String user : tempList) {
                    nodeName.delete(0, nodeName.length());
                    nodeName.append(user);
                    nodeName.append("(");
                    jobsListInUser = this.m_SDReport.getJobsListOfUser(user);
                    if (null != jobsListInUser) {
                        Collections.sort(jobsListInUser);
                        nodeName.append(this.m_SDReport.getJobsListOfUser(user).size());
                        iJobsInUsers += this.m_SDReport.getJobsListOfUser(user).size();
                    } else {
                        nodeName.append("0");
                    }
                    nodeName.append(")");
                    mainUsersNode.add(new DefaultMutableTreeNode(nodeName.toString()));
                }
            }
            this.m_NodeName_InfluenceCount.put(m_sUsers, Integer.toString(iJobsInUsers));
        }
        int sizeOfStationsAndGroupStation = 0;
        int iJobsInStations = 0;
        tempList = this.m_SDReport.getAllStationsList();
        ArrayList<String> stationGroupsList = this.m_SDReport.getAllStationGroupsList();
        if (null != tempList) {
            sizeOfStationsAndGroupStation += tempList.size();
        }
        if (null != stationGroupsList) {
            sizeOfStationsAndGroupStation += stationGroupsList.size();
        }
        if (null != tempList) {
            Collections.sort(tempList);
            if (tempList.size() > 0) {
                jobsListInStation = null;
                mainStationsNode = new DefaultMutableTreeNode("Stations - In Use(" + sizeOfStationsAndGroupStation + ")");
                this.m_NodeName_EntityCount.put(m_sStationsInUse, Integer.toString(sizeOfStationsAndGroupStation));
                for (String station : tempList) {
                    nodeName.delete(0, nodeName.length());
                    nodeName.append(station);
                    nodeName.append("(");
                    jobsListInStation = this.m_SDReport.getJobsListOfStation(station);
                    if (null != jobsListInStation) {
                        Collections.sort(jobsListInStation);
                        nodeName.append(this.m_SDReport.getJobsListOfStation(station).size());
                        iJobsInStations += this.m_SDReport.getJobsListOfStation(station).size();
                        if (this.m_SDReport.getJobsListOfStation(station).size() <= 25) {
                            this.m_listNamesOflowMachinesUse.add(station);
                            ++this.m_iLowMachinesUse;
                        }
                    } else {
                        nodeName.append("0");
                    }
                    nodeName.append(")");
                    mainStationsNode.add(new DefaultMutableTreeNode(nodeName.toString()));
                }
            }
        }
        if (null != stationGroupsList) {
            Collections.sort(stationGroupsList);
            if (stationGroupsList.size() > 0) {
                if (null == mainStationsNode) {
                    mainStationsNode = new DefaultMutableTreeNode("Stations - In Use(" + sizeOfStationsAndGroupStation + ")");
                }
                jobsListInStation = null;
                for (String station : stationGroupsList) {
                    nodeName.delete(0, nodeName.length());
                    nodeName.append(m_sBoldPrefix);
                    nodeName.append(m_sDarkBlue);
                    nodeName.append(station);
                    nodeName.append("(");
                    jobsListInStation = this.m_SDReport.getJobsListOfStation(station);
                    if (null != jobsListInStation) {
                        Collections.sort(jobsListInStation);
                        nodeName.append(this.m_SDReport.getJobsListOfStation(station).size());
                        iJobsInStations += this.m_SDReport.getJobsListOfStation(station).size();
                    } else {
                        nodeName.append("0");
                    }
                    nodeName.append(")");
                    nodeName.append(m_sBoldSuffix);
                    mainStationsNode.add(new DefaultMutableTreeNode(nodeName.toString()));
                }
            }
        }
        this.m_NodeName_InfluenceCount.put(m_sStationsInUse, Integer.toString(iJobsInStations));
        tempList = this.m_SDReport.getAllDefinedStatinGroups();
        if (null != tempList) {
            Collections.sort(tempList);
            int iStationsInStationGroups = 0;
            if (tempList.size() > 0) {
                Object var24_43 = null;
                mainStationGroupsDefinedNode = new DefaultMutableTreeNode("Station Groups - Defined(" + tempList.size() + ")");
                this.m_NodeName_EntityCount.put(m_sStationGroupsDefined, Integer.toString(tempList.size()));
                for (String stationGroup : tempList) {
                    ArrayList<String> arrayList = this.m_SDReport.getStationsListOfStationGroup(stationGroup);
                    if (null != arrayList) {
                        Collections.sort(arrayList);
                        stationGroupNode = new DefaultMutableTreeNode(stationGroup + "(" + arrayList.size() + ")");
                        iStationsInStationGroups += arrayList.size();
                        for (String station : this.m_SDReport.getStationsListOfStationGroup(stationGroup)) {
                            stationGroupNode.add(new DefaultMutableTreeNode(station));
                        }
                    } else {
                        stationGroupNode = new DefaultMutableTreeNode(stationGroup + "(0)");
                        stationGroupNode.add(new DefaultMutableTreeNode(m_sNA));
                    }
                    mainStationGroupsDefinedNode.add(stationGroupNode);
                }
            }
            this.m_NodeName_InfluenceCount.put(m_sStationGroupsDefined, Integer.toString(iStationsInStationGroups));
        }
        if (null != (tempList = this.m_SDReport.getAllStationsWithTriggersList())) {
            int iTriggers = 0;
            Collections.sort(tempList);
            if (tempList.size() > 0) {
                Object var24_47 = null;
                mainTriggersNode = new DefaultMutableTreeNode("Trigger Jobs(" + tempList.size() + ")");
                this.m_NodeName_EntityCount.put(m_sTriggerJobs, Integer.toString(tempList.size()));
                for (String station : tempList) {
                    ArrayList<String> arrayList = this.m_SDReport.getTriggersListOfStation(station);
                    if (null != arrayList) {
                        Collections.sort(arrayList);
                        stationTriggerNode = new DefaultMutableTreeNode(station + "(" + arrayList.size() + ")");
                        iTriggers += arrayList.size();
                        for (String triggerName : this.m_SDReport.getTriggersListOfStation(station)) {
                            stationTriggerNode.add(new DefaultMutableTreeNode(triggerName));
                        }
                    } else {
                        stationTriggerNode = new DefaultMutableTreeNode(station + "(0)");
                        stationTriggerNode.add(new DefaultMutableTreeNode(m_sNA));
                    }
                    mainTriggersNode.add(stationTriggerNode);
                }
            }
            this.m_NodeName_InfluenceCount.put(m_sTriggerJobs, Integer.toString(iTriggers));
        }
        if (null != (tempList = this.m_SDReport.getAllSAPJobsList())) {
            Collections.sort(tempList);
            if (tempList.size() > 0) {
                mainSAPJobsNode = new DefaultMutableTreeNode("SAP Jobs(" + tempList.size() + ")");
                this.m_NodeName_EntityCount.put(m_sSAPJobs, Integer.toString(tempList.size()));
                for (String string : tempList) {
                    mainSAPJobsNode.add(new DefaultMutableTreeNode(string));
                }
            }
        }
        if (null != (tempList = this.m_SDReport.getAllTandemJobsList())) {
            Collections.sort(tempList);
            if (tempList.size() > 0) {
                mainTandemJobsNode = new DefaultMutableTreeNode("Tandem Jobs(" + tempList.size() + ")");
                this.m_NodeName_EntityCount.put(m_sTandemJobs, Integer.toString(tempList.size()));
                for (String string : tempList) {
                    mainTandemJobsNode.add(new DefaultMutableTreeNode(string));
                }
            }
        }
        int sizeOfUnsupportedAttributes = 0;
        if (null != this.m_SDReport.getAllUnsupportedAttributesJobsList()) {
            sizeOfUnsupportedAttributes += this.m_SDReport.getAllUnsupportedAttributesJobsList().size();
        }
        if (null != this.m_SDReport.getAllUnsupportedAttributesJobSetsList()) {
            sizeOfUnsupportedAttributes += this.m_SDReport.getAllUnsupportedAttributesJobSetsList().size();
        }
        if (sizeOfUnsupportedAttributes > 0) {
            mainUnsupportedAttributesNode = new DefaultMutableTreeNode("Unsupported Attributes(" + sizeOfUnsupportedAttributes + ")");
            this.m_NodeName_EntityCount.put(m_sUnsupportedAttributes, Integer.toString(sizeOfUnsupportedAttributes));
            tempList = this.m_SDReport.getAllUnsupportedAttributesJobSetsList();
            if (null != tempList) {
                Collections.sort(tempList);
                if (tempList.size() > 0) {
                    Object var24_55 = null;
                    for (String attributeName : tempList) {
                        nodeName.delete(0, nodeName.length());
                        nodeName.append(attributeName);
                        nodeName.append("(");
                        ArrayList<String> arrayList = this.m_SDReport.getJobSetsListOfUnsupportedAttribute(attributeName);
                        if (null != arrayList) {
                            Collections.sort(arrayList);
                            nodeName.append(this.m_SDReport.getJobSetsListOfUnsupportedAttribute(attributeName).size());
                        } else {
                            nodeName.append("0");
                        }
                        nodeName.append(")");
                        mainUnsupportedAttributesNode.add(new DefaultMutableTreeNode(nodeName.toString()));
                    }
                }
            }
            if (null != (tempList = this.m_SDReport.getAllUnsupportedAttributesJobsList())) {
                Collections.sort(tempList);
                if (tempList.size() > 0) {
                    Object var24_59 = null;
                    for (String attributeName : tempList) {
                        nodeName.delete(0, nodeName.length());
                        nodeName.append(attributeName);
                        nodeName.append("(");
                        ArrayList<String> arrayList = this.m_SDReport.getJobsListOfUnsupportedAttribute(attributeName);
                        if (null != arrayList) {
                            Collections.sort(arrayList);
                            nodeName.append(this.m_SDReport.getJobsListOfUnsupportedAttribute(attributeName).size());
                        } else {
                            nodeName.append("0");
                        }
                        nodeName.append(")");
                        mainUnsupportedAttributesNode.add(new DefaultMutableTreeNode(nodeName.toString()));
                    }
                }
            }
        }
        Integer n = 1;
        mainDatesNode = new DefaultMutableTreeNode("Dates(" + n + ")");
        this.m_NodeName_EntityCount.put(m_sDates, Integer.toString(n));
        mainDatesNode.add(new DefaultMutableTreeNode(m_sRecommendedDateFormat.toString()));
        if (null != mainJobsNode) {
            mainTreeNodes.add(mainJobsNode);
        }
        if (null != mainCalendarsInUseNode) {
            mainTreeNodes.add(mainCalendarsInUseNode);
        }
        if (null != mainCalendarsDefinedNode) {
            mainTreeNodes.add(mainCalendarsDefinedNode);
        }
        if (null != mainUsersNode) {
            mainTreeNodes.add(mainUsersNode);
        }
        if (null != mainStationsNode) {
            mainTreeNodes.add(mainStationsNode);
        }
        if (null != mainStationGroupsDefinedNode) {
            mainTreeNodes.add(mainStationGroupsDefinedNode);
        }
        if (null != mainTriggersNode) {
            mainTreeNodes.add(mainTriggersNode);
        }
        if (null != mainSAPJobsNode) {
            mainTreeNodes.add(mainSAPJobsNode);
        }
        if (null != mainTandemJobsNode) {
            mainTreeNodes.add(mainTandemJobsNode);
        }
        if (null != mainUnsupportedAttributesNode) {
            mainTreeNodes.add(mainUnsupportedAttributesNode);
        }
        if (null != mainDatesNode) {
            mainTreeNodes.add(mainDatesNode);
        }
        return mainTreeNodes;
    }

    protected String getJobInfo(String messageID) {
        StringBuilder formatedData = new StringBuilder();
        String[] messagePartArray = messageID.split(";");
        String jobsPrefix = Params.instance().getDatasourceName() + ";Jobs";
        String calendarsPrefix = Params.instance().getDatasourceName() + ";Calendars - Defined";
        String stationGroupsPrefix = Params.instance().getDatasourceName() + ";Station Groups - Defined";
        String triggerPrefix = Params.instance().getDatasourceName() + ";Trigger Jobs";
        String sapJobPrefix = Params.instance().getDatasourceName() + ";SAP Jobs";
        String tandemJobPrefix = Params.instance().getDatasourceName() + ";Tandem Jobs";
        if (messagePartArray.length == 3) {
            if (messageID.startsWith(jobsPrefix)) {
                String jobSetName = messagePartArray[2].split("\\(")[0];
                String[] jobSetHeader = this.m_SDReport.getJobSetColumnsHeaders();
                String rowInfo = "NULL";
                ArrayList<String> jobInfoList = this.m_SDReport.getJobSetInfo(jobSetName);
                if (null != jobInfoList && jobInfoList.size() > 0) {
                    for (int i = 1; i < jobSetHeader.length; ++i) {
                        rowInfo = jobInfoList.get(i);
                        if (rowInfo.equalsIgnoreCase("NULL")) continue;
                        formatedData.append(jobSetHeader[i]);
                        formatedData.append(" : ");
                        formatedData.append(rowInfo);
                        formatedData.append(this.m_newline);
                    }
                }
                return formatedData.toString();
            }
            if (messageID.startsWith(calendarsPrefix)) {
                return this.m_CalendarTXTReader.getCalendarDescription(messagePartArray[2]);
            }
            if (messageID.startsWith(sapJobPrefix)) {
                String jobInfo = this.getJobInfoFromSelectionList(messagePartArray[2]) + this.m_newline + this.m_SDReport.getJobCommand(messagePartArray[2]);
                return jobInfo;
            }
            if (messageID.startsWith(tandemJobPrefix)) {
                String jobInfo = this.getJobInfoFromSelectionList(messagePartArray[2]) + this.m_newline + "PROGNAME: " + this.m_SDReport.getJobProgname(messagePartArray[2]) + this.m_newline + "IN: " + this.m_SDReport.getJobIn(messagePartArray[2]);
                return jobInfo;
            }
        } else if (messagePartArray.length == 4) {
            if (messageID.startsWith(jobsPrefix)) {
                StringBuilder jobID = new StringBuilder();
                jobID.append(messagePartArray[2].split("\\(")[0]);
                jobID.append(m_sDelimiter);
                jobID.append(messagePartArray[3]);
                return this.getJobInfoFromSelectionList(jobID.toString());
            }
            if (messageID.startsWith(stationGroupsPrefix)) {
                ArrayList<String> stationInfoList = this.m_SDReport.getStationInfo(messagePartArray[3]);
                if (null != stationInfoList) {
                    String rowInfo = "NULL";
                    for (int i = 1; i < this.m_stationColumnHeaders.length; ++i) {
                        rowInfo = stationInfoList.get(i);
                        if (rowInfo.equalsIgnoreCase("NULL")) continue;
                        formatedData.append(this.m_stationColumnHeaders[i]);
                        formatedData.append(" : ");
                        formatedData.append(rowInfo);
                        formatedData.append(this.m_newline);
                    }
                }
            } else if (messageID.startsWith(triggerPrefix)) {
                String triggerInfo = this.m_SDReport.getTriggerInfo(messagePartArray[3]);
                triggerInfo = triggerInfo.replaceAll(";", this.m_newline);
                return triggerInfo;
            }
        }
        return formatedData.toString();
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(Params.instance().getDatasourceName());
        result.add(m_sNA);
        result.add(m_sJobs);
        result.add(m_sCalendarsDefined);
        result.add(m_sStationGroupsDefined);
        result.add(m_sTriggerJobs);
        result.add(m_sSAPJobs);
        result.add(m_sTandemJobs);
        return result;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        return null;
    }

    protected ArrayList<String> getSelectionList(String messageID) {
        String[] msgParams = messageID.split(";");
        String parentNodeName = msgParams[1].split("\\(")[0];
        String nodeName = msgParams[msgParams.length - 1].split("\\(")[0];
        if (nodeName.startsWith(m_sBoldPrefix)) {
            nodeName = nodeName.replaceAll(m_sBoldPrefix, "");
            nodeName = nodeName.replaceAll(m_sDarkBlue, "");
        }
        if (parentNodeName.equalsIgnoreCase(m_sCalendarsInUse)) {
            return this.m_SDReport.getJobsListOfCalendar(nodeName);
        }
        if (parentNodeName.equalsIgnoreCase(m_sUsers)) {
            return this.m_SDReport.getJobsListOfUser(nodeName);
        }
        if (parentNodeName.equalsIgnoreCase(m_sStationsInUse)) {
            return this.m_SDReport.getJobsListOfStation(nodeName);
        }
        if (parentNodeName.equalsIgnoreCase(m_sUnsupportedAttributes)) {
            if (messageID.contains(TNGAssessmentCSVReader.m_sJob)) {
                return this.m_SDReport.getJobsListOfUnsupportedAttribute(nodeName);
            }
            return this.m_SDReport.getJobSetsListOfUnsupportedAttribute(nodeName);
        }
        if (parentNodeName.equalsIgnoreCase(m_sDates)) {
            if (nodeName.equalsIgnoreCase(m_sRecommendedDateFormat)) {
                ArrayList<String> tempList = new ArrayList<String>();
                tempList.add(this.m_SDReport.getRecommendedDateFormat());
                return tempList;
            }
            return null;
        }
        return null;
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        StringBuilder formatedData = new StringBuilder();
        String rowInfo = "NULL";
        if (messageID.split(m_sDelimiter).length == 3) {
            ArrayList<String> jobInfoList = this.m_SDReport.getJobInfo(messageID);
            if (null != jobInfoList) {
                for (int i = 1; i < this.m_jobColumnHeaders.length; ++i) {
                    rowInfo = jobInfoList.get(i);
                    if (rowInfo.equalsIgnoreCase("NULL")) continue;
                    formatedData.append(this.m_jobColumnHeaders[i]);
                    formatedData.append(" : ");
                    formatedData.append(rowInfo);
                    formatedData.append(this.m_newline);
                }
            }
        } else {
            return this.getJobInfo(Params.instance().getDatasourceName() + ";Jobs(0);" + messageID);
        }
        return formatedData.toString();
    }

    protected HashMap<String, String> getDescriptionNodes() {
        String sMainSummary;
        LinkedHashMap descriptionMap_NodeName_NodeDesc = this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
        StringBuilder mainSummary = new StringBuilder();
        mainSummary.append("Summary:");
        mainSummary.append(this.m_newline);
        mainSummary.append(this.m_newline);
        String extraSummary = null;
        for (String nodeName : descriptionMap_NodeName_NodeDesc.keySet()) {
            if (this.m_DescriptionXMLReader.isAutoBuildMainSummary() && nodeName.compareToIgnoreCase("MainSummary") != 0) {
                if (nodeName.compareToIgnoreCase("ExtraSummary") == 0) {
                    extraSummary = (String)descriptionMap_NodeName_NodeDesc.get(nodeName);
                } else {
                    mainSummary.append(nodeName);
                    mainSummary.append(this.m_newline);
                    mainSummary.append(this.evaluateDescriptionParameters(nodeName, (String)descriptionMap_NodeName_NodeDesc.get(nodeName)));
                    mainSummary.append(this.m_newline);
                    mainSummary.append(this.m_newline);
                }
            }
            descriptionMap_NodeName_NodeDesc.put(nodeName, this.evaluateDescriptionParameters(nodeName, (String)descriptionMap_NodeName_NodeDesc.get(nodeName)));
        }
        if (null != extraSummary) {
            mainSummary.append("ExtraSummary");
            mainSummary.append(this.m_newline);
            mainSummary.append(this.evaluateDescriptionParameters("ExtraSummary", extraSummary));
            mainSummary.append(this.m_newline);
            mainSummary.append(this.m_newline);
        }
        if (!this.m_DescriptionXMLReader.isAutoBuildMainSummary() && null != (sMainSummary = (String)descriptionMap_NodeName_NodeDesc.get("MainSummary"))) {
            mainSummary.append(sMainSummary);
            String sExtraSummary = (String)descriptionMap_NodeName_NodeDesc.get("ExtraSummary");
            if (null != sExtraSummary) {
                mainSummary.append(this.m_newline);
                mainSummary.append(this.m_newline);
                mainSummary.append("ExtraSummary");
                mainSummary.append(this.m_newline);
                mainSummary.append(this.evaluateDescriptionParameters("ExtraSummary", sExtraSummary));
                mainSummary.append(this.m_newline);
            }
        }
        descriptionMap_NodeName_NodeDesc.put(Params.instance().getDatasourceName(), mainSummary.toString());
        return descriptionMap_NodeName_NodeDesc;
    }

    public String evaluateDescriptionParameters(String sNodeName, String sDescription) {
        if (!sDescription.contains("#")) {
            return sDescription;
        }
        sDescription = sDescription.replaceAll("#ENV_NAME#", Params.instance().getDatasourceName());
        sDescription = sDescription.replaceAll("#NUM_LOW_USED_MACHINES#", Integer.toString(this.m_iLowMachinesUse));
        sDescription = sDescription.replaceAll("#NUM_TABLES#", Integer.toString(this.m_SDReport.getAllJobSetsList().size()));
        sDescription = sDescription.replaceAll("#DATE_FORMAT#", this.m_SDReport.getRecommendedDateFormat());
        String sNum = null;
        sNum = this.m_NodeName_EntityCount.get(sNodeName);
        if (null == sNum) {
            sNum = "0";
        }
        sDescription = sDescription.replaceAll("#NUM_ENTITIES#", sNum);
        sNum = this.m_NodeName_InfluenceCount.get(sNodeName);
        if (null == sNum) {
            sNum = "0";
        }
        if ((sDescription = sDescription.replaceAll("#NUM_INFL_JOB#", sNum)).contains("#NUM_LOW_USED_MACHINES_LIST#")) {
            StringBuilder machinesList = new StringBuilder();
            for (String machine : this.m_listNamesOflowMachinesUse) {
                machinesList.append(machine);
                machinesList.append(this.m_newline);
            }
            sDescription = sDescription.replaceAll("#NUM_LOW_USED_MACHINES_LIST#", machinesList.toString());
        }
        return sDescription;
    }
}

