/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TNGAssessmentCalendarTXTReader {
    private static String CALENDAR_DECLARATION = "define cal";
    private HashMap<String, String> m_CalendarID_CalendarDescription = new HashMap();

    public TNGAssessmentCalendarTXTReader(String sourceFile) {
        this.readCalendars(sourceFile);
    }

    public ArrayList<String> getAllCalendarsNames() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String jobID : this.m_CalendarID_CalendarDescription.keySet()) {
            resultList.add(jobID);
        }
        return resultList;
    }

    public String getCalendarDescription(String calendarName) {
        if (null != this.m_CalendarID_CalendarDescription) {
            return this.m_CalendarID_CalendarDescription.get(calendarName);
        }
        return "";
    }

    private void readCalendars(String sourceFile) {
        try {
            FileInputStream sourceStream = new FileInputStream(sourceFile);
            Scanner sourceScanner = new Scanner(sourceStream);
            String currId = null;
            String currSet = null;
            String currDesc = null;
            Pattern pattern = Pattern.compile("(.*)(id|set|desc)=(.*)");
            while (sourceScanner.hasNext()) {
                String line = sourceScanner.nextLine().trim();
                if (line.toLowerCase().contains(CALENDAR_DECLARATION)) {
                    if (currId != null && currSet != null) {
                        this.m_CalendarID_CalendarDescription.put(currId, currDesc);
                    }
                    currId = null;
                    currSet = null;
                    currDesc = null;
                }
                Matcher matcher = pattern.matcher(line);
                while (matcher.matches()) {
                    line = matcher.group(1).trim();
                    String key = matcher.group(2).trim();
                    String value = matcher.group(3).trim();
                    matcher = pattern.matcher(line);
                    if (value.startsWith("\"") || value.startsWith("'") || value.startsWith("(")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    if (key.equalsIgnoreCase("id")) {
                        currId = value;
                    }
                    if (key.equalsIgnoreCase("set")) {
                        currSet = value;
                    }
                    if (!key.equalsIgnoreCase("desc")) continue;
                    currDesc = value;
                }
            }
            if (currId != null && currSet != null) {
                this.m_CalendarID_CalendarDescription.put(currId, currDesc);
            }
            sourceStream.close();
            sourceScanner.close();
        }
        catch (IOException ioe) {
            ExceptionHandler.writeToExceptionFile((Exception)ioe);
        }
    }
}

