/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.tng.TngGlobals;
import com.bmc.ctmconvert.tng.TngLineToMap;
import com.csvreader.CsvWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TNG2CSV {
    private File m_tngFile = null;
    private String m_path;
    private File m_station = null;
    private File m_stationGroup = null;
    private File m_resource = null;
    private File m_jobset = null;
    private File m_jobsetPred = null;
    private File m_jobsetRes = null;
    private File m_job = null;
    private File m_jobPred = null;
    private File m_jobRes = null;
    private File m_jobParm = null;
    private File m_trigger = null;
    private ArrayList<HashMap<String, String>> m_stationAttributes = null;
    private ArrayList<HashMap<String, String>> m_stationGroupAttributes = null;
    private ArrayList<HashMap<String, String>> m_resourceAttributes = null;
    private ArrayList<HashMap<String, String>> m_jobsetresAttributes = null;
    private ArrayList<HashMap<String, String>> m_jobsetAttributes = null;
    private ArrayList<HashMap<String, String>> m_jobsetPredAttributes = null;
    private ArrayList<HashMap<String, String>> m_jobAttributes = null;
    private ArrayList<HashMap<String, String>> m_jobPredAttributes = null;
    private ArrayList<HashMap<String, String>> m_jobresAttributes = null;
    private ArrayList<HashMap<String, String>> m_jobParmAttributes = null;
    private ArrayList<HashMap<String, String>> m_triggerAttributes = null;
    private String startingNewEntityToken = "DEFINE";
    private HashMap<String, String> m_lastUpdatedHM = null;
    private String m_lastUpdatedAttributes;
    private BaseProgressBar m_progressBar;
    private int totalEntries;
    private TngLineToMap tngLineToMap;

    public TNG2CSV(File tngFile, String path, BaseProgressBar pb) throws TNGException {
        this.m_path = path;
        if (pb != null) {
            this.m_progressBar = pb;
        }
        if (tngFile == null) {
            throw new TNGException("Error with reading cauexpr.txt file.");
        }
        if (!tngFile.exists()) {
            throw new TNGException("The file: \"cauexpr.txt\" does not exist.");
        }
        this.m_tngFile = tngFile;
        this.tngLineToMap = new TngLineToMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean convert2CSV() throws ConvertorCancelClickException {
        this.initAttributesAL();
        BufferedReader in = new BufferedReader(new FileReader(this.m_tngFile));
        String line = null;
        if (this.m_progressBar != null) {
            this.totalEntries = GlobalFunctions.getHowManyWords((File)this.m_tngFile, (String)this.startingNewEntityToken);
            this.m_progressBar.setProgressMax(this.totalEntries);
        }
        int entitiesCounter = 0;
        while ((line = in.readLine()) != null) {
            if (this.m_progressBar != null && this.m_progressBar.isCancelled()) {
                in.close();
                throw new ConvertorCancelClickException();
            }
            if (line.equals("")) continue;
            if (line.trim().startsWith(this.startingNewEntityToken) || this.isLineStartsWithEntityName(line.trim())) {
                if (this.m_progressBar != null) {
                    this.m_progressBar.setProgressValue(entitiesCounter);
                }
                this.handleLine(line);
            } else {
                if (this.m_progressBar != null) {
                    this.m_progressBar.setProgressValue(entitiesCounter);
                }
                this.tngLineToMap.updateHashMap(this.m_lastUpdatedAttributes, this.m_lastUpdatedHM, line.trim());
            }
            ++entitiesCounter;
        }
        this.initCSVFiles();
        try {
            this.createCsv();
            if (in == null) return true;
        }
        catch (ConvertorCancelClickException e) {
            boolean bl;
            try {
                ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
                bl = false;
                if (in == null) return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    ExceptionHandler.writeToExceptionFile((Exception)e2);
                    return false;
                }
            }
            in.close();
            return bl;
        }
        in.close();
        return true;
    }

    private boolean isLineStartsWithEntityName(String line) {
        for (String entityName : TngGlobals.ENTITIES_ATTR) {
            if (!line.startsWith(entityName)) continue;
            return true;
        }
        return false;
    }

    private void initCSVFiles() {
        this.m_station = new File(this.m_path + "STATION.csv");
        this.m_stationGroup = new File(this.m_path + "STATIONGROUP.csv");
        this.m_resource = new File(this.m_path + "RESOURCE.csv");
        this.m_jobset = new File(this.m_path + "JOBSET.csv");
        this.m_jobsetPred = new File(this.m_path + "JOBSETPRED.csv");
        this.m_jobsetRes = new File(this.m_path + "JOBSETRES.csv");
        this.m_job = new File(this.m_path + "JOB.csv");
        this.m_jobPred = new File(this.m_path + "JOBPRED.csv");
        this.m_jobRes = new File(this.m_path + "JOBRES.csv");
        this.m_jobParm = new File(this.m_path + "JOBPARM.csv");
        this.m_trigger = new File(this.m_path + "TRIGGER.csv");
    }

    private void initAttributesAL() {
        this.m_stationAttributes = new ArrayList();
        this.m_stationGroupAttributes = new ArrayList();
        this.m_resourceAttributes = new ArrayList();
        this.m_jobsetresAttributes = new ArrayList();
        this.m_jobsetAttributes = new ArrayList();
        this.m_jobsetPredAttributes = new ArrayList();
        this.m_jobAttributes = new ArrayList();
        this.m_jobPredAttributes = new ArrayList();
        this.m_jobresAttributes = new ArrayList();
        this.m_jobParmAttributes = new ArrayList();
        this.m_triggerAttributes = new ArrayList();
    }

    private void createCsv() throws ConvertorCancelClickException {
        this.createCsvFile(this.m_station, this.m_stationAttributes, TngGlobals.STATION_ATTRIBUTES);
        this.createCsvFile(this.m_stationGroup, this.m_stationGroupAttributes, TngGlobals.STATION_GROUP_ATTRIBUTES);
        this.createCsvFile(this.m_resource, this.m_resourceAttributes, TngGlobals.RESOURCE_ATTRIBUTES);
        this.createCsvFile(this.m_jobsetRes, this.m_jobsetresAttributes, TngGlobals.JOBSETRES_ATTRIBUTES);
        this.createCsvFile(this.m_jobset, this.m_jobsetAttributes, TngGlobals.JOBSET_ATTRIBUTES);
        this.createCsvFile(this.m_jobsetPred, this.m_jobsetPredAttributes, TngGlobals.JOBSETPRED_ATTRIBUTES);
        this.createCsvFile(this.m_job, this.m_jobAttributes, TngGlobals.JOB_ATTRIBUTES);
        this.createCsvFile(this.m_jobPred, this.m_jobPredAttributes, TngGlobals.JOBPRED_ATTRIBUTES);
        this.createCsvFile(this.m_jobRes, this.m_jobresAttributes, TngGlobals.JOBRES_ATTRIBUTES);
        String[] jobParmArr = this.prepareJOBParmHeader();
        this.updateJobParmAttributes();
        this.createCsvFile(this.m_jobParm, this.m_jobParmAttributes, jobParmArr);
        this.createCsvFile(this.m_trigger, this.m_triggerAttributes, TngGlobals.TRIGGER_ATTRIBUTES);
    }

    private void updateJobParmAttributes() {
        for (HashMap<String, String> tmpHM : this.m_jobParmAttributes) {
            String key = "NUMPARM";
            tmpHM.put(key, this.getNumOfParams(tmpHM));
        }
    }

    private String getNumOfParams(HashMap<String, String> tmpHM) {
        Integer numOfParams = 0;
        for (String key : tmpHM.keySet()) {
            String parm;
            int parmNum;
            String regexp;
            Pattern p;
            Matcher m;
            if (!key.contains("PARM") || !(m = (p = Pattern.compile(regexp = "PARM([0-9]+)")).matcher(key)).matches() || (parmNum = Integer.parseInt(parm = m.group(1))) <= numOfParams) continue;
            numOfParams = parmNum;
        }
        return numOfParams.toString();
    }

    private String[] prepareJOBParmHeader() {
        int i;
        int maxParm = 0;
        for (HashMap<String, String> tmpHM : this.m_jobParmAttributes) {
            for (String key : tmpHM.keySet()) {
                String parm;
                int parmNum;
                String regexp;
                Pattern p;
                Matcher m;
                if (!key.contains("PARM") || !(m = (p = Pattern.compile(regexp = "PARM([0-9]+)")).matcher(key)).matches() || (parmNum = Integer.parseInt(parm = m.group(1))) <= maxParm) continue;
                maxParm = parmNum;
            }
        }
        ArrayList<String> tmpArr = new ArrayList<String>();
        for (i = 0; i < TngGlobals.JOBPARM_ATTRIBUTES.length; ++i) {
            tmpArr.add(TngGlobals.JOBPARM_ATTRIBUTES[i]);
        }
        for (i = 1; i <= maxParm; ++i) {
            tmpArr.add(String.format("PARM%d", i));
        }
        String[] str = new String[tmpArr.size()];
        tmpArr.toArray(str);
        return str;
    }

    private void createCsvFile(File file, ArrayList<HashMap<String, String>> al, String[] header) throws ConvertorCancelClickException {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            CsvWriter csvWriter = new CsvWriter(file.toString());
            csvWriter.writeRecord(header);
            for (int i = 0; i < al.size(); ++i) {
                if (this.m_progressBar != null && this.m_progressBar.isCancelled()) {
                    throw new ConvertorCancelClickException();
                }
                String[] record = new String[header.length];
                for (int j = 0; j < header.length; ++j) {
                    String key = header[j];
                    String value = al.get(i).get(key);
                    if (value == null) {
                        value = "NULL";
                    }
                    if (((value = value.trim()).startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"")) && value.length() > 1) {
                        value = value.substring(1, value.length() - 1);
                    }
                    record[j] = value;
                }
                csvWriter.writeRecord(record);
            }
            csvWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleLine(String line) {
        String type = (line = line.replaceFirst(this.startingNewEntityToken, "").trim()).substring(0, line.indexOf(32));
        if (type.equalsIgnoreCase("STATION")) {
            this.m_lastUpdatedAttributes = GlobalFunctions.getOneStringWithSeparator((String[])TngGlobals.STATION_ATTRIBUTES, (char)'|');
            this.m_stationAttributes.add(this.tngLineToMap.handleLine("STATION", this.m_lastUpdatedAttributes, line));
            this.m_lastUpdatedHM = this.m_stationAttributes.get(this.m_stationAttributes.size() - 1);
            this.handleStationLine();
        } else if (type.equalsIgnoreCase("STATIONGROUP")) {
            this.m_lastUpdatedAttributes = GlobalFunctions.getOneStringWithSeparator((String[])TngGlobals.STATION_GROUP_ATTRIBUTES, (char)'|');
            this.m_stationGroupAttributes.add(this.tngLineToMap.handleLine("STATIONGROUP", this.m_lastUpdatedAttributes, line));
            this.m_lastUpdatedHM = this.m_stationGroupAttributes.get(this.m_stationGroupAttributes.size() - 1);
            this.handleStationGroupLine();
        } else if (type.equalsIgnoreCase("RESOURCE")) {
            this.m_lastUpdatedAttributes = GlobalFunctions.getOneStringWithSeparator((String[])TngGlobals.RESOURCE_ATTRIBUTES, (char)'|');
            this.m_resourceAttributes.add(this.tngLineToMap.handleLine("RESOURCE", this.m_lastUpdatedAttributes, line));
            this.m_lastUpdatedHM = this.m_resourceAttributes.get(this.m_resourceAttributes.size() - 1);
            this.handleResourceLine();
        } else if (type.equalsIgnoreCase("JOBSETRES")) {
            this.m_lastUpdatedAttributes = GlobalFunctions.getOneStringWithSeparator((String[])TngGlobals.JOBSETRES_ATTRIBUTES, (char)'|');
            this.m_jobsetresAttributes.add(this.tngLineToMap.handleLine("JOBSETRES", this.m_lastUpdatedAttributes, line));
            this.m_lastUpdatedHM = this.m_jobsetresAttributes.get(this.m_jobsetresAttributes.size() - 1);
            this.handleJobSetResLine();
        } else if (type.equalsIgnoreCase("JOBSET")) {
            this.m_lastUpdatedAttributes = GlobalFunctions.getOneStringWithSeparator((String[])TngGlobals.JOBSET_ATTRIBUTES, (char)'|');
            this.m_jobsetAttributes.add(this.tngLineToMap.handleLine("JOBSET", this.m_lastUpdatedAttributes, line));
            this.m_lastUpdatedHM = this.m_jobsetAttributes.get(this.m_jobsetAttributes.size() - 1);
            this.handleJobSetLine();
        } else if (type.equalsIgnoreCase("JOBSETPRED")) {
            this.m_lastUpdatedAttributes = GlobalFunctions.getOneStringWithSeparator((String[])TngGlobals.JOBSETPRED_ATTRIBUTES, (char)'|');
            this.m_jobsetPredAttributes.add(this.tngLineToMap.handleLine("JOBSETPRED", "^" + this.m_lastUpdatedAttributes, line));
            this.m_lastUpdatedHM = this.m_jobsetPredAttributes.get(this.m_jobsetPredAttributes.size() - 1);
            this.handleJobSetLine();
        } else if (type.equalsIgnoreCase("JOB")) {
            this.m_lastUpdatedAttributes = GlobalFunctions.getOneStringWithSeparator((String[])TngGlobals.JOB_ATTRIBUTES, (char)'|');
            this.m_jobAttributes.add(this.tngLineToMap.handleLine("JOB", this.m_lastUpdatedAttributes, line));
            this.m_lastUpdatedHM = this.m_jobAttributes.get(this.m_jobAttributes.size() - 1);
            this.handleJobLine();
        } else if (type.equalsIgnoreCase("JOBPRED")) {
            this.m_lastUpdatedAttributes = GlobalFunctions.getOneStringWithSeparator((String[])TngGlobals.JOBPRED_ATTRIBUTES, (char)'|');
            this.m_jobPredAttributes.add(this.tngLineToMap.handleLine("JOBPRED", "^" + this.m_lastUpdatedAttributes, line));
            this.m_lastUpdatedHM = this.m_jobPredAttributes.get(this.m_jobPredAttributes.size() - 1);
            this.handleJobLine();
        } else if (type.equalsIgnoreCase("JOBRES")) {
            this.m_lastUpdatedAttributes = GlobalFunctions.getOneStringWithSeparator((String[])TngGlobals.JOBRES_ATTRIBUTES, (char)'|');
            this.m_jobresAttributes.add(this.tngLineToMap.handleLine("JOBRES", this.m_lastUpdatedAttributes, line));
            this.m_lastUpdatedHM = this.m_jobresAttributes.get(this.m_jobresAttributes.size() - 1);
            this.handleJobResLine();
        } else if (type.equalsIgnoreCase("JOBPARM")) {
            this.m_lastUpdatedAttributes = GlobalFunctions.getOneStringWithSeparator((String[])TngGlobals.JOBPARM_REGEX_ATTRIBUTES, (char)'|');
            this.m_jobParmAttributes.add(this.tngLineToMap.handleLine("JOBPARM", this.m_lastUpdatedAttributes, line));
            this.m_lastUpdatedHM = this.m_jobParmAttributes.get(this.m_jobParmAttributes.size() - 1);
            this.handleJobLine();
        } else if (type.equalsIgnoreCase("TRIGGER")) {
            this.m_lastUpdatedAttributes = GlobalFunctions.getOneStringWithSeparator((String[])TngGlobals.TRIGGER_ATTRIBUTES, (char)'|');
            this.m_triggerAttributes.add(this.tngLineToMap.handleLine("TRIGGER", this.m_lastUpdatedAttributes, line));
            this.m_lastUpdatedHM = this.m_triggerAttributes.get(this.m_triggerAttributes.size() - 1);
            this.handleTriggerLine();
        }
    }

    private void handleJobSetLine() {
        String[] attr = new String[]{"JOBSET_ID"};
        this.handleIDLine(attr);
    }

    private void handleStationGroupLine() {
        String[] attr = new String[]{"STATIONGROUP_ID"};
        this.handleIDLine(attr);
    }

    private void handleTriggerLine() {
        String[] attr = new String[]{"TRIGGER_ID", "EVENT_ID"};
        this.handleIDLine(attr);
    }

    private void handleStationLine() {
        String[] attr = new String[]{"STATION_ID", "MACHINE_TYPE_ID"};
        this.handleIDLine(attr);
    }

    private void handleResourceLine() {
        String[] attr = new String[]{"RES_ID", "STATION_ID"};
        this.handleIDLine(attr);
    }

    private void handleJobSetResLine() {
        String[] attr = new String[]{"JOBSET_ID", "RES_ID"};
        this.handleIDLine(attr);
    }

    private void handleJobResLine() {
        String[] attr = new String[]{"JOBSET_ID", "JOB_ID", "JNO_ID", "RES_ID"};
        this.handleIDLine(attr);
    }

    private void handleJobLine() {
        String[] attr = new String[]{"JOBSET_ID", "JOB_ID", "JNO_ID", "HOST"};
        this.handleIDLine(attr);
    }

    private void handleIDLine(String[] attr) {
        String id = this.m_lastUpdatedHM.get("ID");
        id = id.replaceAll("\\(", "");
        id = id.replaceAll("\\)", "");
        ArrayList sepID = GlobalFunctions.stringToWords((String)id, (String)",", (String)"\"'", null);
        for (int i = 0; i < attr.length; ++i) {
            String value = i < sepID.size() ? (String)sepID.get(i) : "";
            this.m_lastUpdatedHM.put(attr[i], value);
        }
    }

    public static void main(String[] args) {
        try {
            TNG2CSV tng2csv = new TNG2CSV(new File("C:\\TNG\\CDM\\cauexpr.txt"), "C:\\TNG\\", null);
            tng2csv.convert2CSV();
            System.out.println("DONE!");
        }
        catch (TNGException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (ConvertorCancelClickException e) {
            ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
        }
    }

    public class TNGException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TNGException(String msg) {
            super(msg);
        }
    }
}

