/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.tng.TngGlobals;
import com.bmc.ctmconvert.tng.TngJob;
import com.bmc.ctmconvert.tng.TngPredecessorJob;
import com.bmc.ctmconvert.tng.TngSuccessorJob;
import com.bmc.ctmconvert.tng.TngTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class JobSetPredTable
extends CsvFile {
    private HashMap<String, AttrHolderList> m_jobSetPredListByJobSet = new HashMap();
    private HashMap<String, AttrHolderList> m_jobSetPredListByPJob = new HashMap();
    private HashMap<String, AttrHolderList> m_jobSetPredListForTriggers = new HashMap();
    private HashMap<String, AttrHolderList> m_jobSetPredListOutCondByJob = new HashMap();
    private static JobSetPredTable m_instance = null;
    private static Integer m_headerSize = 0;
    private static HashMap<String, Integer> m_header = new HashMap();
    private List<TngSuccessorJob> succecessorFolderList = new ArrayList<TngSuccessorJob>();
    private List<TngSuccessorJob> succecessorFolderTriggerList = new ArrayList<TngSuccessorJob>();

    private JobSetPredTable() {
    }

    public static JobSetPredTable instance() {
        if (m_instance == null) {
            m_instance = new JobSetPredTable();
            m_instance.load();
        }
        return m_instance;
    }

    public static void destroy() {
        m_instance = null;
    }

    public void load() {
        String csvFile = Params.instance().getDatasourcePath() + Globs.DIRSEP + "JOBSETPRED.csv";
        this.load(csvFile);
        m_headerSize = this.m_header2Index.size();
        m_header = this.m_header2Index;
    }

    public List<TngSuccessorJob> getTNGSuccessorFolderList() {
        return this.succecessorFolderList;
    }

    public List<TngSuccessorJob> getTNGFolderTriggersList() {
        return this.succecessorFolderTriggerList;
    }

    private TngSuccessorJob handleTriggerObj(TngSuccessorJob successorFolder, TngTrigger trigger) {
        if (successorFolder.getTriggerList() != null && !successorFolder.getTriggerList().contains(trigger)) {
            successorFolder.getTriggerList().add(trigger);
        } else if (successorFolder.getTriggerList() == null) {
            ArrayList<TngTrigger> triggerList = new ArrayList<TngTrigger>();
            triggerList.add(trigger);
            successorFolder.setTriggerList(triggerList);
        } else {
            successorFolder.getTriggerList().add(trigger);
        }
        return successorFolder;
    }

    public void addJobs(String[] jobPredAttributes) {
        this.handleJob((IAttrHolder)new AttrHolder(jobPredAttributes, m_header));
    }

    public void handleJob(IAttrHolder new_record) {
        TngSuccessorJob successorFolder = new TngSuccessorJob(new_record.getAttr("JOBSET_ID"), "NULL", "NULL", new_record.getAttr("TRID"), new_record.getAttr("TREV"), new_record.getAttr("WORKDAY"), "NULL", "NULL");
        if (new_record.getAttr("TREV").equalsIgnoreCase(TngGlobals.EVENT_CLOSE_FILE)) {
            int index = -1;
            TngTrigger trigger = new TngTrigger(new_record.getAttr("TRID"), new_record.getAttr("TREV"), new_record.getAttr("WORKDAY"));
            if (this.succecessorFolderTriggerList.contains(successorFolder)) {
                index = this.succecessorFolderTriggerList.indexOf(successorFolder);
                successorFolder = this.succecessorFolderTriggerList.get(index);
                successorFolder = this.handleTriggerObj(successorFolder, trigger);
            } else {
                successorFolder.setTrigger(true);
                if (successorFolder.getTriggerList() != null) {
                    if (!successorFolder.getTriggerList().contains(new_record.getAttr("TRID"))) {
                        successorFolder.getTriggerList().add(trigger);
                    }
                } else if (successorFolder.getTriggerList() == null) {
                    ArrayList<TngTrigger> triggerList = new ArrayList<TngTrigger>();
                    triggerList.add(trigger);
                    successorFolder.setTriggerList(triggerList);
                } else {
                    successorFolder.getTriggerList().add(trigger);
                }
            }
            this.succecessorFolderTriggerList.add(successorFolder);
        }
        TngPredecessorJob predecessorFolder = new TngPredecessorJob(new_record.getAttr("PSET"), new_record.getAttr("PJOB"), new_record.getAttr("PJNO"), "NULL", "NULL", new_record.getAttr("WORKDAY"), "NULL");
        predecessorFolder.setTrid(new_record.getAttr("NULL"));
        if (!this.succecessorFolderList.contains(successorFolder)) {
            ArrayList<TngPredecessorJob> predecessorFolderList = new ArrayList<TngPredecessorJob>();
            predecessorFolderList.add(predecessorFolder);
            successorFolder.setPredecessorList(predecessorFolderList);
            this.succecessorFolderList.add(successorFolder);
        } else if (!this.succecessorFolderList.get(this.succecessorFolderList.indexOf(successorFolder)).getPredecessorList().contains(predecessorFolder)) {
            this.succecessorFolderList.get(this.succecessorFolderList.indexOf(successorFolder)).getPredecessorList().add(predecessorFolder);
        }
    }

    protected void handleRecord(IAttrHolder new_record, int key) {
        this.handleJob(new_record);
        if (!new_record.getAttr("PSET").equalsIgnoreCase("NULL")) {
            this.updateListByJob(new_record);
            this.updateListByPJob(new_record);
        } else if (new_record.getAttr("TREV").equalsIgnoreCase(TngGlobals.EVENT_IN_COND)) {
            this.updateListByJob(new_record);
        } else if (new_record.getAttr("TREV").equalsIgnoreCase(TngGlobals.EVENT_OUT_COND)) {
            this.updateListForOutCondsByJob(new_record);
        } else if (new_record.getAttr("TREV").equalsIgnoreCase(TngGlobals.EVENT_CLOSE_FILE)) {
            this.updateListForTriggers(new_record);
        }
    }

    private void updateListByJob(IAttrHolder new_record) {
        AttrHolderList list = null;
        String tableName = new_record.getAttr("JOBSET_ID");
        list = this.m_jobSetPredListByJobSet.get(tableName);
        if (list == null) {
            list = new AttrHolderList();
            this.m_jobSetPredListByJobSet.put(tableName, list);
        }
        list.add((Object)new_record);
    }

    private void updateListByPJob(IAttrHolder new_record) {
        String key = TngJob.buildJobIdKey(new_record.getAttr("PSET"), new_record.getAttr("PJOB"), new_record.getAttr("PJNO"));
        if (new_record.getAttr("PJOB").equalsIgnoreCase("NULL")) {
            key = TngJob.buildJobIdKey(new_record.getAttr("PSET"), null, null);
        }
        AttrHolderList list = null;
        list = this.m_jobSetPredListByPJob.get(key);
        if (list == null) {
            list = new AttrHolderList();
            this.m_jobSetPredListByPJob.put(key, list);
        }
        list.add((Object)new_record);
    }

    private void updateListForOutCondsByJob(IAttrHolder new_record) {
        AttrHolderList list = null;
        String tableName = new_record.getAttr("JOBSET_ID");
        list = this.m_jobSetPredListOutCondByJob.get(tableName);
        if (list == null) {
            list = new AttrHolderList();
            this.m_jobSetPredListOutCondByJob.put(tableName, list);
        }
        list.add((Object)new_record);
    }

    private void updateListForTriggers(IAttrHolder new_record) {
        AttrHolderList list = null;
        String key = TngJob.buildJobIdKey(new_record.getAttr("JOBSET_ID"), null, null);
        list = this.m_jobSetPredListForTriggers.get(key);
        if (list == null) {
            list = new AttrHolderList();
            this.m_jobSetPredListForTriggers.put(key, list);
        }
        list.add((Object)new_record);
    }

    public Set<String> getJobSetPredTriggerJobsList() {
        Set<String> keySet = this.m_jobSetPredListForTriggers.keySet();
        return keySet;
    }

    public AttrHolderList getJobSetPredTriggersForJob(String key) {
        AttrHolderList list = this.m_jobSetPredListForTriggers.get(key);
        return list;
    }

    public Integer getJobSetPredHeaderSize() {
        return m_headerSize;
    }

    public Integer getJobSetPredAttrIndex(String attr) {
        return m_header.get(attr);
    }
}

