/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.tng.TngJob;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JobParmTable
extends CsvFile {
    private HashMap<String, IAttrHolder> m_jobParms = new HashMap();
    private Integer m_maxParameters = null;
    private static JobParmTable m_instance = null;
    private static Integer m_headerSize = 0;
    private static HashMap<String, Integer> m_header = new HashMap();

    private JobParmTable() {
    }

    public static JobParmTable instance() {
        if (m_instance == null) {
            m_instance = new JobParmTable();
            m_instance.load();
        }
        return m_instance;
    }

    public static void destroy() {
        m_instance = null;
    }

    public void load() {
        String csvFile = Params.instance().getDatasourcePath() + Globs.DIRSEP + "JOBPARM.csv";
        this.load(csvFile);
        m_headerSize = this.m_header2Index.size();
        m_header = this.m_header2Index;
    }

    protected void handleRecord(IAttrHolder new_record, int rec_number) {
        String key = TngJob.buildJobIdKey(new_record.getAttr("JOBSET_ID"), new_record.getAttr("JOB_ID"), new_record.getAttr("JNO_ID"));
        this.m_jobParms.put(key, new_record);
    }

    public IAttrHolder getParams(String jobSet, String jobId, String jno) {
        String key = TngJob.buildJobIdKey(jobSet, jobId, jno);
        return this.m_jobParms.get(key);
    }

    public Integer getMaxParam(String jobSet, String jobId, String jno) {
        String key = TngJob.buildJobIdKey(jobSet, jobId, jno);
        String numparm = "";
        if (m_header.containsKey("NUMPARM")) {
            numparm = this.m_jobParms.get(key).getAttr("NUMPARM");
        }
        if (numparm == null || numparm.isEmpty() || numparm == "NULL") {
            return -1;
        }
        if (!GlobalFunctions.isNumber((String)numparm)) {
            return -1;
        }
        return Integer.parseInt(numparm);
    }

    public int getMaxParam() {
        if (this.m_maxParameters != null) {
            return this.m_maxParameters;
        }
        int maxParm = 0;
        Iterator<String> iterator = this.m_jobParms.keySet().iterator();
        if (iterator.hasNext()) {
            String[] attributes;
            String key = iterator.next();
            IAttrHolder attrs = this.m_jobParms.get(key);
            for (String attribue : attributes = attrs.getCsvHeader().split(",")) {
                String parm;
                int parmNum;
                String regexp;
                Pattern p;
                Matcher m;
                if (!attribue.contains("PARM") || !(m = (p = Pattern.compile(regexp = "PARM([0-9]+)")).matcher(attribue)).matches() || (parmNum = Integer.parseInt(parm = m.group(1))) <= maxParm) continue;
                maxParm = parmNum;
            }
        }
        this.m_maxParameters = maxParm;
        return this.m_maxParameters;
    }

    public Integer getJobParmHeaderSize() {
        return m_headerSize;
    }

    public Integer getJobParmAttrIndex(String attr) {
        return m_header.get(attr);
    }

    public void appendJobParmAttributes(String[] jobParmAttributes) {
        int rec_number = this.m_jobParms.size();
        this.handleRecord((IAttrHolder)new AttrHolder(jobParmAttributes, m_header), rec_number);
    }
}

