/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.base.BaseBrowseTextField;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FileFunctions;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.tng.TNG2CSV;
import java.awt.Component;
import java.io.File;
import java.io.IOException;

public class DataImportTNG
extends DataImportVendor {
    private BaseBrowseTextField jobDefinitions;
    private BaseBrowseTextField calendarDefinitions;

    public DataImportTNG() {
        this.importPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("CAPTURE_DATA_TITLE_IMPORT_TNG")), new BaseFooterPanel(""));
        BaseSection section = new BaseSection(TextManager.instance().get("SECTION_IMPORT_DATA"));
        String[] extentions = new String[]{"TXT"};
        this.jobDefinitions = new BaseBrowseTextField(extentions, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH));
        String desc = String.format(TextManager.instance().get("CA_UNICENTER_WLM_DESCRIPTION"), "\"cauexpr.txt\"", "\"cauexpr -a\"", Params.instance().getVendorName());
        section.addField(new BaseField((BaseComponent)this.jobDefinitions, TextManager.instance().get("FIELD_TNG_JOB_DEFINITIONS"), true, desc));
        this.calendarDefinitions = new BaseBrowseTextField(extentions, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH_OR_EMPTY));
        desc = String.format(TextManager.instance().get("CA_UNICENTER_WLM_DESCRIPTION"), "\"Calendar\"", "\n 1) \"caldb save cal_filename.dsb\"   \n 2) \"caldb script cal_filename.dsb > cal_filename.txt\"\n", Params.instance().getVendorName());
        section.addField(new BaseField((BaseComponent)this.calendarDefinitions, TextManager.instance().get("FIELD_TNG_CALENDAR_DEFINITIONS"), false, desc));
        this.importPanel.addSection(section);
        this.importPanel.buildContentPanel();
    }

    public BaseContentPanel getNextPanel() {
        return this.importPanel;
    }

    public Component getDefaultFocusedComponent() {
        return this.jobDefinitions.getComponent();
    }

    public FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar) {
        return DataImportTNG.staticDataImport(destinationFolderPath, this.jobDefinitions.getText(), this.calendarDefinitions.getText(), progressBar);
    }

    public static FlowGlobals.COMPLETION_MODE staticDataImport(String destinationFolderPath, String jobDefinitions, String calendarDefinitions, BaseProgressBar progressBar) {
        if (progressBar != null) {
            progressBar.setLabel(TextManager.instance().get("TNG_PROGRESS_BAR_PROCESSING_CAUEXPR"));
        }
        File cauexprFile = new File(jobDefinitions);
        File calendarsFile = new File(calendarDefinitions);
        if (!calendarsFile.getName().isEmpty()) {
            File destCalFile = new File(destinationFolderPath + "TngCalendars.CAL");
            try {
                FileFunctions.copyFile((File)calendarsFile, (File)destCalFile);
            }
            catch (IOException e) {
                ProcessAlertsManager.instance().addMessage(String.format("Failed to copy %s to %s", calendarsFile.toString(), destCalFile.toString()));
                return FlowGlobals.COMPLETION_MODE.FAILURE;
            }
        }
        boolean rc = false;
        try {
            TNG2CSV tng2csv = new TNG2CSV(cauexprFile, destinationFolderPath, progressBar);
            rc = tng2csv.convert2CSV();
        }
        catch (TNG2CSV.TNGException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            ProcessAlertsManager.instance().addMessage(e.getMessage());
            return FlowGlobals.COMPLETION_MODE.FAILURE;
        }
        catch (ConvertorCancelClickException e) {
            ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
            ProcessAlertsManager.instance().addMessage(e.getMessage());
            return FlowGlobals.COMPLETION_MODE.ABORTED;
        }
        return rc ? FlowGlobals.COMPLETION_MODE.SUCCESS : FlowGlobals.COMPLETION_MODE.FAILURE;
    }

    public String getHelpTitle() {
        return "LOAD_DATA_TNG";
    }

    public String getFieldsData() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.jobDefinitions.getComponent().getName() + "=" + this.jobDefinitions.getText() + "\n");
        stringBuilder.append(this.calendarDefinitions.getComponent().getName() + "=" + this.calendarDefinitions.getText() + "\n");
        return stringBuilder.toString();
    }
}

