/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.redwoodbpa.convertor.steps.scheduling;

import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.redwoodbpa.entities.SAPSystem;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J4\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u001a\u0010\u0013\u001a\u00020\u0014*\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u0002J\"\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\b0\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/bmc/ctmconvert/redwoodbpa/convertor/steps/scheduling/RegularCalendarsConvertor;", "", "generalMessages", "", "", "<init>", "(Ljava/util/List;)V", "convert", "", "Lcom/bmc/ctmconvert/common/calendars/CtmCalendar;", "sapSystem", "Lcom/bmc/ctmconvert/redwoodbpa/entities/SAPSystem;", "convertSapCalendarToRegularCalendars", "createRegularCalendar", "index", "", "fiveYearSAPCalendars", "Lcom/bmc/ctmconvert/redwoodbpa/entities/SAPSystem$SAPCalendar;", "calendarIdentity", "fillYearDays", "", "groupDatesByMaxFiveYears", "dates", "Scheduler-Redwood-BPA"})
@SourceDebugExtension(value={"SMAP\nRegularCalendarsConvertor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegularCalendarsConvertor.kt\ncom/bmc/ctmconvert/redwoodbpa/convertor/steps/scheduling/RegularCalendarsConvertor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,97:1\n774#2:98\n865#2,2:99\n1485#2:101\n1510#2,3:102\n1513#2,3:112\n1567#2:118\n1598#2,4:119\n1863#2:126\n774#2:127\n865#2,2:128\n1864#2:130\n1053#2:131\n381#3,7:105\n77#4:115\n97#4,2:116\n99#4,3:123\n*S KotlinDebug\n*F\n+ 1 RegularCalendarsConvertor.kt\ncom/bmc/ctmconvert/redwoodbpa/convertor/steps/scheduling/RegularCalendarsConvertor\n*L\n22#1:98\n22#1:99,2\n23#1:101\n23#1:102,3\n23#1:112,3\n26#1:118\n26#1:119,4\n58#1:126\n60#1:127\n60#1:128,2\n58#1:130\n72#1:131\n23#1:105,7\n24#1:115\n24#1:116,2\n24#1:123,3\n*E\n"})
public final class RegularCalendarsConvertor {
    @NotNull
    private final List<String> generalMessages;

    public RegularCalendarsConvertor(@NotNull List<String> generalMessages) {
        Intrinsics.checkNotNullParameter(generalMessages, (String)"generalMessages");
        this.generalMessages = generalMessages;
    }

    @NotNull
    public final List<CtmCalendar> convert(@NotNull SAPSystem sapSystem) {
        Intrinsics.checkNotNullParameter((Object)sapSystem, (String)"sapSystem");
        return this.convertSapCalendarToRegularCalendars(sapSystem, this.generalMessages);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CtmCalendar> convertSapCalendarToRegularCalendars(SAPSystem sapSystem, List<String> generalMessages) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable list$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        SAPSystem.SAPCalendar it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        int currentYear = LocalDateTime.now().getYear();
        Iterable iterable = sapSystem.getSAPCalendars();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SAPSystem.SAPCalendar)element$iv$iv;
            boolean bl = false;
            if (!(Integer.parseInt(it.getYear()) >= currentYear)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (SAPSystem.SAPCalendar)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getIdentity();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$groupByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator<Object> iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Object element$iv$iv;
            Object allYears = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            key$iv$iv = this.groupDatesByMaxFiveYears((List)allYears.getValue());
            boolean $i$f$mapIndexed = false;
            void $i$f$getOrPut = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void fiveYearSAPCalendars;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                List list = (List)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(this.createRegularCalendar((int)index, (List<SAPSystem.SAPCalendar>)fiveYearSAPCalendars, generalMessages, (String)allYears.getKey()));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final CtmCalendar createRegularCalendar(int index, List<SAPSystem.SAPCalendar> fiveYearSAPCalendars, List<String> generalMessages, String calendarIdentity) {
        CtmCalendar ctmCalendar = new CtmCalendar(calendarIdentity + "_" + (index + 1), Params.instance().getDatacenterName());
        this.fillYearDays(ctmCalendar, fiveYearSAPCalendars);
        String fiveYearsAtOneString = CollectionsKt.joinToString$default((Iterable)fiveYearSAPCalendars, (CharSequence)",", null, null, (int)0, null, RegularCalendarsConvertor::createRegularCalendar$lambda$4, (int)30, null);
        String[] stringArray = new String[]{calendarIdentity, ctmCalendar.getName(), fiveYearsAtOneString};
        Reporter.addMessage(generalMessages, (String)"INF21018", (String)"GENERAL", (String[])stringArray);
        return ctmCalendar;
    }

    /*
     * WARNING - void declaration
     */
    private final void fillYearDays(CtmCalendar $this$fillYearDays, List<SAPSystem.SAPCalendar> fiveYearSAPCalendars) {
        Iterable $this$forEach$iv = fiveYearSAPCalendars;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SAPSystem.SAPCalendar sapCalendar = (SAPSystem.SAPCalendar)element$iv;
            boolean bl = false;
            for (SAPSystem.SAPCalendar.Month month : sapCalendar.getMonths()) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = month.getDays();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    SAPSystem.SAPCalendar.Month.BPADay it = (SAPSystem.SAPCalendar.Month.BPADay)element$iv$iv;
                    boolean bl2 = false;
                    if (!it.isSet()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (SAPSystem.SAPCalendar.Month.BPADay day : (List)destination$iv$iv) {
                    $this$fillYearDays.addDay(Integer.parseInt(sapCalendar.getYear()), month.getName().ordinal() + 1, day.getDay());
                }
            }
        }
    }

    private final List<List<SAPSystem.SAPCalendar>> groupDatesByMaxFiveYears(List<SAPSystem.SAPCalendar> dates) {
        Iterable $this$sortedBy$iv = dates;
        boolean $i$f$sortedBy = false;
        List sortedDates = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SAPSystem.SAPCalendar it = (SAPSystem.SAPCalendar)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getYear());
                it = (SAPSystem.SAPCalendar)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getYear())));
            }
        });
        List groups = new ArrayList();
        List currentGroup = new ArrayList();
        for (SAPSystem.SAPCalendar date : sortedDates) {
            if (currentGroup.isEmpty()) {
                currentGroup.add(date);
                continue;
            }
            SAPSystem.SAPCalendar lastDate = (SAPSystem.SAPCalendar)CollectionsKt.first((List)currentGroup);
            if (Math.abs(Integer.parseInt(date.getYear()) - Integer.parseInt(lastDate.getYear())) < 5) {
                currentGroup.add(date);
                continue;
            }
            groups.add(currentGroup);
            Object[] objectArray = new SAPSystem.SAPCalendar[]{date};
            currentGroup = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        if (!((Collection)currentGroup).isEmpty()) {
            groups.add(currentGroup);
        }
        return groups;
    }

    private static final CharSequence createRegularCalendar$lambda$4(SAPSystem.SAPCalendar it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getYear();
    }
}

