/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.redwoodbpa.convertor.steps.jobtypes.sapr3;

import com.bmc.ctmconvert.api.SapBWParametersAPI;
import com.bmc.ctmconvert.api.SapR3AbapStepAPI;
import com.bmc.ctmconvert.api.SapR3ParametersAPI;
import com.bmc.ctmconvert.api.SapR3StepAPI;
import com.bmc.ctmconvert.redwoodbpa.convertor.steps.jobtypes.sapr3.step.AbapStepConvertor;
import com.bmc.ctmconvert.redwoodbpa.convertor.steps.jobtypes.sapr3.step.ExternalCommandStepConvertor;
import com.bmc.ctmconvert.redwoodbpa.entities.JobDefinition;
import com.bmc.ctmconvert.redwoodbpa.extensions.CommonKt;
import com.bmc.ctmconvert.redwoodbpa.extensions.CtmJobKt;
import com.bmc.ctmconvert.redwoodbpa.extensions.JobDefinitionParameterKt;
import com.bmc.ctmconvert.redwoodbpa.messages.InfosKt;
import com.bmc.ctmconvert.redwoodbpa.messages.WarningsKt;
import com.bmc.ctmconvert.scriptelement.CtmJob;
import com.bmc.ctmconvert.scriptelement.SapR3Action;
import com.bmc.ctmconvert.scriptelement.SapR3JobClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tJ&\u0010\u0011\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0002J\u001e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\t2\b\u0010 \u001a\u0004\u0018\u00010\rH\u0002J&\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010%\u001a\u00020\u0014H\u0002J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u001e\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\t2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010*\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\t2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010+\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\t2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006,"}, d2={"Lcom/bmc/ctmconvert/redwoodbpa/convertor/steps/jobtypes/sapr3/SapJobsConvertor;", "", "<init>", "()V", "toSap", "", "jobDefinition", "Lcom/bmc/ctmconvert/redwoodbpa/entities/JobDefinition;", "ctmJob", "Lcom/bmc/ctmconvert/scriptelement/CtmJob;", "setAsCreateMultiStepJob", "bpaParams", "", "Lcom/bmc/ctmconvert/redwoodbpa/entities/JobDefinition$JobDefinitionParameter;", "toSapRedwoodBuiltInDefinitions", "jobChainCall", "Lcom/bmc/ctmconvert/redwoodbpa/entities/JobDefinition$JobChainCall;", "setSapBW", "cachedJobsParamsElements", "description", "", "notSupportedSapJobType", "sapR3Job", "sapType", "setAsCopyExistingJob", "setAsCreateANewJob", "sapR3CtmJob", "setLocalVariablesForJob", "removePercentageFromNameIfExists", "parameter", "notSupportedJobClassValue", "Lcom/bmc/ctmconvert/scriptelement/SapR3JobClass;", "variable", "setUser", "newStep", "Lcom/bmc/ctmconvert/api/SapR3StepAPI;", "jobsParamsElements", "stepNumberExtension", "setSapConnectionProfile", "setSapJobName", "job", "params", "setSapBWJobId", "setJobClass", "Scheduler-Redwood-BPA"})
@SourceDebugExtension(value={"SMAP\nSapJobsConvertor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SapJobsConvertor.kt\ncom/bmc/ctmconvert/redwoodbpa/convertor/steps/jobtypes/sapr3/SapJobsConvertor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,186:1\n1485#2:187\n1510#2,3:188\n1513#2,3:198\n827#2:203\n855#2,2:204\n1863#2,2:206\n381#3,7:191\n216#4,2:201\n*S KotlinDebug\n*F\n+ 1 SapJobsConvertor.kt\ncom/bmc/ctmconvert/redwoodbpa/convertor/steps/jobtypes/sapr3/SapJobsConvertor\n*L\n41#1:187\n41#1:188,3\n41#1:198,3\n122#1:203\n122#1:204,2\n122#1:206,2\n41#1:191,7\n43#1:201,2\n*E\n"})
public final class SapJobsConvertor {
    public final void toSap(@NotNull JobDefinition jobDefinition, @NotNull CtmJob ctmJob) {
        Intrinsics.checkNotNullParameter((Object)jobDefinition, (String)"jobDefinition");
        Intrinsics.checkNotNullParameter((Object)ctmJob, (String)"ctmJob");
        List<JobDefinition.JobDefinitionParameter> bpaParams = CtmJobKt.getJobDefinition(ctmJob).getBPAParams();
        switch (jobDefinition.getSapAction()) {
            case "MULTI_STEP_RUN": {
                this.setAsCreateMultiStepJob(ctmJob, bpaParams);
                break;
            }
            case "ABAP_RUN_PRINT": {
                this.setAsCreateANewJob(ctmJob, bpaParams);
                break;
            }
            case "ABAP_RUN": {
                this.setAsCreateANewJob(ctmJob, bpaParams);
                break;
            }
            case "VARIANT_STORE": {
                this.setAsCreateANewJob(ctmJob, bpaParams);
                break;
            }
            case "EXTERNAL_COMMAND_RUN": {
                this.setAsCreateANewJob(ctmJob, bpaParams);
                break;
            }
            case "TEMPLATE_JOB_RUN": {
                this.setAsCopyExistingJob(ctmJob, jobDefinition.getBPAParams());
                break;
            }
            case "BW_CHAIN_RUN": {
                this.setSapBW(ctmJob, jobDefinition.getBPAParams(), jobDefinition.getBPADescription());
                break;
            }
            default: {
                this.notSupportedSapJobType(ctmJob, jobDefinition.getSapAction());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setAsCreateMultiStepJob(CtmJob ctmJob, List<? extends JobDefinition.JobDefinitionParameter> bpaParams) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        SapR3ParametersAPI sapR3Parameters = ctmJob.general().sapR3Parameters();
        Iterable iterable = bpaParams;
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            JobDefinition.JobDefinitionParameter it = (JobDefinition.JobDefinitionParameter)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getStepNumber();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = MapsKt.toSortedMap((Map)destination$iv$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                String it = (String)a;
                boolean bl = false;
                String string = it;
                it = (String)b;
                Comparable comparable = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
                bl = false;
                String string2 = it;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(string2 != null ? Integer.valueOf(Integer.parseInt(string2)) : null));
            }
        });
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            SapR3StepAPI newStep;
            SapR3StepAPI sapR3StepAPI;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String stepNumber = (String)entry.getKey();
            List stepParams = (List)entry.getValue();
            if (Intrinsics.areEqual((Object)CtmJobKt.getJobDefinition(ctmJob).getSapAction(), (Object)"EXTERNAL_COMMAND_RUN")) {
                ExternalCommandStepConvertor externalCommandStepConvertor = new ExternalCommandStepConvertor();
                Intrinsics.checkNotNull((Object)sapR3Parameters);
                Intrinsics.checkNotNull((Object)stepParams);
                sapR3StepAPI = (SapR3StepAPI)externalCommandStepConvertor.convertExternalCommand(sapR3Parameters, stepParams);
            } else {
                SapR3AbapStepAPI sapR3AbapStepAPI;
                if (stepNumber != null) {
                    String it;
                    boolean bl3 = false;
                    AbapStepConvertor abapStepConvertor = new AbapStepConvertor();
                    Intrinsics.checkNotNull((Object)stepParams);
                    sapR3AbapStepAPI = abapStepConvertor.convertAbapStep(stepParams, ctmJob, true, it);
                } else {
                    sapR3AbapStepAPI = null;
                }
                sapR3StepAPI = (SapR3StepAPI)sapR3AbapStepAPI;
            }
            if ((newStep = sapR3StepAPI) == null) continue;
            Intrinsics.checkNotNull((Object)stepParams);
            this.setUser(newStep, stepParams, "_" + stepNumber);
        }
        this.setSapJobName(ctmJob, bpaParams);
        this.setJobClass(ctmJob, bpaParams);
        this.setSapConnectionProfile(ctmJob);
        this.setLocalVariablesForJob(ctmJob, bpaParams);
    }

    public final void toSapRedwoodBuiltInDefinitions(@NotNull JobDefinition.JobChainCall jobChainCall, @NotNull CtmJob ctmJob) {
        Intrinsics.checkNotNullParameter((Object)jobChainCall, (String)"jobChainCall");
        Intrinsics.checkNotNullParameter((Object)ctmJob, (String)"ctmJob");
        if (StringsKt.contains$default((CharSequence)jobChainCall.getJobDefinitionName(), (CharSequence)"BW", (boolean)false, (int)2, null)) {
            this.setSapBW(ctmJob, jobChainCall.getJobChainCallInExpressionParameters(), "");
        } else {
            this.setAsCreateANewJob(ctmJob, jobChainCall.getJobChainCallInExpressionParameters());
        }
    }

    private final void setSapBW(CtmJob ctmJob, List<? extends JobDefinition.JobDefinitionParameter> cachedJobsParamsElements, String description) {
        ctmJob.setSapBWType();
        ctmJob.setDescription(description);
        this.setSapBWJobId(ctmJob, cachedJobsParamsElements);
    }

    private final void notSupportedSapJobType(CtmJob sapR3Job, String sapType) {
        sapR3Job.setDummyType();
        sapR3Job.general().sapR3Parameters().deleteAll();
        sapR3Job.addMessage(WarningsKt.unsupportedSapType(sapR3Job, sapType));
    }

    private final void setAsCopyExistingJob(CtmJob sapR3Job, List<? extends JobDefinition.JobDefinitionParameter> cachedJobsParamsElements) {
        sapR3Job.general().sapR3Parameters().setAction(SapR3Action.CopyAnExistingJob);
        this.setSapJobName(sapR3Job, cachedJobsParamsElements);
        this.setSapConnectionProfile(sapR3Job);
    }

    private final void setAsCreateANewJob(CtmJob sapR3CtmJob, List<? extends JobDefinition.JobDefinitionParameter> bpaParams) {
        SapR3StepAPI sapR3StepAPI;
        SapR3ParametersAPI sapR3Parameters = sapR3CtmJob.general().sapR3Parameters();
        if (Intrinsics.areEqual((Object)CtmJobKt.getJobDefinition(sapR3CtmJob).getSapAction(), (Object)"EXTERNAL_COMMAND_RUN")) {
            ExternalCommandStepConvertor externalCommandStepConvertor = new ExternalCommandStepConvertor();
            Intrinsics.checkNotNull((Object)sapR3Parameters);
            sapR3StepAPI = (SapR3StepAPI)externalCommandStepConvertor.convertExternalCommand(sapR3Parameters, bpaParams);
        } else {
            sapR3StepAPI = (SapR3StepAPI)new AbapStepConvertor().convertAbapStep(bpaParams, sapR3CtmJob, false, "");
        }
        SapR3StepAPI newStep = sapR3StepAPI;
        this.setSapJobName(sapR3CtmJob, bpaParams);
        this.setJobClass(sapR3CtmJob, bpaParams);
        this.setSapConnectionProfile(sapR3CtmJob);
        this.setLocalVariablesForJob(sapR3CtmJob, bpaParams);
        this.setUser(newStep, bpaParams, "");
    }

    /*
     * WARNING - void declaration
     */
    private final void setLocalVariablesForJob(CtmJob sapR3Job, List<? extends JobDefinition.JobDefinitionParameter> cachedJobsParamsElements) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = cachedJobsParamsElements;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            JobDefinition.JobDefinitionParameter it = (JobDefinition.JobDefinitionParameter)element$iv$iv;
            boolean bl = false;
            if (it.isBuiltInSapR3PParameter()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JobDefinition.JobDefinitionParameter parameter = (JobDefinition.JobDefinitionParameter)element$iv;
            boolean bl = false;
            String name = this.removePercentageFromNameIfExists(parameter);
            String value = parameter.getValue();
            sapR3Job.general().addLocalVariable(name, value);
        }
    }

    private final String removePercentageFromNameIfExists(JobDefinition.JobDefinitionParameter parameter) {
        String paramName = parameter.getName();
        return StringsKt.startsWith$default((String)paramName, (String)"%%", (boolean)false, (int)2, null) ? StringsKt.replaceFirst$default((String)paramName, (String)"%%", (String)"", (boolean)false, (int)4, null) : paramName;
    }

    private final SapR3JobClass notSupportedJobClassValue(CtmJob sapR3Job, JobDefinition.JobDefinitionParameter variable) {
        sapR3Job.addMessage(InfosKt.invalidValueJobClassParam(sapR3Job, variable));
        return SapR3JobClass.MediumPriority;
    }

    private final void setUser(SapR3StepAPI newStep, List<? extends JobDefinition.JobDefinitionParameter> jobsParamsElements, String stepNumberExtension) {
        Object object = JobDefinitionParameterKt.getVariable(jobsParamsElements, "SAP_USER_NAME" + stepNumberExtension);
        if (object == null || (object = ((JobDefinition.JobDefinitionParameter)object).getValue()) == null) {
            object = "";
        }
        newStep.setUser((String)object);
    }

    private final void setSapConnectionProfile(CtmJob sapR3Job) {
        Object object = sapR3Job.getJobInputXmlData().getFirstChildElementByName("DefaultQueue");
        String defaultQueue = object != null ? object.getAttribute("path") : null;
        object = defaultQueue;
        if (object == null || object.length() == 0) {
            sapR3Job.general().sapR3Parameters().setConnectionProfile("DEFAULT_SAP_CONNECTION_PROFILE");
        } else {
            sapR3Job.general().sapR3Parameters().setConnectionProfile(CommonKt.getItemNameFromBusinessKey(defaultQueue));
        }
    }

    private final void setSapJobName(CtmJob job, List<? extends JobDefinition.JobDefinitionParameter> params) {
        SapR3ParametersAPI sapR3ParametersAPI = job.general().sapR3Parameters();
        Object object = JobDefinitionParameterKt.getVariable(params, "JOBNAME");
        if (object == null || (object = ((JobDefinition.JobDefinitionParameter)object).getValue()) == null) {
            object = "";
        }
        sapR3ParametersAPI.setSAPJobName((String)object);
    }

    private final void setSapBWJobId(CtmJob job, List<? extends JobDefinition.JobDefinitionParameter> params) {
        SapBWParametersAPI sapBWParametersAPI = job.general().sapBWParameters();
        Object object = JobDefinitionParameterKt.getVariable(params, "NAME");
        if (object == null || (object = ((JobDefinition.JobDefinitionParameter)object).getValue()) == null) {
            object = "";
        }
        sapBWParametersAPI.setID((String)object);
    }

    private final void setJobClass(CtmJob job, List<? extends JobDefinition.JobDefinitionParameter> params) {
        JobDefinition.JobDefinitionParameter variable = JobDefinitionParameterKt.getVariable(params, "JOBCLASS");
        if (variable == null) {
            job.general().sapR3Parameters().setJobClass(SapR3JobClass.MediumPriority);
            return;
        }
        SapR3JobClass it = variable.asSapR3JobClass();
        boolean bl = false;
        SapR3ParametersAPI sapR3ParametersAPI = job.general().sapR3Parameters();
        SapR3JobClass sapR3JobClass = it;
        if (sapR3JobClass == null) {
            sapR3JobClass = this.notSupportedJobClassValue(job, variable);
        }
        sapR3ParametersAPI.setJobClass(sapR3JobClass);
    }
}

