/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.redwoodbpa.convertor.steps.conditions;

import com.bmc.ctmconvert.ConversionContext;
import com.bmc.ctmconvert.redwoodbpa.convertor.steps.conditions.ConditionConversionStep;
import com.bmc.ctmconvert.redwoodbpa.convertor.steps.conditions.RaiseEventsConvertor;
import com.bmc.ctmconvert.redwoodbpa.convertor.steps.conditions.UniqueCondNameGenerator;
import com.bmc.ctmconvert.redwoodbpa.entities.JobDefinition;
import com.bmc.ctmconvert.redwoodbpa.extensions.CtmFolderKt;
import com.bmc.ctmconvert.redwoodbpa.extensions.CtmJobKt;
import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;
import com.bmc.ctmconvert.scriptelement.CtmFolder;
import com.bmc.ctmconvert.scriptelement.CtmJob;
import com.bmc.ctmconvert.scriptelement.CtmWorkspace;
import com.bmc.ctmconvert.scriptelement.CtmXmlElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J \u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0014H\u0002J\"\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J \u0010$\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/bmc/ctmconvert/redwoodbpa/convertor/steps/conditions/AtoBConvertor;", "Lcom/bmc/ctmconvert/redwoodbpa/convertor/steps/conditions/ConditionConversionStep;", "withCleanup", "", "raiseEventsConvertor", "Lcom/bmc/ctmconvert/redwoodbpa/convertor/steps/conditions/RaiseEventsConvertor;", "<init>", "(ZLcom/bmc/ctmconvert/redwoodbpa/convertor/steps/conditions/RaiseEventsConvertor;)V", "uniqueCondNameGenerator", "Lcom/bmc/ctmconvert/redwoodbpa/convertor/steps/conditions/UniqueCondNameGenerator;", "execute", "", "conversionContext", "Lcom/bmc/ctmconvert/ConversionContext;", "convertRaiseEventsToOnDoCond", "convertWaitEventsToInConditions", "generateUniqueCondName", "waitEvent", "Lcom/bmc/ctmconvert/redwoodbpa/entities/JobDefinition$JobDefinitionWaitEvent;", "ctmJob", "Lcom/bmc/ctmconvert/scriptelement/CtmBaseEntity;", "createConditionsBetweenNestedFolders", "ctmFolder", "Lcom/bmc/ctmconvert/scriptelement/CtmFolder;", "addConditionsBetweenFirstJobChainCallsInAllSteps", "workspace", "Lcom/bmc/ctmconvert/scriptelement/CtmWorkspace;", "parentFolderOfThisJobChain", "isExistedJob", "jobChainCall", "Lcom/bmc/ctmconvert/redwoodbpa/entities/JobDefinition$JobChainCall;", "createConditionInAndOutConditionBetweenEntities", "fromEntity", "toEntity", "getCtmJobEntity", "Lcom/bmc/ctmconvert/scriptelement/CtmJob;", "isSameJobNameAndSameParent", "Scheduler-Redwood-BPA"})
@SourceDebugExtension(value={"SMAP\nAtoBConvertor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtoBConvertor.kt\ncom/bmc/ctmconvert/redwoodbpa/convertor/steps/conditions/AtoBConvertor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1863#2,2:119\n1863#2,2:121\n1863#2,2:123\n1863#2:125\n1863#2,2:126\n1864#2:128\n1863#2:129\n1863#2,2:130\n1864#2:132\n808#2,11:133\n3467#2,10:144\n1053#2:154\n1557#2:155\n1628#2,3:156\n774#2:159\n865#2,2:160\n*S KotlinDebug\n*F\n+ 1 AtoBConvertor.kt\ncom/bmc/ctmconvert/redwoodbpa/convertor/steps/conditions/AtoBConvertor\n*L\n13#1:119,2\n22#1:121,2\n25#1:123,2\n32#1:125\n33#1:126,2\n32#1:128\n37#1:129\n38#1:130,2\n37#1:132\n55#1:133,11\n55#1:144,10\n67#1:154\n68#1:155\n68#1:156,3\n68#1:159\n68#1:160,2\n*E\n"})
public final class AtoBConvertor
implements ConditionConversionStep {
    private final boolean withCleanup;
    @NotNull
    private final RaiseEventsConvertor raiseEventsConvertor;
    @NotNull
    private final UniqueCondNameGenerator uniqueCondNameGenerator;

    public AtoBConvertor(boolean withCleanup, @NotNull RaiseEventsConvertor raiseEventsConvertor) {
        Intrinsics.checkNotNullParameter((Object)raiseEventsConvertor, (String)"raiseEventsConvertor");
        this.withCleanup = withCleanup;
        this.raiseEventsConvertor = raiseEventsConvertor;
        this.uniqueCondNameGenerator = new UniqueCondNameGenerator();
    }

    @Override
    public void execute(@NotNull ConversionContext conversionContext) {
        Intrinsics.checkNotNullParameter((Object)conversionContext, (String)"conversionContext");
        List list = conversionContext.getWorkspace().getAllFolders();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllFolders(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CtmFolder ctmFolder = (CtmFolder)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)ctmFolder);
            this.createConditionsBetweenNestedFolders(ctmFolder);
            this.addConditionsBetweenFirstJobChainCallsInAllSteps(conversionContext.getWorkspace(), ctmFolder);
        }
        this.convertWaitEventsToInConditions(conversionContext);
        this.convertRaiseEventsToOnDoCond(conversionContext);
    }

    private final void convertRaiseEventsToOnDoCond(ConversionContext conversionContext) {
        CtmJob it;
        List list = conversionContext.getWorkspace().getAllJobs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllJobs(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (CtmJob)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.raiseEventsConvertor.convertRaiseEventsToOnDoInJob(it, this.uniqueCondNameGenerator);
        }
        List list2 = conversionContext.getWorkspace().getAllFolders();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllFolders(...)");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (CtmFolder)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.raiseEventsConvertor.convertRaiseEventsToOnDoInFolder((CtmFolder)it, this.uniqueCondNameGenerator);
        }
    }

    private final void convertWaitEventsToInConditions(ConversionContext conversionContext) {
        JobDefinition.JobDefinitionWaitEvent waitEvent;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        List list = conversionContext.getWorkspace().getAllJobs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllJobs(...)");
        Iterable $this$forEach$iv2 = list;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CtmJob ctmJob = (CtmJob)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)ctmJob);
            $this$forEach$iv = CtmJobKt.getJobDefinition(ctmJob).getWaitEvents();
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                waitEvent = (JobDefinition.JobDefinitionWaitEvent)element$iv2;
                boolean bl2 = false;
                this.generateUniqueCondName(waitEvent, (CtmBaseEntity)ctmJob, conversionContext);
            }
        }
        List list2 = conversionContext.getWorkspace().getAllFolders();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllFolders(...)");
        $this$forEach$iv2 = list2;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CtmFolder ctmFolder = (CtmFolder)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)ctmFolder);
            $this$forEach$iv = CtmFolderKt.getJobDefinition(ctmFolder).getWaitEvents();
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                waitEvent = (JobDefinition.JobDefinitionWaitEvent)element$iv2;
                boolean bl3 = false;
                this.generateUniqueCondName(waitEvent, (CtmBaseEntity)ctmFolder, conversionContext);
            }
        }
    }

    private final void generateUniqueCondName(JobDefinition.JobDefinitionWaitEvent waitEvent, CtmBaseEntity ctmJob, ConversionContext conversionContext) {
        this.uniqueCondNameGenerator.getUniqueConditionName(waitEvent.getName(), (Function1<? super String, Unit>)((Function1)arg_0 -> AtoBConvertor.generateUniqueCondName$lambda$7(conversionContext, waitEvent, ctmJob, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final void createConditionsBetweenNestedFolders(CtmFolder ctmFolder) {
        void $this$filterIsInstanceTo$iv$iv;
        List list = ctmFolder.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CtmFolder)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$zipWithNext$iv = (List)destination$iv$iv;
        boolean $i$f$zipWithNext = false;
        Iterator iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            CollectionsKt.emptyList();
        } else {
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void b;
                void a;
                Object element$iv$iv;
                Object next$iv = iterator$iv.next();
                element$iv$iv = (CtmFolder)next$iv;
                CtmFolder ctmFolder2 = (CtmFolder)current$iv;
                List list2 = result$iv;
                boolean bl = false;
                this.createConditionInAndOutConditionBetweenEntities((CtmBaseEntity)a, (CtmBaseEntity)b);
                list2.add(Unit.INSTANCE);
                current$iv = next$iv;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addConditionsBetweenFirstJobChainCallsInAllSteps(CtmWorkspace workspace, CtmFolder parentFolderOfThisJobChain) {
        void $this$filterTo$iv$iv;
        JobDefinition.JobChainCall it;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        CtmXmlElement ctmXmlElement = parentFolderOfThisJobChain.getFolderInputXmlData();
        if ((ctmXmlElement != null ? ctmXmlElement.getXmlElement() : null) == null) {
            return;
        }
        Iterable $this$sortedBy$iv = CtmFolderKt.getJobDefinition(parentFolderOfThisJobChain).getAllJobChainSteps();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                JobDefinition.JobChainStep it = (JobDefinition.JobChainStep)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.sequenceNumber());
                it = (JobDefinition.JobChainStep)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.sequenceNumber()));
            }
        });
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JobDefinition.JobChainStep jobChainStep = (JobDefinition.JobChainStep)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((JobDefinition.JobChainStep)((Object)it)).getFirstNonEmptyJobChainCalls());
        }
        Iterable $this$filter$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (JobDefinition.JobChainCall)element$iv$iv;
            boolean bl = false;
            if (!this.isExistedJob(workspace, it, parentFolderOfThisJobChain)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int i = 0;
        List firstJobChainCallsOrderedBasedOnSequenceNumber = (List)destination$iv$iv;
        int n = firstJobChainCallsOrderedBasedOnSequenceNumber.size() - 2;
        if (i <= n) {
            while (true) {
                CtmJob fromEntity = this.getCtmJobEntity(workspace, (JobDefinition.JobChainCall)firstJobChainCallsOrderedBasedOnSequenceNumber.get(i), parentFolderOfThisJobChain);
                CtmJob toEntity = this.getCtmJobEntity(workspace, (JobDefinition.JobChainCall)firstJobChainCallsOrderedBasedOnSequenceNumber.get(i + 1), parentFolderOfThisJobChain);
                if (fromEntity != null && toEntity != null) {
                    this.createConditionInAndOutConditionBetweenEntities((CtmBaseEntity)fromEntity, (CtmBaseEntity)toEntity);
                }
                if (i == n) break;
                ++i;
            }
        }
    }

    private final boolean isExistedJob(CtmWorkspace workspace, JobDefinition.JobChainCall jobChainCall, CtmFolder parentFolderOfThisJobChain) {
        return this.getCtmJobEntity(workspace, jobChainCall, parentFolderOfThisJobChain) != null;
    }

    private final void createConditionInAndOutConditionBetweenEntities(CtmBaseEntity fromEntity, CtmBaseEntity toEntity) {
        String string = "%s-TO-%s";
        Object[] objectArray = new Object[]{fromEntity.getName(), toEntity.getName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String conditionName = string2;
        this.uniqueCondNameGenerator.getUniqueConditionName(conditionName, (Function1<? super String, Unit>)((Function1)arg_0 -> AtoBConvertor.createConditionInAndOutConditionBetweenEntities$lambda$12(fromEntity, toEntity, this, arg_0)));
    }

    private final CtmJob getCtmJobEntity(CtmWorkspace workspace, JobDefinition.JobChainCall jobChainCall, CtmFolder parentFolderOfThisJobChain) {
        Object v1;
        block1: {
            List list = workspace.getAllJobs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllJobs(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                CtmJob ctmJob = (CtmJob)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)ctmJob);
                if (!this.isSameJobNameAndSameParent(ctmJob, jobChainCall, parentFolderOfThisJobChain)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSameJobNameAndSameParent(CtmJob ctmJob, JobDefinition.JobChainCall jobChainCall, CtmFolder parentFolderOfThisJobChain) {
        if (!Intrinsics.areEqual((Object)CtmJobKt.getJobDefinition(ctmJob).getName(), (Object)jobChainCall.getJobDefinitionName())) return false;
        Optional optional = ctmJob.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getParent(...)");
        if (!Intrinsics.areEqual((Object)OptionalsKt.getOrNull((Optional)optional), (Object)parentFolderOfThisJobChain)) return false;
        return true;
    }

    private static final Unit generateUniqueCondName$lambda$7(ConversionContext $conversionContext, JobDefinition.JobDefinitionWaitEvent $waitEvent, CtmBaseEntity $ctmJob, String uniqueCondName) {
        Intrinsics.checkNotNullParameter((Object)uniqueCondName, (String)"uniqueCondName");
        CtmJob ctmJob = $conversionContext.getWorkspace().getJobByName($waitEvent.getName());
        if (ctmJob != null) {
            ctmJob.addOutCondition(uniqueCondName);
        }
        $ctmJob.addInCondition(uniqueCondName);
        return Unit.INSTANCE;
    }

    private static final Unit createConditionInAndOutConditionBetweenEntities$lambda$12(CtmBaseEntity $fromEntity, CtmBaseEntity $toEntity, AtoBConvertor this$0, String newUniqueConditionName) {
        Intrinsics.checkNotNullParameter((Object)newUniqueConditionName, (String)"newUniqueConditionName");
        $fromEntity.addOutCondition(newUniqueConditionName);
        $toEntity.addInCondition(newUniqueConditionName, this$0.withCleanup);
        return Unit.INSTANCE;
    }
}

