/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.redwoodbpa.convertor.steps;

import com.bmc.ctmconvert.ConversionContext;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.redwoodbpa.convertor.steps.ConversionStep;
import com.bmc.ctmconvert.redwoodbpa.convertor.steps.scheduling.RBCConvertor;
import com.bmc.ctmconvert.redwoodbpa.convertor.steps.scheduling.RegularCalendarsConvertor;
import com.bmc.ctmconvert.redwoodbpa.entities.JobDefinition;
import com.bmc.ctmconvert.redwoodbpa.entities.SAPSystem;
import com.bmc.ctmconvert.redwoodbpa.entities.TimeWindow;
import com.bmc.ctmconvert.redwoodbpa.extensions.CtmFolderKt;
import com.bmc.ctmconvert.redwoodbpa.extensions.CtmJobKt;
import com.bmc.ctmconvert.redwoodbpa.messages.InfosKt;
import com.bmc.ctmconvert.redwoodbpa.messages.WarningsKt;
import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;
import com.bmc.ctmconvert.scriptelement.CtmFolder;
import com.bmc.ctmconvert.scriptelement.CtmJob;
import com.bmc.ctmconvert.scriptelement.OrderableEntityWrapper;
import com.bmc.ctmconvert.workspace.entities.IRBC;
import com.bmc.ctmconvert.workspace.entities.RbcAPI;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J4\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00050\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020!H\u0002\u00a8\u0006\""}, d2={"Lcom/bmc/ctmconvert/redwoodbpa/convertor/steps/SchedulingCreator;", "Lcom/bmc/ctmconvert/redwoodbpa/convertor/steps/ConversionStep;", "<init>", "()V", "execute", "", "conversionContext", "Lcom/bmc/ctmconvert/ConversionContext;", "issueNotSupportedTimeZoneIfFound", "jobDef", "Lcom/bmc/ctmconvert/redwoodbpa/entities/JobDefinition;", "it", "Lcom/bmc/ctmconvert/scriptelement/OrderableEntityWrapper;", "setTimeWindow", "job", "Lcom/bmc/ctmconvert/scriptelement/CtmBaseEntity;", "rbcConvertor", "Lcom/bmc/ctmconvert/redwoodbpa/convertor/steps/scheduling/RBCConvertor;", "timeWindow", "Lcom/bmc/ctmconvert/redwoodbpa/entities/TimeWindow;", "setRbc", "Lkotlin/Function1;", "Lcom/bmc/ctmconvert/workspace/entities/RbcAPI;", "setRBCForJob", "Lcom/bmc/ctmconvert/scriptelement/CtmJob;", "setStartAndEndTime", "ctmBaseEntity", "timeWindowElement", "Lcom/bmc/ctmconvert/redwoodbpa/entities/TimeWindow$TimeWindowElement;", "formatToString", "", "Ljava/time/Duration;", "issueNotSupportedSubmitFrameIfFound", "Lcom/bmc/ctmconvert/scriptelement/CtmFolder;", "Scheduler-Redwood-BPA"})
@SourceDebugExtension(value={"SMAP\nSchedulingCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchedulingCreator.kt\ncom/bmc/ctmconvert/redwoodbpa/convertor/steps/SchedulingCreator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1863#2:130\n295#2,2:131\n1864#2:133\n1863#2:134\n295#2,2:135\n1864#2:137\n1863#2:138\n1863#2,2:139\n1864#2:141\n1863#2,2:142\n1863#2,2:144\n*S KotlinDebug\n*F\n+ 1 SchedulingCreator.kt\ncom/bmc/ctmconvert/redwoodbpa/convertor/steps/SchedulingCreator\n*L\n23#1:130\n24#1:131,2\n23#1:133\n34#1:134\n35#1:135,2\n34#1:137\n48#1:138\n49#1:139,2\n48#1:141\n54#1:142,2\n77#1:144,2\n*E\n"})
public final class SchedulingCreator
implements ConversionStep {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull ConversionContext conversionContext) {
        Intrinsics.checkNotNullParameter((Object)conversionContext, (String)"conversionContext");
        AutoCloseable autoCloseable = (AutoCloseable)conversionContext.getCalendarsWriter();
        Throwable throwable = null;
        try {
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            DefCalFile defCal = (DefCalFile)autoCloseable;
            boolean bl = false;
            RBCConvertor rbcConvertor = new RBCConvertor(conversionContext.getValidator());
            List list = conversionContext.getWorkspace().getAllJobs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllJobs(...)");
            Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)list);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object v1;
                CtmJob ctmJob;
                block14: {
                    ctmJob = (CtmJob)element$iv;
                    boolean bl2 = false;
                    $this$firstOrNull$iv = conversionContext.getInputData().getTimeWindows();
                    $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        TimeWindow tn = (TimeWindow)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)tn.getName(), (Object)CtmJobKt.getJobDefinition(ctmJob).getTimeWindow())) continue;
                        v1 = element$iv2;
                        break block14;
                    }
                    v1 = null;
                }
                TimeWindow timewindow = v1;
                if (timewindow != null) {
                    this.setTimeWindow((CtmBaseEntity)ctmJob, rbcConvertor, timewindow, (Function1<? super RbcAPI, Unit>)((Function1)arg_0 -> SchedulingCreator.execute$lambda$9$lambda$2$lambda$1(this, ctmJob, arg_0)));
                }
                this.issueNotSupportedSubmitFrameIfFound(ctmJob);
                this.issueNotSupportedTimeZoneIfFound(CtmJobKt.getJobDefinition(ctmJob), (OrderableEntityWrapper)ctmJob);
            }
            List list2 = conversionContext.getWorkspace().getAllFolders();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllFolders(...)");
            $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)list2);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object v3;
                CtmFolder folder;
                block15: {
                    folder = (CtmFolder)element$iv;
                    boolean bl4 = false;
                    $this$firstOrNull$iv = conversionContext.getInputData().getTimeWindows();
                    $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        TimeWindow timeWindow = (TimeWindow)element$iv2;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)timeWindow.getName(), (Object)CtmFolderKt.getJobDefinition(folder).getTimeWindow())) continue;
                        v3 = element$iv2;
                        break block15;
                    }
                    v3 = null;
                }
                TimeWindow timeWindow = v3;
                if (timeWindow != null) {
                    this.setTimeWindow((CtmBaseEntity)folder, rbcConvertor, timeWindow, (Function1<? super RbcAPI, Unit>)((Function1)arg_0 -> SchedulingCreator.execute$lambda$9$lambda$5$lambda$4(folder, arg_0)));
                }
                this.issueNotSupportedSubmitFrameIfFound(folder);
                this.issueNotSupportedTimeZoneIfFound(CtmFolderKt.getJobDefinition(folder), (OrderableEntityWrapper)folder);
            }
            RegularCalendarsConvertor regularCalendarsConvertor = new RegularCalendarsConvertor(conversionContext.getGeneralMessages());
            Iterable $this$forEach$iv2 = conversionContext.getInputData().getSapSystems();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                SAPSystem sapSystem = (SAPSystem)element$iv;
                boolean bl6 = false;
                Iterable $this$forEach$iv3 = regularCalendarsConvertor.convert(sapSystem);
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    CtmCalendar ctmCalendar = (CtmCalendar)element$iv3;
                    boolean bl7 = false;
                    defCal.write(ctmCalendar, false);
                }
            }
            $this$forEach$iv2 = rbcConvertor.getConvertedRBCs();
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Map map;
                RbcAPI rbc = (RbcAPI)element$iv;
                boolean bl8 = false;
                Intrinsics.checkNotNullExpressionValue((Object)rbc.getAttributes(), (String)"getAttributes(...)");
                Properties properties = new Properties();
                Properties properties2 = properties;
                properties2.putAll((Map<?, ?>)map);
                defCal.writeRBC(properties);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void issueNotSupportedTimeZoneIfFound(JobDefinition jobDef, OrderableEntityWrapper it) {
        String jobTimeZone;
        CharSequence charSequence;
        String timeZoneName = jobDef.getTimeWindowTimeZone();
        CharSequence charSequence2 = timeZoneName;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            it.addMessage(WarningsKt.timeZoneNotSupported(string, "TimeWindowTimeZone:" + timeZoneName));
        }
        if (!((charSequence = (CharSequence)(jobTimeZone = jobDef.getJobTimeZone())) == null || charSequence.length() == 0)) {
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            it.addMessage(WarningsKt.timeZoneNotSupported(string, "JobTimeZone:" + jobTimeZone));
        }
    }

    private final void setTimeWindow(CtmBaseEntity job, RBCConvertor rbcConvertor, TimeWindow timeWindow, Function1<? super RbcAPI, Unit> setRbc) {
        Iterable $this$forEach$iv = rbcConvertor.convertAndValidate(timeWindow, (OrderableEntityWrapper)job);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            setRbc.invoke(element$iv);
        }
        if (timeWindow.getTimeWindowElements().isEmpty()) {
            job.addMessage(WarningsKt.emptyTimeWindow(job, timeWindow.getName()));
            return;
        }
        if (timeWindow.getTimeWindowElements().size() > 1) {
            job.addMessage(WarningsKt.multipleTimeWindowElementsWarning(job, timeWindow.getName()));
        }
        this.setStartAndEndTime(job, (TimeWindow.TimeWindowElement)CollectionsKt.first(timeWindow.getTimeWindowElements()));
    }

    private final void setRBCForJob(RbcAPI it, CtmJob job) {
        RbcAPI rbc = RbcAPI.createJobRBC((String)it.getName());
        job.scheduling().addRBC((IRBC)rbc);
        String string = rbc.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        job.addMessage(InfosKt.timeWindowConvertedToRBC(job, string));
    }

    private final void setStartAndEndTime(CtmBaseEntity ctmBaseEntity, TimeWindow.TimeWindowElement timeWindowElement) {
        Duration duration = Duration.ofMillis(timeWindowElement.getStartTimeInMs());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        String fromTime = this.formatToString(duration);
        Duration duration2 = Duration.ofMillis(timeWindowElement.getEndTimeInMs());
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
        String toTime = this.formatToString(duration2);
        ctmBaseEntity.scheduling().setTimeSettings(fromTime, toTime);
    }

    private final String formatToString(Duration $this$formatToString) {
        String string = "%02d%02d";
        Object[] objectArray = new Object[]{$this$formatToString.toHoursPart(), $this$formatToString.toMinutesPart()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final void issueNotSupportedSubmitFrameIfFound(CtmJob it) {
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)CtmJobKt.getJobDefinition(it).getSubmitFrame())).toString()).length() > 0) {
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            it.addMessage(WarningsKt.notSupportedSubmitFrame(string, CtmJobKt.getJobDefinition(it).getSubmitFrame()));
        }
    }

    private final void issueNotSupportedSubmitFrameIfFound(CtmFolder it) {
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)CtmFolderKt.getJobDefinition(it).getSubmitFrame())).toString()).length() > 0) {
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            it.addMessage(WarningsKt.notSupportedSubmitFrame(string, CtmFolderKt.getJobDefinition(it).getSubmitFrame()));
        }
    }

    private static final Unit execute$lambda$9$lambda$2$lambda$1(SchedulingCreator this$0, CtmJob $ctmJob, RbcAPI rbc) {
        Intrinsics.checkNotNullParameter((Object)rbc, (String)"rbc");
        this$0.setRBCForJob(rbc, $ctmJob);
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$9$lambda$5$lambda$4(CtmFolder $folder, RbcAPI it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $folder.scheduling().addControlmLevelRuleBasedCalendar(it.getName());
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        $folder.addMessage(InfosKt.timeWindowConvertedToRBC($folder, string));
        return Unit.INSTANCE;
    }
}

