/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.xml_json_compare;

import com.bmc.toolbox.xml_json_compare.Changes;
import com.bmc.toolbox.xml_json_compare.Structure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class StructureCompare {
    private final Structure left;
    private final Structure right;
    private final Changes changes;

    public StructureCompare(Structure left, Structure right) {
        this.left = left;
        this.right = right;
        this.changes = new Changes();
    }

    public Changes compare() {
        return this.compare(this.left, this.right);
    }

    private static <T, R> List<T> diffListsByProperty(List<T> left, List<T> right, Function<T, R> propertyGetter) {
        ArrayList<T> diff = new ArrayList<T>(left);
        List names = right.stream().map(propertyGetter).collect(Collectors.toList());
        return diff.stream().filter(s -> !names.contains(propertyGetter.apply(s))).collect(Collectors.toList());
    }

    private void compareAttributes(Structure left, Structure right) {
        List<Pair<String, String>> leftAttributes = left.transformAttributes();
        List<Pair<String, String>> rightAttributes = right.transformAttributes();
        List<Pair> onlyInLeft = StructureCompare.diffListsByProperty(leftAttributes, rightAttributes, Pair::getKey);
        onlyInLeft.forEach(diff -> this.changes.addLeftChange(new Changes.Change((String)diff.getKey(), (String)diff.getValue(), new Changes.Change(left.getName()))));
        List<Pair> onlyInRight = StructureCompare.diffListsByProperty(rightAttributes, leftAttributes, Pair::getKey);
        onlyInRight.forEach(diff -> this.changes.addRightChange(new Changes.Change((String)diff.getKey(), (String)diff.getValue(), new Changes.Change(left.getName()))));
    }

    private Changes compare(Structure left, Structure right) {
        if (!left.getName().equals(right.getName())) {
            this.changes.addChange(new Changes.Change(left), new Changes.Change(right));
        } else {
            this.compareAttributes(left, right);
            this.compareChildren(left.getChildren(), right.getChildren());
        }
        return this.changes;
    }

    private <T> void iterateLists(List<T> left, List<T> right, BiConsumer<T, T> consumer) {
        Iterator<T> leftIterator = left.iterator();
        Iterator<T> rightIterator = right.iterator();
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            consumer.accept(leftIterator.next(), rightIterator.next());
        }
    }

    private void compareChildren(List<Structure> left, List<Structure> right) {
        List leftSorted = left.stream().sorted().collect(Collectors.toList());
        List rightSorted = right.stream().sorted().collect(Collectors.toList());
        List<Structure> onlyInLeft = StructureCompare.diffListsByProperty(leftSorted, rightSorted, Structure::getName);
        onlyInLeft.forEach(diff -> this.changes.addLeftChange(new Changes.Change((Structure)diff)));
        List<Structure> onlyInRight = StructureCompare.diffListsByProperty(rightSorted, leftSorted, Structure::getName);
        onlyInRight.forEach(diff -> this.changes.addRightChange(new Changes.Change((Structure)diff)));
        List leftReminder = leftSorted.stream().filter(i -> !onlyInLeft.contains(i)).collect(Collectors.toList());
        List rightReminder = rightSorted.stream().filter(i -> !onlyInRight.contains(i)).collect(Collectors.toList());
        this.iterateLists(leftReminder, rightReminder, this::compare);
    }
}

