/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.xml_json_compare;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public interface Structure
extends Comparable<Structure> {
    public String getName();

    public String getType();

    public Optional<Structure> getParent();

    public List<Pair<String, String>> getAttributes();

    public List<Structure> getChildren();

    public Predicate<String> getFilter();

    public Function<String, String> getMapper();

    default public boolean hasChildren() {
        return this.getChildren().isEmpty();
    }

    default public List<Pair<String, String>> transformAttributes() {
        return this.getAttributes().stream().map(attribute -> {
            String attributeKey = this.getMapper().apply((String)attribute.getKey());
            return new ImmutablePair((Object)attributeKey, (Object)((String)attribute.getValue()));
        }).filter(attribute -> this.getFilter().test((String)attribute.getKey())).sorted().collect(Collectors.toList());
    }

    @Override
    default public int compareTo(Structure other) {
        return this.getName().compareTo(other.getName());
    }
}

