/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.xml_json_compare;

import com.bmc.toolbox.xml_json_compare.InputFile;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONObject;

public class Mappers {
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String ATTRIBUTES = "attributes";
    public static final String VALUE = "value";
    public static final String FILTER = "filter";
    public static final String TRANSFORM = "transform";
    public static final String TARGET_ATTRIBUTE = "target";
    public static final String MAPPERS = "mappers";
    public static final String ENABLED = "enabled";
    private final List<Function<String, String>> jsonMappers = new ArrayList<Function<String, String>>();
    private final List<Function<String, String>> xmlMappers = new ArrayList<Function<String, String>>();
    private final List<Function<String, String>> generalMappers = new ArrayList<Function<String, String>>();
    private final List<Predicate<String>> jsonFiters = new ArrayList<Predicate<String>>();
    private final List<Predicate<String>> xmlFilters = new ArrayList<Predicate<String>>();
    private final List<Predicate<String>> generalFilters = new ArrayList<Predicate<String>>();

    public Mappers(InputFile inputFile) {
        this();
        this.loadMappers(inputFile);
    }

    public Mappers() {
    }

    private void loadMappers(InputFile inputFile) {
        JSONObject json = new JSONObject(inputFile.asString());
        this.load(json);
    }

    public Predicate<String> getFilterFor(TARGET target) {
        List<Predicate<String>> filters = this.getFiltersBy(target);
        return this.concat(this.generalFilters, filters).stream().reduce(s -> true, Predicate::and);
    }

    public Function<String, String> getMapperFor(TARGET target) {
        List<Function<String, String>> mappers = this.getMapperBy(target);
        return this.concat(this.generalMappers, mappers).stream().reduce(s -> s, Function::compose);
    }

    private List<Function<String, String>> getMapperBy(TARGET target) {
        return switch (target.ordinal()) {
            case 0 -> this.jsonMappers;
            case 1 -> this.xmlMappers;
            default -> this.generalMappers;
        };
    }

    private List<Predicate<String>> getFiltersBy(TARGET target) {
        return switch (target.ordinal()) {
            case 0 -> this.jsonFiters;
            case 1 -> this.xmlFilters;
            default -> this.generalFilters;
        };
    }

    private void load(JSONObject json) {
        JSONArray mappers = json.getJSONArray(MAPPERS);
        List<JSONObject> jsonObjects = IntStream.range(0, mappers.length()).mapToObj(mappers::getJSONObject).filter(this::isEnabled).collect(Collectors.toList());
        jsonObjects.forEach(data -> {
            List<String> attributes = this.getAttributes((JSONObject)data);
            TARGET target = this.getTarget((JSONObject)data);
            String type = data.getString(TYPE_ATTRIBUTE);
            if (type.equals(FILTER)) {
                this.addFilter(attributes, target);
            } else if (type.equals(TRANSFORM)) {
                this.addMapper((JSONObject)data, attributes, target);
            }
        });
    }

    private boolean isEnabled(JSONObject data) {
        return !data.has(ENABLED) || data.getBoolean(ENABLED);
    }

    private void addMapper(JSONObject data, List<String> attributes, TARGET target) {
        String newValue = data.get(VALUE).toString();
        Function<String, String> mapper = originalValue -> attributes.stream().anyMatch(attribute -> attribute.equals(originalValue)) ? newValue : originalValue;
        this.getMapperBy(target).add(mapper);
    }

    private void addFilter(List<String> attributes, TARGET target) {
        Predicate<String> ignoreIfAttributesContainInput = input -> !attributes.contains(input);
        this.getFiltersBy(target).add(ignoreIfAttributesContainInput);
    }

    private TARGET getTarget(JSONObject data) {
        String target = data.has(TARGET_ATTRIBUTE) ? data.getString(TARGET_ATTRIBUTE) : "";
        return TARGET.from(target);
    }

    private List<String> getAttributes(JSONObject data) {
        JSONArray attributesJsonArray = data.getJSONArray(ATTRIBUTES);
        return IntStream.range(0, attributesJsonArray.length()).mapToObj(attributesJsonArray::getString).collect(Collectors.toList());
    }

    private <T> List<T> concat(List<T> left, List<T> right) {
        return Stream.concat(left.stream(), right.stream()).collect(Collectors.toList());
    }

    public static enum TARGET {
        JSON,
        XML,
        GENERAL;


        public static TARGET from(String target) {
            if (target.equals("xml")) {
                return XML;
            }
            if (target.equals("json")) {
                return JSON;
            }
            return GENERAL;
        }
    }

    public static enum TYPE {
        FILTER,
        MAPPER,
        IDENTITY;

    }
}

