/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.xml_json_compare;

import com.bmc.toolbox.xml_json_compare.InputFile;
import com.bmc.toolbox.xml_json_compare.Mappers;
import com.bmc.toolbox.xml_json_compare.Structure;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONObject;

public class JsonStructure
implements Structure {
    private final JSONObject json;
    private final String name;
    private final Mappers mappers;
    private final Structure parent;

    public JsonStructure(InputFile jsonDraft, Mappers mappers) {
        this(new JSONObject(jsonDraft.asString()), "", mappers, null);
    }

    public JsonStructure(JSONObject json, String name, Mappers mappers, Structure parent) {
        this.json = json;
        this.name = name;
        this.mappers = mappers;
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.json.has("Type") ? this.json.getString("Type") : "unknown";
    }

    @Override
    public Optional<Structure> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public List<Pair<String, String>> getAttributes() {
        return this.json.toMap().entrySet().stream().filter(entry -> !this.isObject(entry.getValue().toString())).map(entry -> new ImmutablePair((Object)((String)entry.getKey()), (Object)entry.getValue().toString())).collect(Collectors.toList());
    }

    @Override
    public List<Structure> getChildren() {
        List<Object> names = this.json.names().toList();
        return names.stream().filter(jsonName -> this.json.get(jsonName.toString()) instanceof JSONObject).map(jsonName -> {
            JSONObject jsonObject = this.json.getJSONObject(jsonName.toString());
            return new JsonStructure(jsonObject, jsonName.toString(), this.mappers, this);
        }).collect(Collectors.toList());
    }

    @Override
    public Predicate<String> getFilter() {
        return this.mappers.getFilterFor(Mappers.TARGET.JSON);
    }

    @Override
    public Function<String, String> getMapper() {
        return this.mappers.getMapperFor(Mappers.TARGET.JSON);
    }

    private boolean isObject(String item) {
        boolean hasObjectStart = item.startsWith("{");
        boolean hasObjectEnd = item.endsWith("}");
        return hasObjectStart && hasObjectEnd;
    }

    public String toString() {
        return this.getName();
    }
}

