/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.xml_json_compare;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class InputFile {
    private final String filePath;

    public InputFile(String filePath) {
        this.filePath = filePath;
    }

    public String asString() {
        try {
            Path xmlFile = Paths.get(this.filePath, new String[0]);
            byte[] bytes = Files.readAllBytes(xmlFile);
            return new String(bytes);
        }
        catch (IOException e) {
            throw new InputFileErrorException(e.getMessage());
        }
    }

    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.filePath);
        }
        catch (FileNotFoundException e) {
            throw new InputFileErrorException(e.getMessage());
        }
    }

    public String getExtension() {
        return Optional.ofNullable(this.filePath).filter(f -> f.contains(".")).map(f -> f.substring(this.filePath.lastIndexOf(46) + 1)).orElse("");
    }

    static class InputFileErrorException
    extends RuntimeException {
        public InputFileErrorException(String message) {
            super(message);
        }
    }
}

