/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.xml_json_compare;

import com.bmc.toolbox.xml_json_compare.Structure;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Changes {
    public static final String LEFT_CHANGE = "<<";
    public static final String RIGHT_CHANGE = ">>";
    private final List<Change> differences = new ArrayList<Change>();

    public void addRightChange(Change change) {
        this.differences.add(change.setDirection(DIRECTION.RIGHT));
    }

    public void addLeftChange(Change change) {
        this.differences.add(change.setDirection(DIRECTION.LEFT));
    }

    public void addChange(Change left, Change right) {
        this.addLeftChange(left);
        this.addRightChange(right);
    }

    public boolean hasChanges() {
        return !this.differences.isEmpty();
    }

    public String toString() {
        return this.differences.stream().map(change -> change.getDirection() + change.toString()).collect(Collectors.joining("\n"));
    }

    static enum DIRECTION {
        LEFT,
        RIGHT;

    }

    public static class Change {
        private final Optional<Change> parent;
        private final String name;
        private final String value;
        private DIRECTION direction;

        public Change(String name, String value, Change parent) {
            this.name = name;
            this.value = value;
            this.parent = Optional.ofNullable(parent);
        }

        public Change(String name, String value, Optional<Structure> parent) {
            this.name = name;
            this.value = value;
            this.parent = parent.map(p -> new Change(p.getType(), p.getName(), p.getParent()));
        }

        public Change(String name) {
            this(name, "", Optional.empty());
        }

        public Change(Structure structure) {
            this(structure.getType(), structure.getName(), structure.getParent());
        }

        public Optional<Change> getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            String indent = this.getParent().map(p -> "\t").orElse("");
            String self = Stream.of(this.getName(), this.getValue()).filter(s -> !s.isEmpty()).collect(Collectors.joining("->"));
            return indent + self;
        }

        public String getDirection() {
            String prefix = this.direction == DIRECTION.LEFT ? Changes.LEFT_CHANGE : Changes.RIGHT_CHANGE;
            return this.parent.map(p -> "").orElse(prefix);
        }

        public Change setDirection(DIRECTION direction) {
            this.direction = direction;
            return this;
        }
    }
}

